package tk.ipmsg.swt;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

/**
 * SWTIP Messenger̃CNXB
 * 
 * @author Naoki Takezoe
 */
public class Main {
    
    private Shell   shell;
    private Display display;
    private Table   table;
    private Text    text;
    private Button  send;
    private Button  lock;
    
    private String  userName;
    private String  groupName;
    private Messenger messenger;
    
	private Tray tray;
	private TrayItem trayItem;
	
	private boolean useTray;
	private boolean debug;
	
	private Properties properties;
	private String PROPERTY_FILE = "ipmsg.properties";
    
	/**
	 * Constructor for Main.
	 * 
	 * @param display Display
	 * @param shell   Shell
	 * @param useTray ^XNgCɓ邩ǂ
	 * @param debug   fobO[h
	 */
	public Main(Display display,Shell shell,boolean useTray,boolean debug) {
		this.display = display;
		this.shell   = shell;
		this.useTray = useTray;
		this.debug   = debug;
		
		this.properties = new Properties();
		try {
		    this.properties.load(new FileInputStream(PROPERTY_FILE));
		} catch(IOException ex){
		    ex.printStackTrace();
		}
		initComponents();
	}
    
	public boolean getDebugMode(){
	    return this.debug;
	}
	
    /**
     * ݒp_CAO\
     */
    public void showSetupDialog(){
        
        SetupDialog dialog = new SetupDialog(shell);
        dialog.setInitValue(properties.getProperty("userName"),
                            properties.getProperty("groupName"));
        
        if(dialog.open()){  
        
            this.userName  = dialog.getUserName();
            this.groupName = dialog.getGroupName();
            this.properties.setProperty("userName" ,this.userName);
            this.properties.setProperty("groupName",this.groupName);
            
            try {
                // ^XNgC̏
                if(useTray){
	        		tray     = display.getSystemTray();
	        		trayItem = new TrayItem(tray,SWT.NONE);
	        		trayItem.setImage(ImageRegistry.getImage("icons/ipmsg16x16.gif"));
	        		trayItem.setToolTipText("IP Messenger");
	        		// ^XNgCNbNƂ̏
	        		trayItem.addListener (SWT.Selection, new Listener () {
	        			public void handleEvent (Event event) {
	        			    shell.setVisible(true);
	        			    trayItem.setVisible(false);
	        			}
	        		});
	        		// EBhEŏƂ̏
	                shell.addListener (SWT.Iconify,new Listener(){
	                    public void handleEvent(Event event){
	                        shell.setVisible(false);
	        			    trayItem.setVisible(true);
	                    }
	                });
                }
        		// C_CAOJ
                open();
                if(useTray){
	                shell.setVisible(false);
                }
                // MessengerIuWFNg̊Jn
                messenger = new Messenger(this.userName,this.userName,this.groupName,this);
                messenger.login();
                messenger.start();
            } catch(IOException ex){
                // O
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
                mesBox.setText("O");
                mesBox.setMessage(ex.toString());
                mesBox.open();
                shell.dispose();
            }
        } else {
            shell.dispose();
        }
    }
    
    /**
     * R|[lg̏
     */
    private void initComponents(){
        shell.setText("IP Messenger");
        shell.setLayout(new FillLayout());
        shell.setImage(ImageRegistry.getImage("icons/ipmsg16x16.gif"));
        
        SashForm sash = new SashForm(shell,SWT.VERTICAL);
        
        table = new Table(sash,SWT.MULTI|SWT.FULL_SELECTION|SWT.BORDER);
        table.setHeaderVisible(true);
        String[] cols = {"[U","O[v","zXg"};
        for(int i=0;i<cols.length;i++){
            TableColumn col = new TableColumn(table,SWT.LEFT);
            col.setText(cols[i]);
            col.setWidth(100);
			if(i==0){
				col.addSelectionListener(new UserSortListener());
			} else if(i==1){
				col.addSelectionListener(new GroupSortListener());
			} else if(i==2){
				col.addSelectionListener(new HostSortListener());
			}
        }
        
        Composite composite = new Composite(sash,SWT.NULL);
        
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing   = 0;
        layout.marginHeight      = 0;
        layout.marginWidth       = 0;
        composite.setLayout(layout);
        
        text = new Text(composite,SWT.WRAP|SWT.V_SCROLL|SWT.MULTI|SWT.BORDER);
        GridData gridData1 = new GridData(GridData.FILL_BOTH);
        text.setLayoutData(gridData1);
        
        Composite buttons = new Composite(composite,SWT.NULL);
        GridData gridData2 = new GridData(GridData.HORIZONTAL_ALIGN_END);
        buttons.setLayoutData(gridData2);
        
        RowLayout layout2 = new RowLayout();
        buttons.setLayout(layout2);
        
        send = new Button(buttons,SWT.NULL);
        send.setText("      M      ");
        send.addSelectionListener(new SendListener());
        
        lock = new Button(buttons,SWT.CHECK);
        lock.setText("");
        
        shell.setSize(300,250);
    }
    
    /**
     * o[e[uɒǉ܂B
     * 
     * @param userName  [U
     * @param groupName O[v
     * @param host      zXg
     */
    public void addMember(String userName,String groupName,String host){
        if(userName.equals(this.userName) && groupName.equals(this.groupName)){
            // ͂΂ɑ}
	        TableItem item = new TableItem(table,SWT.NULL,0);
	        String[] data = {userName,groupName,host};
	        item.setText(data);
        } else {
            // ȊO͉ɒǉ
	        TableItem item = new TableItem(table,SWT.NULL);
	        String[] data = {userName,groupName,host};
	        item.setText(data);
        }
    }
    
    /**
     * o[e[u폜܂B
     * 
     * @param host zXg
     */
    public void removeMember(String host){
        if(this.shell.isDisposed()){
            return;
        }
        for(int i=0;i<table.getItemCount();i++){
            TableItem item = table.getItem(i);
            if(item.getText(2).equals(host)){
                table.remove(i);
                break;
            }
        }
    }
    
    /**
     * CEBhE\܂B
     */
    private void open(){
        shell.open();
    }
    
    /**
     * ShellIuWFNg擾܂B
     */
    public Shell getShell(){
        return this.shell;
    }
    
    /**
     * M{^̏
     */
    class SendListener extends SelectionAdapter {

        public void widgetSelected(SelectionEvent e){
            TableItem[] items = table.getSelection();
            if(items==null || items.length==0){
                //System.out.println("IĂȂB");
                return;
            }
            
            try {
                String msg = text.getText();
                boolean flag = lock.getSelection();
                for(int i=0;i<items.length;i++){
                	String user = items[i].getText(0);
                    String host = items[i].getText(2);
                    messenger.sendMsg(user,host,msg,flag);
                }
                
                // Ԃɖ߂
                text.setText("");
                lock.setSelection(false);
                table.deselectAll();

            } catch(Exception ex){
                // O
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
                mesBox.setText("O");
                mesBox.setMessage(ex.toString());
                mesBox.open();
            }
        }
    }
	
	///////////////////////////////////////////////////////////////////////////
	// \[g֌W̓NXQ
	
	/**
	 * [Uł̃\[g
	 */
	class UserSortListener extends SelectionAdapter {
		
		public void widgetSelected(SelectionEvent e){
			
			if(table.getItemCount()==0){ return; }
			
			TableItem[] items = table.getItems();
			Arrays.sort(items,new UserComparator());
			Vector vec = new Vector();
			for(int i=0;i<items.length;i++){
				String[] data = {items[i].getText(0),items[i].getText(1),items[i].getText(2)};
				vec.add(data);
			}
			
			table.removeAll();
			for(int i=0;i<vec.size();i++){
				TableItem item = new TableItem(table,SWT.NULL);
				item.setText((String[])vec.get(i));
			}
		}
	}
	
	/**
	 * O[vł̃\[g
	 */
	class GroupSortListener extends SelectionAdapter {
		
		public void widgetSelected(SelectionEvent e){
			
			if(table.getItemCount()==0){ return; }
			
			TableItem[] items = table.getItems();
			Arrays.sort(items,new GroupComparator());
			Vector vec = new Vector();
			int spaceCount = 0;
			int sameCount  = 1;
			for(int i=0;i<items.length;i++){
				String[] data = {items[i].getText(0),items[i].getText(1),items[i].getText(2)};
				boolean regFlag = false;
				if(i!=0 && data[1].equals(groupName) && !data[1].equals("")){
					vec.insertElementAt(data,sameCount);
					sameCount++;
					regFlag = true;
				} else if(i>1){
					String[] prev = (String[])vec.get(i-1);
					if(prev[1].equals("")){
						vec.insertElementAt(data,i-spaceCount);
						regFlag = true;
						if(data[1].equals("")){ spaceCount++; }
					}
				}
				if(!regFlag){
					vec.add(data);
					if(data[1].equals("") && i!=0){ spaceCount++; }
				}
			}
			
			table.removeAll();
			for(int i=0;i<vec.size();i++){
				TableItem item = new TableItem(table,SWT.NULL);
				item.setText((String[])vec.get(i));
			}
			
		}
	}

	/**
	 * zXgł̃\[g
	 */
	class HostSortListener extends SelectionAdapter {
		
		public void widgetSelected(SelectionEvent e){
			
			if(table.getItemCount()==0){ return; }
			
			TableItem[] items = table.getItems();
			Arrays.sort(items,new HostComparator());
			Vector vec = new Vector();
			for(int i=0;i<items.length;i++){
				String[] data = {items[i].getText(0),items[i].getText(1),items[i].getText(2)};
				vec.add(data);
			}
			
			table.removeAll();
			for(int i=0;i<vec.size();i++){
				TableItem item = new TableItem(table,SWT.NULL);
				item.setText((String[])vec.get(i));
			}
		}
	}

	
	/**
	 * [UŃ\[g邽߂Comparator
	 */
	class UserComparator implements Comparator {
		
		public int compare(Object o1,Object o2){
			TableItem item1 = (TableItem)o1;
			TableItem item2 = (TableItem)o2;
			
			String user1 = item1.getText(0);
			String user2 = item2.getText(0);
			
			if(userName.equals(user1)){
				return -1;
			}
			
			return user1.compareTo(user2);
		}
	}
	
	/**
	 * O[vŃ\[g邽߂Comparator
	 */
	class GroupComparator implements Comparator {
		
		public int compare(Object o1,Object o2){
			TableItem item1 = (TableItem)o1;
			TableItem item2 = (TableItem)o2;
			
			String group1 = item1.getText(1);
			String group2 = item2.getText(1);
			
			if(groupName.equals(group1)){
				return -1;
			}
			
			return group1.compareTo(group2);
		}
	}
	
	/**
	 * zXgŃ\[g邽߂Comparator
	 */
	class HostComparator implements Comparator {
		
		private String hostName;
		
		public HostComparator(){
			TableItem item = table.getItem(0);
			this.hostName = item.getText(2);
		}
		
		public int compare(Object o1,Object o2){
			TableItem item1 = (TableItem)o1;
			TableItem item2 = (TableItem)o2;
			
			String host1 = item1.getText(2);
			String host2 = item2.getText(2);
			
			if(this.hostName.equals(host1)){
				return -1;
			}
			
			return host1.compareTo(host2);
		}
	}
	///////////////////////////////////////////////////////////////////////////
	
    /**
     * OAEg
     */
    public void logout(){
        if(messenger!=null){
            try {
                properties.store(new FileOutputStream(PROPERTY_FILE),null);
                messenger.logout();
            } catch(IOException ex){
                // O
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
                mesBox.setText("O");
                mesBox.setMessage(ex.toString());
                mesBox.open();
            }
        }
    }
    
    /**
     * SWTIPMessenger̋NNXB
     * ȉ̋NIvVw\łB
     * <ul>
     *   <li>-tray = ŏꍇɃ^XNgCɓ܂B</li>
     *   <li>-debug = Wo͂ɃfobObZ[Wo͂܂B</li>
     * </ul>
     * 
     * @param args R}hC
     */
    public static void main(String[] args){
        // R}hC̉
        boolean useTray = false;
        boolean debug   = false;
        for(int i=0;i<args.length;i++){
            if(args[i].equals("-tray")){
                useTray = true;
            } else if(args[i].equals("-debug")){
                debug = true;
            }
        }
        
        Display display = new Display();
        Shell shell = new Shell(display);
        
        Main main = new Main(display,shell,useTray,debug);
        main.showSetupDialog();
        
        while (!shell.isDisposed ()){
            if (!display.readAndDispatch ()){
                display.sleep ();
            }
        }
        main.logout();
        ImageRegistry.dispose();
        display.dispose();
        System.exit(0);
    }
}
