/*
 * Decompiled with CFR 0.152.
 */
package tk.ipmsg;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public abstract class IPMessenger
extends Thread {
    protected String userName;
    protected String nickName;
    protected String group;
    protected String hostName;
    protected DatagramSocket socket;
    protected boolean absenceMode;
    protected String absenceMsg;
    protected int in_port;
    protected boolean debug;
    private boolean loopFlag;
    private HashMap userNames = new HashMap();
    private static String CHARSET = "MS932";

    public IPMessenger() {
    }

    protected void debugMessage(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    public IPMessenger(String userName, String nickName, String group, boolean debug) throws IOException {
        this.userName = userName;
        this.nickName = nickName;
        this.group = group;
        this.hostName = InetAddress.getLocalHost().getHostName();
        this.absenceMode = false;
        this.absenceMsg = "";
        this.socket = new DatagramSocket(2425);
        this.in_port = 2425;
        this.debug = debug;
    }

    public void login() throws IOException {
        this.broadcastMsg(this.makeTelegram(1025, this.nickName + "\u0000" + this.group));
        this.loopFlag = true;
    }

    public void logout() throws IOException {
        this.broadcastMsg(this.makeTelegram(1026, this.nickName + "\u0000" + this.group));
        this.loopFlag = false;
    }

    public void absence(String msg, boolean mode) throws IOException {
        int command;
        if (mode) {
            this.absenceMsg = msg == null || msg.equals("") ? "ABSENCE" : "[" + this.absenceMsg + "]";
            this.absenceMode = true;
            command = 260;
        } else {
            this.absenceMsg = "";
            this.absenceMode = false;
            command = 4;
        }
        this.broadcastMsg(this.makeTelegram(command, this.nickName + this.absenceMsg + "\u0000" + this.group));
    }

    public abstract void receiveMsg(String var1, String var2, String var3, boolean var4);

    public void sendMsg(String host, String msg, boolean secret) throws IOException {
        int mode = 0;
        if (secret) {
            mode = 0x100200;
        }
        this.send(this.makeTelegram(0x20 | mode, msg), host, this.in_port);
    }

    public abstract void addMember(String var1, String var2, String var3, String var4, int var5);

    public abstract void removeMember(String var1);

    public abstract void openMsg(String var1, String var2);

    public void readMsg(String host) throws IOException {
        this.send(this.makeTelegram(0x100030, String.valueOf(new Date().getTime() / 1000L)), host, this.in_port);
    }

    public void run() {
        try {
            while (this.loopFlag) {
                byte[] buf = new byte[8192];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.socket.receive(packet);
                new ChildThread(packet).start();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void send(String msg, String host, int port) throws IOException {
        String message = msg;
        byte[] byteMsg = message.getBytes(CHARSET);
        DatagramPacket packet = new DatagramPacket(byteMsg, byteMsg.length, InetAddress.getByName(host), port);
        this.socket.send(packet);
    }

    private String makeTelegram(int command, String supplement) {
        StringBuffer sb = new StringBuffer();
        sb.append(1);
        sb.append(":");
        sb.append(new Date().getTime() / 1000L);
        sb.append(":");
        sb.append(this.userName);
        sb.append(":");
        sb.append(this.hostName);
        sb.append(":");
        sb.append(command);
        sb.append(":");
        sb.append(supplement);
        return sb.toString();
    }

    private void broadcastMsg(String msg) throws IOException {
        String message = msg;
        byte[] byteMsg = message.getBytes(CHARSET);
        DatagramPacket packet = new DatagramPacket(byteMsg, byteMsg.length, InetAddress.getByName("255.255.255.255"), this.in_port);
        this.socket.send(packet);
    }

    private static String[] split(String s1, String s2) {
        if (s1 == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        int last = 0;
        int index = 0;
        while ((index = s1.indexOf(s2, last)) != -1) {
            v.add(s1.substring(last, index));
            last = index + s2.length();
        }
        if (last != s1.length()) {
            v.add(s1.substring(last));
        }
        return v.toArray(new String[v.size()]);
    }

    private class ChildThread
    extends Thread {
        private DatagramPacket packet;

        public ChildThread(DatagramPacket packet) {
            this.packet = packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String fromAddr;
                String message = new String(this.packet.getData(), CHARSET);
                IPMessenger.this.debugMessage("[MSG]" + message.trim());
                String[] telegram = IPMessenger.split(message, ":");
                int command = 0;
                command = Integer.parseInt(telegram[4]);
                int cmd_no = command & 0xFF;
                InetAddress from = this.packet.getAddress();
                String fromHost = fromAddr = IPMessenger.split(from.toString(), "/")[1];
                int fromPort = this.packet.getPort();
                int packetNo = Integer.parseInt(telegram[1]);
                if (fromPort != IPMessenger.this.in_port) {
                    return;
                }
                switch (cmd_no) {
                    case 3: {
                        String[] dim = IPMessenger.split(telegram[5], "\u0000");
                        if (dim[0].equals("")) {
                            dim[0] = telegram[2];
                        }
                        IPMessenger.this.userNames.put(fromHost, dim[0]);
                        IPMessenger.this.addMember(fromHost, dim[0], dim[1], fromAddr, 0x100 & command);
                        break;
                    }
                    case 1: {
                        String[] dim = IPMessenger.split(telegram[5], "\u0000");
                        IPMessenger.this.userNames.put(fromHost, dim[0]);
                        IPMessenger.this.addMember(fromHost, dim[0], dim[1], fromAddr, 0x100 & command);
                        if (IPMessenger.this.absenceMode) {
                            IPMessenger.this.send(IPMessenger.this.makeTelegram(259, IPMessenger.this.nickName + IPMessenger.this.absenceMsg + "\u0000" + IPMessenger.this.group), fromAddr, fromPort);
                            break;
                        }
                        IPMessenger.this.send(IPMessenger.this.makeTelegram(3, IPMessenger.this.nickName + "\u0000" + IPMessenger.this.group), fromAddr, fromPort);
                        break;
                    }
                    case 32: {
                        int ack_cmd;
                        boolean lockFlag = false;
                        if ((command & 0x100) != 0) {
                            ack_cmd = 33;
                            IPMessenger.this.send(IPMessenger.this.makeTelegram(ack_cmd, String.valueOf(packetNo)), fromAddr, IPMessenger.this.in_port);
                        }
                        if ((command & 0x200) != 0) {
                            ack_cmd = 33;
                            IPMessenger.this.send(IPMessenger.this.makeTelegram(ack_cmd, String.valueOf(packetNo)), fromAddr, IPMessenger.this.in_port);
                            lockFlag = true;
                        }
                        int in_length = telegram.length;
                        if (telegram.length > 6) {
                            for (int j = 6; j < in_length; ++j) {
                                telegram[5] = telegram[5] + ":" + telegram[j];
                            }
                        }
                        String nickName = (String)IPMessenger.this.userNames.get(fromHost);
                        IPMessenger.this.receiveMsg(fromHost, nickName, telegram[5].trim(), lockFlag);
                        break;
                    }
                    case 48: {
                        if ((command & 0x100000) == 0) break;
                        int ack_cmd = 50;
                        IPMessenger.this.send(IPMessenger.this.makeTelegram(ack_cmd, String.valueOf(packetNo)), fromAddr, IPMessenger.this.in_port);
                        IPMessenger.this.openMsg(fromHost, telegram[2]);
                        break;
                    }
                    case 4: {
                        String[] dim = IPMessenger.split(telegram[5], "\u0000");
                        IPMessenger.this.addMember(fromHost, dim[0], dim[1], fromAddr, 0x100 & command);
                        break;
                    }
                    case 2: {
                        IPMessenger.this.userNames.remove(fromHost);
                        IPMessenger.this.removeMember(fromHost);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

