/*
 * Decompiled with CFR 0.152.
 */
package tk.ipmsg.swt;

import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tk.ipmsg.swt.Messenger;

public class SendDialog {
    private Shell shell;
    private String message;
    private String host;
    private String user;
    private Text text;
    private Button send;
    private Button lock;
    private Messenger messenger;

    public SendDialog(Shell shell, String host, String user, String message, Messenger messenger) {
        this.shell = new Shell(shell, 240);
        this.message = message;
        this.host = host;
        this.messenger = messenger;
        this.user = user;
        this.initComponents();
    }

    private void initComponents() {
        this.shell.setText(this.user + "\u3078\u306e\u8fd4\u4fe1");
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        this.text = new Text((Composite)this.shell, 2626);
        GridData gridData1 = new GridData(1808);
        this.text.setLayoutData((Object)gridData1);
        String res = SendDialog.createResponseMessage(this.message);
        this.text.setText(res);
        this.text.setSelection(res.length());
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData gridData2 = new GridData(128);
        composite.setLayoutData((Object)gridData2);
        RowLayout layout2 = new RowLayout();
        composite.setLayout((Layout)layout2);
        this.send = new Button(composite, 0);
        this.send.setText("      \u9001\u4fe1      ");
        this.send.addSelectionListener((SelectionListener)new SendListener());
        this.lock = new Button(composite, 32);
        this.lock.setText("\u5c01\u66f8");
        this.shell.setSize(300, 200);
    }

    public void open() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private static String createResponseMessage(String source) {
        if (source == null || source.equals("")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("> ");
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\n') {
                sb.append(c);
                sb.append("> ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    class SendListener
    extends SelectionAdapter {
        SendListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String msg = SendDialog.this.text.getText();
            if (msg != null && !msg.equals("")) {
                try {
                    SendDialog.this.messenger.sendMsg(SendDialog.this.user, SendDialog.this.host, msg, SendDialog.this.lock.getSelection());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    MessageBox mesBox = new MessageBox(SendDialog.this.shell, 33);
                    mesBox.setText("\u4f8b\u5916");
                    mesBox.setMessage(ex.toString());
                    mesBox.open();
                }
            }
            SendDialog.this.shell.dispose();
        }
    }
}

