/*
 * Decompiled with CFR 0.152.
 */
package tk.ipmsg.swt;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.swt.widgets.MessageBox;
import tk.ipmsg.IPMessenger;
import tk.ipmsg.swt.Logger;
import tk.ipmsg.swt.Main;
import tk.ipmsg.swt.ReceiveDialog;

public class Messenger
extends IPMessenger {
    private Main main;
    private HashMap hash = new HashMap();

    public Messenger(String userName, String nickName, String group, Main main) throws IOException {
        super(userName, nickName, group, main.getDebugMode());
        this.main = main;
    }

    public void receiveMsg(String host, String user, String msg, boolean flag) {
        this.main.getShell().getDisplay().asyncExec((Runnable)new RunnableReceiveMessage(host, user, msg, flag, this));
        StringBuffer sb = new StringBuffer();
        sb.append("=====================================\n");
        sb.append("From:" + user + "(" + host + ")\n");
        sb.append(new Date().toString() + "\n");
        sb.append("-------------------------------------\n");
        sb.append(msg + "\n\n");
        Logger.writeLog(sb.toString());
    }

    public void openMsg(String host, String user) {
        this.main.getShell().getDisplay().asyncExec((Runnable)new RunnableOpenMessage(host, user));
    }

    public void addMember(String host, String nickName, String group, String addr, int absence) {
        if (this.hash.get(host) == null) {
            this.main.getShell().getDisplay().asyncExec((Runnable)new RunnableAddMember(nickName, group, host));
            this.hash.put(host, nickName);
        }
    }

    public void sendMsg(String user, String host, String msg, boolean secret) throws IOException {
        super.sendMsg(host, msg, secret);
        StringBuffer sb = new StringBuffer();
        sb.append("=====================================\n");
        sb.append("To:" + user + "(" + host + ")\n");
        sb.append(new Date().toString() + "\n");
        sb.append("-------------------------------------\n");
        sb.append(msg + "\n\n");
        Logger.writeLog(sb.toString());
    }

    public void removeMember(String host) {
        if (this.hash.get(host) != null && !this.main.getShell().isDisposed()) {
            this.main.getShell().getDisplay().asyncExec((Runnable)new RunnableRemoveMember(host));
            this.hash.remove(host);
        }
    }

    class RunnableOpenMessage
    implements Runnable {
        private String host;
        private String user;

        public RunnableOpenMessage(String host, String user) {
            this.host = host;
            this.user = user;
        }

        public void run() {
            MessageBox dialog = new MessageBox(Messenger.this.main.getShell(), 32);
            dialog.setText(this.user);
            dialog.setMessage("\u958b\u5c01\u3055\u308c\u307e\u3057\u305f\n(" + new Date().toString() + ")");
            dialog.open();
        }
    }

    class RunnableReceiveMessage
    implements Runnable {
        private String user;
        private String host;
        private String message;
        private boolean flag;
        private Messenger messenger;

        public RunnableReceiveMessage(String host, String user, String message, boolean flag, Messenger messenger) {
            this.host = host;
            this.user = user;
            this.message = message;
            this.flag = flag;
            this.messenger = messenger;
        }

        public void run() {
            ReceiveDialog dialog = new ReceiveDialog(Messenger.this.main.getShell(), this.user, this.host, this.message, this.flag, this.messenger);
            dialog.open();
        }
    }

    class RunnableRemoveMember
    implements Runnable {
        private String host;

        public RunnableRemoveMember(String host) {
            this.host = host;
        }

        public void run() {
            Messenger.this.main.removeMember(this.host);
        }
    }

    class RunnableAddMember
    implements Runnable {
        private String nickName;
        private String group;
        private String host;

        public RunnableAddMember(String nickName, String group, String host) {
            this.nickName = nickName;
            this.group = group;
            this.host = host;
        }

        public void run() {
            Messenger.this.main.addMember(this.nickName, this.group, this.host);
        }
    }
}

