/*
 * Decompiled with CFR 0.152.
 */
package tk.ipmsg.swt;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import tk.ipmsg.swt.ImageRegistry;
import tk.ipmsg.swt.Messenger;
import tk.ipmsg.swt.SetupDialog;

public class Main {
    private Shell shell;
    private Display display;
    private Table table;
    private Text text;
    private Button send;
    private Button lock;
    private String userName;
    private String groupName;
    private Messenger messenger;
    private Tray tray;
    private TrayItem trayItem;
    private boolean useTray;
    private boolean debug;
    private Properties properties;
    private String PROPERTY_FILE = "ipmsg.properties";

    public Main(Display display, Shell shell, boolean useTray, boolean debug) {
        this.display = display;
        this.shell = shell;
        this.useTray = useTray;
        this.debug = debug;
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(this.PROPERTY_FILE));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.initComponents();
    }

    public boolean getDebugMode() {
        return this.debug;
    }

    public void showSetupDialog() {
        SetupDialog dialog = new SetupDialog(this.shell);
        dialog.setInitValue(this.properties.getProperty("userName"), this.properties.getProperty("groupName"));
        if (dialog.open()) {
            this.userName = dialog.getUserName();
            this.groupName = dialog.getGroupName();
            this.properties.setProperty("userName", this.userName);
            this.properties.setProperty("groupName", this.groupName);
            try {
                if (this.useTray) {
                    this.tray = this.display.getSystemTray();
                    this.trayItem = new TrayItem(this.tray, 0);
                    this.trayItem.setImage(ImageRegistry.getImage("icons/ipmsg16x16.gif"));
                    this.trayItem.setToolTipText("IP Messenger");
                    this.trayItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            Main.this.shell.setVisible(true);
                            Main.this.trayItem.setVisible(false);
                        }
                    });
                    this.shell.addListener(19, new Listener(){

                        public void handleEvent(Event event) {
                            Main.this.shell.setVisible(false);
                            Main.this.trayItem.setVisible(true);
                        }
                    });
                }
                this.open();
                if (this.useTray) {
                    this.shell.setVisible(false);
                }
                this.messenger = new Messenger(this.userName, this.userName, this.groupName, this);
                this.messenger.login();
                this.messenger.start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(this.shell, 33);
                mesBox.setText("\u4f8b\u5916");
                mesBox.setMessage(ex.toString());
                mesBox.open();
                this.shell.dispose();
            }
        } else {
            this.shell.dispose();
        }
    }

    private void initComponents() {
        this.shell.setText("IP Messenger");
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setImage(ImageRegistry.getImage("icons/ipmsg16x16.gif"));
        SashForm sash = new SashForm((Composite)this.shell, 512);
        this.table = new Table((Composite)sash, 67586);
        this.table.setHeaderVisible(true);
        String[] cols = new String[]{"\u30e6\u30fc\u30b6", "\u30b0\u30eb\u30fc\u30d7", "\u30db\u30b9\u30c8"};
        for (int i = 0; i < cols.length; ++i) {
            TableColumn col = new TableColumn(this.table, 16384);
            col.setText(cols[i]);
            col.setWidth(100);
            if (i == 0) {
                col.addSelectionListener((SelectionListener)new UserSortListener());
                continue;
            }
            if (i == 1) {
                col.addSelectionListener((SelectionListener)new GroupSortListener());
                continue;
            }
            if (i != 2) continue;
            col.addSelectionListener((SelectionListener)new HostSortListener());
        }
        Composite composite = new Composite((Composite)sash, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.text = new Text(composite, 2626);
        GridData gridData1 = new GridData(1808);
        this.text.setLayoutData((Object)gridData1);
        Composite buttons = new Composite(composite, 0);
        GridData gridData2 = new GridData(128);
        buttons.setLayoutData((Object)gridData2);
        RowLayout layout2 = new RowLayout();
        buttons.setLayout((Layout)layout2);
        this.send = new Button(buttons, 0);
        this.send.setText("      \u9001\u4fe1      ");
        this.send.addSelectionListener((SelectionListener)new SendListener());
        this.lock = new Button(buttons, 32);
        this.lock.setText("\u5c01\u66f8");
        this.shell.setSize(300, 250);
    }

    public void addMember(String userName, String groupName, String host) {
        if (userName.equals(this.userName) && groupName.equals(this.groupName)) {
            TableItem item = new TableItem(this.table, 0, 0);
            String[] data = new String[]{userName, groupName, host};
            item.setText(data);
        } else {
            TableItem item = new TableItem(this.table, 0);
            String[] data = new String[]{userName, groupName, host};
            item.setText(data);
        }
    }

    public void removeMember(String host) {
        if (this.shell.isDisposed()) {
            return;
        }
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            if (!item.getText(2).equals(host)) continue;
            this.table.remove(i);
            break;
        }
    }

    private void open() {
        this.shell.open();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void logout() {
        if (this.messenger != null) {
            try {
                this.properties.store(new FileOutputStream(this.PROPERTY_FILE), null);
                this.messenger.logout();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(this.shell, 33);
                mesBox.setText("\u4f8b\u5916");
                mesBox.setMessage(ex.toString());
                mesBox.open();
            }
        }
    }

    public static void main(String[] args) {
        boolean useTray = false;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-tray")) {
                useTray = true;
                continue;
            }
            if (!args[i].equals("-debug")) continue;
            debug = true;
        }
        Display display = new Display();
        Shell shell = new Shell(display);
        Main main = new Main(display, shell, useTray, debug);
        main.showSetupDialog();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        main.logout();
        ImageRegistry.dispose();
        display.dispose();
        System.exit(0);
    }

    class HostComparator
    implements Comparator {
        private String hostName;

        public HostComparator() {
            TableItem item = Main.this.table.getItem(0);
            this.hostName = item.getText(2);
        }

        public int compare(Object o1, Object o2) {
            TableItem item1 = (TableItem)o1;
            TableItem item2 = (TableItem)o2;
            String host1 = item1.getText(2);
            String host2 = item2.getText(2);
            if (this.hostName.equals(host1)) {
                return -1;
            }
            return host1.compareTo(host2);
        }
    }

    class GroupComparator
    implements Comparator {
        GroupComparator() {
        }

        public int compare(Object o1, Object o2) {
            TableItem item1 = (TableItem)o1;
            TableItem item2 = (TableItem)o2;
            String group1 = item1.getText(1);
            String group2 = item2.getText(1);
            if (Main.this.groupName.equals(group1)) {
                return -1;
            }
            return group1.compareTo(group2);
        }
    }

    class UserComparator
    implements Comparator {
        UserComparator() {
        }

        public int compare(Object o1, Object o2) {
            TableItem item1 = (TableItem)o1;
            TableItem item2 = (TableItem)o2;
            String user1 = item1.getText(0);
            String user2 = item2.getText(0);
            if (Main.this.userName.equals(user1)) {
                return -1;
            }
            return user1.compareTo(user2);
        }
    }

    class HostSortListener
    extends SelectionAdapter {
        HostSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int i;
            if (Main.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] items = Main.this.table.getItems();
            Arrays.sort(items, new HostComparator());
            Vector<String[]> vec = new Vector<String[]>();
            for (i = 0; i < items.length; ++i) {
                String[] data = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2)};
                vec.add(data);
            }
            Main.this.table.removeAll();
            for (i = 0; i < vec.size(); ++i) {
                TableItem item = new TableItem(Main.this.table, 0);
                item.setText((String[])vec.get(i));
            }
        }
    }

    class GroupSortListener
    extends SelectionAdapter {
        GroupSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int i;
            if (Main.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] items = Main.this.table.getItems();
            Arrays.sort(items, new GroupComparator());
            Vector<String[]> vec = new Vector<String[]>();
            int spaceCount = 0;
            int sameCount = 1;
            for (i = 0; i < items.length; ++i) {
                String[] prev;
                String[] data = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2)};
                boolean regFlag = false;
                if (i != 0 && data[1].equals(Main.this.groupName) && !data[1].equals("")) {
                    vec.insertElementAt(data, sameCount);
                    ++sameCount;
                    regFlag = true;
                } else if (i > 1 && (prev = (String[])vec.get(i - 1))[1].equals("")) {
                    vec.insertElementAt(data, i - spaceCount);
                    regFlag = true;
                    if (data[1].equals("")) {
                        ++spaceCount;
                    }
                }
                if (regFlag) continue;
                vec.add(data);
                if (!data[1].equals("") || i == 0) continue;
                ++spaceCount;
            }
            Main.this.table.removeAll();
            for (i = 0; i < vec.size(); ++i) {
                TableItem item = new TableItem(Main.this.table, 0);
                item.setText((String[])vec.get(i));
            }
        }
    }

    class UserSortListener
    extends SelectionAdapter {
        UserSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int i;
            if (Main.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] items = Main.this.table.getItems();
            Arrays.sort(items, new UserComparator());
            Vector<String[]> vec = new Vector<String[]>();
            for (i = 0; i < items.length; ++i) {
                String[] data = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2)};
                vec.add(data);
            }
            Main.this.table.removeAll();
            for (i = 0; i < vec.size(); ++i) {
                TableItem item = new TableItem(Main.this.table, 0);
                item.setText((String[])vec.get(i));
            }
        }
    }

    class SendListener
    extends SelectionAdapter {
        SendListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items = Main.this.table.getSelection();
            if (items == null || items.length == 0) {
                return;
            }
            try {
                String msg = Main.this.text.getText();
                boolean flag = Main.this.lock.getSelection();
                for (int i = 0; i < items.length; ++i) {
                    String user = items[i].getText(0);
                    String host = items[i].getText(2);
                    Main.this.messenger.sendMsg(user, host, msg, flag);
                }
                Main.this.text.setText("");
                Main.this.lock.setSelection(false);
                Main.this.table.deselectAll();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(Main.this.shell, 33);
                mesBox.setText("\u4f8b\u5916");
                mesBox.setMessage(ex.toString());
                mesBox.open();
            }
        }
    }
}

