#!/usr/bin/ruby1.9
# -*- encoding: utf-8 -*-

###############################
# Author: vagus <vagus.xyz@gmail.com>
# LastUpdate: 2010-5-31
# 無保証、無制限(改変、再配布 etc)
###############################
#
# KEN_ALL.CSV から Anthy 用の zipcode.t を作成する
# (事前に ken_all.lzh を落として伸張しておくこと)
# http://www.post.japanpost.jp/zipcode/dl/kogaki/lzh/ken_all.lzh
#
###############################
# 既知の問題:
# ・文字列でソートするから数字部分の並びがおかしい
#
# (JIGYOSYO.CSV は一部、第3水準の漢字を使っていて、EUC-JP に変換できないので
# 入れない。)
#
###############################

ZIPDICT = "./zipcode.t"

# 「種市第４６地割～第４９地割」みたいなのを
# ["種市第４６地割", "種市第４７地割", "種市第４８地割", "種市第４９地割"]
# に展開する関数
def expand_range(str)
  str = str.tr("[０-９]","[0-9]")

  str.match(/^([^0-9]+)([0-9]+)[^0-9]+([0-9]+)([^0-9]+)/)
  ($2.to_i..$3.to_i).map{|i|
    "#{$1}#{i.to_s.tr("[0-9]","[０-９]")}#{$4}"
  }
end

#--------------------------------------------
# KEN_ALL.CSV を読んで必要な field を抜き出す
#--------------------------------------------
ken_all_src = []
open("KEN_ALL.CSV", "r:CP932"){|f|
  ken_all_src = f.read.encode("UTF-8")\
                  .gsub('"','')\
                  # 「－」はeucに変換できないので「─」に置換
                  .gsub('－','─')\
                  .each_line.map{|line|
                    e =line.chomp.split(",")
                    ["#{e[2]}", "#{e[6]}", "#{e[7]}", "#{e[8]}"]
                  }
}

#-----------------------------------------
# 複数行にまたがっている奴を一行にまとめる
#-----------------------------------------
ken_all = []
zipcode = ken_all_src[0][0]
adr = ken_all_src[0][3]
hold = ken_all_src[0..2]

ken_all_src.each{|item|
  # （ ）内が複数行にまたがっているものがあるので、それを1行にまとめ、
  # （ ）の部分を削除する(除く: "（？階）" )
  if item[3] =~ /（[^）]+$/
    zipcode = item[0]
    adr = item[3]
    hold = item[0..2]
  elsif item[0] == zipcode && item[3] !~ /[（）]/
    adr += item[3]
  elsif item[0] == zipcode && item[3] =~ /）/
    # 丸括弧内の記述は自由すぎるので、"（？階）"以外削除
    adr_tmp = "#{adr}#{item[3]}".sub(/（.+）$/,"")
    ken_all << [hold[0], hold[1..2].join + adr_tmp]
  else
    # 複数行にまたがっていない場合。

    # 丸括弧内の記述は自由すぎるので、"（？階）"以外削除
    # その前に複数丸括弧は「─」にしておく
    # 「名駅ミッドランドスクエア（高層棟）（？階）」のみだから
    item[3] = item[3].sub("）（","─")
    if item[3] =~ /（/
        item[3] = item[3].sub(/（.+）$/,"") if item[3] !~ /階）$/
    elsif item[3] =~ /[いる]場合|一円$/
      # 住所として無意味なものを削除
      # (「以下に掲載がない場合」「の次に番地がくる場合」
      # 「新庄村一円」)
      item[3] = ""
    end

    #-----------------------------------
    # item[3](町域)が複数に分かれる場合の対応
    #-----------------------------------
    if item[3] =~ /、/
      # 「穴明２２地割、穴明２３地割」のような場合
      item_tmp = item[3].split("、")
    elsif item[3] == "新所・岡崎・梅田入会地"
      # これだけなぜか中黒
      # 中黒は「赤坂ミッドタウン・タワー」とかがあるので
      # これ以外は split 不可
      item_tmp = item[3].split("・")
    elsif item[3] =~ /～/
      # 「越中畑６４地割～越中畑６６地割」のような場合は展開する
      item_tmp = expand_range(item[3])
    else
      item_tmp = [item[3]]
    end

    # ken_all にまとめる
    item_tmp.each{|y|
      ken_all << [item[0], item[1..2].join + y]
    }
  end
}
# 「江田島町国有無番地」はどうするか


#-----------------------------
# 英数記号を半角にした候補を追加
#-----------------------------
hankaku = []
ken_all.each{|item|
  if item[1] =~ /[０-９Ａ-Ｚ（）─]/
    hankaku << [item[0], item[1].tr("０-９Ａ-Ｚ（）─", "0-9A-Z()-")]
  end
}

ken_all += hankaku

#-----------------------------
# sort, uniq して成形して出力
#-----------------------------
open(ZIPDICT, "w"){|f|
  ken_all.uniq.sort{|x, y|
    [x[0], x[1]] <=> [y[0], y[1]]
  }.each{|x|
    f.puts "#{x[0]} #CNS #{x[1].encode('EUC-JP')}"
  }
}









