// ComGeneric.h
// (c) 2002-2004 exeal

#ifndef _COM_GENERIC_H_
#define _COM_GENERIC_H_

#include <objbase.h>
#include <cassert>
#include <stdexcept>


namespace Armaiti {


// }NƂ
/////////////////////////////////////////////////////////////////////////////

#define RETURN_IF_FAILED(hr)	\
	if(FAILED(hr))				\
		return (hr)

#define VERIFY_POINTER(p)	\
	if((p) == 0)			\
		return E_POINTER

inline VARIANT_BOOL toVariantBoolean(bool b) {
	return b ? VARIANT_TRUE : VARIANT_FALSE;
}


// CComPtr class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// CComPtr::operator-> Ԃ AddRef ARelease Ăяo֎~vLV
template<class T>
class CComPtrProxy : public T {
	// \bh
private:
	STDMETHOD_(ULONG, AddRef)() = 0;
	STDMETHOD_(ULONG, Release)() = 0;
//
//	// Zq
//private:
//	void	operator delete(void*);
};

/// COM X}[g|C^
template<class T>
class CComPtr {
	// RXgN^
public:
	///	RXgN^
	explicit CComPtr(T* p = 0) : m_pointee(p) {
		if(m_pointee != 0)
			m_pointee->AddRef();
	}
	///	Rs[RXgN^
	explicit CComPtr(const CComPtr<T>& rhs) : m_pointee(rhs.m_pointee) {
		if(m_pointee != 0)
			m_pointee->AddRef();
	}
	///	fXgN^
	virtual ~CComPtr() {
		if(m_pointee != 0)
			m_pointee->Release();
	}

	// Zq
public:
	/**
	 *	@brief	QƉZq
	 *	̉Zq̌ʂ͏o͈ƂĂ̂ݎgpB
	 *	ZqĂяoɃIuWFNg null łȂ΁A
	 *	O̒l Release 
	 */
	T** operator &() {
		if(m_pointee != 0)
			m_pointee->Release();
		return static_cast<T**>(&m_pointee);
	}

	///	oANZXZq
	CComPtrProxy<T>* operator ->() const {
		assert(m_pointee != 0);
		return static_cast<CComPtrProxy<T>*>(m_pointee);
	}
//	T& operator *() const {
//		assert(m_pointee != 0);
//		return *m_pointee;
//	}

	/**
	 *	@brief	Zq
	 *	<var>p</var>  null ł悢
	 */
	CComPtr<T>& operator =(T* p) {
		if(m_pointee != p) {
			if(m_pointee != 0)
				m_pointee->Release();
			m_pointee = p;
			if(m_pointee != 0)
				m_pointee->AddRef();
		}
		return *this;
	}

	///	Zq
	template<class I>
	CComPtr<T>& operator =(const CComPtr<I>& rhs) {
		if(this != &rhs) {
			if(m_pointee != 0)
				m_pointee->Release();
			m_pointee = rhs.m_pointee;
			m_pointee->AddRef();
		}
		return *this;
	}

	///	Zq
	bool operator ==(const T* p) const {
		return m_pointee == p;
	}

	///	sZq
	bool operator !=(const T* p) const {
		return m_pointee != p;
	}

	///	̃|C^^ւ̃LXg
	operator T*() const {
		return static_cast<T*>(m_pointee);
	}

	// \bh
public:
	///	::CoCreateInstance ɂIuWFNg
	HRESULT CreateInstance(REFCLSID rclsid,
			IUnknown* pUnkOuter = 0, DWORD dwClsContext = CLSCTX_ALL, REFIID riid = __uuidof(T)) {
		assert(m_pointee == 0);
		return ::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, reinterpret_cast<void**>(&m_pointee));
	}

	///	<var>p</var> ƓIuWFNgǂԂ
	bool IsEqualObject(IUnknown* p) const {
		if(m_pointee == 0 && p == 0)
			return true;
		else if(m_pointee == 0 || p == 0)
			return false;

		IUnknown*	p1 = 0;
		IUnknown*	p2 = 0;
		bool		b;

		m_pointee->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p1));
		p->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p2));
		b = p1 == p2;
		p1->Release();
		p2->Release();

		return b;
	}

	/**
	 *	@see		IUnknown::QueryInterface
	 *	@param pp	[out] LXg
	 */
	template<class I>
	HRESULT QueryInterface(I** pp) const {
		assert(m_pointee != 0);
		if(pp == 0)
			return E_POINTER;
		return m_pointee->QueryInterface(__uuidof(I), reinterpret_cast<void**>(pp));
	}

	// f[^o
private:
	T*	m_pointee;
};


// CComException class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	IErrorInfo  C++ OƂĈ߂̃bpNX
 *	o: Essential COM (Don Box)
 */
class CComException {
	// RXgN^
public:
	/**
	 *	RXgN^
	 *	@param hResult			SCODE
	 *	@param riid				IID
	 *	@param pwszSource		̗O𓊂NX
	 *	@param pwszDescription	O̐Bnull ̏ꍇ <var>hResult</var> 擾
	 *	@param pwszHelpFile		wvt@C̃pX
	 *	@param dwHelpContext	wvgsbN̔ԍ
	 */
	CComException(
			HRESULT hResult,
			REFIID riid,
			const OLECHAR* pwszSource,			// class threw this exception
			const OLECHAR* pwszDescription = 0,	// description of this error (set null to obtain from hResult)
			const OLECHAR* pwszHelpFile = 0,
			DWORD dwHelpContext = 0) {
		HRESULT				hr;
		ICreateErrorInfo*	pcei = 0;

		assert(FAILED(hResult));

		hr = ::CreateErrorInfo(&pcei);
		assert(SUCCEEDED(hr));

		hr = pcei->SetGUID(riid);
		assert(SUCCEEDED(hr));
		if(pwszSource != 0) {
			hr = pcei->SetSource(const_cast<OLECHAR*>(pwszSource));
			assert(SUCCEEDED(hr));
		}
		if(pwszDescription != 0) {
			hr = pcei->SetDescription(const_cast<OLECHAR*>(pwszDescription));
			assert(SUCCEEDED(hr));
		} else {
			BSTR	bstrDescription = 0;
			CComException::GetDescriptionOfSCode(hResult, bstrDescription);
			hr = pcei->SetDescription(bstrDescription);
			::SysFreeString(bstrDescription);
			assert(SUCCEEDED(hr));
		}
		if(pwszHelpFile != 0) {
			hr = pcei->SetHelpFile(const_cast<OLECHAR*>(pwszHelpFile));
			assert(SUCCEEDED(hr));
		}
		hr = pcei->SetHelpContext(dwHelpContext);
		assert(SUCCEEDED(hr));

		m_hResult = hResult;
		hr = pcei->QueryInterface(IID_IErrorInfo, reinterpret_cast<void**>(&m_pErrorInfo));
		assert(SUCCEEDED(hr));
		pcei->Release();
	}
	/// fXgN^
	virtual ~CComException() {
		if(m_pErrorInfo != 0)
			m_pErrorInfo->Release();
	}

	// \bh
public:
	/// G[ IErrorInfo Ԃ
	void	GetErrorInfo(IErrorInfo** pErrorInfo) const {
		assert(pErrorInfo != 0);
		*pErrorInfo = m_pErrorInfo;
		(*pErrorInfo)->AddRef();
	}

	///	G[ HRESULT Ԃ
	HRESULT	GetSCode() const {
		return m_hResult;
	}

	/// OIuWFNg_XbhOƂē
	void	ThrowLogicalThreadError() {
		::SetErrorInfo(0, m_pErrorInfo);
	}

	/**
	 *	HRESULT ɑΉG[bZ[WԂ
	 *	@param hResult			[in] HRESULT
	 *	@param bstrDescription	[out] G[bZ[W
	 *	@param dwLanguage		[in]  ID
	 */
	static void GetDescriptionOfSCode(HRESULT hResult,
			BSTR& bstrDescription, DWORD dwLanguageId = MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT)) {
		void*	pwszDescription = 0;

		FormatMessageW(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			0, hResult, dwLanguageId, reinterpret_cast<wchar_t*>(&pwszDescription), 0, 0);
		bstrDescription = ::SysAllocString(reinterpret_cast<OLECHAR*>(pwszDescription));
		::LocalFree(pwszDescription);
	}

	// f[^o
private:
	HRESULT		m_hResult;
	IErrorInfo*	m_pErrorInfo;

};

} // namespace Armaiti

#endif /* _COM_GENERIC_H_ */

/* [EOF] */