// PluginManager.h
// (c) 2003 exeal

#ifndef _PLUGIN_MANAGER_H_
#define _PLUGIN_MANAGER_H_

#include <vector>
#include "..\Armaiti\UnknownImpl.h"
using namespace Armaiti;
#define _COM_NO_STANDARD_GUIDS_
#include "msxml3.tlh"
using namespace MSXML2;


namespace Alpha {

class CAlphaApp;

// CPluginManager class definition
/////////////////////////////////////////////////////////////////////////////

///	vOC̊Ǘ
class CPluginManager {
	// RXgN^
public:
	CPluginManager();
	~CPluginManager();

	// \bh
public:
	bool			ExecutePlugin(CAlphaApp* pApp, unsigned int iPlugin) throw(out_of_range);
	unsigned int	GetCount() const;
	wstring			GetLastErrorMessage() const;
	wstring			GetPluginDescription(unsigned int iPlugin) const throw(out_of_range);
	wstring			GetPluginName(unsigned int iPlugin) const throw(out_of_range);
	void			LimitCount(unsigned int cLimit);
	bool			LoadPlugins(const wchar_t* pwszFilePath);

	// f[^o
private:
	struct TPluginInfo {
		bool	bReferenceURI;
		wstring	strName;
		wstring	strLanguage;
		wstring	strScript;
		wstring	strDescription;
	};
	vector<TPluginInfo>	m_vecPlugins;
	unsigned int		m_cLimit;
	wstring				m_strLastErrorMessage;
	wstring				m_strFilePath;

	// NX
private:
	class CSAXReadHandler :
			public IUnknownImpl<CUnheapMemoryManageModel>,
			public ISAXContentHandler,
			public ISAXErrorHandler {
		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN()
		STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {
			VERIFY_POINTER(ppvObject);
			if(riid == IID_IUnknown || riid == __uuidof(ISAXContentHandler))
				*ppvObject = static_cast<ISAXContentHandler*>(this);
			else if(riid == __uuidof(ISAXErrorHandler))
				*ppvObject = static_cast<ISAXErrorHandler*>(this);
			else
				return (*ppvObject = 0), E_NOINTERFACE;
			reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
			return S_OK;
		}
//		BEGIN_INTERFACE_TABLE()
//			IMPLEMENTS_LEFTMOST_INTERFACE(ISAXContentHandler)
//			IMPLEMENTS_INTERFACE(ISAXErrorHandler)
//		END_INTERFACE_TABLE()

		// ISAXContentHandler C^[tFCX
		STDMETHODIMP	putDocumentLocator(ISAXLocator* pLocator);
		STDMETHODIMP	startDocument();
		STDMETHODIMP	endDocument();
		STDMETHODIMP	startPrefixMapping(wchar_t* pwchPrefix,
							int cchPrefix, wchar_t* pwchUri, int cchUri);
		STDMETHODIMP	endPrefixMapping(wchar_t* pwchPrefix, int cchPrefix);
		STDMETHODIMP	startElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
							wchar_t* pwchLocalName, int cchLocalName,
							wchar_t* pwchQName, int cchQName, ISAXAttributes* pAttributes);
		STDMETHODIMP	endElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
							wchar_t* pwchLocalName, int cchLocalName,
							wchar_t* pwchQName, int cchQName);
		STDMETHODIMP	characters(wchar_t* pwchChars, int cchChars);
		STDMETHODIMP	ignorableWhitespace(wchar_t* pwchChars, int cchChars);
		STDMETHODIMP	processingInstruction (wchar_t* pwchTarget, int cchTarget,
							wchar_t* pwchData, int cchData);
		STDMETHODIMP	skippedEntity(wchar_t* pwchName, int cchName);

		// ISAXErrorHandler C^[tFCX
		STDMETHODIMP	error(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	fatalError(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	ignorableWarning(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);

		// f[^o
	public:
		unsigned int	m_iPlugin;
		int				m_nReadingPhase;	// 0-plugin, 1-description, 2-script
		CPluginManager*	m_pParent;
	} m_oSAXHandler;

	friend class CSAXReadHandler;
};

} /* namespace Alpha */

#endif /* _PLUGIN_MANAGER_H_ */

/* [EOF] */