// PluginManager.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "PluginManager.h"
#include "Alpha.h"					// CAlphaApp
#include "AlphaScriptHost.h"		// CAlphaScriptHost
#include "Ambient.h"				// CApplication
#include <objsafe.h>				// IObjectSafety
#include "..\Manah\Text.h"
using Alpha::CPluginManager;
using namespace Manah;
using namespace Manah::Text;


// CPluginManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CPluginManager::CPluginManager() : m_cLimit(8) {
	m_oSAXHandler.m_pParent = this;
}

///	fXgN^
CPluginManager::~CPluginManager() {
}

/**
 *	vOCs
 *	@param iPlugin		vOC̔ԍ
 *	@param pApp			AvP[V
 *	@throw out_of_range	<var>iPlugin</var> ȂƂX[
 *	@return				XNvgsłǂ
 */
bool CPluginManager::ExecutePlugin(Alpha::CAlphaApp* pApp, unsigned int iPlugin) throw(out_of_range) {
	assert(pApp != 0);

	CLSID							clsidLanguageEngine;
	CComPtr<IActiveScript>			pScriptEngine;			// XNvgGW	
	CComPtr<IActiveScriptParse>		pScriptParser;			// p[T
	CComPtr<IObjectSafety>			pObjectSafety;			// GW̐M
	CComPtr<CAlphaScriptHost>		pScriptHost;			// XNvgzXg
	CComPtr<Ambient::CApplication>	pApplication;			// ŏʃIuWFNg
	HRESULT						hr;

	TPluginInfo&	pluginInfo = m_vecPlugins[iPlugin];
	wchar_t*		pwszSource = 0;	// \[Xt@CǂݍޏꍇɎgp

	m_strLastErrorMessage.erase();
	if(iPlugin >= m_vecPlugins.size())
		throw out_of_range("Second argument is out of bound.");

	// src gꍇ -> t@Cǂݍ
	wchar_t	wszFilePath[MAX_PATH];
	if(pluginInfo.bReferenceURI) {
		CFile			oFile;
		DWORD			dwFileSize;
		wchar_t*		pwszTitle;
		unsigned char*	pszSource;
		CharCode		cc = CC_AUTO;

		::GetModuleFileNameW(0, wszFilePath, MAX_PATH);
		pwszTitle = wcsrchr(wszFilePath, L'\\');
		wcscpy(pwszTitle + 1, pluginInfo.strScript.c_str());
		if(!::PathFileExistsW(wszFilePath)) {
			m_strLastErrorMessage = wszFilePath;
			m_strLastErrorMessage += L"\n\nt@C܂B\nvOCs邱Ƃ͂ł܂B";
			return false;
		}
		try {
			oFile.Open(wszFilePath, CFile::modeRead | CFile::shareDenyNone);
		} catch(CFileException& /* e */) {
			m_strLastErrorMessage = wszFilePath;
			m_strLastErrorMessage += L"\n\nt@Cǂݍ߂܂łB\nvOCs邱Ƃ͂ł܂B";
			return false;
		}
		dwFileSize = oFile.GetFileSize(0);
		pszSource = new unsigned char[dwFileSize];
		dwFileSize = oFile.Read(pszSource, dwFileSize);
		oFile.Close();
		pwszSource = new wchar_t[dwFileSize * 2];
		dwFileSize = ConvertToUnicode(cc, pwszSource, pszSource, dwFileSize);
		*(pwszSource + dwFileSize) = 0;
		delete[] pszSource;
	}

	// ꖼXNvgGW[h
	if(FAILED(::CLSIDFromProgID(pluginInfo.strLanguage.c_str(), &clsidLanguageEngine))
			|| FAILED(::CoCreateInstance(clsidLanguageEngine, 0,
				CLSCTX_ALL, IID_IActiveScript, reinterpret_cast<void**>(&pScriptEngine)))) {
		m_strLastErrorMessage = L"script vf̌ꖼȂAXNvgGWCXg[Ă܂B\nvOCs邱Ƃ͂ł܂B";
		return false;
	}

	// GW̃ZLeBxグ (s\)
//	if(FAILED(pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety)))) {
//		m_strLastErrorMessage = L"GW Alpha ̃ZLeBv𖞂܂łB\nvOCs邱Ƃ͂ł܂B";
//		return false;
//	}
//	DWORD	dwSupportedOpts, dwEnabledOpts;
//	pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts);
//	pObjectSafety->SetInterfaceSafetyOptions(IID_IActiveScript,
//		INTERFACESAFE_FOR_UNTRUSTED_CALLER | INTERFACESAFE_FOR_UNTRUSTED_DATA,
//		INTERFACESAFE_FOR_UNTRUSTED_CALLER | INTERFACESAFE_FOR_UNTRUSTED_DATA);

	// vOCs̏
	pApplication = new Ambient::CApplication(pApp);
	pScriptHost = new CAlphaScriptHost(pApp->GetMainWindow()->m_hWnd, pScriptEngine);
	pScriptHost->SetScriptPath(pluginInfo.bReferenceURI ? wszFilePath : m_strFilePath.c_str());
	pScriptHost->AddTopLevelObject(OLESTR("Ambient"), pApplication);
	pScriptHost->AddTopLevelObject(OLESTR("Alpha"), pApplication);
	pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pScriptParser));
	hr = pScriptEngine->SetScriptSite(pScriptHost);
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = pScriptParser->InitNew();
	hr = pScriptEngine->AddNamedItem(OLESTR("Ambient"), SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	hr = pScriptEngine->AddNamedItem(OLESTR("Alpha"), SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	hr = pScriptEngine->AddNamedItem(OLESTR("WScript"), SCRIPTITEM_ISVISIBLE);

	// s
	pScriptParser->ParseScriptText(
		pluginInfo.bReferenceURI ? pwszSource : pluginInfo.strScript.c_str(),
		0, 0, 0, 0, 0, SCRIPTTEXT_ISVISIBLE, 0, 0);
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_STARTED);
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);

	// n
	pScriptEngine->Close();
	delete[] pwszSource;

	return true;
}

///	vOČԂ
unsigned int CPluginManager::GetCount() const {
	return m_vecPlugins.size();
}

///	ŌɔG[̃G[bZ[WԂ
wstring CPluginManager::GetLastErrorMessage() const {
	return m_strLastErrorMessage;
}

/**
 *	vOC̐Ԃ
 *	@param iPlugin		vOC̔ԍ
 *	@throw out_of_range	<var>iPlugin</var> ȂƂX[
 */
wstring CPluginManager::GetPluginDescription(unsigned int iPlugin) const throw(out_of_range) {
	if(iPlugin >= m_vecPlugins.size())
		throw out_of_range("Specified plugin not found.");
	return m_vecPlugins[iPlugin].strDescription;
}

/**
 *	vOC̖OԂ
 *	@param iPlugin		vOC̔ԍ
 *	@throw out_of_range	<var>iPlugin</var> ȂƂX[
 */
wstring CPluginManager::GetPluginName(unsigned int iPlugin) const throw(out_of_range) {
	if(iPlugin >= m_vecPlugins.size())
		throw out_of_range("Specified plugin not found.");
	return m_vecPlugins[iPlugin].strName;
}

/**
 *	ێłvOC̑𐧌Bݒꂽ͍폜
 *	@param cLimit	Vl
 */
void CPluginManager::LimitCount(unsigned int cLimit) {
	m_cLimit = cLimit;
	if(m_cLimit > m_vecPlugins.size())
		m_vecPlugins.resize(m_cLimit);
}

/**
 *	t@CvOC[h
 *	@param pwszFilePath	vOCt@C
 *	@return				
 */
bool CPluginManager::LoadPlugins(const wchar_t* pwszFilePath) {
	assert(pwszFilePath != 0);

	CComPtr<ISAXXMLReader>	pXMLReader;
	HRESULT					hr;

	m_strLastErrorMessage.erase();
	m_strFilePath = pwszFilePath;
	hr = ::CoCreateInstance(__uuidof(SAXXMLReader), 0,
		CLSCTX_ALL, __uuidof(ISAXXMLReader), reinterpret_cast<void**>(&pXMLReader));
	if(SUCCEEDED(hr)) {
		pXMLReader->putContentHandler(&m_oSAXHandler);
		pXMLReader->putErrorHandler(&m_oSAXHandler);
		hr = pXMLReader->parseURL(const_cast<wchar_t*>(pwszFilePath));
		if(FAILED(hr))
			m_vecPlugins.clear();
	} else
		m_strLastErrorMessage = L"SAX p[Tpł܂BXML t@C̉͂ɂ MSXML 3 KvłB";

	return m_strLastErrorMessage.empty();
}


// CSAXReadHandler class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	ISAXContentHandler::characters
STDMETHODIMP CPluginManager::CSAXReadHandler::characters(wchar_t* pwchChars, int cchChars) {
	if(m_nReadingPhase == 1)	// description
		m_pParent->m_vecPlugins[m_iPlugin].strDescription.append(pwchChars, cchChars);
	else if(m_nReadingPhase == 2)	// script
		m_pParent->m_vecPlugins[m_iPlugin].strScript.append(pwchChars, cchChars);
	return S_OK;
}

///	@see	ISAXContentHandler::endDocument
STDMETHODIMP CPluginManager::CSAXReadHandler::endDocument() {
	return S_OK;
}

///	@see	ISAXContentHandler::endElement
STDMETHODIMP CPluginManager::CSAXReadHandler::endElement(wchar_t* pwchNamespaceUri,
		int cchNamespaceUri, wchar_t* pwchLocalName, int cchLocalName, wchar_t* pwchQName, int cchQName) {
	if(wcsncmp(pwchLocalName, L"plugin", cchLocalName) == 0)
		++m_iPlugin;
	else if(wcsncmp(pwchLocalName, L"description", cchLocalName) == 0
			|| wcsncmp(pwchLocalName, L"script", cchLocalName) == 0)
		m_nReadingPhase = 0;
	return S_OK;
}

///	@see	ISAXContentHandler::endPrefixMapping
STDMETHODIMP CPluginManager::CSAXReadHandler::endPrefixMapping(wchar_t* pwchPrefix, int cchPrefix) {
	return S_OK;
}

///	@see	ISAXErrorHandler::error
STDMETHODIMP CPluginManager::CSAXReadHandler::error(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	stream;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	stream << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pParent->m_strLastErrorMessage = stream.str();
	return S_OK;
}

///	@see	ISAXErrorHandler::fatalError
STDMETHODIMP CPluginManager::CSAXReadHandler::fatalError(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	stream;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	stream << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pParent->m_strLastErrorMessage = stream.str();
	return S_OK;
}

///	@see	ISAXErrorHandler::ignorableWarning
STDMETHODIMP CPluginManager::CSAXReadHandler::ignorableWarning(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	return S_OK;
}

///	@see	ISAXContentHandler::ignorableWhitespace
STDMETHODIMP CPluginManager::CSAXReadHandler::ignorableWhitespace(wchar_t* pwchChars, int cchChars) {
	return S_OK;
}

///	@see	ISAXContentHandler::processingInstruction
STDMETHODIMP CPluginManager::CSAXReadHandler::processingInstruction(
		wchar_t* pwchTarget, int cchTarget, wchar_t* pwchData, int cchData) {
	return S_OK;
}

///	@see	ISAXContentHandler::putDocumentLocator
STDMETHODIMP CPluginManager::CSAXReadHandler::putDocumentLocator(ISAXLocator* pLocator) {
	return S_OK;
}

///	@see	ISAXContentHandler::skippedEntity
STDMETHODIMP CPluginManager::CSAXReadHandler::skippedEntity(wchar_t* pwchName, int cchName) {
	return S_OK;
}

///	@see	ISAXContentHandler::startDocument
STDMETHODIMP CPluginManager::CSAXReadHandler::startDocument() {
	m_iPlugin = 0;
	m_pParent->m_vecPlugins.clear();
	return S_OK;
}

///	@see	ISAXContentHandler::startElement
STDMETHODIMP CPluginManager::CSAXReadHandler::startElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
	   wchar_t* pwchLocalName, int cchLocalName, wchar_t* pwchQName, int cchQName, ISAXAttributes* pAttributes) {
	wchar_t*	pwszValue = 0;
	int			cchValue;
	HRESULT		hr;

	if(m_iPlugin >= m_pParent->m_cLimit - 1)
		return S_OK;
		
	if(wcsncmp(pwchLocalName, L"plugin", cchLocalName) == 0) {	// plugin vf name 擾
		m_nReadingPhase = 0;
		m_pParent->m_vecPlugins.resize(m_iPlugin + 1);
		hr = pAttributes->getValueFromName(L"", 0, L"name", 4, &pwszValue, &cchValue);
		m_pParent->m_vecPlugins[m_iPlugin].strName = SUCCEEDED(hr) ? pwszValue : L"";
	} else if(wcsncmp(pwchLocalName, L"script", cchLocalName) == 0) {	// script vf language Asrc 擾
		m_nReadingPhase = 2;
		hr = pAttributes->getValueFromName(L"", 0, L"language", 8, &pwszValue, &cchValue);
		m_pParent->m_vecPlugins[m_iPlugin].strLanguage = SUCCEEDED(hr) ? pwszValue : L"";
		hr = pAttributes->getValueFromName(L"", 0, L"src", 3, &pwszValue, &cchValue);
		if(SUCCEEDED(hr)) {
			m_nReadingPhase = 0;	// CDATA ͓ǂ܂Ȃ
			m_pParent->m_vecPlugins[m_iPlugin].bReferenceURI = true;
			m_pParent->m_vecPlugins[m_iPlugin].strScript = pwszValue;
		} else
			m_pParent->m_vecPlugins[m_iPlugin].bReferenceURI = false;
	} else if(wcsncmp(pwchLocalName, L"description", cchLocalName) == 0)
		m_nReadingPhase = 1;
	return S_OK;
}

///	@see	ISAXContentHandler::startPrefixMapping
STDMETHODIMP CPluginManager::CSAXReadHandler::startPrefixMapping(
		wchar_t* pwchPrefix, int cchPrefix, wchar_t* pwchUri, int cchUri) {
	return S_OK;
}

/* [EOF] */