// CodePageManager.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _CODE_PAGE_MANAGER_H_
#define _CODE_PAGE_MANAGER_H_

#include <list>
#include <map>


// CCodePageManager class definition
/////////////////////////////////////////////////////////////////////////////

namespace Alpha {

typedef map<UINT, const wchar_t*>	CodePageMap;

///	R[hy[W̊Ǘ
class CCodePageManager {
	// \bh
public:
	static void				EnumCodePages(list<UINT>& li);
	static void				EnumAvailableCodePageNames(list<wstring>& li);
	static void				EnumAvailableCodePages(list<UINT>& li);
	static const wchar_t*	GetCodePageName(UINT nCodePage);
private:
	static BOOL CALLBACK	_EnumCodePagesProc(LPTSTR lpCodePageString);

	// f[^o
private:
	static list<UINT>*	m_pWork;
	static CodePageMap	m_mapNames;

};

}

#endif /* _CODE_PAGE_MANAGER_H_ */

/* [EOF] */