// CodePageManager.cpp
/////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "CodePageManager.h"
#include "AlphaDoc.h"
using Alpha::CCodePageManager;
using Alpha::CodePageMap;


// CCodePageManager class implementation
/////////////////////////////////////////////////////////////////////////////

list<UINT>*	CCodePageManager::m_pWork = 0;
CodePageMap	CCodePageManager::m_mapNames;

///	::EnumSystemCodePages Ŏg
BOOL CALLBACK CCodePageManager::_EnumCodePagesProc(LPTSTR lpCodePageString) {
	assert(m_pWork != 0);

//	CPINFOEX	cpiex;	// _~[
	UINT		nCP =  wcstoul(lpCodePageString, 0, 10);

	if(::IsValidCodePage(nCP) /*&& ::GetCPInfoEx(nCP, 0, &cpiex)*/)
		CCodePageManager::m_pWork->push_back(nCP);

	return TRUE;
}

///	VXeŗp\ȃR[hy[W̃XgԂ
void CCodePageManager::EnumAvailableCodePageNames(list<wstring>& li) {
	list<UINT>	listCPs;

	li.clear();
	EnumAvailableCodePages(listCPs);
	for(list<UINT>::const_iterator it = listCPs.begin(); it != listCPs.end(); ++it)
		li.push_back(GetCodePageName(*it));
}

///	VXeŗp\ȃR[hy[W̃XgԂ
void CCodePageManager::EnumAvailableCodePages(list<UINT>& li) {
	m_pWork = &li;
	m_pWork->clear();
	::EnumSystemCodePages(_EnumCodePagesProc, CP_INSTALLED);
	m_pWork = 0;

	// ȉǉ
	li.push_back(Ascension::EXTCP_EUCJP);
	li.push_back(Ascension::EXTCP_UTF16LE);
	li.push_back(Ascension::EXTCP_UTF16BE);
	li.push_back(Ascension::EXTCP_UTF32LE);
	li.push_back(Ascension::EXTCP_UTF32BE);
	li.push_back(Ascension::EXTCP_UTF5);
}

///	SẴR[hy[WXgԂ
void CCodePageManager::EnumCodePages(list<UINT>& li) {
	static UINT	arrCPs[] = {
		Ascension::EXTCP_EUCJP,	Ascension::EXTCP_UTF16LE,	Ascension::EXTCP_UTF16BE,
		Ascension::EXTCP_UTF32LE,	Ascension::EXTCP_UTF32BE,	Ascension::EXTCP_UTF5,
		37,		437,	500,	708,	709,	710,	720,	737,
		775,	850,	852,	855,	857,	858,	860,	861,
		862,	863,	864,	865,	866,	869,	870,	874,
		875,	932,	949,	950,	1026,	1047,	1140,	1141,
		1142,	1143,	1144,	1145,	1146,	1147,	1148,	1149,
		1250,	1251,	1252,	1253,	1254,	1255,	1256,	1257,
		1258,	1361,	10000,	10001,	10002,	10003,	10004,	10005,
		10006,	10007,	10008,	10010,	10017,	10021,	10029,	10079,
		10081,	10082,	20000,	20001,	20002,	20003,	20004,	20005,
		20105,	20106,	20107,	20108,	20127,	20261,	20269,	20273,
		20277,	20278,	20280,	20284,	20285,	20290,	20297,	20420,
		20423,	20424,	20833,	20838,	20866,	20871,	20880,	20905,
		20924,	20932,	21025,	21027,	21866,	28591,	28592,	28593,
		28594,	28595,	28596,	28599,	28605,	29001,	38598,	50220,
		50221,	50222,	50225,	50227,	50229,	50930,	50931,	50933,
		50935,	50936,	50937,	50939,	51936,	51949,	51950,	52936,
		54936,	57002,	57003,	57004,	57005,	57006,	57007,	57008,
		57009,	57010,	57011,	65000,	65001
	};

	li.assign(arrCPs, arrCPs + sizeof(arrCPs) / sizeof(UINT));
//	for(size_t i = 0; i < sizeof(arrCPs) / sizeof(UINT); ++i)	// VC6
//		li.push_back(arrCPs[i]);
}

/**
 *	R[hy[W̖OԂ
 *	@param nCodePage	R[hy[W
 *	@return				OBȂƂ͋󕶎
 */
const wchar_t* CCodePageManager::GetCodePageName(UINT nCodePage) {
	static wchar_t						wszCPName[100];
//	CPINFOEX							cpiex;
	map<UINT, const wchar_t*>::iterator	it;

	if(m_mapNames.empty()) {
		m_mapNames[Ascension::EXTCP_EUCJP] = L"{ (EUC)";
		m_mapNames[Ascension::EXTCP_UTF16LE] = L"UTF-16";
		m_mapNames[Ascension::EXTCP_UTF16BE] = L"UTF-16 big endian";
		m_mapNames[Ascension::EXTCP_UTF32LE] = L"UTF-32";
		m_mapNames[Ascension::EXTCP_UTF32BE] = L"UTF-32 big endian";
		m_mapNames[Ascension::EXTCP_UTF5] = L"UTF-5";
		m_mapNames[37] = L"č/Ji_ (IBM EBCDIC)";
		m_mapNames[437] = L"č (OEM)";
		m_mapNames[500] = L"C^[iVi (IBM EBCDIC)";
		m_mapNames[708] = L"ArA (ASMO)";
		m_mapNames[709] = L"ArA (ASMO 449+, BCON V4)";	// [*]
		m_mapNames[710] = L"ArA (Transparent Arabic)";	// [*]
		m_mapNames[720] = L"ArA (Transparent ASMO)";
		m_mapNames[737] = L"MV (437G, OEM)";
		m_mapNames[775] = L"og (OEM)";
		m_mapNames[850] = L"ꃉe I (OEM)";
		m_mapNames[852] = L"e II (OEM)";
		m_mapNames[855] = L"L (OEM)";
		m_mapNames[857] = L"gR (OEM)";
		m_mapNames[858] = L"ꃉe I + [bp (OEM)";
		m_mapNames[860] = L"|gK (OEM)";
		m_mapNames[861] = L"ACXh (OEM)";
		m_mapNames[862] = L"wuC (OEM)";
		m_mapNames[863] = L"Ji_/tX (OEM)";
		m_mapNames[864] = L"ArA (OEM)";
		m_mapNames[865] = L"k (OEM)";
		m_mapNames[866] = L"VA (OEM)";
		m_mapNames[869] = L"MV (OEM)";
		m_mapNames[870] = L"}`K/ROECE (e-2, IBM EBCDIC)";
		m_mapNames[874] = L"^C (ANSI/OEM)";
		m_mapNames[875] = L"_ MV (IBM EBCDIC)";
		m_mapNames[932] = L"{ (Shift-JIS, ANSI/OEM)";
		m_mapNames[936] = L"ȑ̎ (GBK, ANSI/OEM)";
		m_mapNames[949] = L"؍ (ANSI/OEM)";
		m_mapNames[950] = L"ɑ̎ (Big5, ANSI/OEM)";
		m_mapNames[1026] = L"gR (IBM EBCDIC)";
		m_mapNames[1047] = L"e-1/Open System (IBM EBCDIC)";
		m_mapNames[1140] = L"č/Ji_ (37 + [, IBM EBCDIC)";
		m_mapNames[1141] = L"hCc (20273 + [, IBM EBCDIC)";
		m_mapNames[1142] = L"f}[N/mEF[ (20277 + [, IBM EBCDIC)";
		m_mapNames[1143] = L"tBh/XEF[f (20278 + [, IBM EBCDIC)";
		m_mapNames[1144] = L"C^A (20280 + [, IBM EBCDIC)";
		m_mapNames[1145] = L"e AJ/XyC (20284 + [, IBM EBCDIC)";
		m_mapNames[1146] = L"p (20285 + [, IBM EBCDIC)";
		m_mapNames[1147] = L"tX (20297 + [, IBM EBCDIC)";
		m_mapNames[1148] = L"C^[iVi (500 + [, IBM EBCDIC)";
		m_mapNames[1149] = L"ACXh (20871 + [, IBM EBCDIC)";
		m_mapNames[1250] = L"[bp (ANSI)";
		m_mapNames[1251] = L"L (ANSI)";
		m_mapNames[1252] = L"e I (ANSI)";
		m_mapNames[1253] = L"MV (ANSI)";
		m_mapNames[1254] = L"gR (ANSI)";
		m_mapNames[1255] = L"wuC (ANSI)";
		m_mapNames[1256] = L"ArA (ANSI)";
		m_mapNames[1257] = L"og (ANSI)";
		m_mapNames[1258] = L"xgi (ANSI/OEM)";
		m_mapNames[1361] = L"؍ (Johab)";
		m_mapNames[10000] = L"[} (Macintosh)";
		m_mapNames[10001] = L"{ (Macintosh)";
		m_mapNames[10002] = L"ɑ̎ (Big5, Macintosh)";
		m_mapNames[10003] = L"؍ (Macintosh)";
		m_mapNames[10004] = L"ArA (Macintosh)";
		m_mapNames[10005] = L"wuC (Macintosh)";
		m_mapNames[10006] = L"MV I (Macintosh)";
		m_mapNames[10007] = L"L (Macintosh)";
		m_mapNames[10008] = L"ȑ̎ (GB2312, Macintosh)";
		m_mapNames[10010] = L"[}jA (Macintosh)";
		m_mapNames[10017] = L"ENCi (Macintosh)";
		m_mapNames[10021] = L"^C (Macintosh)";
		m_mapNames[10029] = L"e II (Macintosh)";
		m_mapNames[10079] = L"ACXh (Macintosh)";
		m_mapNames[10081] = L"gR (Macintosh)";
		m_mapNames[10082] = L"NA`A (Macintosh)";
		m_mapNames[20000] = L"p (CNS)";
		m_mapNames[20001] = L"p (TCA)";
		m_mapNames[20002] = L"p (Eten)";
		m_mapNames[20003] = L"p (IBM5550)";
		m_mapNames[20004] = L"p (TeleText)";
		m_mapNames[20005] = L"p (Wang)";
		m_mapNames[20105] = L"IRV C^[iVi At@xbg No.5 (IA5)";
		m_mapNames[20106] = L"hCc (IA5)";
		m_mapNames[20107] = L"XEF[f (IA5)";
		m_mapNames[20108] = L"mEF[ (IA5)";
		m_mapNames[20127] = L"US-ASCII";
		m_mapNames[20261] = L"T.61";
		m_mapNames[20269] = L"Non-Spacing Accent (ISO 6937)";
		m_mapNames[20273] = L"hCc (IBM EBCDIC)";
		m_mapNames[20277] = L"f}[N/mEF[ (IBM EBCDIC)";
		m_mapNames[20278] = L"tBh/XEF[f (IBM EBCDIC)";
		m_mapNames[20280] = L"C^A (IBM EBCDIC)";
		m_mapNames[20284] = L"e AJ/XyC (IBM EBCDIC)";
		m_mapNames[20285] = L"p (IBM EBCDIC)";
		m_mapNames[20290] = L"{ (J^Jig, IBM EBCDIC)";
		m_mapNames[20297] = L"tX (IBM EBCDIC)";
		m_mapNames[20420] = L"ArA (IBM EBCDIC)";
		m_mapNames[20423] = L"MV (IBM EBCDIC)";
		m_mapNames[20424] = L"wuC (IBM EBCDIC)";
		m_mapNames[20833] = L"؍g (IBM EBCDIC)";
		m_mapNames[20838] = L"^C (IBM EBCDIC)";
		m_mapNames[20866] = L"VA (KOI8)";
		m_mapNames[20871] = L"ACXh (IBM EBCDIC)";
		m_mapNames[20880] = L"L (VA, IBM EBCDIC)";
		m_mapNames[20905] = L"gR (IBM EBCDIC)";
		m_mapNames[20924] = L"e-1/Open System (1047 + [, IBM EBCDIC)";
		m_mapNames[20932] = L"{ (JIS X 0208-1990 & 0212-1990)";
		m_mapNames[20936] = L"ȑ̎ (GB2312)";
		m_mapNames[21025] = L"L (ZrAAuKA, IBM EBCDIC)";
		m_mapNames[21027] = L"Ext Alpha Lowercase";
		m_mapNames[21866] = L"ENCi (KOI8-U)";
		m_mapNames[28591] = L"e I (ISO 8859-1)";
		m_mapNames[28592] = L"[bp (ISO 8859-2)";
		m_mapNames[28593] = L"e 3 (ISO 8859-3)";
		m_mapNames[28594] = L"og (ISO 8859-4)";
		m_mapNames[28595] = L"L (ISO 8859-5)";
		m_mapNames[28596] = L"ArA (ISO 8859-6)";
		m_mapNames[28597] = L"MV (ISO 8859-7)";
		m_mapNames[28598] = L"wuC (o, ISO 8859-8)";
		m_mapNames[28599] = L"e 5 (ISO 8859-9)";
		m_mapNames[28605] = L"e 9 (ISO 8859-15)";
		m_mapNames[29001] = L"[bp 3";	// [*]
		m_mapNames[38598] = L"wuC (_, ISO 8859-8)";
		m_mapNames[50220] = L"{ (pJ^JiȂ, ISO-2022)";
		m_mapNames[50221] = L"{ (pJ^Ji, ISO-2022)";
		m_mapNames[50222] = L"{ (JIS X 0201-1989, ISO-2022)";
		m_mapNames[50225] = L"؍ (ISO-2022)";
		m_mapNames[50227] = L"ȑ̎ (ISO-2022)";
		m_mapNames[50229] = L"ɑ̎ (ISO-2022)";
		m_mapNames[50930] = L"{ (J^Jig)";	// [*]
		m_mapNames[50931] = L"{ + č/Ji_";	// [*]
		m_mapNames[50933] = L"؍ + ؍g";	// [*]
		m_mapNames[50935] = L"ȑ̎ + ȑ̎g";	// [*]
		m_mapNames[50936] = L"ȑ̎";	// [*]
		m_mapNames[50937] = L"ɑ̎ + č/Ji_";	// [*]
		m_mapNames[50939] = L"{ + {ꃉeg";	// [*]
		m_mapNames[51936] = L"ȑ̎ (EUC)";	// [*]
		m_mapNames[51949] = L"؍ (EUC)";
		m_mapNames[51950] = L"ɑ̎ (EUC)";	// [*]
		m_mapNames[52936] = L"ȑ̎ (HZ-GB2312)";
		m_mapNames[54936] = L"ȑ̎ (GB18030)";	// [WinXP ̂]
		m_mapNames[57002] = L"foiK (ISCII)";
		m_mapNames[57003] = L"xK (ISCII)";
		m_mapNames[57004] = L"^~[ (ISCII)";
		m_mapNames[57005] = L"eO (ISCII)";
		m_mapNames[57006] = L"AbT (ISCII)";
		m_mapNames[57007] = L"I[ (ISCII)";
		m_mapNames[57008] = L"Ji (ISCII)";
		m_mapNames[57009] = L"} (ISCII)";
		m_mapNames[57010] = L"OW[g (ISCII)";
		m_mapNames[57011] = L"OL[ (ISCII)";
		m_mapNames[65000] = L"UTF-7";
		m_mapNames[65001] = L"UTF-8";
	}

	it = m_mapNames.find(nCodePage);
	if(it != m_mapNames.end())
		wcscpy(wszCPName, it->second);
/*	else if(::GetCPInfoEx(nCodePage, 0, &cpiex)) {
		wcscpy(wszCPName, wcschr(cpiex.CodePageName, L'(') + 1);
		*(wszCPName + wcslen(wszCPName) - 1) = 0;
	}*/ else
		return L"";
	return wszCPName;
}

/* [EOF] */