#!usr/local/bin/perl

# unicat.pl (c) 2003-2004 exeal
# CEditView δĤΥ᥽åɼΤˡ
# UnicodeData.txt ꤷƥ°
# ɥݥȤΥ޶ڤΥꥹ (8ĤȤ˲Ԥ) 롣
# 1Ĥ2:
#
#   unicat.pl <category> [-d:directory]
#
# "category" ϰʲ椫򤹤뤫ͭʥƥ̾ (2ʸ):
#
#   mark -- Mn, Mc, Me
#   numeric -- Nd, Nl, No
#   space -- Zs
#   format -- Cf
#   id_continue -- Mn, Mc, Nd, Pc
#
# ɸϡ

use strict;
use Integer;

# show usage and abort
sub usage($) {
	die("\n" . shift() . "\nUsage: unicat.pl <category> [-d:directory]\n\n");
}

my $strFileName = 'UnicodeData.txt';
my $strPattern;

usage("Bad parameter number.") if($#ARGV != 0 and $#ARGV != 1);
if($ARGV[0] eq 'mark') {
	$strPattern = '(Mn)|(Mc)|(Me)';
} elsif($ARGV[0] eq 'numeric') {
	$strPattern = '(Nd)|(Nl)|(No)';
} elsif($ARGV[0] eq 'space') {
	$strPattern = 'Zs';
} elsif($ARGV[0] eq 'format') {
	$strPattern = 'Cf';
} elsif($ARGV[0] eq 'id_continue') {
	$strPattern = '(Mn)|(Mc)|(Nd)|(Pc)';
} else {
	$strPattern = $ARGV[0];
}
if($#ARGV == 1) {
	usage("Second parameter is illegal.") unless($ARGV[1] =~ /\-d\:(.+)/);
	my $strPath = $1;
	$strPath =~ tr/\"//;
	$strFileName = $strPath . "\\" . $strFileName;
}

my $strLine;
my $cMatch = 0;

if(!open(FH, $strFileName)) {
	die("\nCannot open $strFileName.\nIf UnicodeData.txt is not current directory, you can use -d:<directory> switch to specify where the file is.\n");
}

while($strLine = <FH>) {
	if($strLine =~ m/^(.*?)\;.*?\;(\w\w)/) {
		my $cp = $1;
		if($2 =~ m/$strPattern/) {
			print(($cMatch++ % 8 == 0) ? "\n" : " ");
			print("0x$cp,");
		}
	}
}

close(FH);

# print "\n$cMatch characters output.\n\n";

__END__