// TextSearcher.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "TextSearcher.h"
#include "EditView.h"
#include "..\..\Manah\Text.h"
#include "..\..\Armaiti\OleTypeWrapper.h"
#include "VBScript_RegExp.tlh"
using namespace Ascension;
using namespace Manah::Text;
using namespace Armaiti;
using namespace Armaiti::OLE;
using namespace VBScript_RegExp_55;


// CTextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSearcher::CTextSearcher() : m_pRegExp(0) {
}

///	fXgN^
CTextSearcher::~CTextSearcher() {
	if(m_pRegExp != 0)
		m_pRegExp->Release();
}

///	K\\ǂԂ
bool CTextSearcher::IsRegExpAvailable() const {
	AssertValid();

	if(m_pRegExp != 0)
		return true;

	CLSID	clsid;

	if(FAILED(::CLSIDFromProgID(OLESTR("VBScript.RegExp"), &clsid)))
		return false;
	if(FAILED(::CoCreateInstance(clsid, 0,
			CLSCTX_INPROC, __uuidof(IRegExp),
			reinterpret_cast<void**>(&const_cast<CTextSearcher*>(this)->m_pRegExp))))
		return false;
	return true;
}

/**
 *	s
 *	@param iBegin	Jnʒu
 *	@param iFound	[out] ʒu
 *	@param cchFound	[out] ̒
 *	@return			ǂ
 *	@throw EFailedToLoadRegExpEngine
 *					K\GW̓ǂݍ݂Ɏs
 */
bool CTextSearcher::Search(size_t iBegin, size_t& iFound, size_t& cchFound)
		throw(EFailedToLoadRegExpEngine, ERegExpPatternIsInvalid) {
	AssertValid();

	// 
	if(toBoolean(m_sfFlags & SF_REGEXP)) {
		if(!IsRegExpAvailable())
			throw EFailedToLoadRegExpEngine();

		CComPtr<IMatchCollection>	pMatches;
		CComPtr<IMatch>				pMatch;
		long		cMatched;
		CComBSTR	bstrPattern(m_strFindWhat.c_str());
		CComBSTR	bstrSource((m_sfFlags & SF_BACKWARD) ?
						m_strTarget.substr(0, iBegin).c_str() :
						m_strTarget.c_str() + min(iBegin, m_strTarget.length()));

		m_pRegExp->put_Global(toVariantBoolean(m_sfFlags & SF_BACKWARD));
		if(FAILED(m_pRegExp->put_Pattern(bstrPattern.GetBSTR())))
			throw ERegExpPatternIsInvalid();
		if(FAILED(m_pRegExp->Execute(bstrSource.GetBSTR(), reinterpret_cast<IDispatch**>(&pMatches))))
			throw ERegExpPatternIsInvalid();
		pMatches->get_Count(&cMatched);
		if(cMatched == 0)
			return false;
		pMatches->get_Item(
			toBoolean(m_sfFlags & SF_BACKWARD) ? cMatched - 1 : 0,
			reinterpret_cast<IDispatch**>(&pMatch));
		pMatch->get_FirstIndex(reinterpret_cast<long*>(&iFound));	// Ȃ
		pMatch->get_Length(reinterpret_cast<long*>(&cchFound));
		iFound += ((m_sfFlags & SF_BACKWARD) ? 0 :iBegin);
		return true;
	} else {
		iFound = iBegin;
		do {
			if(toBoolean(m_sfFlags & SF_BACKWARD))	// O
				iFound = m_strTarget.rfind(m_strFindWhat, iFound - 1);
			else						// 
				iFound = m_strTarget.find(m_strFindWhat, iFound);
			if(iFound == wstring::npos)
				break;
			if(!toBoolean(m_sfFlags & SF_WHOLEWORD)
					|| (HasWordBorderAt(m_strTarget.c_str(), iFound)
					&& HasWordBorderAt(m_strTarget.c_str(), iFound + m_strTarget.length()))) {
				cchFound = m_strFindWhat.length();
				return true;
			}
			iFound += (toBoolean(m_sfFlags & SF_BACKWARD) ? -1 : 1);
		} while(true);
	}

	return false;
}

///	tO̐ݒ
void CTextSearcher::SetFlag(SearchFlag flags) {
	AssertValid();
	m_sfFlags = flags;
}

///	̐ݒ
void CTextSearcher::SetText(const wstring& strText) {
	AssertValid();

	size_t		cch = strText.length();
	wchar_t*	pwsz = new wchar_t[cch];
	wcsncpy(pwsz, strText.c_str(), cch);

	if(toBoolean(m_sfFlags & SF_IGNORE_CASE_SIMPLE))
		::CharLowerBuffW(pwsz, cch);
	if(toBoolean(m_sfFlags & SF_IGNORE_KANATYPE))
		ToHiragana(pwsz, cch);

	m_strFindWhat.assign(pwsz, cch);
	delete[] pwsz;
}

///	Ώە̐ݒ
void CTextSearcher::SetTargetText(const wstring& strText) {
	AssertValid();

	size_t		cch = strText.length();
	wchar_t*	pwsz = new wchar_t[cch];
	wcsncpy(pwsz, strText.c_str(), cch);

	if(toBoolean(m_sfFlags & SF_IGNORE_CASE_SIMPLE))
		::CharLowerBuffW(pwsz, cch);
	if(toBoolean(m_sfFlags & SF_IGNORE_KANATYPE))
		ToHiragana(pwsz, cch);

	m_strTarget.assign(pwsz, cch);
	delete[] pwsz;
}


// CBoundarySearcher
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CBoundarySearcher::CBoundarySearcher(CEditView& oView) : m_pView(&oView) {
}

/**
 *	PꋫEɎgNXԂ
 *	@param cp	ׂR[h|Cg
 *	@return		PꋫENX
 */
CBoundarySearcher::WBClass CBoundarySearcher::GetWordBoundaryClass(unsigned long cp) const {
	using CBoundarySearcher::WBClass;

	const LANGID	langid = ::GetUserDefaultLangID();

	// General Category  `Cf'  `Zs' ̃R[h|Cg (unicat.pl 萶)
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error List version differs from Ascension Unicode version. Update correspoding code.
#endif
	static unsigned long	arrCf[] = {
		0x00AD, 0x0600, 0x0601, 0x0602, 0x0603, 0x06DD, 0x070F, 0x17B4,
		0x17B5, 0x200C, 0x200D, 0x200E, 0x200F, 0x202A, 0x202B, 0x202C,
		0x202D, 0x202E, 0x2060, 0x2061, 0x2062, 0x2063, 0x206A, 0x206B,
		0x206C, 0x206D, 0x206E, 0x206F, 0xFEFF, 0xFFF9, 0xFFFA, 0xFFFB,
		0x1D173, 0x1D174, 0x1D175, 0x1D176, 0x1D177, 0x1D178, 0x1D179, 0x1D17A,
		0xE0001, 0xE0020, 0xE0021, 0xE0022, 0xE0023, 0xE0024, 0xE0025, 0xE0026,
		0xE0027, 0xE0028, 0xE0029, 0xE002A, 0xE002B, 0xE002C, 0xE002D, 0xE002E,
		0xE002F, 0xE0030, 0xE0031, 0xE0032, 0xE0033, 0xE0034, 0xE0035, 0xE0036,
		0xE0037, 0xE0038, 0xE0039, 0xE003A, 0xE003B, 0xE003C, 0xE003D, 0xE003E,
		0xE003F, 0xE0040, 0xE0041, 0xE0042, 0xE0043, 0xE0044, 0xE0045, 0xE0046,
		0xE0047, 0xE0048, 0xE0049, 0xE004A, 0xE004B, 0xE004C, 0xE004D, 0xE004E,
		0xE004F, 0xE0050, 0xE0051, 0xE0052, 0xE0053, 0xE0054, 0xE0055, 0xE0056,
		0xE0057, 0xE0058, 0xE0059, 0xE005A, 0xE005B, 0xE005C, 0xE005D, 0xE005E,
		0xE005F, 0xE0060, 0xE0061, 0xE0062, 0xE0063, 0xE0064, 0xE0065, 0xE0066,
		0xE0067, 0xE0068, 0xE0069, 0xE006A, 0xE006B, 0xE006C, 0xE006D, 0xE006E,
		0xE006F, 0xE0070, 0xE0071, 0xE0072, 0xE0073, 0xE0074, 0xE0075, 0xE0076,
		0xE0077, 0xE0078, 0xE0079, 0xE007A, 0xE007B, 0xE007C, 0xE007D, 0xE007E,
		0xE007F,
	};
	static unsigned long	arrZs[] = {
		0x0009,	// ^u Zs ł͂ȂA󔒗ޕƂĈ
		0x0020, 0x00A0, 0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003,
		0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x200B,
		0x202F, 0x205F, 0x3000,
	};

	if(std::binary_search(m_pView->m_FoundationInfo.listCharsTreatedAsAlpha.begin(),
			m_pView->m_FoundationInfo.listCharsTreatedAsAlpha.end(), cp))
		return aLetter;
	else if(std::binary_search(arrZs,
			arrZs + sizeof(arrZs) / sizeof(unsigned long), cp))
		return space;
	else if(cp == 0x002E		// Full Stop
			|| (cp == 0x003A	// Colon (for Swedish)
			&& toBoolean(langid & LANG_SWEDISH)))
		return midNumLet;
	else if(cp == 0x0027		// Apostrophe
			|| cp == 0x00B7		// Middle Dot
			|| cp == 0x05F4		// Hebrew Punctuation Gershayim
			|| cp == 0x2019		// Right Single Quotation Mark
			|| cp == 0x2027		// Hyphenation Point
			|| (cp == 0x0022	// Quotation Mark (for legacy Hebrew)
			&& toBoolean(langid & LANG_HEBREW)))
		return midLetter;
	else if(cp == 0x2024		// One Dot Leader
			|| cp == 0x2025		// Two Dot Leader
			|| cp == 0x2026)	// Horizontal Ellipsis
		return midNum;
	else if(std::binary_search(arrCf,
			arrCf + sizeof(arrCf) / sizeof(unsigned long), cp))
		return format;
	else if(cp == 0x05F3		// Hebrew Punctuation Geresh
			|| CEditView::IsIdentifierStartChar(cp))
		return aLetter;
	else if((cp >= 0x0030 && cp <= 0x0039)	// C0 digits
			|| (cp >= 0x0660 && cp <= 0x0669)	// Arabic-Indic digits
			|| (cp >= 0x06F0 && cp <= 0x06F9)	// Extended Arabic-Indic digits
			|| (cp >= 0x0966 && cp <= 0x096F)	// Devanagari digits
			|| (cp >= 0x09E6 && cp <= 0x09EF)	// Bengali digits
			|| (cp >= 0x0A66 && cp <= 0x0A6F)	// Gurmukhi digits
			|| (cp >= 0x09E6 && cp <= 0x09EF)	// Bengali digits
			|| (cp >= 0x0AE6 && cp <= 0x0AEF)	// Gujarati digits
			|| (cp >= 0x0B66 && cp <= 0x0B6F)	// Oriya digits
			|| (cp >= 0x09E6 && cp <= 0x09EF)	// Bengali digits
			|| (cp >= 0x0BE7 && cp <= 0x0BE8)	// Tamil digits
			|| (cp >= 0x0C66 && cp <= 0x0C6F)	// Telugu digits
			|| (cp >= 0x0CE6 && cp <= 0x0CEF)	// Kannada digits
			|| (cp >= 0x0D66 && cp <= 0x0D6F)	// Malayalam digits
			|| (cp >= 0x0E50 && cp <= 0x0E59)	// Thai digits
			|| (cp >= 0x0ED0 && cp <= 0x0ED9)	// Lao digits
			|| (cp >= 0x0F20 && cp <= 0x0F29)	// Tibetan digits
			|| (cp >= 0x1040 && cp <= 0x1049)	// Myanmar digits
			|| (cp >= 0x1369 && cp <= 0x1371)	// Ethiopic digits
			|| (cp >= 0x17E0 && cp <= 0x17E9)	// Khmer digits
			|| (cp >= 0x1810 && cp <= 0x1819)	// Mongolian digits
			|| (cp >= 0x1946 && cp <= 0x194F)	// Limbu digits
			|| (cp >= 0x0104A0 && cp <= 0x0104A9)	// Osmanya digits
			|| (cp >= 0x01D7CE && cp <= 0x01D7FF))	// Mathematical digits
		return numeric;
	else
		return other;
}

/**
 *	񂪎wʒuɒPꋫEǂׂ
 *	@param str	ׂ镶
 *	@param i	ׂʒu
 *	@return		<var>i</var> PꋫȄꍇ true
 */
bool CBoundarySearcher::HasWordBoundaryAt(const wstring& str, size_t i) const {
/*	AssertValid();

	if(i == 0 || i == str.length())
		return true;	// (1, 2)
	else if(i > str.length())
		return false;

	const wchar_t*	pwsz = str.c_str();
	const size_t	cch = str.length();
	unsigned long	cpNext = DecodeUTF16SurrogatePairToCodePoint(pwsz + i, cch - i);

	if(!IsFirstCharacterOfCluster(cpNext))
		return false;	// (3)

	WBClass	wbcNext = GetWordBoundaryClass(cpNext);

	if(wbcNext == format)
		return false;	// (4)
	if(wbcNext == aLetter || wbcNext == midLetter
			|| wbcNext = midNumLet || wbcNext == midNum || wbcNext == numeric) {
		unsigned long	cpPrev;
		WBClass			wbcPrev;

		if(i > 2
				&& IsUTF16HighSurrogate(pwsz[i - 2])
				&& IsUTF16LowSurrogate(pwsz[i - 1]))
			cpPrev = DecodeUTF16SurrogatePairToCodePoint(pwsz + i - 2, 2);
		else
			cpPrev = pwsz[i - 1];
		wbcPrev = 
	} else*/
		return false;
}

/**
 *	NX^̍ŏ̕ɂȂ邩𒲂ׂ (A
 *	ʃTQ[g͒ÕR[h|CgɈˑ邽߂̃\bhłׂ͒Ȃ)
 *	@param cp	ׂR[h|Cg
 *	@return		<var>cp</var> NX̐擪̕ɂȂꍇ true
 */
bool CBoundarySearcher::IsFirstCharacterOfCluster(unsigned long cp) {
	// ʕނ Mn (Mark, Non-Spacing)AMc (Mark, Spacing Combining)A
	// Me (Mark, Enclosing) ̂ꂩłR[h|Cg
	// unicat.pl 莩 (Unicode 4.0)
	//
	// NOTE: ̕ނɂĂ Unicode R\[VA
	// uUAX#29: Text BoundariesvɃKChC邪A
	// Ascension ͂ɂ͏]ȂB
	//
	// NOTE: XɈȉ͂̃̕\bhł͔łȂA
	// Lbg󂯎ȂقǂȂB
	//   U+17B4: Khmer Vowel Inherent Aq
	//   U+17B5: Khmer Vowel Inherent Aa
	// 2 Unicode 4.0 ł񐄏ƂȂĂ
	static unsigned long	arrMxCodePoints[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\EditView_GraphemeExtender_4_0"
	};
	return !std::binary_search(arrMxCodePoints,
			arrMxCodePoints + sizeof(arrMxCodePoints) / sizeof(unsigned long), cp);
}

/**
 *	NX̐擪̕
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@return			ʒu
 */
CCharPos CBoundarySearcher::SearchFirstCharacterOfCluster(const CCharPos& pos, bool bForward) const {
	AssertValid();

	if(pos.m_iChar == 0 && !bForward) {
		if(pos.m_iLine == 0)
			return pos;
		return CCharPos(pos.m_iLine - 1,
				m_pView->GetDocument()->GetLineLength(pos.m_iLine - 1));
	}

	const size_t	cLines = m_pView->GetDocument()->GetLineCount();
	const wstring&	strLine = m_pView->GetDocument()->GetLine(pos.m_iLine);
	const size_t	cchLine = strLine.length();

	assert(pos.m_iLine < cLines && pos.m_iChar < cchLine);

	if(pos.m_iChar == cchLine
			&& pos.m_iLine < cLines - 1)
		return CCharPos(pos.m_iLine + 1, 0);

	const wchar_t*	pwszLine = strLine.c_str();
	unsigned long	cp;

	if(bForward) {
		for(size_t i = pos.m_iChar + 1; i < cchLine; ++i) {
			cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + i, cchLine - 1);
			if(CBoundarySearcher::IsFirstCharacterOfCluster(cp))
				return CCharPos(pos.m_iLine, i);
			if(cp > 0xFFFF)
				++i;
		}
		return CCharPos(pos.m_iLine, cchLine);
	} else {
		for(size_t i = pos.m_iChar - 1; i > 0; --i) {
			if(i > 2
					&& IsUTF16HighSurrogate(pwszLine[i - 2])
					&& IsUTF16LowSurrogate(pwszLine[i - 1]))
				cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + i - 2, 2);
			else
				cp = pwszLine[i - 1];
			if(CBoundarySearcher::IsFirstCharacterOfCluster(cp))
				return CCharPos(pos.m_iLine, i);
			if(cp > 0xFFFF)
				--i;
		}
		return CCharPos(pos.m_iLine, 0);
	}
}

/**
 *	@brief	PꋫE
 *
 *	ʒu͌JnʒuƂ͈قȂʒuɂȂ
 *	(hLg̐擪ȀꍇȊO)
 *
 *	PꋫE̊TO͒PPʂ̈ړR}h (CmdMoveNextWord)
 *	_uNbNɂJ[\ʒu̒PIȂǂɎgp
 *
 *	Ascension ɂPꋫE̒`͂܂m肵ĂȂB	
 *	݂̎ IsFirstCharacterOfCluster Ɠ
 *	uUAX #29: Text BoundariesvqgɂĂ邪A
 *	̃KChCSɖĂ킯ł͂Ȃ
 *	({ɓɂȂĂ)
 *
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@param bWordEnd	P̖ꍇ true
 *	@return			ʒu
 */
CCharPos CBoundarySearcher::SearchWordBoundary(const CCharPos& pos, bool bForward, bool bWordEnd) const {
	AssertValid();

	const LANGID	langid = ::GetUserDefaultLangID();

//#define CHECK_LOCALE_SPECIFIC_LETTERS()

	CEditDoc*	pDocument = m_pView->GetDocument();
	CCharPos	posFound = pos;

	if(pos.m_iChar == 0 && !bForward) {
		if(pos.m_iLine == 0)
			return pos;
		posFound.m_iLine = pos.m_iLine - 1;
		posFound.m_iChar = pDocument->GetLineLength(posFound.m_iLine);
		if(bWordEnd)
			return posFound;
	} else if(bForward
			&& pos.m_iChar == pDocument->GetLineLength(pos.m_iLine)) {
		if(pos.m_iLine == pDocument->GetLineCount() - 1)
			return pos;
		posFound.m_iLine = pos.m_iLine + 1;
		posFound.m_iChar = CEditView::IsWhiteSpace(
							pDocument->GetLine(posFound.m_iLine).c_str(),
							pDocument->GetLineLength(posFound.m_iLine));
		if(!bWordEnd)
			return posFound;
	}

	const wstring&	strLine = pDocument->GetLine(pos.m_iLine);
	const wchar_t*	pwszLine = strLine.c_str();
	size_t			cchLine = strLine.length();

	if(cchLine == 0 || (pos.m_iChar >= cchLine - 1 && bForward))	// eot (2)
		return CCharPos(pos.m_iLine, cchLine);

	WBClass			wbcLeft = uncalculated;			// ׂʒu̍
	WBClass			wbcRight = uncalculated;		// ׂʒủE
	unsigned long	nCodePoint, nNextCodePoint = -1, nPrevCodePoint;

	if(bForward) {
		WBClass	wbcRightAnother = uncalculated;	// ׂʒu2E
		while(posFound.m_iChar < cchLine) {
			if(nNextCodePoint != -1) {
				nCodePoint = nNextCodePoint;
				nNextCodePoint = -1;
			} else
				nCodePoint = DecodeUTF16SurrogatePairToCodePoint(
						pwszLine + posFound.m_iChar, cchLine - posFound.m_iChar);
			if(posFound.m_iChar == pos.m_iChar) {
				wbcLeft = GetWordBoundaryClass(nCodePoint);
				++posFound.m_iChar;
				nPrevCodePoint = nCodePoint;
				continue;
			}
			if(wbcRight == uncalculated)
				wbcRight = GetWordBoundaryClass(nCodePoint);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(wbcRight == format || CBoundarySearcher::IsFirstCharacterOfCluster(nCodePoint)) {
				if(wbcLeft == aLetter && wbcRight == aLetter) {	// (5+, !13)
//					CHECK_LOCALE_SPECIFIC_LETTERS();
					posFound.m_iChar += (nCodePoint > 0xFFFF) ? 2 : 1;
				} else if((wbcLeft == aLetter || wbcLeft == numeric)
						&& (wbcRight == aLetter || wbcRight == numeric))	// (8, 9, 10)
					posFound.m_iChar += (nCodePoint > 0xFFFF) ? 2 : 1;
				else if((wbcLeft == aLetter	// (6, 7)?
						&& (wbcRight == midLetter /*|| wbcRight == midNumLet*/))
						|| (wbcLeft == numeric)	// (11, 12)?
						&& (wbcRight == midNum || wbcRight == midNumLet)) {
					unsigned long	iNextChar = (nCodePoint > 0xFFFF) ? 2 : 1;

					iNextChar = posFound.m_iChar + iNextChar;
					if(iNextChar >= cchLine)
						return CCharPos(posFound.m_iLine, cchLine);	// (2)
					nNextCodePoint = DecodeUTF16SurrogatePairToCodePoint(
							pwszLine + iNextChar, cchLine - iNextChar);
					wbcRightAnother = GetWordBoundaryClass(nNextCodePoint);
					if(wbcLeft != wbcRightAnother)
						return posFound;	// (14)
					posFound.m_iChar = iNextChar;	// (6, 7, 11, 12)
					wbcRight = wbcRightAnother;
					wbcRightAnother = uncalculated;
				} else if((!bWordEnd && wbcRight == space)	// (0)
						|| (bWordEnd && wbcLeft == space))	// (0)
					posFound.m_iChar += (nCodePoint > 0xFFFF) ? 2 : 1;
				else
					return posFound;
			} else {
				posFound.m_iChar += (nCodePoint > 0xFFFF) ? 2 : 1;
				wbcRight = wbcLeft;
				nCodePoint = nPrevCodePoint;
			}

			wbcLeft = wbcRight;
			wbcRight = wbcRightAnother;
			wbcRightAnother = uncalculated;
			nPrevCodePoint = nCodePoint;
		}
		return posFound;	// (2)
	} else {
		WBClass	wbcLeftAnother = uncalculated;	// ׂʒu2
		while(posFound.m_iChar > 0) {
			if(nNextCodePoint != -1) {
				nCodePoint = nNextCodePoint;
				nNextCodePoint = -1;
			} else if(posFound.m_iChar > 1
					&& IsUTF16LowSurrogate(pwszLine[posFound.m_iChar - 1])
					&& IsUTF16HighSurrogate(pwszLine[posFound.m_iChar - 2]))
				nCodePoint = DecodeUTF16SurrogatePairToCodePoint(
					pwszLine + posFound.m_iChar - 2, cchLine - posFound.m_iChar + 2);
			else
				nCodePoint = DecodeUTF16SurrogatePairToCodePoint(
					pwszLine + posFound.m_iChar - 1, cchLine - posFound.m_iChar + 1);
			if(posFound.m_iChar == pos.m_iChar) {
				wbcRight = GetWordBoundaryClass(nCodePoint);
				posFound.m_iChar -= (nCodePoint > 0xFFFF) ? 2 : 1;
				nPrevCodePoint = nCodePoint;
				continue;
			}
			if(wbcLeft == uncalculated)
				wbcLeft = GetWordBoundaryClass(nCodePoint);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(wbcLeft == format || CBoundarySearcher::IsFirstCharacterOfCluster(nCodePoint)) {
				if(wbcLeft == aLetter && wbcRight == aLetter) {	// (5+, !13)
//					CHECK_LOCALE_SPECIFIC_LETTERS();
					posFound.m_iChar -= (nCodePoint > 0xFFFF) ? 2 : 1;
				} else if((wbcLeft == aLetter || wbcLeft == numeric)	// (8, 9, 10)
						&& (wbcRight == aLetter || wbcRight == numeric))
					posFound.m_iChar -= (nCodePoint > 0xFFFF) ? 2 : 1;
				else if((wbcRight == aLetter	// (6, 7)?
						&& (wbcLeft == midLetter /*|| wbcLeft == midNumLet*/))
						|| (wbcRight == numeric)	// (11, 12)?
						&& (wbcLeft == midNum || wbcLeft == midNumLet)) {
					unsigned long	iNextChar = (nCodePoint > 0xFFFF) ? 2 : 1;

					iNextChar = posFound.m_iChar - iNextChar;
					if(iNextChar == 0)
						return CCharPos(posFound.m_iLine, 0);	// (2)
					iNextChar -= iNextChar > 1
						&& IsUTF16HighSurrogate(pwszLine[iNextChar - 2])
						&& IsUTF16LowSurrogate(pwszLine[iNextChar - 1]) ? 2 : 1;
					nNextCodePoint = DecodeUTF16SurrogatePairToCodePoint(
							pwszLine + iNextChar, cchLine - iNextChar);
					wbcLeftAnother = GetWordBoundaryClass(nNextCodePoint);
					if(wbcRight != wbcLeftAnother)
						return posFound;	// (14)
					posFound.m_iChar = iNextChar;	// (6, 7, 11, 12)
			//		wbcLeft = wbcLeftAnother;
			//		wbcLeftAnother = uncalculated;
				} else if((!bWordEnd && wbcRight == space)	// (0)
						|| (bWordEnd && wbcLeft == space))	// (0)
					posFound.m_iChar -= (nCodePoint > 0xFFFF) ? 2 : 1;
				else
					return posFound;
			} else {
				posFound.m_iChar -= (nCodePoint > 0xFFFF) ? 2 : 1;
				wbcLeft = wbcRight;
				nCodePoint = nPrevCodePoint;
			}

			wbcRight = wbcLeft;
			wbcLeft = wbcLeftAnother;
			wbcLeftAnother = uncalculated;
			nPrevCodePoint = nCodePoint;
		}
		return posFound;	// (2)
	}
}

/* [EOF] */