// SelectLanguageDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "SelectLanguageDlg.h"
using Alpha::CSelectLanguageDlg;


// CSelectLanguageDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CSelectLanguageDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_SCRIPTENGINES && wNotifyCode == LBN_DBLCLK) {
		OnOK();
		return true;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CSelectLanguageDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	for(set<wstring>::const_iterator it = m_setLanguages.begin(); it != m_setLanguages.end(); ++it)
		SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_SETCURSEL, 0, 0L);

	return true;
}

///	@see	CDialog::OnOK
void CSelectLanguageDlg::OnOK() {
	wchar_t*	pwszSelection = 0;
	int			iSelection = SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETCURSEL, 0, 0L);
	size_t		cchSelection = SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETTEXTLEN, iSelection, 0L);

	pwszSelection = new wchar_t[cchSelection + 1];
	SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETTEXT, iSelection, reinterpret_cast<LPARAM>(pwszSelection));
	m_strSelection = pwszSelection;
	delete[] pwszSelection;

	CDialog::OnOK();
}

/* [EOF] */