// KeyBindManager.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "KeyBindManager.h"
using Alpha::CKeyBindManager;
using Alpha::KeyBindModifier;

const wchar_t* CKeyBindManager::m_arrKeyName[0x0100] = {	// L[̖O (蓖ĕs\ȃL[ null)
	/* 0x00 */	0,	0,	0,	L"Esc",	L"NbN",	0,	0,	0,
				L"BackSpace",	L"Tab",	0,	0,	L"Del",	L"Enter",	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				L"Esc",	0,	0,	0,	0,	0,	0,	0,
	/* 0x20 */	L"Space",	L"PageUp",	L"PageDown",	L"End",	L"Home",	L"",	L"",	L"",
				L"",	0,	0,	0,	0,	0,	0,	0,
				L"0",	L"1",	L"2",	L"3",	L"4",	L"5",	L"6",	L"7",
				L"8",	L"9",	0,	0,	0,	0,	0,	0,
	/* 0x40 */	0,	L"A",	L"B",	L"C",	L"D",	L"E",	L"F",	L"G",
				L"H",	L"I",	L"J",	L"K",	L"L",	L"M",	L"N",	L"O",
				L"P",	L"Q",	L"R",	L"S",	L"T",	L"U",	L"V",	L"W",
				L"X",	L"Y",	L"Z",	0,	0,	0,	0,	0,
	/* 0x60 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	L"*",	L"+",	L"|",	L"-",	L".",	L"/",
				L"F1",	L"F2",	L"F3",	L"F4",	L"F5",	L"F6",	L"F7",	L"F8",
				L"F9",	L"F10",	L"F11",	L"F12",	L"F13",	L"F14",	L"F15",	L"F16",
	/* 0x80 */	L"F17",	L"F18",	L"F19",	L"F20",	L"F21",	L"F22",	L"F23",	L"F24",
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
	/* 0xA0 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	L":",	L";",	L",",	0,	0,	0,
	/* 0xC0 */	L"@",	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	L"[",	L"\\",	L"]",	L"^",	0,
	/* 0xE0 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0
};


// CKeyBindManager class implementation
/////////////////////////////////////////////////////////////////////////////

CKeyBindManager::CKeyBindManager() {
	Reset();
}

/**
 *	݂̃IuWFNg̏ԂANZ[^e[u쐬AԂ
 *	@return	쐬ꂽANZ[^e[uBĂяo폜KvB
 *			R}h1o^ĂȂƂ null
 */
HACCEL CKeyBindManager::CreateAcceleratorTable() const {
	if(m_cCommands == 0)
		return 0;

	HACCEL	hAccel = 0;
	LPACCEL	pAccels = new ACCEL[m_cCommands];

	int		c = 0;
	for(short i = 0; i < 0x0100; ++i) {
		for(int j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] != 0) {
				(pAccels + c)->cmd = m_arrCommands[j][i];
				(pAccels + c)->key = i;
				(pAccels + c)->fVirt = FNOINVERT | FVIRTKEY;
				if(j & KBM_ALT)
					(pAccels + c)->fVirt |= FALT;
				if(j & KBM_CTRL)
					(pAccels + c)->fVirt |= FCONTROL;
				if(j & KBM_SHIFT)
					(pAccels + c)->fVirt |= FSHIFT;
				++c;
			}
		}
	}
	assert(c == m_cCommands);
	hAccel = ::CreateAcceleratorTable(pAccels, m_cCommands);

	delete[] pAccels;
	return hAccel;
}

/**
 *	L[R}h ID 擾
 *	@param sVKey			zL[
 *	@param kbm				CL[
 *	@return					蓖ĂĂR}h IDB蓖ĂĂȂƂ0
 *	@exception out_of_range	<var>sVKey</var> sȂƂX[
 */
int CKeyBindManager::GetCommandID(short sVKey, KeyBindModifier kbm) const throw(out_of_range) {
	if(sVKey >= 0x0100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	return m_arrCommands[kbm][sVKey];
}

/**
 *	蓖ĂĂL[ƏCL[Ԃ
 *	@param nCommand	R}h ID
 *	@param sVKey	zL[
 *	@param kbm		CL[
 *	@return			R}ho^Ăΐ^
 */
bool CKeyBindManager::GetKeyBind(int nCommand, short& sVKey, KeyBindModifier& kbm) const {
	for(short i = 0; i < 0x0100; ++i) {
		for(BYTE j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] == nCommand) {
				sVKey = i;
				kbm = static_cast<KeyBindModifier>(j);
				return true;
			}
		}
	}
	return false;
}

/**
 *	L[̖OԂ
 *	@param sVKey			zL[
 *	@return					L[BΉL[ꍇ null
 *	@exception out_of_range	<var>sVKey</var> sȂƂX[
 */
const wchar_t* CKeyBindManager::GetKeyName(short sVKey) throw(out_of_range) {
	if(sVKey >= 0x100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	return m_arrKeyName[sVKey];
}

/**
 *	R}hɊ蓖ĂĂL[̕\擾
 *	@param nCommand	R}h
 *	@return			"Ctrl+N" Ȃǂ̕\Bo^ĂȂ΋󕶎
 */
wstring CKeyBindManager::GetKeyString(int nCommand) const {
	wstring	str;

	for(short i = 0; i < 0x0100; ++i) {
		for(BYTE j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] == nCommand) {
				if(j & KBM_SHIFT)
					str += L"Shift+";
				if(j & KBM_CTRL)
					str += L"Ctrl+";
				if(j & KBM_ALT)
					str += L"Alt+";
				str += m_arrKeyName[i];
				return str;
			}
		}
	}
	return str;
}

/**
 *	o^Sĉ
 */
void CKeyBindManager::Reset() {
	m_cCommands = 0;
	memset(m_arrCommands, 0, sizeof(int) * 0x0100 * 8);
}

/**
 *	1̃R}ho^
 *	@param sVKey	zL[
 *	@param kbm		CL[
 *	@param nCommand	R}h ID
 */
void CKeyBindManager::SetOneCommand(short sVKey, KeyBindModifier kbm, int nCommand) throw(out_of_range) {
	if(sVKey >= 0x0100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	if(nCommand != 0 && m_arrCommands[kbm][sVKey] == 0)
		++m_cCommands;
	else if(nCommand == 0 && m_arrCommands[kbm][sVKey] != 0)
		--m_cCommands;
	m_arrCommands[kbm][sVKey] = nCommand;
}

/* [EOF] */