// ExecuteCommandDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "ExecuteCommandDlg.h"
#include "Alpha.h"
#include "..\Manah\TextConverter.h"
using Alpha::CAlphaApp;
using Alpha::CExecuteCommandDlg;
using namespace Manah;


// CExecuteCommandDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CExecuteCommandDlg::CExecuteCommandDlg(CAlphaApp* pApplication)
		: m_pApplication(pApplication), m_bExecuting(false) {
	assert(m_pApplication != 0);
//	m_oDosCommand.SetTimeout(5000);
}

///	@see	CDialog::OnCancel
void CExecuteCommandDlg::OnCancel() {
	if(m_bExecuting) {	// [~]{^
		m_oDosCommand.Stop();
		::SetWindowTextW(GetDlgItem(IDCANCEL), L"");
	} else
		CDialog::OnCancel();
}

///	@see	CDialog::OnClose
void CExecuteCommandDlg::OnClose() {
	m_oDosCommand.Stop();
	m_bHijackConsole = IsDlgButtonChecked(IDC_CHK_GETCONSOLE) == BST_CHECKED;
	m_bUseUnicode = IsDlgButtonChecked(IDC_CHK_USEUNICODEFORINPUT) == BST_CHECKED;

	CDialog::OnClose();
}

///	@see	CDialog::OnCommand
bool CExecuteCommandDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case IDC_COMBO_COMMAND:
		if(wNotifyCode == CBN_EDITCHANGE)
			::EnableWindow(GetDlgItem(IDOK), ::GetWindowTextLength(GetDlgItem(wID)) != 0);
		break;
	case IDC_BTN_CLEAR:	// [NA]
		m_oDosCommand.Clear();
		OnChangeOutput();
		break;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CExecuteCommandDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CheckDlg2StateButton(IDC_CHK_GETCONSOLE, m_bHijackConsole);
	CheckDlg2StateButton(IDC_CHK_USEUNICODEFORINPUT, m_bUseUnicode);
	OnCommand(IDC_COMBO_COMMAND, CBN_EDITCHANGE, 0);

	return true;
}

///	@see	CDialog::OnOK
void CExecuteCommandDlg::OnOK() {
	if(!m_bExecuting) {	// [s]
		HWND			hwndCmdLineCmb;
		wchar_t*		pwszCmdLine = 0;
		size_t			cchCmdLine;
		wstring			strCmdLine;			// `̃R}hC
		const wstring&	strFilePath = m_pApplication->GetActiveDocument()->GetPathName();

		hwndCmdLineCmb = GetDlgItem(IDC_COMBO_COMMAND);
		cchCmdLine = ::GetWindowTextLength(hwndCmdLineCmb);
		pwszCmdLine = new wchar_t[cchCmdLine + 1];
		::GetWindowText(hwndCmdLineCmb, pwszCmdLine, cchCmdLine + 1);

		// "$F" t@CpXɕϊ
		strCmdLine = pwszCmdLine;
		wstring::size_type	iLast = 0;
		while(true) {
			iLast = strCmdLine.find(L"$F", iLast);
			if(iLast == wstring::npos)
				break;
			strCmdLine.replace(iLast, 2, L"\"" + strFilePath + L"\"");
			iLast += strFilePath.length() + 2;
		}

		// [R\[荞] ꍇ̓EBhEpӂ
		if(IsDlgButtonChecked(IDC_CHK_GETCONSOLE) == BST_CHECKED) {
			HWND	hSplitStatic = GetDlgItem(IDC_STATIC_PROMPT);
			HWND	hInputEdit = GetDlgItem(IDC_EDIT_INPUT);
			HWND	hOutputEdit = GetDlgItem(IDC_EDIT_OUTPUT);
			RECT	rect;

			::EnableWindow(GetDlgItem(IDC_COMBO_COMMAND), false);
			::EnableWindow(hInputEdit, true);
			::SetWindowTextW(GetDlgItem(IDOK), L"(&I)");
			::SetWindowTextW(GetDlgItem(IDCANCEL), L"~(&A)");
			GetWindowRect(&rect);
			rect.bottom = rect.top + 460;
			MoveWindow(&rect, true);
			::EnableWindow(GetDlgItem(IDC_CHK_GETCONSOLE), false);
			::EnableWindow(GetDlgItem(IDC_CHK_USEUNICODEFORINPUT), false);
			::MoveWindow(hSplitStatic, 10, 112, 452, 2, false);
			::MoveWindow(hInputEdit, 10, 118, 452, 16, false);
			::MoveWindow(hOutputEdit, 10, 138, 452, 278, false);
			::ShowWindow(hSplitStatic, SW_SHOW);
			::ShowWindow(hInputEdit, SW_SHOW);
			::ShowWindow(hOutputEdit, SW_SHOW);

			// R}h̎s
			m_bExecuting = true;
			m_oDosCommand.Execute(strCmdLine, true, static_cast<CDosCommand::ICommandEvent*>(this));
			::SetFocus(hInputEdit);
			::SendMessage(hInputEdit, EM_SETSEL, 0, -1);
		} else
			m_oDosCommand.Execute(strCmdLine, false);

		delete[] pwszCmdLine;
	} else {	// []
		HWND		hwndInputEdit = GetDlgItem(IDC_EDIT_INPUT);
		char*		pszInput = 0;
		wchar_t*	pwszInput = 0;
		size_t		cchInput = ::GetWindowTextLength(hwndInputEdit);
		size_t		cchConverted;
		string		strInput;

		pwszInput = new wchar_t[cchInput + 1];
		::GetWindowText(hwndInputEdit, pwszInput, cchInput + 1);
		if(IsDlgButtonChecked(IDC_CHK_USEUNICODEFORINPUT) == BST_CHECKED)	// [W͂ Unicode gp]
			strInput.assign(reinterpret_cast<char*>(pwszInput), cchInput * 2);
		else {
			pszInput = new char[cchInput * 2 + 1];
			cchConverted = CTextConverter::ConvertUnicodeToShiftJIS(pszInput, pwszInput);
			strInput.assign(pszInput, cchConverted);
			delete[] pszInput;
		}
		m_oDosCommand.SendLine(strInput);
		delete[] pwszInput;
		::SetFocus(hwndInputEdit);
		::SendMessage(hwndInputEdit, EM_SETSEL, 0, -1);
	}

//	CDialog::OnOK();
}

///	@see CDosCommand::OnChangeOutput
void CExecuteCommandDlg::OnChangeOutput() {
	HWND			hwndOutputEdit = GetDlgItem(IDC_EDIT_OUTPUT);
	string			strOutputOrg = m_oDosCommand.GetOutputLines();
	stringstream	ssOutput;
	int				cchOutput;
	wchar_t*		pwszOutput = 0;

	// LF ȂGfBbgRg[̂߂ CR+LF ɕϊ
	// (̓̓Rg[gꍇ͕ϊȂĂ낤)
	string::size_type	i = 0, iLast = 0;
	while(true) {
		i = strOutputOrg.find('\n', iLast);
		if(i == string::npos) {
			ssOutput << strOutputOrg.substr(iLast);
			break;
		} else if(i == 0)
			ssOutput << "\r\n";
		else if(strOutputOrg[i - 1] == '\r')
			ssOutput << strOutputOrg.substr(iLast, i - iLast + 1);
		else
			ssOutput << strOutputOrg.substr(iLast, i - iLast) << "\r\n";
		iLast = i + 1;
	}

	// ݂ ANSI R[hy[WƂO Unicode ɕϊ
	cchOutput = ::MultiByteToWideChar(CP_ACP, 0, ssOutput.str().c_str(), -1, 0, 0);
	pwszOutput = new wchar_t[cchOutput * sizeof(wchar_t)];
	::MultiByteToWideChar(CP_ACP, 0, ssOutput.str().c_str(), -1, pwszOutput, cchOutput);

	::SendMessage(hwndOutputEdit, EM_SETSEL, 0, -1);
	::SendMessage(hwndOutputEdit, EM_REPLACESEL, 0, reinterpret_cast<LPARAM>(pwszOutput));
	delete[] pwszOutput;
}

///	@see CDosCommand::OnExit
void CExecuteCommandDlg::OnExit(CDosCommand::ExecuteStatus es) {
	SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_SETSEL, -1, -1);
	switch(es) {
	case CDosCommand::timeout:
		MessageBox(L"^CAEg܂B\nR}h͒~܂B", IDS_APPNAME, MB_ICONEXCLAMATION);
		SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_REPLACESEL, 0,
			reinterpret_cast<LPARAM>(L"\r\n(R}h~܂B)\r\n"));
		break;
	case CDosCommand::aborted:
		MessageBox(L"R}h~܂B", IDS_APPNAME, MB_ICONEXCLAMATION);
		SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_REPLACESEL, 0,
			reinterpret_cast<LPARAM>(L"\r\n(R}h~܂B)\r\n"));
		break;
	case CDosCommand::failedToCreateNewProcess:
		MessageBox(L"vZX̋NɎs܂!", IDS_APPNAME, MB_ICONHAND);
		SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_REPLACESEL, 0,
			reinterpret_cast<LPARAM>(L"\r\n(R}h̎sɎs܂B)\r\n"));
		break;
	case CDosCommand::failedToCreateNewThread:
		MessageBox(L"Xbh̋NɎs܂!", IDS_APPNAME, MB_ICONHAND);
		SendDlgItemMessage(IDC_EDIT_OUTPUT, EM_REPLACESEL, 0,
			reinterpret_cast<LPARAM>(L"\r\n(R}h̎sɎs܂B)\r\n"));
		break;
	}
	m_bExecuting = false;

	HWND	hwndOKButton = GetDlgItem(IDOK);

	::EnableWindow(GetDlgItem(IDC_CHK_GETCONSOLE), true);
	::EnableWindow(GetDlgItem(IDC_CHK_USEUNICODEFORINPUT), true);
	::EnableWindow(GetDlgItem(IDC_COMBO_COMMAND), true);
	::EnableWindow(GetDlgItem(IDC_EDIT_INPUT), false);
	::SetFocus(GetDlgItem(IDC_COMBO_COMMAND));
	SendDlgItemMessage(IDC_COMBO_COMMAND, CB_SETEDITSEL, 0, -1);
	::SetWindowText(hwndOKButton, L"s(&E)");
	::SetWindowText(GetDlgItem(IDCANCEL), L"");
	SetWindowText(L"R}h̎s");
}


/* [EOF] */