// CodePagesDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CodePagesDlg.h"
#include "CodePageManager.h"
using Alpha::CCodePagesDlg;


// CCodePagesDlg class implementation
/////////////////////////////////////////////////////////////////////////////

bool CCodePagesDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	LVCOLUMN					lvc;
	LVITEM						item;
	HWND						hwndCPList;
	list<UINT>					liCPs;
	list<UINT>::const_iterator	it;

	hwndCPList = GetDlgItem(IDC_LIST_CODEPAGES);
	lvc.mask = LVCF_TEXT | LVCF_WIDTH;
	lvc.pszText = L"R[hy[W";
	lvc.cx = 258;
	ListView_InsertColumn(hwndCPList, 0, &lvc);

	CCodePageManager::EnumAvailableCodePages(liCPs);
	ZeroMemory(&item, sizeof(LVITEM));
	item.mask = LVIF_TEXT | LVIF_PARAM;
	for(it = liCPs.begin(); it != liCPs.end(); ++it) {
		item.pszText = const_cast<wchar_t*>(CCodePageManager::GetCodePageName(*it));
		if(*(item.pszText) != 0) {
			item.lParam = *it;
			ListView_InsertItem(hwndCPList, &item);
		}
	}

	int			iCurrent;
	LVFINDINFOW	fi = {LVFI_PARAM, 0, m_nCodePage, {0, 0}, 0};
	iCurrent = ListView_FindItem(hwndCPList, 0, &fi);
	ListView_SetItemState(hwndCPList, iCurrent, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
	ListView_EnsureVisible(hwndCPList, iCurrent, false);
	long	nStyle = ::GetWindowLong(hwndCPList, GWL_EXSTYLE);
	::SetWindowLong(hwndCPList, GWL_EXSTYLE, nStyle & ~WS_EX_NOPARENTNOTIFY);
	ListView_SetExtendedListViewStyle(hwndCPList, LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);

	return true;
}

bool CCodePagesDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_CODEPAGES && lpNMHDR->code == NM_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

void CCodePagesDlg::OnOK() {
	HWND	hwndCPList = GetDlgItem(IDC_LIST_CODEPAGES);
	LVITEM	item;
	
	item.mask = LVIF_PARAM;
	item.iItem = ListView_GetSelectionMark(hwndCPList);
	item.iSubItem = 0;

	ListView_GetItem(hwndCPList, &item);
	m_nCodePage = item.lParam;

	CDialog::OnOK();
}

/* [EOF] */