// EditView.h
// (c) 2003 exeal

#ifndef _EDIT_VIEW_H_
#define _EDIT_VIEW_H_

#include "EditDoc.h"
#include "..\..\Manah\DC.h"			// Manah::Windows::GDI::CMinimalDC
#include "..\..\Manah\MenuOperator.h"
#include "..\..\Manah\TextConverter.h"
#include "..\..\Armaiti\DraggingTextDataObject.h"
#include "LineLayout.h"
#include "KeyMacroPlayer.h"
#include "AutoCompleteWnd.h"
#include <set>


namespace Ascension {

class CEditView;
class CEditController;
class CLineLayoutInfo;
class CLineLayoutManager;
class CEditPoint;
class CEditRange;
class CKeywordManager;
class CKeyMacroPlayer;
class CAutoCompleteWnd;


// Miscellaneous
/////////////////////////////////////////////////////////////////////////////

#define WM_REDO								(WM_APP + 1)
#define WM_SELECTALL						(WM_APP + 2)
#define ID_SHOWUNICODECONTROLCHARS			(WM_APP + 3)
#define ID_INSERTUNICODECONTROLCHAR_LRM		(WM_APP + 4)
#define ID_INSERTUNICODECONTROLCHAR_RLM		(WM_APP + 5)
#define ID_INSERTUNICODECONTROLCHAR_ZWJ		(WM_APP + 6)
#define ID_INSERTUNICODECONTROLCHAR_ZWNJ	(WM_APP + 7)
#define ID_INSERTUNICODECONTROLCHAR_LRE		(WM_APP + 8)
#define ID_INSERTUNICODECONTROLCHAR_RLE		(WM_APP + 9)
#define ID_INSERTUNICODECONTROLCHAR_LRO		(WM_APP + 10)
#define ID_INSERTUNICODECONTROLCHAR_RLO		(WM_APP + 11)
#define ID_INSERTUNICODECONTROLCHAR_PDF		(WM_APP + 12)
#define ID_INSERTUNICODECONTROLCHAR_NADS	(WM_APP + 13)
#define ID_INSERTUNICODECONTROLCHAR_NODS	(WM_APP + 14)
#define ID_INSERTUNICODECONTROLCHAR_ASS		(WM_APP + 15)
#define ID_INSERTUNICODECONTROLCHAR_ISS		(WM_APP + 16)
#define ID_INSERTUNICODECONTROLCHAR_AAFS	(WM_APP + 17)
#define ID_INSERTUNICODECONTROLCHAR_IAFS	(WM_APP + 18)
#define ID_INSERTUNICODECONTROLCHAR_RS		(WM_APP + 19)
#define ID_INSERTUNICODECONTROLCHAR_US		(WM_APP + 20)
#define ID_INSERTUNICODESPACECHAR_NEL		(WM_APP + 29)
#define ID_INSERTUNICODESPACECHAR_NBSP		(WM_APP + 30)
#define ID_INSERTUNICODESPACECHAR_U1680		(WM_APP + 31)
#define ID_INSERTUNICODESPACECHAR_U2000		(WM_APP + 32)
#define ID_INSERTUNICODESPACECHAR_U2001		(WM_APP + 33)
#define ID_INSERTUNICODESPACECHAR_U2002		(WM_APP + 34)
#define ID_INSERTUNICODESPACECHAR_U2003		(WM_APP + 35)
#define ID_INSERTUNICODESPACECHAR_U2004		(WM_APP + 36)
#define ID_INSERTUNICODESPACECHAR_U2005		(WM_APP + 37)
#define ID_INSERTUNICODESPACECHAR_U2006		(WM_APP + 38)
#define ID_INSERTUNICODESPACECHAR_U2007		(WM_APP + 39)
#define ID_INSERTUNICODESPACECHAR_U2008		(WM_APP + 40)
#define ID_INSERTUNICODESPACECHAR_U2009		(WM_APP + 41)
#define ID_INSERTUNICODESPACECHAR_U200A		(WM_APP + 42)
#define ID_INSERTUNICODESPACECHAR_U200B		(WM_APP + 43)
#define ID_INSERTUNICODESPACECHAR_LS		(WM_APP + 44)
#define ID_INSERTUNICODESPACECHAR_PS		(WM_APP + 45)
#define ID_INSERTUNICODESPACECHAR_U202F		(WM_APP + 46)
#define ID_INSERTUNICODESPACECHAR_U3000		(WM_APP + 47)
#define ID_TOGGLEIMESTATUS					(WM_APP + 48)
#define ID_RECOMPOSITIONIME					(WM_APP + 49)
#define ID_SHOWRTL							(WM_APP + 50)

// ^C} ID
///	}EXhbOőI͈͂ύX
const UINT	ID_TIMER_EXPANDSELECTION		= 0;
///	}EXhbOőIsύX
const UINT	ID_TIMER_EXPANDLINESELECTION	= 1;
///	OLE hbO
const UINT	ID_TIMER_DRAGSCROLL				= 2;
///	ss
const UINT	ID_TIMER_LINEPARSE				= 3;

///	CWP[^}[W̕
#define INDICATORMARGIN_WIDTH	16

/**
 *	@brief	R}h̎
 *
 *	R}h̓GfB^̂鑀̒PʁBNCAg͂̃R}hŝ
 *	CEditView::ExecCommand gB܂AGfB^ł̓R}hPʂŃAhDA
 *	hDAL[}NL^/Đ/ۑsBeR}h̎ CEditView::CmdXXXX sB
 *	el̐̊ʓ̓R}ḧƂ̌^
 */
enum CommandIdentifier {
	///	I͈͂1O̕폜
	CMDID_EDIT_BACKSPACE,
	///	݂̉sR[hŉs
	CMDID_EDIT_BREAK,
	/// ̓ ( : wchar_t)
	CMDID_EDIT_CHAR,
	///	Rs[
	CMDID_EDIT_COPY,
	///	؂
	CMDID_EDIT_CUT,
	///	I͈͂1̕폜
	CMDID_EDIT_DELETE,
	///	ݍs폜
	CMDID_EDIT_DELETELINE,
	///	P̐擪܂ō폜
	CMDID_EDIT_DELETETOWORDSTART,
	///	P̖܂ō폜
	CMDID_EDIT_DELETETOWORDEND,
	///	1s}
	CMDID_EDIT_INSERTPREVLINE,
	///	I͈͂Ls^CY
	CMDID_EDIT_MAKESELCAPITAL,
	///	I͈͂ɕϊ
	CMDID_EDIT_MAKESELLOWER,
	///	I͈͂啶ɕϊ
	CMDID_EDIT_MAKESELUPPER,
	///	P͌
	CMDID_EDIT_OPENCANDIDATEWINDOW,
	///	\t
	CMDID_EDIT_PASTE,
	///	ĕϊ
	CMDID_EDIT_RECOMPOSESELECTION,
	///	蒼
	CMDID_EDIT_REDO,
	/// ͕̓ ###  (ϊ̎ : NextCharConvert)
	CMDID_EDIT_SETNEXTINPUTCONVERT,
	/// Xy[XCfg
	CMDID_EDIT_SPACEINDENT,
	/// Xy[XtCfg
	CMDID_EDIT_SPACEUNINDENT,
	///	I͈͂̋󔒂^uɕϊ
	CMDID_EDIT_TABIFY,
	/// ^uCfg
	CMDID_EDIT_TABINDENT,
	/// ^utCfg
	CMDID_EDIT_TABUNINDENT,
	///	̓ ( : wchar_t*)
	CMDID_EDIT_TEXT,
	///	 <-> R[h|Cg̕ϊ
	CMDID_EDIT_TOGGLECHARCODEPOINT,
	///	IME J/IME 
	CMDID_EDIT_TOGGLEIMESTATUS,
	///	}/㏑[h̕ύX
	CMDID_EDIT_TOGGLEOVERTYPEMODE,
	///	ɖ߂
	CMDID_EDIT_UNDO,
	///	I͈͂̃^u󔒂ɕϊ
	CMDID_EDIT_UNTABIFY,

	///	̃ubN}[N
	CMDID_MOVE_BOOKMARKNEXT,
	///	ÕubN}[N
	CMDID_MOVE_BOOKMARKPREV,
	///	I
	CMDID_MOVE_CANCELSELECTION,
	///	1Ɉړ
	CMDID_MOVE_CHARNEXT,
	///	1܂őI
	CMDID_MOVE_CHARNEXTEXTEND,
	///	1OɈړ
	CMDID_MOVE_CHARPREV,
	///	1O܂őI
	CMDID_MOVE_CHARPREVEXTEND,
	///	eLXg1sփXN[
	CMDID_MOVE_DISPLAYLINEDOWN,
	///	eLXg1sփXN[
	CMDID_MOVE_DISPLAYLINEUP,
	///	eLXg1y[WփXN[
	CMDID_MOVE_DISPLAYNEXTPAGE,
	///	eLXg1y[WփXN[
	CMDID_MOVE_DISPLAYPREVPAGE,
	///	Ɉړ
	CMDID_MOVE_END,
	///	܂őI
	CMDID_MOVE_ENDEXTEND,
	///	Ɉړ
	CMDID_MOVE_HOME,
	///	܂őI
	CMDID_MOVE_HOMEEXTEND,
	/// 1sɈړ
	CMDID_MOVE_LINEDOWN,
	///	1s܂őI
	CMDID_MOVE_LINEDOWNEXTEND,
	///	sɈړ
	CMDID_MOVE_LINEEND,
	///	s܂őI
	CMDID_MOVE_LINEENDEXTEND,
	///	sɈړ
	CMDID_MOVE_LINEHOME,
	///	s܂őI
	CMDID_MOVE_LINEHOMEEXTEND,
	/// 1sɈړ
	CMDID_MOVE_LINEUP,
	///	1s܂ňړ
	CMDID_MOVE_LINEUPEXTEND,
	///	ΊʂɈړ
	CMDID_MOVE_MATCHBRACKET,
	///	Ίʂ܂ňړ
	CMDID_MOVE_MATCHBRACKETEXTEND,
	///	1y[WɈړ
	CMDID_MOVE_PAGEDOWN,
	///	1y[W܂őI
	CMDID_MOVE_PAGEDOWNEXTEND,
	///	1y[WɈړ
	CMDID_MOVE_PAGEUP,
	///	1y[W܂őI
	CMDID_MOVE_PAGEUPEXTEND,
	///	SđI
	CMDID_MOVE_SELECTALL,
	///	݂̒PI
	CMDID_MOVE_SELECTCURRENTWORD,
	///	̒P̏I[Ɉړ
	CMDID_MOVE_WORDENDNEXT,
	///	̒P̏I[܂őI
	CMDID_MOVE_WORDENDNEXTEXTEND,
	///	O̒P̏I[Ɉړ
	CMDID_MOVE_WORDENDPREV,
	///	O̒P̏I[܂őI
	CMDID_MOVE_WORDENDPREVEXTEND,
	///	̒P̐擪Ɉړ
	CMDID_MOVE_WORDNEXT,
	///	̒P̐擪܂őI
	CMDID_MOVE_WORDNEXTEXTEND,
	///	O̒P̐擪Ɉړ
	CMDID_MOVE_WORDPREV,
	///	O̒P̐擪܂őI
	CMDID_MOVE_WORDPREVEXTEND,
};

///	Cfg̎
enum AutoIndentType {
	///	Ȃ
	AIT_NONE,
	///	O̍sɈv
	AIT_BLOCK,
	///	`̃X}[gCfg
	AIT_SMART
};

///	SetSel Q
enum SelCorrectingDirection {
	///	
	SCD_INVARIANT,
	///	
	SCD_LEFT,
	///	E
	SCD_RIGHT
};

/// ɓ͂镶̕ϊ
enum NextCharConvert {
	/// ϊ
	NCC_NONE,
	/// ANZg
	NCC_GRAVE,
	/// sANZg
	NCC_ACUTE,
	/// Ȑ܃ANZg
	NCC_CIRCUMFLEX,
	/// `_
	NCC_TILDE,
	/// EEg
	NCC_DIAERESIS,
	/// 
	NCC_RINGABOVE,
	/// ZfB[
	NCC_CEDILLA,
	/// ΐ
	NCC_STROKE,
	/// ss
	NCC_SHARP,
	/// eth
	NCC_ETH,
	/// 
	NCC_COMBINED
};

///	CmdEditConvertSel ̕ϊ[h
enum SelConvertType {
	///	啶
	SCT_UPPERCASE,
	///	啶珬
	SCT_LOWERCASE,
	///	Ls^CY (P̐擪啶)
	SCT_CAPITALIZE,
};

/// ܂Ԃ[h
enum WrapMode {
	/// ܂ԂȂ
	WPM_NONE,
	/// w蕝Ő܂Ԃ
	WPM_SPECIFIED,
	/// EBhEŐ܂Ԃ
	WPM_WINDOW
};

/// [ɕ\ ()
enum LeftTabType {
	/// \Ȃ
	LTT_NONE		= 0x00,
	/// u[N|CgȂǂ\\ȃCWP[^}[W
	LTT_INDICATOR	= 0x01,
	/// sԍ
	LTT_LINENUMBER	= 0x02
};

/// C̎
enum UnderlineType {
	/// 
	ULT_NONE,
	/// 
	ULT_SOLID,
	/// j
	ULT_DASHED,
	/// _
	ULT_DOTTED,
	/// g
	ULT_WAVED
};

/// ҏWP
struct TEditOperation {
	EditOperationType	type;	// ̎
	CCharPos			pos;	// sʃLbgړʒu

	void	set(EditOperationType type_, const CCharPos& pos_) {
		type = type_;
		pos = pos_;
	}
};

/// ̐FAȂ
struct TTextFoundation {
	bool			enabled;	// C邩ǂ
	COLORREF		fgColor;	// OiF
	COLORREF		bgColor;	// wiF
	bool			italic;		// Α
	bool			bold;		// 
	UnderlineType	underline;	// 

	TTextFoundation() {
		set(true, RGB(0x00, 0x00, 0x00), RGB(0xFF, 0xFF, 0xFF));
	}
	void	set(bool bEnabled, COLORREF clrFore, COLORREF clrBg,
			bool bItalic = false, bool bBold = false, UnderlineType ultUnderline = ULT_NONE) {
		enabled = bEnabled;
		fgColor = clrFore;
		bgColor = clrBg;
		italic = bItalic;
		bold = bBold;
		underline = ultUnderline;
	}
};

///	CEditView::GetAllLineParams Ŏgp
struct TAppDefinedLine {
	/// _s
	unsigned long	iLine;
	/// AvP[V`l
	DWORD			dwParam;
};


/// r[̎GȐݒ
typedef unsigned short	EditViewOption;
/// OLE hbOAhhbvg
const EditViewOption	EVO_USE_OLEDRAGDROP			= 0x0001;
///	ݍsɉ\
const EditViewOption	EVO_SHOW_CURRENTUNDERLINE	= 0x0002;
///	s}[N\
const EditViewOption	EVO_SHOW_BREAKARROWS		= 0x0004;
///	EOF }[N\
const EditViewOption	EVO_SHOW_EOFMARK			= 0x0008;
///	󔒗ޕ\
const EditViewOption	EVO_SHOW_WHITESPACE			= 0x0010;
/// Unicode 䕶\ ()
const EditViewOption	EVO_SHOW_UNICODECTRLCHARS	= 0x0020;
///	IɑĂs̔wih
const EditViewOption	EVO_PAINTBREAKCONTINUINGSEL	= 0x0040;
///	hbOAhhbvIێ
const EditViewOption	EVO_KEEPSELONDRAGDROP		= 0x0080;
///	\P⊮ő啶ʂȂ
const EditViewOption	EVO_IGNORECASE				= 0x0100;
///	L[{[hŃLbgړłȂ̑OɃ}EXňړł悤ɂ
const EditViewOption	EVO_ACCEPTABLECARETBYMOUSE	= 0x0200;

///	tO
typedef unsigned short	EditViewFindFlag;
///	O
const EditViewFindFlag	EVF_FORWARD				= 0x00;
///	
const EditViewFindFlag	EVF_BACKWARD			= 0x01;
///	PP
const EditViewFindFlag	EVF_WHOLEWORD			= 0x02;
///	啶ʂȂ
const EditViewFindFlag	EVF_IGNORECASE			= 0x04;
///	ЉʂȂ
const EditViewFindFlag	EVF_IGNOREKANATYPE		= 0x08;
///	K\ (ȊÕtO͖)
const EditViewFindFlag	EVF_REGULAREXPRESSION	= 0x20;

///	CEditView ̐ݒ荀
struct TEditViewOption {
	///	Cfg̎
	AutoIndentType	aitAutoIndentType;
	///	X}[gCfgΊʌōls
	unsigned long	cRecognizingLines;
	///	^ȗ֕
	wchar_t			chTabAlternative;
	///	̑̋󔒗ޕ̑֕
	wchar_t			chWhitespaceAlternative;
	///	EOF }[N̕
	std::wstring	strEndOfFile;
	///	P\ƂĈ̏W
	std::wstring	strCharsTreatedAsAlpha;
	///	̑̐ݒ
	EditViewOption	evoMiscellaneous;
};


// IEditViewEventListener interface definition
/////////////////////////////////////////////////////////////////////////////

///	CEditView CX^X̃Cxgnh
interface IEditViewEventListener {
	///	fXgN^
	virtual ~IEditViewEventListener() {
	}
	/**
	 *	sύXꂽ
	 *	@param iLine	ύXꂽ擪s (_s)
	 *	@param cLines	ύXꂽs
	 */
	virtual void	OnChangeLines(unsigned long iLine, unsigned long cLines) = 0;
	/**
	 *	s쐬ꂽ
	 *	@param iLine	쐬ꂽ擪s (_s)
	 *	@param cLines	쐬ꂽs
	 */
	virtual void	OnCreateLines(unsigned long iLine, unsigned long cLines) = 0;
	/**
	 *	s폜ꂽ
	 *	@param iLine	폜ꂽ擪s (_s)
	 *	@param cLines	폜ꂽs
	 */
	virtual void	OnDeleteLines(unsigned long iLine, unsigned long cLines) = 0;
	/**
	 *	уCWP[^}[W`ɌĂяo
	 *	@param iLine			_s
	 *	@param oDC				foCXReLXgB<strong>߂Oɑɖ߂</strong>
	 *	@param rectMargin		`͈
	 *	@param bBookmarked		̍sɃubN}[Nݒ肳Ă邩
	 *	@param dwParam			̍s̃AvP[V`l
	 *	@param bSingleEmphasis	̍sB̋\s
	 */
	virtual void	OnDrawIndicatorMargin(unsigned long iLine, CMinimalDC& oDC,
						const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) = 0;
	/**
	 *	Lbgړ
	 *	@param pos	ړ̃Lbgʒu
	 */
	virtual void	OnMoveCaret(const CCharPos& pos) = 0;
	/**
	 *	}EXJ[\ړ
	 *	@param pt	NCAgW
	 */
	virtual void	OnMoveCursor(const POINT& pt) = 0;
	/**
	 *	s`OɑOiFƔwiF₢킹
	 *	@param iLine			_s
	 *	@param bBookmarked		̍sɃubN}[Nݒ肳Ă邩
	 *	@param dwParam			̍s̃AvP[V`l
	 *	@param bSingleEmphasis	̍sB̋\s
	 *	@param clrFore			OiFB-1ԂƒʏʂF (Ăяoɂ-1ZbgĂ)
	 *	@param clrBack			wiFB-1ԂƒʏʂF (Ăяoɂ-1ZbgĂ)
	 */
	virtual void	OnQueryLineColor(unsigned long iLine, bool bBookmarked, DWORD dwParam,
						bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) = 0;
};


// CClipboardRing class definition
/////////////////////////////////////////////////////////////////////////////

///	1̃Nbv{[heLXg\\
struct TClipText {
	///	eLXg
	std::wstring	strText;
	///	`f[^
	bool			bBox;
};

///	Nbv{[hOCxg
interface IClipboardRingEventListener {
	///	fXgN^
	virtual ~IClipboardRingEventListener() {}
	///	eLXg̃XgύXꂽ
	virtual void	OnClipboardRingChanged() = 0;
	///	CClipboardRing::Add \bhŒǉ悤ƂeLXg傫߁A󂯓ꂪۂꂽ
	virtual void	OnClipboardRingDeniedAdding() = 0;
};

///	Nbv{[hO
class CClipboardRing : public Manah::CObject {
	// RXgN^
public:
	CClipboardRing();

	// \bh
public:
	void			Add(const std::wstring& strText, bool bBox);
	void			Delete(unsigned char iText) throw(out_of_range);
	void			DeleteAll();
	unsigned char	GetCount() const;
	void			GetText(unsigned char iText, std::wstring& strText, bool& bBox) const throw(out_of_range);
	void			LimitCount(unsigned char nLimit);
	bool			Load(const std::wstring& strPathName);
	bool			Save(const std::wstring& strPathName) const;
	void			SetEventListener(IClipboardRingEventListener* pEventListener);

	// f[^o
private:
	std::list<TClipText>			m_listDatas;
	unsigned char					m_nLimit;
	unsigned long					m_nMaxByte;
	IClipboardRingEventListener*	m_pEventListener;
};


// CEditView class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	Ascension eLXgGfB^̃r[
 *
 *	̃AvP[Vɑgݍ݂ꍇ CEditController gΊy`B
 *	<h3>KvpA</h3>
 *	<ul>
 *		<li>̃NXł OLE hbOAhhbvgp̂
 *	gݍ݃AvP[V OleInitialze API ĂяoĂKvB</li>
 *		<li>̓\yуC^[tFCX͑S Unicode gp邽߁A
 *	 Windows NT n݂̂ƂȂB</li>
 *		<li>̃NX͌_ł̓XbhZ[tł<strong>Ȃ</strong>B</li>
 *		<li> Unicode 4.0 ̒`ɂ͏]ĂȂB</li>
 *	</ul>
 *	<h3>p</h3>
 *	<p>̃NXŎgpP̒`͈ȉ̂Ƃ:</p>
 *	<dl>
 *		<dt>AJ[|Cg</dt><dd>IJn_BLbg</dd>
 *		<dt>ANeBu|Cg</dt><dd>II_BLbg</dd>
 *		<dt>P (Char)</dt><dd>Ch11P</dd>
 *		<dt>P (Column)</dt><dd>Œ蕝tHg̔p11P</dd>
 *		<dt>XN[W</dt><dd>XN[̍オ_</dd>
 *		<dt>NCAgW (Pos)</dt><dd>CEditView EBhE̍オ_</dd>
 *		<dt>r[W</dt><dd>NCAgW + (ѕ + ], э + ])BXN[͖</dd>
 *	</dl>
 *	<h3>Rs[RXgN^ɂ镡ɂ (To deriver)</h3>
 *	<p>CEditView ̑cNX͑SăRs[RXgN^ĂA
 *	̃NXłRs[RXgN^găr[𕡐邱Ƃo (
 *	cNXƓlEBhE͍쐬Ȃ)Bf[^oɑ
 *	̃NX͈ꕔ̃o𕡐ƕŋLB</p>
 *	<p>̓Rs[RXgN^̉EӂŁALf[^o<strong>L</strong>B
 *	LȂr[폜ĂLf[^͔jȂA
 *	Lr[폜ƁAL͂̃r[畡ꂽ̃r[ɈڂB
 *	čŌɎcr[폜ꂽƂALf[^͔j󂳂B
 *	̂߃Rs[RXgN^ł͕̃r[A
 *	̃r[IWĩr[LB܂A
 *	r[͎j󂳂ꂽƂɃIWiɒʒmB</p>
 *	<p>܂ALێr[͎ɑ΂ݒ̍XV𑼂̃r[ɒʒmƂڂB
 *	NCAgr[̖{IłȂݒ (tHgsԊuAAvP[V`sȂ)
 *	Lr[ɑ΂čsƁAIɕ̃r[ɂf̂ŁA
 *	NCAg͂֘ASẴr[ݒ肷Kv͖B</p>
 *	<p>CEditController NXŕsꍇ2̃r[͂̕[ɏ]B
 *	L̂͊{Iɍŏ̃r[ANX GetPrimaryView
 *	\bhŊmɏLr[擾łB</p>
 *
 *	@see	CEditDoc, CEditController
 */
class CEditView :
		public Manah::Windows::CView,
		public Armaiti::IUnknownImpl<Armaiti::CUnheapMemoryManageModel>,
		public IDropSource,
		public IDropTarget {

	///	{^ǂ̂悤ȖړIŉĂ邩\
	enum LeftDownMode {
		LDM_NONE,				// ĂȂ
		LDM_SELECTION,			// I͈͂̊g/k
		LDM_BOXSELECTION,		// `I͈͂̊g/k
		LDM_LINESELECTION,		// sI
		LDM_DRAGANDDROP,		// vZX̃hbOAhhbv
		LDM_DRAGANDDROPSELF,	// vZX̃hbOAhhbv
		LDM_DRAGANDDROPBOXSELF	// vZX̃hbOAhhbv (`)
	};

	friend class CEditController;
	friend class CLineLayoutManager;
	friend class CEditPoint;
	friend class CEditRange;
	friend class CAutoCompleteWnd;

	// f[^o
private:
	static bool								m_bRegistered;		// EBhENX̓o^tO
	static CClipboardRing					m_oClipboardRing;	// Nbv{[hO
	static CPopupMenu						m_oContextMenu;		// ftHg̃ReLXgj[
	Armaiti::OLE::CDraggingTextDataObject*	m_pDragging;		// OLE hbOIuWFNg
	CKeyMacroPlayer*						m_pKeyMacroPlayer;	// L[}N̊Ǘ
	CAutoCompleteWnd*						m_pwndAutoComplete;	// ͕⊮EBhE
	IEditViewEventListener*					m_pEventListener;	// CxgXi

	/* LÂ̊Ǘ (NX̐Q) */
	CEditView*		m_pOriginalView;		//  (null łΎ)
	std::set<CEditView*>	m_setClones;	// ̕

	/* CAEg */
	struct TEditViewLayout {	// CAEg܂Ƃ߂邾̍\
		unsigned int		nLineHeight;			// s̍ (ʁA)
		unsigned int		nCharHeight;			// ̍
		unsigned int		nCharWidth;				// p ()  (m_nLineHeight  API ŎIɎZo)
		int					nCharSpan;				// ̊Ԋu
		unsigned short		nTabWidth;				// ^u (pP)
		unsigned int		nLeftMargin;			// ]
		unsigned int		nTopMargin;				// ]
		unsigned int		nLeftTabWidth;			//  (sԍubN}[N\邽߂) ^uɕKvȒ
		unsigned int		nHScrollRatio;			// XN[1r[̉ɑ邩 (ʂ1)
		unsigned int		nVScrollRatio;			// XN[1sr[̉sɑ邩 (ʂ1)
		RECT				rectUpdate;				// OnPaint ŗLȍXV̈
		CCharPos			posHilightedBrackets[2];// \Ίʂ̈ʒu (ꍇ CCharPos(-1, -1))
		std::wstring		strFontFace;			// ̃tHg
		TTextFoundation		tfTextFoundation[TEXTTYPE_NUMBER];	// eLXg̐FȂ
		COLORREF			clrUnderline;			// ݍsɕ\鉺̐F
		COLORREF			clrIAUnderline;			// ANeBuɌݍsɕ\鉺̐F
		CLineLayoutInfo*	pAppDefinedSingleLine;	// AvP[V`s (Ps)
		unsigned long		iBoxSelectionAnchorLine;// `ĨAJ[|Cg̕\s
		unsigned long		iBoxSelectionActiveLine;// `ĨANeBu|Cg̕\s
		unsigned long		xBoxSelectionAnchor;	// `ĨAJ[|Cg̃r[ x W
		unsigned long		xBoxSelectionActive;	// `ĨANeBu|Cg̃r[ x W

		TEditViewLayout() : nLineHeight(13), nCharHeight(12), nCharWidth(7),
				nCharSpan(0), nTabWidth(4),
				nLeftMargin(1), nTopMargin(1), nHScrollRatio(1), nVScrollRatio(1),
				clrUnderline(-1), clrIAUnderline(-1), pAppDefinedSingleLine(0) {
					posHilightedBrackets[0] =
					posHilightedBrackets[1] = CCharPos(-1, -1);
		}
	} m_layoutInfo;

	CLineLayoutManager*	m_pLineLayoutManager;	// ܂ԂȂǂ̍sCAEg

	/* [h */
	struct TEditViewModeState {
		bool			bOverwrite;			// ㏑[h
		bool			bShowUnicodeCtrls;	// Unicode 䕶\邩ǂ ()
		bool			bBoxSelecting;		// `I ({^ĂȂĂ悢)
		bool			bCaretMarkByMouse;	// Lbg󂯎Ȃ̑OɃ}EXňړł
		LeftTabType		lttTabType;			// LeftTabType `Q
		WrapMode		wpmWrapMode;		// ݂̐܂Ԃ[h (WordWrapMode `Q)
		unsigned long	nWrapWidth;			// w蕝Ő܂ԂƂ1s̕\ (ϕ*)
		bool			bUseOLEDragDrop;	// OLE hbOAhhbvgǂ
		AutoIndentType	aitAutoIndentType;	// Cfg̎
		unsigned long	cFindLimit;			// X}[gCfggpɉsO܂ł̊ʂɑΉ邩

		TEditViewModeState() : bOverwrite(false), bShowUnicodeCtrls(false), bBoxSelecting(false),
			bCaretMarkByMouse(false), lttTabType(LTT_LINENUMBER), wpmWrapMode(WPM_NONE), nWrapWidth(100),
			bUseOLEDragDrop(true), aitAutoIndentType(AIT_BLOCK), cFindLimit(100) {
		}
	} m_ModeState;

	/* ⊮ */
	struct TAutoComplete {
		unsigned long	iCurrentLine;		// ͌EBhE\̍s
		unsigned long	iStartWordStart;	// ͌EBhE\OɂP̐擪ʒu
		unsigned long	iStartChar;			// ͌EBhE\̃Lbg̕ʒu
	} m_AutoComplete;

	bool			m_bActiveIMEComposition;	// IME œ͒
	LeftDownMode	m_ldmLeftDown;				// LeftDownMode `Q
	NextCharConvert	m_nccNextCharConvert;		// NextCharConvert `Q
	TEditOperation	m_eoLast;					// OɍsҏW
	bool			m_bIgnoreSelChange;			// OnUpdate Ō݈ʒu̕ύX𖳎B
												// ̃tO؂ւ邱Ƃɂĕ`ʂ炷ƂłB
												// XVeŜꎞIɖƑ̃r[ŉeo
												// (͓̃r[ĂӖ) A
												// ݈ʒu̓r[ŗL̂̂Ȃ̂ŖȂ

	/* ݈ʒu */
	CCharPos		m_posAnchor;		// IJnʒu
	CCharPos		m_posActive;		// IIʒu (Lbgʒu)
	POINT			m_ptScroll;			// XN[o[̈ʒu (x:Ay:)B
										// ̒l m_nHScrollRatio  m_nVScrollRatio 悸
										// \Jnʒu (:ϕPʁA:\sP) 
	unsigned long	m_iFirstVisibleLine;// ݂̐擪s (_sB\s m_ptScroll.y)B
										// _s<->\sϊ̂߂̃LbV
										// cXN[ (OnVScroll)A܂Ԃ񂪕ωƂ (OnSize,
										// ModifyFontInfo)A\Jn_sO̍sҏWꂽƂ
										// (OnUpdate) XV
	unsigned long	m_nLastPixel;		// Lbg𓮂n߂O̍[̈ʒu (r[W)B
										// ̒l GetSel Ō݈ʒuɏ邪A
										// []A[] L[ňړƂ̂ݑO̒lێ

	/* \ */
	typedef map<
		wchar_t, list<wstring>
	>	OperatorMap;
	struct TEditViewFoundationInfo {
		bool			bDrawCurrentUnderline;	// ݍs̉`悷邩ǂ
		bool			bDrawBreakArrow;		// s̖`悷邩ǂ
		bool			bDrawEOF;				// [EOF]`悷邩ǂ
		bool			bDrawSpaces;			// 󔒂̑֕`悷邩ǂ
		bool			bIgnoreCaseOnHilite;	// \RgJn/I񌟍ɑ啶ʂȂ
		bool			bPaintBreakContinuingSelection;	///	IɑĂs̔wih邩ǂ
		wchar_t			chTab;					// ^ȗ֕
		wchar_t			chIdeographicSpace;		// Sp󔒂̑֕
		wchar_t			chSpace;				// ̑̋󔒗ޕ̑֕
		std::wstring	strEndOfFile;			// [EOF] }[N̕
		std::wstring	strCommentStart1;		// sRgJn1
		std::wstring	strCommentEnd1;			// sRgI1
		std::wstring	strCommentStart2;		// sRgJn2
		std::wstring	strCommentEnd2;			// sRgI2
		std::wstring	strCommentLineHeader1;	// PsRgJn1
		std::wstring	strCommentLineHeader2;	// PsRgJn2
		CKeywordManager*	pKeywords1;				// \L[[h1̃Xg
		CKeywordManager*	pKeywords2;				// \L[[h2̃Xg
		OperatorMap			mapOperators;			// Zq
		xstring				strCharsTreatedAsAlpha;	// L[[h\ƂĎgXg
		bool				bLockedParsing;			// s͂}Ă邩 (LockParsing Q)

		TEditViewFoundationInfo();
		TEditViewFoundationInfo(const TEditViewFoundationInfo& rhs);
		~TEditViewFoundationInfo();
	} m_FoundationInfo;

	/* GDI IuWFNg */
	struct TEditViewGDIObjects {
		Manah::Windows::GDI::CMinimalDC	oMemDC;	// EBhE DC Ɍ݊̂郁 DC (CEditView::Create 1񂾂쐬)
		HBITMAP	hMemLineBMP;	// 1s`̃rbg}bv (OnSize Ŕj/쐬)
		HBITMAP	hMemLeftTabBMP;	// т̃rbg}bv (SetLeftTabType AOnSize Ŕj/쐬)
		HPEN	hUnderlinePen;	// ݍs̉
		HPEN	hIAUnderlinePen;// ݍs̉ (ANeBu)
		HPEN	hLeftIndicatorPen;	// LTT_INDICATOR [hɍт`̂Ɏgp
		HPEN	hLineNumberPen;	// LTT_LINENUMBER [hɍт`̂Ɏgp
		HPEN	hColumnPen;		// TTT_COLUMNNUMBER [hɏт`̂Ɏgp
		HPEN	hWhiteSpacePen;	// 󔒗ޕ (̑փrbg}bv) `̂Ɏgp
		HPEN	hLineBreakPen;	// s}[N`̂Ɏgp
		HFONT	hNormalFont;	// ̖WtHgBvZɂgp
		HFONT	hBoldFont;		// `ɎgptHg
		HFONT	hItalicFont;	// C^bN̕`ɎgptHg
		HFONT	hBoldItalicFont;// C^bN̕`ɎgptHg

		TEditViewGDIObjects() : hMemLineBMP(0), hMemLeftTabBMP(0),
			hUnderlinePen(0), hIAUnderlinePen(0), hLeftIndicatorPen(0), hLineNumberPen(0), hColumnPen(0),
			hWhiteSpacePen(0), hLineBreakPen(0),
			hNormalFont(0), hBoldFont(0), hItalicFont(0), hBoldItalicFont(0) {
		}
		~TEditViewGDIObjects() {
			::DeleteObject(hMemLineBMP);
			::DeleteObject(hMemLeftTabBMP);
			::DeleteObject(hUnderlinePen);
			::DeleteObject(hIAUnderlinePen);
			::DeleteObject(hLeftIndicatorPen);
			::DeleteObject(hLineNumberPen);
			::DeleteObject(hColumnPen);
			::DeleteObject(hWhiteSpacePen);
			::DeleteObject(hLineBreakPen);
			::DeleteObject(hNormalFont);
			::DeleteObject(hBoldFont);
			::DeleteObject(hItalicFont);
			::DeleteObject(hBoldItalicFont);
		}
	} m_GDIObjects;

protected:
	static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CandidateWordListProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// RXgN^
public:
	CEditView();
	CEditView(const CEditView& rhs);
	virtual ~CEditView();

	// Zq
private:
	CEditView& operator =(const CEditView& rhs);	/// gpȂ

	// \bh
public:
	// 쐬
	virtual bool	Create(HWND hwndParent, const RECT* pRect,						// EBhE쐬
						DWORD dwStyle, DWORD dwExStyle) throw(runtime_error);

	// ̎擾
	void			GetAllLineParams(std::list<TAppDefinedLine>& listLines) const;	// AvP[V`l̑S擾
	DWORD			GetLineParam(unsigned long iLine) const;						// AvP[V`l̎擾
	void			GetOption(TEditViewOption& evo) const;							// GȐݒ̎擾
	unsigned short	GetTabWidth() const;											// ^u̎擾

	// ̐ݒ
	void	ModifyFontInfo(const LOGFONTW& lf, bool bRedraw = true);		// tHg̕ύX
	void	SetAppDefinedLine(unsigned long iLine);							// AvP[V`s̐ݒ
	void	SetCandidateWords(const std::list<TCandidateWord>& listWords);	// ͌PꃊXg̐ݒ
	void	SetCharSpaces(unsigned int nLineSpan, unsigned int nCharSpan);	// sÅԊu̕ύX
	void	SetEventListener(IEditViewEventListener* pEventListener);		// CxgXi̓o^
	void	SetLeftTabType(LeftTabType ltt);								// [̑т̐ݒ
	void	SetLineParam(unsigned long iLine,								// AvP[V`l̐ݒ
				DWORD dwParam, DWORD dwMask = 0xFFFFFFFF);
	void	SetMargins(unsigned int nLeft, unsigned int nTop);				// ]̐ݒ
	void	SetTabWidth(unsigned short nTabWidth);							// ^u̐ݒ
	void	SetOption(TEditViewOption& evo);								// ̑̐ݒ

	// \ڂ̎擾
	TTextFoundation	GetTextFoundation(TextType type) const throw(out_of_range);		// C̎擾

	// \ڂ̐ݒ
	void	LockParsing();													// s͂}
	void	SetKeywordLists(const std::list<std::wstring>& listKeywords1,	// \2̐ݒ
				const std::list<std::wstring>& listKeywords2);
	void	SetMultilineCommentDelimiters(									// ubNRg̐ݒ
				const std::wstring& strBegin1, const std::wstring& strEnd1,
				const std::wstring& strBegin2, const std::wstring& strEnd2);
	void	SetOperators(const std::list<std::wstring>& listOperators);		// Zq̐ݒ
	void	SetSinglelineCommentHeaders(									// sRg̐ݒ
				const std::wstring& strHeader1, const std::wstring& strHeader2);
	void	SetTextFoundation(TextType type,								// C̐ݒ
				const TTextFoundation& tf) throw(out_of_range);
	void	UnlockParsing();												// s̗͂}

	// Lbg
	void	GetSel(CCharPos& posBegin, CCharPos& posEnd) const;				// I͈͂̎擾
	bool	HasSelection() const;											// I͈͂邩ǂ
	void	RecreateCaret();												// Lbg쐬
	void	SetSel(const CCharPos& posAnchor, const CCharPos& posActive,	// I͈͂̐ݒ
				bool bScroll = true, bool bRepaint = true);
	void	SetSelWithoutSelection(const CCharPos& pos,						// Lbgʒu̐ݒ
				bool bScroll = true, bool bRepaint = true);
	void	SetSelWithoutSelection(unsigned int iLine, unsigned int iChar,
				 bool bScroll = true, bool bRepaint = true);

	// ƒu
	unsigned long	BookmarkAll(const std::wstring& strText, EditViewFindFlag evfFlags);	// Să}[N
	bool			FindNext(const std::wstring& strText, EditViewFindFlag evfFlags);		// /O
	unsigned long	ReplaceAll(const std::wstring& strFindWhat,								// SĒu
						const std::wstring& strReplaceWith, EditViewFindFlag evfFlags);
	bool			ReplaceAndFindNext(const std::wstring& strFindWhat,						// uĎ
						const std::wstring& strReplaceWith, EditViewFindFlag evfFlags);

	// eLXg
	static CClipboardRing&	GetClipboardRing();					// Nbv{[hO擾
	std::wstring			GetNearestWordFromCaret() const;	// Lbgt߂̒P擾
	std::wstring			GetNearestWordFromCursor() const;	// J[\t߂̒P擾
	std::wstring			GetPrecedingWord() const;			// Lbg̍ɂP擾
	std::wstring			GetSelection() const;				// I͈͂̎̕擾

	// Cӂ̈ʒu
	CEditPoint*	CreateEditPoint(const CCharPos& pos);
	CEditRange*	CreateRange(const CCharPos& posStart, const CCharPos& posEnd);

	// ubN}[N
	void	ClearBookmarks();												// ubN}[NSĉ
	void	GetBookmarkList(std::list<unsigned long>& listLines) const;		// ubN}[ÑXgԂ
	bool	HasBookmarkAt(unsigned long iLine) const throw(out_of_range);	// ubN}[Nݒ肳Ă邩Ԃ
	void	SetBookmark(unsigned long iLine,								// ubN}[N̐ݒ/
				bool bOn = true) throw(out_of_range);
	void	ToggleBookmark(unsigned long iLine) throw(out_of_range);		// ubN}[N̐ݒ/

	// R}h
	void	ExecCommand(CommandIdentifier cmd, LPARAM lParam = 0L);	// R}ḧꊇ
protected:
	/* ړƑI */
	void	CmdMoveCancelSelection();
	void	CmdMoveCharNext(bool bSelect = false);
	void	CmdMoveCharPrev(bool bSelect = false);
	void	CmdMoveDisplayLineUp();
	void	CmdMoveDisplayLineDown();
	void	CmdMoveDisplayNextPage();
	void	CmdMoveDisplayPrevPage();
	void	CmdMoveEnd(bool bSelect = false);
	void	CmdMoveHome(bool bSelect = false);
	void	CmdMoveLineDown(bool bSelect = false);
	void	CmdMoveLineEnd(bool bSelect = false);
	void	CmdMoveLineHome(bool bSelect = false);
	void	CmdMoveLineUp(bool bSelect = false);
	void	CmdMoveMatchBracket(bool bSelect = false);
	void	CmdMoveNextBookmark();
	void	CmdMovePageDown(bool bSelect = false);
	void	CmdMovePageUp(bool bSelect = false);
	void	CmdMovePrevBookmark();
	void	CmdMoveSelectAll();
	void	CmdMoveSelectCurrentWord();
	void	CmdMoveWordEndNext(bool bSelect = false);
	void	CmdMoveWordEndPrev(bool bSelect = false);
	void	CmdMoveWordNext(bool bSelect = false);
	void	CmdMoveWordPrev(bool bSelect = false);
	/* ҏW */
	void	CmdEditChar(wchar_t ch);
	void	CmdEditBreak();
	void	CmdEditInsertPrevLine();
	void	CmdEditBackspace();
	void	CmdEditDelete();
	void	CmdEditDeleteLine();
	void	CmdEditDeleteToWordEnd();
	void	CmdEditDeleteToWordStart();
	void	CmdEditUndo();
	void	CmdEditRedo();
	void	CmdEditConvertSel(SelConvertType sct);
	void	CmdEditCut();
	void	CmdEditCopy();
	void	CmdEditPaste();
	void	CmdEditSpaceIndent(bool bReverse = false);
	void	CmdEditTabify(bool bRevoke = false);
	void	CmdEditTabIndent(bool bReverse = false);
	void	CmdEditText(const wchar_t* pwszText);
	void	CmdEditToggleCharCodePoint();
	void	CmdEditToggleOvertypeMode();
	void	CmdEditSetNextInputConvert(NextCharConvert n);
	void	CmdEditToggleIMEStatus();
	void	CmdEditRecomposeSelection();
	void	CmdEditOpenCandidateWindow();
	/* L[}N */
public:
	void	CmdKeymacroPlay();									// L[}N̎s
	void	CmdKeymacroRecord();								// L[}N̋L^
	void	CmdKeymacroStop();									// L[}N̋L^~
	void	CmdKeymacroPause();									// L[}N̋L^ꎞ~/ĊJ
	void	CmdKeymacroLoad(const std::wstring& strPathName);	// L[}N̓ǂݍ
	void	CmdKeymacroSave(const std::wstring& strPathName);	// L[}N̕ۑ
	void	CmdKeymacroCancel();								// L[}N̋L^~
	/* ̑̓ */
	bool	SmartIndent(wchar_t ch);						// X}[gCfgs

	// [eBeB
	CCharPos		CharFromPos(const POINT& pt,					// NCAgWƃXN[ԂsƕvZ
						bool bIgnoreMark, bool* bTruncated = 0) const;
	unsigned long	ColumnFromChar(const CCharPos& pos) const;					// ʒuԍ擾
	CCharPos		DisplayCharFromLogicalChar(const CCharPos& posLogical) const;	// _ʒu\ʒuɕϊ
	unsigned long	DisplayLineFromLogicalLine(unsigned long iLine) const;	// _s\sɕϊ
	unsigned long	GetDisplayLineCount() const;					// \sԂ
	void			GetDisplayLineOffsetIndex(unsigned long iDisplayLine,		// \s_sƃItZbgɕϊ
						unsigned long& iLogicalLine, unsigned long& iOffset) const;
	unsigned int	GetVisibleLineCount() const;					// EBhEƕ̍\\ȍsvZ
	unsigned int	GetVisibleCharCount() const;					// EBhEƕ̕\\1sɕvZ
	bool			IsOverSelection(const POINT& pt) const;						// ʒuI͈͏ォǂ
	bool			IsOverURIString(const POINT& pt, std::wstring& strURI) const;	// ʒu URI ォǂ
	CCharPos		LogicalCharFromDisplayChar(const CCharPos& posDisplay) const;	// \ʒu_ʒuɕϊ
	POINT			PosFromChar(const CCharPos& col) const;		// sƗAXN[ԂNCAgWvZ

	// Nbv{[h (ȊȎ HandleCommand gp)
	UINT	CanPaste() const;	// Nbv{[h̓ey[Xgł邩ǂԂ

	// hLgƂ̒ʐM
	virtual CEditDoc*	GetDocument() const;	// hLgIuWFNgւ̃ANZX

	// [h
	KeyMacroState		GetKeyMacroState() const;					// L[}N̏ԂԂ
	static CEditView*	GetViewKeyMacroRecording();					// L[}NL^/ꎞ~̃r[Ԃ
	WrapMode			GetWrapMode() const;						// ܂Ԃ[hԂ
	bool				IsOverwriteMode() const;					// ㏑[hǂԂ
	void				SetOverwriteMode(bool bOverwrite = true);	// ㏑[h̐ݒ
	void				SetWrapMode(WrapMode wpm);					// ܂Ԃ[h̐ݒ
	void				SetWrapWidth(unsigned long nWrapWidth);		// ܂Ԃ̐ݒ

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDropSource)
		IMPLEMENTS_INTERFACE(IDropTarget)
//		IMPLEMENTS_INTERFACE(IDispatch)
//		IMPLEMENTS_INTERFACE(IViewObjectEx)
//		IMPLEMENTS_INTERFACE(IViewObject2)
//		IMPLEMENTS_INTERFACE(IViewObject)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObject)
//		IMPLEMENTS_INTERFACE(IOleWindow, IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceActiveObject)
//		IMPLEMENTS_INTERFACE(IOleControl)
//		IMPLEMENTS_INTERFACE(IOleObject)
//		IMPLEMENTS_INTERFACE(IPersistStreamInit)
//		IMPLEMENTS_INTERFACE(ISupportErrorInfo)
	END_INTERFACE_TABLE()

	// IDropSource C^[tFCX
	STDMETHODIMP	QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState);
	STDMETHODIMP	GiveFeedback(DWORD dwEffect);

	// IDropTarget C^[tFCX
	STDMETHODIMP	DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragLeave();
	STDMETHODIMP	Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);

	// J[eBeB (I͈̓eLXgwp)
protected:
	void	DeleteSel(OperationConcatenationFlag ocf);									// I͈͂̍폜
	void	InsertText(const std::wstring& strText, OperationConcatenationFlag ocf);	// Lbgʒuւ̑̕}
public:	// b...
	void	ReplaceSel(const std::wstring& strText, OperationConcatenationFlag ocf, bool bBoxPaste = false);	// I͈͂̒u

	// J[eBeB ()
protected:
	static unsigned long	IsNumeric(const wchar_t* psz, unsigned long cch);			// l
	static unsigned long	IsSingleQuotation(const wchar_t* psz, unsigned long cch);	// VONH[gň͂܂ꂽ
	static unsigned long	IsDoubleQuotation(const wchar_t* psz, unsigned long cch);	// _uNH[gň͂܂ꂽ
	static unsigned long	IsWhiteSpace(const wchar_t* psz, unsigned long cch);		// 󔒗ނ
	static unsigned long	IsURIString(const wchar_t* psz, unsigned long cch);			// URI 
	bool			CharIsInCommentOrQuotation(const CCharPos& pos) const;				// Rgp
	static bool		IsCharAcceptableCaret(unsigned long nCodePoint);
	unsigned long	IsWord(const wchar_t* psz, unsigned long cch) const;				// P
	bool			IsSComment1(const wchar_t* psz, unsigned long cch) const;			// PsRg1T
	bool			IsSComment2(const wchar_t* psz, unsigned long cch) const;			// PsRg2T
	unsigned long	IsMComment1(const wchar_t* psz, unsigned long cch, bool& bContinued) const;	// sRg1T
	unsigned long	IsMComment2(const wchar_t* psz, unsigned long cch, bool& bContinued) const;	// sRg2T
	unsigned long	IsOperator(const wchar_t* psz, unsigned long cch) const;			// Zq
	unsigned char	IsInvalidCharacter(const wchar_t* psz, unsigned long cch) const;	// sȕ
				
	// J[eBeB (`)
protected:
	virtual void			DrawBreakMark(int x, int y, BreakType bt, COLORREF clrBack);	// s}[N̕`
	virtual void			DrawLeftTab(unsigned long iStart, unsigned long iEnd);			// т`
	virtual unsigned long	DrawLine(unsigned long iLine, int y,							// 1s`
								const std::wstring& strLine, BreakType bt, const CLineLayoutInfo* pLineInfo);
	HFONT					GetFontForRenderingToken(TextType type) const;					// w肵g[N`tHgԂ
	void					InvalidateLine(unsigned long iLine);							// ws`𖳌
	void					InvalidateLines(unsigned long iStart, unsigned long iEnd);		// wԍs`𖳌

	// J[eBeB (ʒuvZ)
protected:
	wstring			CalculateSpacesReachingVirtualPoint(
						unsigned long iLine, unsigned long xVirtual) const;
	unsigned long	CharFromPixel(unsigned long iLine, unsigned long x,
						bool bIgnoreMark, bool* pbTruncated = 0) const;
	unsigned int	GetAvgCharWidth() const;										// 1̕ϕԂ
	unsigned long	GetNextTabStop(unsigned long xView, bool bRtlReading) const;	// ̃^uʒuԂ
	int				MakeCaretPosValid(const wchar_t* pwsz, unsigned long cch,		// LbgʒȕC
						unsigned long nCaretPos, bool bBackward) const;

	// J[eBeB (̑)
protected:
	virtual int		CompareString(const wchar_t* psz1,
						const wchar_t* psz2, unsigned long cch) const;				// ̔r
	virtual bool	FindBracket(const CCharPos& pos, CCharPos& posFound) const;		// Ίʂ
	virtual bool	FindTextInternal(unsigned long iLine, unsigned long iChar,		// 1s猟
						const std::wstring& strText, EditViewFindFlag evf,
						unsigned long* piFound = 0, unsigned long* pcchFound = 0) const;
	unsigned int	GetLineNumberMaxDigit() const;									// s̍ő包Ԃ
	void			InitializeWindow();
	void			InsertBoxText(const CCharPos& pos,								// `̑}
						const std::wstring& strText, OperationConcatenationFlag ocf);
	bool			IsAcceptableAsMacroKey(UINT nChar) const;						// L[}NŋL^\ȃL[
	static bool		IsNeutralNoAlpha(wchar_t wch);									// ԕ̒P\ǂ𒲂ׂ
	void			ModifyScrollInfo(bool bHorizontal, bool bVertical);				// XN[o[ݒ̍XV
	void			RecalcLeftTabWidth(int cy = -1);								// m_nLeftTabWidth XV
	static bool		RegisterWindowClass();											// Ascension EBhENX̓o^
	virtual void	UpdateGDIObjects();												// GDI IuWFNg̍XV
	virtual void	ValidateCaretPos();												// Lbg𐳂ʒuɈړ
	void			ValidateIMEWindowPos();											// IME EBhE𐳂ʒuɈړ

	// J[eBeB (̑) ʂɌJ
public:
	virtual void	DrawUnderline(int x1, int x2, int y, UnderlineType ult);		// 
	virtual bool	SearchUsingRegExp(const std::wstring& strTarget,				// K\s
						const std::wstring& strPattern, bool bReverse,
						bool bIgnoreCase, size_t& iFound, size_t& cchFound);

protected:
	virtual LRESULT	DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);

	// bZ[Wnh
protected:
	virtual void	OnChar(UINT nChar, UINT nFlags);						// WM_CHAR
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	virtual bool	OnContextMenu(HWND hWnd, POINT pt);						// WM_CONTEXTMENU
	virtual void	OnDestroy();											// WM_DESTROY
	virtual void	OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_HSCROLL
	virtual bool	OnImeComposition(WPARAM wParam, LPARAM lParam);			// WM_IME_COMPOSITION
	virtual void	OnImeEndComposition();									// WM_IME_ENDCOMPOSITION
	virtual void	OnImeStartComposition();								// WM_IME_STARTCOMPOSITION
	virtual void	OnKeyDown(UINT nChar, UINT nFlags);						// WM_KEYDOWN
	virtual void	OnKillFocus(HWND hwndNew);								// WM_KILLFOCUS
	virtual void	OnLButtonDblClk(UINT nFlags, POINT pt);					// WM_LBUTTONDBLCLK
	virtual void	OnLButtonDown(UINT nFlags, POINT pt);					// WM_LBUTTONDOWN
	virtual void	OnLButtonUp(UINT nFlags, POINT pt);						// WM_LBUTTONUP
	virtual void	OnMouseMove(UINT nFlags, POINT pt);						// WM_MOUSEMOVE
	virtual bool	OnMouseWheel(UINT nFlags, short zDelta, POINT pt);		// WM_MOUSEWHEEL
	virtual void	OnPaint();												// WM_PAINT
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);	// WM_SETCURSOR
	virtual void	OnSetFocus(HWND hwndOld);								// WM_SETFOCUS
	virtual void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE
	virtual void	OnSysColorChange();										// WM_SYSCOLORCHANGE
	virtual void	OnTimer(UINT nIDEvent);									// WM_TIMER
	virtual void	OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_VSCROLL

	// WbZ[Wnh
	virtual void	OnDocumentSetup(LPARAM lHint = 0);								// hLgA[hꂽ
	virtual void	OnUpdate(Manah::Windows::CView* pSender, LPARAM lParam, void* pHint);	// hLg̒ʐM
};

// CC֐̎
/////////////////////////////////////////////////////////////////////////////

/**
 *	u\tv삪\擾
 *	@return	\t\ȃNbv{[h`Bs̏ꍇ0
 */
inline UINT CEditView::CanPaste() const {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return 0;

	UINT	nBoxClipFormat = ::RegisterClipboardFormatW(L"MSDEVColumnSelect");

	if(nBoxClipFormat != 0 && ::IsClipboardFormatAvailable(nBoxClipFormat))
		return nBoxClipFormat;
	if(::IsClipboardFormatAvailable(CF_UNICODETEXT))
		return CF_UNICODETEXT;
	if(::IsClipboardFormatAvailable(CF_TEXT))
		return CF_TEXT;

	return 0;
}

///	wʒuRgptłΐ^Ԃ
inline bool CEditView::CharIsInCommentOrQuotation(const CCharPos& pos) const {
	AssertValid();

	const TokenList&			listTokens = m_pLineLayoutManager->GetLine(pos.m_iLine)->GetTokenList();
	TokenList::const_iterator	itTokens = listTokens.begin();

	for(; itTokens != listTokens.end(); ++itTokens) {
		if(pos.m_iChar > itTokens->GetIndex()
				&& pos.m_iChar < itTokens->GetIndex() + itTokens->GetStringLength()) {
			TextType	tt = itTokens->GetType();
			return (tt == TT_COMMENT || tt == TT_DOUBLEQUOTATION || tt == TT_SINGLEQUOTATION);
		}
	}
	return false;
}

/**
 *	ݎgpĂtHg (C^bNłȂ) 
 *	1`悷Ƃ̕ϕԂ
 */
inline unsigned int CEditView::GetAvgCharWidth() const {
	AssertValid();
	return m_layoutInfo.nCharWidth + m_layoutInfo.nCharSpan;
}

///	Nbv{[hOԂ
inline CClipboardRing& CEditView::GetClipboardRing() {
	return m_oClipboardRing;
}

/**
 *	w肵g[N`tHgԂ
 *	@param type	g[N̎
 *	@return		tHg
 */
inline HFONT CEditView::GetFontForRenderingToken(TextType type) const {
	AssertValid();

	TTextFoundation	tf = m_layoutInfo.tfTextFoundation[type];
	if(tf.enabled && tf.bold)
		return tf.italic ? m_GDIObjects.hBoldItalicFont : m_GDIObjects.hBoldFont;
	else
		return (tf.enabled && tf.italic) ? m_GDIObjects.hItalicFont : m_GDIObjects.hNormalFont;
}

///	݂̃L[}N̏ԂԂ
inline KeyMacroState CEditView::GetKeyMacroState() const {
	AssertValid();
	return m_pKeyMacroPlayer->GetState();
}

/**
 *	hLǧ݂̍ŏIsl10iŉɂȂ邩Ԃ
 *	@return	Kvȕ
 */
inline unsigned int CEditView::GetLineNumberMaxDigit() const {
	AssertValid();

	unsigned int	n = 1;
	unsigned long	nLineCount = GetDocument()->GetLineCount();

	while(nLineCount >= 10) {
		nLineCount /= 10;
		++n;
	}
	return n;
}

/**
 *	̃^uʒuԂ
 *	@param xView		r[ x W
 *	@param bRtlReading	E獶ɓǂޏꍇ ()
 */
inline unsigned long CEditView::GetNextTabStop(unsigned long xView, bool bRtlReading) const {
	AssertValid();
	if(!bRtlReading)
		return xView + m_layoutInfo.nTabWidth * GetAvgCharWidth()
			- xView % (m_layoutInfo.nTabWidth * GetAvgCharWidth());
	else
		return xView - xView % (m_layoutInfo.nTabWidth * GetAvgCharWidth());
}

///	GȐݒԂ
inline void CEditView::GetOption(TEditViewOption& evo) const {
	AssertValid();

	evo.aitAutoIndentType = m_ModeState.aitAutoIndentType;
	evo.chTabAlternative = m_FoundationInfo.chTab;
	evo.chWhitespaceAlternative = m_FoundationInfo.chSpace;
	evo.cRecognizingLines = m_ModeState.cFindLimit;
	evo.strEndOfFile = m_FoundationInfo.strEndOfFile;

	EditViewOption&	misc = evo.evoMiscellaneous;
	misc = 0;
	if(m_FoundationInfo.bDrawBreakArrow)				misc |= EVO_SHOW_BREAKARROWS;
	if(m_FoundationInfo.bDrawCurrentUnderline)			misc |= EVO_SHOW_CURRENTUNDERLINE;
	if(m_FoundationInfo.bDrawEOF)						misc |= EVO_SHOW_EOFMARK;
	if(m_FoundationInfo.bDrawSpaces)					misc |= EVO_SHOW_WHITESPACE;
	if(m_FoundationInfo.bIgnoreCaseOnHilite)			misc |= EVO_IGNORECASE;
	if(m_FoundationInfo.bPaintBreakContinuingSelection)	misc |= EVO_PAINTBREAKCONTINUINGSEL;
	if(m_ModeState.bShowUnicodeCtrls)					misc |= EVO_SHOW_UNICODECTRLCHARS;
	if(m_ModeState.bUseOLEDragDrop)						misc |= EVO_USE_OLEDRAGDROP;

	std::wostringstream	ssChars;
	const xstring&		strAlpha = m_FoundationInfo.strCharsTreatedAsAlpha;
	wchar_t				wszSurrogates[3] = {0, 0, 0};
	for(xstring::size_type i = 0; i < strAlpha.length(); ++i) {
		if(strAlpha[i] >= 0x010000) {
			Manah::CTextConverter::EncodeCodePointToUTF16SurrogatePair(strAlpha[i], wszSurrogates);
			ssChars << wszSurrogates;
		} else
			ssChars << static_cast<wchar_t>(strAlpha[i]);
	}
	evo.strCharsTreatedAsAlpha = ssChars.str();
}

///	݂̃^uԂ
inline unsigned short CEditView::GetTabWidth() const {
	AssertValid();
	return m_layoutInfo.nTabWidth;
}

/**
 *	C̎擾
 *	@param type			̎
 *	@return				C
 *	@throw out_of_range	<var>type</var> sȂƂX[
 *	@see				SetTextFoundation
 */
inline TTextFoundation CEditView::GetTextFoundation(TextType type) const throw(out_of_range) {
	AssertValid();
	if(type < TT_NORMAL || type >= TEXTTYPE_NUMBER)
		throw out_of_range("Specified type is invalid.");

	TTextFoundation	tf = m_layoutInfo.tfTextFoundation[type];

	// OiF̎
	if(tf.fgColor == -1) {
		if(type == TT_NORMAL)					tf.fgColor = ::GetSysColor(COLOR_WINDOWTEXT);
		else if(type == TT_SELECTION)			tf.fgColor = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
		else if(type == TT_INACTIVESELECTION)	tf.fgColor = ::GetSysColor(COLOR_INACTIVECAPTIONTEXT);
		else									tf.fgColor = (m_layoutInfo.tfTextFoundation[TT_NORMAL].fgColor != -1) ?
													m_layoutInfo.tfTextFoundation[TT_NORMAL].fgColor : ::GetSysColor(COLOR_WINDOWTEXT);
	}

	// wiF̎
	if(tf.bgColor == -1) {
		if(type == TT_NORMAL)					tf.bgColor = ::GetSysColor(COLOR_WINDOW);
		else if(type == TT_SELECTION)			tf.bgColor = ::GetSysColor(COLOR_HIGHLIGHT);
		else if(type == TT_INACTIVESELECTION)	tf.bgColor = ::GetSysColor(COLOR_INACTIVECAPTION);
		else									tf.bgColor = (m_layoutInfo.tfTextFoundation[TT_NORMAL].bgColor != -1) ?
													m_layoutInfo.tfTextFoundation[TT_NORMAL].bgColor : ::GetSysColor(COLOR_WINDOW);
	}

	return tf;
}

///	L[}NL^/ꎞ~̃r[Ԃ
inline CEditView* CEditView::GetViewKeyMacroRecording() {
	return CKeyMacroPlayer::Create()->GetActiveView();
}

/**
 *	NCAg̈ɕ\ł񐔂擾
 *	@return	\\ȗ
 */
inline unsigned int CEditView::GetVisibleCharCount() const {
	RECT	rect;
	GetClientRect(&rect);
	return (rect.right - rect.left == 0) ? 0 :
		(rect.right - rect.left - m_layoutInfo.nLeftMargin - m_layoutInfo.nLeftTabWidth) / GetAvgCharWidth();
}

/**
 *	NCAg̈ɕ\łs擾
 *	@return	\\ȍs
 */
inline unsigned int CEditView::GetVisibleLineCount() const {
	RECT	rect;
	GetClientRect(&rect);
	return (rect.bottom - rect.left == 0) ? 0:
		(rect.bottom - rect.top - m_layoutInfo.nTopMargin) / m_layoutInfo.nLineHeight;
}

///	܂Ԃ[hԂ
inline WrapMode CEditView::GetWrapMode() const {
	AssertValid();
	return m_ModeState.wpmWrapMode;
}

/**
 *	I͈͂邩ǂԂ
 *	@return	I͈͂Ȃ true
 */
inline bool CEditView::HasSelection() const {
	AssertValid();
	return m_posAnchor != m_posActive;
}

/**
 *	L[}NɕۑłL[ǂԂ
 *	@param nChar	zL[
 */
inline bool CEditView::IsAcceptableAsMacroKey(UINT nChar) const {
	switch(nChar) {
	case VK_LBUTTON:
	case VK_RBUTTON:
	case VK_CANCEL:
	case VK_MBUTTON:
	case VK_MENU:
	case VK_LWIN:
	case VK_RWIN:
	case VK_APPS:
	case VK_LMENU:
	case VK_RMENU:
		return false;
	}
	return true;
}

/**
 *	_uNH[gň͂܂ꂽ̒Ԃ (pɓ)B
 *	GXP[vɂ̓obNXbVgp
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		p̒BȂ0BĂȂ <var>cch</var> 𓯂lԂ
 */
inline unsigned long CEditView::IsDoubleQuotation(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	if(*psz != L'\"')
		return 0;
	for(unsigned long i = 1; i < cch; ++i) {
		if(*(psz + i) == L'\\')	// ͖̕
			++i; 
		else if(*(psz + i) == L'\"')
			return i + 1;
	}
	return cch;
}

/**
 *	݂̃R[hy[Wŕsȕ̒Ԃ
 *	@param psz	ׂ镶ւ̃|C^
 *	@param cch	<var>psz</var> ̒
 *	@return		sȕłȂꍇ0BsȒ U+10000 ̏ꍇ2BȊO1
 */
inline unsigned char CEditView::IsInvalidCharacter(const wchar_t* psz, unsigned long cch) const {
	assert(psz != 0);

	if(cch == 0)
		return 0;
	else if(cch > 1
			&& Manah::CTextConverter::IsUTF16HighSurrogate(psz[0])
			&& Manah::CTextConverter::IsUTF16LowSurrogate(psz[1])) {
		BOOL	b = FALSE;
		::WideCharToMultiByte(GetDocument()->GetCodePage(), 0, psz, 2, 0, 0, 0, &b);
		return toBoolean(b) ? 1 : 0;
	} else {
		BOOL	b = FALSE;
		::WideCharToMultiByte(GetDocument()->GetCodePage(), 0, psz, 1, 0, 0, 0, &b);
		return toBoolean(b) ? 1 : 0;
	}
}

/**
 *	sRg1̒Ԃ (RgJnAIɓ)B
 *	@param psz			ׂ镶
 *	@param cch			<var>psz</var> ̒
 *	@param bContinued	ׂ镶񂪊ɕsRg1ł邱ƂĂ true w肷B
 *						̃\bh͏IɃRgIĂ false AłȂ true ݒ肷
 */
inline unsigned long CEditView::IsMComment1(const wchar_t* psz, unsigned long cch, bool& bContinued) const {
	assert(psz != 0);

	if(m_FoundationInfo.strCommentStart1.empty() || m_FoundationInfo.strCommentEnd1.empty())
		return 0;
	if(bContinued && cch < m_FoundationInfo.strCommentEnd1.length())
		return cch;
	if(!bContinued && cch < m_FoundationInfo.strCommentStart1.length())
		return 0;

	unsigned long	i = 0;

	if(!bContinued) {	// Jñ`FbN
		if(0 == CompareString(psz,
				m_FoundationInfo.strCommentStart1.c_str(),
				m_FoundationInfo.strCommentStart1.length())) {
			bContinued = true;
			i = m_FoundationInfo.strCommentStart1.length();
		} else
			return 0;
	}

	// IT
	if(m_FoundationInfo.bIgnoreCaseOnHilite) {	// 啶ʂȂꍇ
		wchar_t*	pszDummy = new wchar_t[cch];
		wchar_t*	pszEndStr = new wchar_t[m_FoundationInfo.strCommentEnd1.length() + 1];
		wcsncpy(pszDummy, psz, cch);
		Manah::CTextConverter::ToLower(pszDummy, cch);
		wcscpy(pszEndStr, m_FoundationInfo.strCommentEnd1.c_str());
		Manah::CTextConverter::ToLower(pszEndStr);
		std::wstring	str = wstring(pszDummy, cch);
		delete[] pszDummy;
		pszDummy = 0;
		i = str.find(pszEndStr, i);
		delete[] pszEndStr;
		pszEndStr = 0;
	} else {
		std::wstring	str = wstring(psz, cch);
		i = str.find(m_FoundationInfo.strCommentEnd1, i);
	}
	if(i == wstring::npos) {
		bContinued = true;
		return cch;
	} else {
		bContinued = false;
		return i + m_FoundationInfo.strCommentEnd1.length();
	}
}

/**
 *	sRg2̒Ԃ (RgJnAIɓ)B
 *	@param psz			ׂ镶
 *	@param cch			<var>psz</var> ̒
 *	@param bContinued	ׂ镶񂪊ɕsRg1ł邱ƂĂ true w肷B
 *						̃\bh͏IɃRgIĂ false AłȂ true ݒ肷
 */
inline unsigned long CEditView::IsMComment2(const wchar_t* psz, unsigned long cch, bool& bContinued) const {
	assert(psz != 0);

	if(m_FoundationInfo.strCommentStart2.empty() || m_FoundationInfo.strCommentEnd2.empty())
		return 0;
	if(bContinued && cch < m_FoundationInfo.strCommentEnd2.length())
		return cch;
	if(!bContinued && cch < m_FoundationInfo.strCommentStart2.length())
		return 0;

	unsigned long	i = 0;

	if(!bContinued) {	// Jñ`FbN
		if(0 == CompareString(psz,
				m_FoundationInfo.strCommentStart2.c_str(),
				m_FoundationInfo.strCommentStart2.length())) {
			bContinued = true;
			i = m_FoundationInfo.strCommentStart2.length();
		} else
			return 0;
	}

	// IT
	if(m_FoundationInfo.bIgnoreCaseOnHilite) {	// 啶ʂȂꍇ
		wchar_t*	pszDummy = new wchar_t[cch];
		wchar_t*	pszEndStr = new wchar_t[m_FoundationInfo.strCommentEnd2.length() + 1];
		wcsncpy(pszDummy, psz, cch);
		Manah::CTextConverter::ToLower(pszDummy, cch);
		wcscpy(pszEndStr, m_FoundationInfo.strCommentEnd2.c_str());
		Manah::CTextConverter::ToLower(pszEndStr);
		std::wstring	str = wstring(pszDummy, cch);
		delete[] pszDummy;
		pszDummy = 0;
		i = str.find(pszEndStr, i);
		delete[] pszEndStr;
		pszEndStr = 0;
	} else {
		std::wstring	str = wstring(psz, cch);
		i = str.find(m_FoundationInfo.strCommentEnd2, i);
	}
	if(i == wstring::npos) {
		bContinued = true;
		return cch;
	} else {
		bContinued = false;
		return i + m_FoundationInfo.strCommentEnd2.length();
	}
}

///	ԕ̔P\ǂԂ ([U`P\͖)
inline bool CEditView::IsNeutralNoAlpha(wchar_t wch) {
	WORD	wCharType;

	::GetStringTypeW(CT_CTYPE2, &wch, 1, &wCharType);
	if(wCharType >= C2_BLOCKSEPARATOR && wCharType <= C2_OTHERNEUTRAL) {
		::GetStringTypeW(CT_CTYPE3, &wch, 1, &wCharType);
		return !toBoolean(wCharType & (C3_DIACRITIC | C3_VOWELMARK | /*C3_LEXICAL |*/ C3_ALPHA));
	}
	return false;
}

///	l\̒ԂBlłȂ 0 Ԃ
inline unsigned long CEditView::IsNumeric(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	if(!toBoolean(iswdigit(*psz)))
		return 0;
	for(unsigned long i = 1; i < cch; ++i) {
		if(toBoolean(iswalnum(psz[i])) || psz[i] == L'.')
			/* Ȃ */;
		else
			return i;
	}
	return cch;
}

/**
 *	Zq̒Ԃ
 *	@param psz	ׂ镶
 *	@param cch	<var>psz</var> ̒
 *	@return		Zq̒BȂ0
 */
inline unsigned long CEditView::IsOperator(const wchar_t* psz, unsigned long cch) const {
	AssertValid();
	assert(psz != 0);

	if(cch == 0)
		return 0;
	OperatorMap::const_iterator	itInis = m_FoundationInfo.mapOperators.find(psz[0]);
	if(itInis == m_FoundationInfo.mapOperators.end())
		return 0;
	std::list<std::wstring>::const_iterator	it = itInis->second.begin();
	for(; it != itInis->second.end(); ++it) {
		if(cch < it->length())
			continue;
		if(0 == CompareString(psz, it->c_str(), it->length()))
			return it->length();
	}
	return 0;
}

/**
 *	㏑[hǂԂ
 *	@see	CEditView::SetOverwriteMode
 */
inline bool CEditView::IsOverwriteMode() const {
	AssertValid();
	return m_ModeState.bOverwrite;
}

/**
 *	񂪒PsRg1JnŎn܂Ă邩Ԃ
 *	@param psz	ׂ镶
 *	@param cch	<var>psz</var> ̒
 */
inline bool CEditView::IsSComment1(const wchar_t* psz, unsigned long cch) const {
	assert(psz != 0);

	if(m_FoundationInfo.strCommentLineHeader1.empty())
		return false;
	if(cch < m_FoundationInfo.strCommentLineHeader1.length())
		return false;
	return 0 == CompareString(psz,
		m_FoundationInfo.strCommentLineHeader1.c_str(),
		m_FoundationInfo.strCommentLineHeader1.length());
}

/**
 *	񂪒PsRg2JnŎn܂Ă邩Ԃ
 *	@param psz	ׂ镶
 *	@param cch	<var>psz</var> ̒
 */
inline bool CEditView::IsSComment2(const wchar_t* psz, unsigned long cch) const {
	assert(psz != 0);

	if(m_FoundationInfo.strCommentLineHeader2.empty())
		return false;
	if(cch < m_FoundationInfo.strCommentLineHeader2.length())
		return false;
	return 0 == CompareString(psz,
		m_FoundationInfo.strCommentLineHeader2.c_str(),
		m_FoundationInfo.strCommentLineHeader2.length());
}

/**
 *	VONH[gň͂܂ꂽ̒Ԃ (pɓ)B
 *	GXP[vɂ̓obNXbVgpB
 *	Ȃ 0 ԂB
 *	ĂȂ <var>cch</var> 𓯂lԂ
 */
inline unsigned long CEditView::IsSingleQuotation(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	if(*psz != L'\'')
		return 0;
	for(unsigned long i = 1; i < cch; ++i) {
		if(*(psz + i) == L'\\')	// ͖̕
			++i; 
		else if(*(psz + i) == L'\'')
			return i + 1;
	}
	return cch;
}

/**
 *	󔒗ޕ̒Ԃ
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		󔒗ޕAĂ钷BzCgXy[XłȂ0
 */
inline unsigned long CEditView::IsWhiteSpace(const wchar_t* psz, unsigned long cch) {
	assert(psz != 0);

	for(unsigned long i = 0; i < cch; ++i) {
		if(!iswspace(*(psz+i)))
			return i;
	}
	return cch;
}

/**
 *	P̒Ԃ
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		P\AĂ钷BPłȂ0
 */
inline unsigned long CEditView::IsWord(const wchar_t* psz, unsigned long cch) const {
	assert(psz != 0);

	WORD			w;
	unsigned long	ch;
	for(unsigned long i = 0; i < cch; ++i) {
		if(Manah::CTextConverter::IsUTF16HighSurrogate(*(psz + i))
				&& i < cch - 1
				&& Manah::CTextConverter::IsUTF16LowSurrogate(*(psz + i + 1))) {
			ch = Manah::CTextConverter::DecodeUTF16SurrogatePairToCodePoint(psz + i, cch - i);
			if(m_FoundationInfo.strCharsTreatedAsAlpha.find(ch) != xstring::npos)
				++i;
			else if((ch >= 0x010000 && ch <= 0x01004D)		// Linear B Syllabary
					|| (ch >= 0x010080 && ch <= 0x0100FA)	// Linear B Ideograms
					|| (ch >= 0x010300 && ch <= 0x01031E)	// Old Italic
					|| (ch >= 0x010330 && ch <= 0x010349)	// Gothic
					|| (ch >= 0x010380 && ch <= 0x01039D)	// Ugaritic
					|| (ch >= 0x010400 && ch <= 0x01044F)	// Diseret
					|| (ch >= 0x010450 && ch <= 0x01047F)	// Shavian
					|| (ch >= 0x010480 && ch <= 0x01049D)	// Osmanya
					|| (ch >= 0x010800 && ch <= 0x01083C)	// Cypriot
					|| (ch == 0x01083F)
					|| (ch >= 0x01D400 && ch <= 0x01D454)	// Mathematical Alphanumeric Symbols
					|| (ch >= 0x01D456 && ch <= 0x01D49C)
					|| (ch == 0x01D49E)
					|| (ch == 0x01D49F)
					|| (ch == 0x01D4A2)
					|| (ch == 0x01D4A5)
					|| (ch == 0x01D4A6)
					|| (ch >= 0x01D4A9 && ch <= 0x01D4AC)
					|| (ch >= 0x01D4AE && ch <= 0x01D4B9)
					|| (ch == 0x01D4BB)
					|| (ch >= 0x01D4BD && ch <= 0x01D4C3)
					|| (ch >= 0x01D4C5 && ch <= 0x01D505)
					|| (ch >= 0x01D507 && ch <= 0x01D50A)
					|| (ch >= 0x01D50D && ch <= 0x01D514)
					|| (ch >= 0x01D516 && ch <= 0x01D51C)
					|| (ch >= 0x01D51E && ch <= 0x01D539)
					|| (ch >= 0x01D53B && ch <= 0x01D53E)
					|| (ch >= 0x01D540 && ch <= 0x01D544)
					|| (ch == 0x01D546)
					|| (ch >= 0x01D54A && ch <= 0x01D550)
					|| (ch >= 0x01D552 && ch <= 0x01D7C9)
					|| (ch >= 0x020000 && ch <= 0x02A6D6)	// CJK Unified Ideographs Extension B
					|| (ch >= 0x02F800 && ch <= 0x02FA1D)	// CJK Compatibility Ideographs Supplement
					|| (ch >= 0x0E0041 && ch <= 0x0E005A)	// Tags
					|| (ch >= 0x0E0061 && ch <= 0x0E007A))
				++i;
			else if((i != 0) && (	// 
					(ch >= 0x010107 && ch <= 0x010133)		// Aegean Numbers
					|| (ch >= 0x010320 && ch <= 0x010323)	// Old Italic
					|| (ch >= 0x0104A0 && ch <= 0x0104A9)	// Osmanya
					|| (ch >= 0x01D7CE && ch <= 0x01D7FF)	// Mathematical Alphanumeric Symbols
					|| (ch >= 0x0E0030 && ch <= 0x0E0039)))	// Tags
				++i;
			else
				return i;
		} else if(m_FoundationInfo.strCharsTreatedAsAlpha.find(psz[i]) != xstring::npos)
			continue;
		else {
			::GetStringTypeW(CT_CTYPE3, psz + i, 1, &w);
			if(!toBoolean(w & (C3_DIACRITIC | C3_VOWELMARK | /*C3_LEXICAL |*/ C3_ALPHA))) {
				if(i != 0) {
					::GetStringTypeW(CT_CTYPE1, psz + i, 1, &w);
					if(!toBoolean(w & C1_DIGIT))
						return i;
				} else
					return i;
			}
		}
	}
	return cch;
}

} // namespace Ascension

#endif /* _EDIT_VIEW_H_ */

/* [EOF] */