// AlphaScriptHost.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AlphaScriptHost.h"
#include "AlphaApplicationObject.h"
using Alpha::CAlphaScriptHost;
using Alpha::Ambient::CAutomationScriptHost;

// ɂĂ͊ CLSID AIID `ɂȂ
// ȉ̐錾IIɗLɂƂ悢 (Ǝv)

//static const CLSID CLSID_ProcessDebugManager = {
//	0x78a51822, 0x51f4, 0x11d0, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
static const IID	IID_IActiveScriptDebug = {
	0x51973C10, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IActiveScriptSiteDebug = {
	0x51973C11, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IProcessDebugManager = {
	0x51973C2f, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};
static const IID	IID_IDebugApplication = {
	0x51973C32, 0xCB0C, 0x11d0, {0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A}};


// CAlphaScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param hWnd					TCgEBhE
 *	@param pDebugApplication	fobO null
 */
CAlphaScriptHost::CAlphaScriptHost(HWND hWnd, IDebugApplication* pDebugApplication /* = 0 */)
		: m_pAutomation(0), m_hOwnerWindow(hWnd), m_pDebugApplication(pDebugApplication),
		m_bIsErrorReported(false), m_bAllowedErrorReport(true) {
	assert(m_hOwnerWindow == 0 || ::IsWindow(m_hOwnerWindow));

	m_pAutomation = new CAutomationScriptHost(m_hOwnerWindow);
	m_pAutomation->AddRef();
	m_pDebugApplication = pDebugApplication;
	if(m_pDebugApplication != 0)
		m_pDebugApplication->AddRef();
}

///	fXgN^
CAlphaScriptHost::~CAlphaScriptHost() {
	if(m_pAutomation != 0)
		m_pAutomation->Release();
	if(m_pDebugApplication != 0)
		m_pDebugApplication->Release();
	for(MemberTable::iterator it = m_mapTopLevelObjects.begin(); it != m_mapTopLevelObjects.end(); ++it)
		it->second->Release();
}

/**
 *	ŏʃIuWFNg̐ݒBOŕ̃IuWFNgǉꍇ̋ɂĂ͕ۏ؂ȂB
 *	̃IuWFNg͎ʎq̑啶ʂȂB
 *	@param lpstrObjectName	ŏʃIuWFNg̖O
 *	@param pObject			ŏʃIuWFNg (null ƃgbvxIuWFNg͍폜)
 */
void CAlphaScriptHost::AddTopLevelObject(LPCOLESTR lpstrObjectName, IDispatch* pObject) {
	assert(lpstrObjectName != 0 && ::StrCmpIW(lpstrObjectName, L"WScript") != 0);

	wchar_t*	pwszObjectName = new wchar_t[wcslen(lpstrObjectName) + 1];

	wcscpy(pwszObjectName, lpstrObjectName);
	::CharUpperW(pwszObjectName);

	if(pObject != 0) {	// ǉ
		m_mapTopLevelObjects[pwszObjectName] = pObject;
		pObject->AddRef();
	} else {	// 폜
		MemberTable::iterator	it = m_mapTopLevelObjects.find(pwszObjectName);
		if(it != m_mapTopLevelObjects.end()) {
			it->second->Release();
			m_mapTopLevelObjects.erase(it);
		}
	}

	delete[] pwszObjectName;
}

///	XNvgG[Ƀ_CAOoǂݒ肷
void CAlphaScriptHost::AllowErrorReport(bool bAllow) {
	m_bAllowedErrorReport = bAllow;
}

///	@see	IActiveScriptSiteWindow::EnableModeless
STDMETHODIMP CAlphaScriptHost::EnableModeless(BOOL fEnable) {
	return E_NOTIMPL;
}

///	@see	IActiveScriptSiteDebug::GetApplication
STDMETHODIMP CAlphaScriptHost::GetApplication(IDebugApplication** ppda) {
	VERIFY_POINTER(ppda);
	if(m_pDebugApplication == 0)
		return E_UNEXPECTED;
	m_pDebugApplication->QueryInterface(IID_IDebugApplication, reinterpret_cast<void**>(ppda));
	return S_OK;
}

///	I[g[VŃXNvgzXgԂ
void CAlphaScriptHost::GetAutomationHostObject(IScriptHost** ppScriptHost) const {
	assert(ppScriptHost != 0);
	m_pAutomation->QueryInterface(IID_IScriptHost, reinterpret_cast<void**>(ppScriptHost));
}

///	@see	IActiveScriptSiteDebug::GetDocumentContextFromPosition
STDMETHODIMP CAlphaScriptHost::GetDocumentContextFromPosition(
		DWORD dwSourceContext, ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc) {
	return E_NOTIMPL;
}

///	@see	IActiveScriptSite::GetDocVersionString
STDMETHODIMP CAlphaScriptHost::GetDocVersionString(BSTR* pbstrVersion) {
	return E_NOTIMPL;
}

///	@see	IActiveScriptSite::GetItemInfo
STDMETHODIMP CAlphaScriptHost::GetItemInfo(LPCOLESTR pstrName,
		DWORD dwReturnMask, IUnknown** ppunkItem, ITypeInfo** ppTypeInfo) {
	IDispatch*					pItemObject = 0;
	wchar_t*					pwszName = new wchar_t[wcslen(pstrName) + 1];
	MemberTable::const_iterator	it;

	wcscpy(pwszName, pstrName);
	::CharUpperW(pwszName);
	it = m_mapTopLevelObjects.find(pwszName);

	if(it != m_mapTopLevelObjects.end())
		pItemObject = it->second;
	else if(wcscmp(pwszName, L"WSCRIPT") == 0)
		pItemObject = m_pAutomation;
	else {
		if(dwReturnMask & SCRIPTINFO_IUNKNOWN) {
			VERIFY_POINTER(ppunkItem);
			*ppunkItem = 0;
		}
		if(dwReturnMask & SCRIPTINFO_ITYPEINFO) {
			VERIFY_POINTER(ppTypeInfo);
			*ppTypeInfo = 0;
		}
		delete[] pwszName;
		return TYPE_E_ELEMENTNOTFOUND;
	}

	if(dwReturnMask & SCRIPTINFO_IUNKNOWN) {
		VERIFY_POINTER(ppunkItem);
		*ppunkItem = pItemObject;
		(*ppunkItem)->AddRef();
	}
	if(dwReturnMask & SCRIPTINFO_ITYPEINFO) {
		VERIFY_POINTER(ppTypeInfo);
		pItemObject->GetTypeInfo(0, 0, ppTypeInfo);
	}

	delete[] pwszName;
	return S_OK;
}

///	@see	IActiveScriptSite::GetLCID
STDMETHODIMP CAlphaScriptHost::GetLCID(LCID* plcid) {
	return E_NOTIMPL;
}

///	@see	IActiveScriptSiteDebug::GetRootApplicationNode
STDMETHODIMP CAlphaScriptHost::GetRootApplicationNode(IDebugApplicationNode** ppdanRoot) {
	return E_NOTIMPL;
}

///	@see	IActiveScriptSiteWindow::GetWindow
STDMETHODIMP CAlphaScriptHost::GetWindow(HWND* phwnd) {
	VERIFY_POINTER(phwnd);
	*phwnd = m_hOwnerWindow;
	return S_OK;
}

///	Ō̃XNvg]ɃG[񍐂Ăΐ^AB
///	\bhďóAɃXNvg]܂ŋUԂ
bool CAlphaScriptHost::IsErrorReportedAtLastParse() const {
	bool	bError = m_bIsErrorReported;
	m_bIsErrorReported = false;
	return bError;
}

///	@see	IActiveScriptSite::OnEnterScript
STDMETHODIMP CAlphaScriptHost::OnEnterScript() {
	if(m_pDebugApplication != 0)
		HRESULT	hr = m_pDebugApplication->CauseBreak();	// fobKu[N|CgZbg邽߂Ɏ~߂
	return S_OK;
}

///	@see	IActiveScriptSite::OnLeaveScript
STDMETHODIMP CAlphaScriptHost::OnLeaveScript() {
	return S_OK;
}

///	@see	IActiveScriptSite::OnScriptError
STDMETHODIMP CAlphaScriptHost::OnScriptError(IActiveScriptError* pscripterror) {
	if(pscripterror == 0)
		return E_INVALIDARG;

	wchar_t			wszMessage[1024];
	EXCEPINFO		ei;
	DWORD			dwSrcCtx;
	unsigned long	iLine;
	long			iChar;

	m_bIsErrorReported = true;

	if(m_bAllowedErrorReport && SUCCEEDED(pscripterror->GetExceptionInfo(&ei))) {
		pscripterror->GetSourcePosition(&dwSrcCtx, &iLine, &iChar);
		swprintf(wszMessage,
			L"XNvgG[܂B\n\ns:\t%lu\n:\t%ld\nG[:\t%s\nSCODE:\t%lX\n\[X:\t%s",
			iLine + 1, iChar + 1, ei.bstrDescription, ei.scode, ei.bstrSource);
		::MessageBox(m_hOwnerWindow, wszMessage, L"Alpha Script Host", MB_ICONHAND);
		::SysFreeString(ei.bstrSource);
		::SysFreeString(ei.bstrDescription);
		::SysFreeString(ei.bstrHelpFile);
	}

	return S_OK;
}

///	@see	IActiveScriptSiteDebug::OnScriptErrorDebug
STDMETHODIMP CAlphaScriptHost::OnScriptErrorDebug(
		IActiveScriptErrorDebug* pErrorDebug, BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing) {
	::MessageBox(0, L"G[!", L"w", 0);
	return S_OK;
}

///	@see	IActiveScriptSite::OnScriptTerminate
STDMETHODIMP CAlphaScriptHost::OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo) {
	return S_OK;
}

///	@see	IActiveScriptSite::OnStateChange
STDMETHODIMP CAlphaScriptHost::OnStateChange(SCRIPTSTATE ssScriptState) {
	return S_OK;
}

///	XNvgIuWFNg^ăCxgVN
void CAlphaScriptHost::RunEventSinks(IDispatch* pScriptObject) {
	m_pAutomation->RunEventSinks(pScriptObject);
}

///	sXNvgpX̐ݒ (qgƂĎgp)
void CAlphaScriptHost::SetScriptPath(const wchar_t* pwszScriptPath) {
	m_pAutomation->SetScriptPath(pwszScriptPath);
}

/* [EOF] */