// AlphaEditController.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AlphaEditController.h"
#include "AlphaView.h"

using Alpha::CAlphaEditController;
using Alpha::CAlphaView;


// CAlphaEditController class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaEditController::CAlphaEditController() : m_iLastActiveView(0) {
}

///	@see	CView::Create
bool CAlphaEditController::Create(HWND hwndParent, const RECT* lpRect,
		DWORD dwStyle, DWORD dwExStyle, DWORD dwViewStyle, DWORD dwViewExStyle) {
	return _Create<CAlphaEditController>(hwndParent, lpRect,
			dwStyle, dwExStyle, dwViewStyle, dwViewExStyle);
}

///	@see	IAlphaTab::DeleteInstance
void CAlphaEditController::DeleteInstance() {
	GetDocument()->SetEventListener(0);	// r[̔j󒆂ɃNCAgɃR[obN\
	DestroyWindow();
	delete this;
}

///	@see	IAlphaTab::GetDescription
wstring CAlphaEditController::GetDescription() const {
	wstring	strDescription = GetDocument()->GetPathName();
	if(GetDocument()->IsModified())
		strDescription += L" *";
	return strDescription;
}

///	@see	IAlphaTab::GetTabTitle
wstring CAlphaEditController::GetTabTitle() const {
	wstring	strTitle = GetDocument()->GetTitle();
	if(GetDocument()->IsModified())
		strTitle += L" *";
	return strTitle;
}

///	@see	IAlphaTab::GetWindow
HWND CAlphaEditController::GetWindow() const {
	return GetActiveView()->m_hWnd;
}

///	@see	IAlphaTab::IsTextEditor
bool CAlphaEditController::IsTextEditor() const {
	return true;
}

///	@see	IAlphaTab::OnActive
void CAlphaEditController::OnActivate(bool bActive) {
	if(!bActive)
		m_iLastActiveView = (GetActiveView() == GetPrimaryView()) ? 0 : 1;
	ShowWindow(bActive ? SW_SHOW : SW_HIDE);
	if(bActive) {
		if(m_iLastActiveView == 0)	GetPrimaryView()->SetFocus();
		else						m_p2ndView->SetFocus();
	}
}

///	@see	IAlphaTab::OnClose
bool CAlphaEditController::OnClosing() {
	return true;
}

///	@see	IAlphaTab::OnSize
void CAlphaEditController::OnSize(const RECT* lpRect) {
	MoveWindow(lpRect);
}

///	@see	IAlphaTab::RefreshWindow
void CAlphaEditController::RefreshWindow() {
	GetActiveView()->InvalidateRect(0);
	GetActiveView()->UpdateWindow();
}

/* [EOF] */