// AlphaApplicationDebugger.h
// (c) 2003 exeal

#ifndef _ALPHA_APPLICATION_DEBUGGER_H_
#define _ALPHA_APPLICATION_DEBUGGER_H_

#include <list>
#include "AlphaScriptHost.h"
#include "AlphaDoc.h"
#include "..\Armaiti\ArmaitiImplementation.h"

namespace Alpha {

/// fobÕG[ (XNvgG[ł͂ȂAfobK̖)
enum DebugStatus {
	/// 薳
	DS_OK,
	/// PDM ̎擾Ɏs
	DS_FAILEDTOGETPDM,
	/// GWȂ
	DS_UNKNOWNSCRIPTLANGUAGE,
	/// GWp[T񋟂ĂȂ
	DS_ENGINENOTSUPPORTPARSER,
	/// GWfobOT|[gĂȂ
	DS_ENGINENOTSUPPORTDEBUGGING,
};

// TBreakPointInfo structure
/////////////////////////////////////////////////////////////////////////////

///	u[N|Cg\
struct TBreakPointInfo {
	/// _s
	unsigned long	iLine;
	/// u[N|CgLǂ
	bool			bEnabled;
};

///	u[N|Cg̃Xg
typedef list<TBreakPointInfo>	BreakPointList;


// IAlphaApplicationDebuggerListener interface definition
/////////////////////////////////////////////////////////////////////////////

///	fobK̃Cxg󂯎C^[tFCX
interface IAlphaApplicationDebuggerEventListener {
	///	fXgN^
	virtual ~IAlphaApplicationDebuggerEventListener() {}
	/// fobOJn
	virtual void	OnDebugStart() = 0;
	/// fobOI
	virtual void	OnDebugEnd() = 0;
	/// u[N|CgŒ~
	virtual void	OnDebugStopAtBreakPoint(unsigned long iLine) = 0;
	/// ^CG[Œ~
	virtual void	OnDebugStopByError(unsigned long iLine) = 0;
	/// XebvI[o[Ȃǂňړ
	virtual void	OnDebugStepTo(unsigned long iLine) = 0;
	/// fobOɃG[
	virtual void	OnDebugIllegalStatus(DebugStatus ds) = 0;
};


// CAlphaApplicationDebugger class definition
/////////////////////////////////////////////////////////////////////////////

///	XNvgfobK
class CAlphaApplicationDebugger :
		public IUnknownImpl<CMultiThreadMemoryManageModel>,
		public IApplicationDebugger,
		public IDebugSessionProvider {
	// RXgN^
public:
	CAlphaApplicationDebugger(HWND hwndMain, const BreakPointList& listBreakPoints);

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IApplicationDebugger)
		IMPLEMENTS_INTERFACE(IDebugSessionProvider)
	END_INTERFACE_TABLE()


	// IApplicationDebugger C^[tFCX
	STDMETHODIMP	QueryAlive();
	STDMETHODIMP	CreateInstanceAtDebugger(REFCLSID rclsid,
						IUnknown* pUnkOuter, DWORD dwClsContext, REFIID riid, IUnknown** ppvObject);
	STDMETHODIMP	onDebugOutput(LPCOLESTR pstr);
	STDMETHODIMP	onHandleBreakPoint(IRemoteDebugApplicationThread* prpt,
						BREAKREASON br, IActiveScriptErrorDebug* pError);
	STDMETHODIMP	onClose();
	STDMETHODIMP	onDebuggerEvent(REFIID riid, IUnknown* punk);

	// IDebugSessionProvider C^[tFCX
	STDMETHODIMP	StartDebugSession(IRemoteDebugApplication* pda);

	// 
	void				GetDebuggingApplication(IRemoteDebugApplication** ppApplication);
	void				GetDebuggingApplicationThread(IRemoteDebugApplicationThread** ppAppThread);
	const CAlphaDoc*	GetDebuggingDocument() const;
	void				GetScriptHost(IActiveScriptSiteDebug** ppScriptSite);
	bool				IsDebugging() const;

	// 
	void	Abort();
	void	Continue();
	void	StartDebugging(const CAlphaDoc* pDocument, const wstring& strLanguageName);
	void	StepInto();
	void	StepOver();
	void	StepOut();
	HRESULT	EvaluateExpression(const wstring& strExpression,
				unsigned int nRadix, bool bNoSideEffects, DebugPropertyInfo* pdpiResult);

	// Xi
	void	SetEventListener(IAlphaApplicationDebuggerEventListener* pEventListener);

protected:
	void						_SetBreakPoints();
	static unsigned int WINAPI	_StartDebugging(void* pParam);

	// f[^o
private:
	IRemoteDebugApplicationThread*			m_pRemoteAppThread;
	IActiveScript*							m_pActiveEngine;
	CAlphaScriptHost*						m_pScriptHost;
	IAlphaApplicationDebuggerEventListener*	m_pEventListener;
	HWND									m_hwndMain;
	bool									m_bDebugging;
	bool									m_bFirstHalt;
	const BreakPointList					m_listBreakPoints;
	wstring									m_strLanguageName;
	const CAlphaDoc*						m_pDocument;
};

} /* namespace Alpha */

#endif /* _ALPHA_APPLICATION_DEBUGGER_H_ */

/* [EOF] */