// Alpha.cpp : AvP[Vp̃Gg |Cg̒`
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "alpha_mc.h"
#include "Alpha.h"
#include "AlphaScriptHost.h"
#include "AboutDlg.h"
#include "CommonOptionDlg.h"
#include "DocTypeOptionDlg.h"
#include "CodePagesDlg.h"
#include "CodePageManager.h"
#include "FilePropertyDlg.h"
#include "FileOperationDlg.h"
#include "ExecuteCommandDlg.h"
#include "DebugDlg.h"
#include "SelectLanguageDlg.h"
#include "ConfirmUnsavedDocumentDlg.h"
#include "NewFileFormatDlg.h"
#include "..\Manah\WaitCursor.h"
#include "..\Manah\DC.h"
#include "..\Manah\GDIObject.h"
#include <algorithm>
#include <fstream>
#include <dlgs.h>
//#include "Msxml3.tlh"	// MSXML2::IXMLDOMDocument
using namespace Alpha;
using namespace Manah::Windows::GDI;


// O[o֐
/////////////////////////////////////////////////////////////////////////////

///	Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	CAlphaApp*		pApp;
	CWindow			wndApp;
	HWND			hExistWnd;
	OSVERSIONINFOA	osvi;

	// NT nׂ
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA);
	::GetVersionExA(&osvi);
	if(!toBoolean(osvi.dwPlatformId & VER_PLATFORM_WIN32_NT)) {
		::MessageBoxA(0, "gp̃o[W OS ł Alpha s邱Ƃ͂ł܂B", "Alpha", MB_ICONHAND);
		return -1;
	}

	pApp = new CAlphaApp();

	// ȒPȑdN}~
	hExistWnd = ::FindWindowW(L"Alpha", 0);
	if(!::IsWindow(hExistWnd)) {	// B Alpha vZX
		::OleInitialize(0);
		::InitCommonControls();
		pApp->InitApplication(hInstance);
		pApp->InitInstance();
		pApp->Run();
		::OleUninitialize();
	} else {	// ̃vZXɃR}hCn
		COPYDATASTRUCT	cd = {0,
			(wcslen(::GetCommandLineW()) + 1) * sizeof(wchar_t), ::GetCommandLineW()};
		::SendMessage(hExistWnd, WM_COPYDATA, 0, reinterpret_cast<LPARAM>(&cd));
		::Sleep(300);
		::SetForegroundWindow(hExistWnd);
	}

	delete pApp;

	return 0;
}


// CAlphaApp class implementation
/////////////////////////////////////////////////////////////////////////////

CAlphaApp* CAlphaApp::m_pInstance = 0;

///	RXgN^
CAlphaApp::CAlphaApp()
		: m_pMenu(0), m_pNewDocTypeMenu(0), m_pAppDocTypeMenu(0),
		m_iActiveTab(-1), m_iLastActiveTab(0), m_bSizingOutputWnd(false),
		m_pActiveDebugger(0), m_pDebuggingEditor(0), m_pMRUManager(0), m_pXMLDoc(0),
		m_pApplication(0), m_pDocuments(0) {
	assert(CAlphaApp::m_pInstance == 0);
	CAlphaApp::m_pInstance = this;
	m_pdlgGotoLine = new CGotoLineDlg(this);
	m_pdlgBookmark = new CBookmarkDlg(this);
	m_pdlgDebugBreakPoints = new CDebugBreakPointsDlg;
	m_pdlgDebugCallStack = new CDebugCallStackDlg;
	m_pdlgDebugImmediate = new CDebugImmediateDlg;
	m_pdlgDebugRunningDocuments = new CDebugRunningDocumentsDlg;
	m_pdlgDebugThreads = new CDebugThreadsDlg;
	m_pdlgDebugVariables = new CDebugVariablesDlg;
}

///	fXgN^
CAlphaApp::~CAlphaApp() {
	::DestroyAcceleratorTable(m_hAcceleratorTable);
	delete m_pdlgGotoLine;
	delete m_pdlgBookmark;
	delete m_pdlgDebugBreakPoints;
	delete m_pdlgDebugCallStack;
	delete m_pdlgDebugImmediate;
	delete m_pdlgDebugRunningDocuments;
	delete m_pdlgDebugThreads;
	delete m_pdlgDebugVariables;
	if(m_pApplication != 0)
		m_pApplication->Release();
	if(m_pDocuments != 0)
		m_pDocuments->Release();
	CAlphaApp::m_pInstance = 0;
}

/**
 *	w肵r[ɃhLg^CvKp
 *	@param iTab		^u
 *	@param iDocType	KphLg^CvB-1w肷Ɗgqɍ̂KpB
 *					ǂ̃hLg^CvɂȂ0 (ݒ薳) Kp
 */
void CAlphaApp::ApplyDocumentType(unsigned int iTab, unsigned int iDocType /* = -1 */) {
	AssertValid();

	CWaitCursor wc;

	IAlphaTab*				pTab = m_vecDocuments[iTab];
	CAlphaEditController*	pCtrl = 0;
	CAlphaDoc*				pDoc = 0;
	TDocumentType*			pDocType = 0;
	TDocumentStyleType*		pDocStyleType = 0;

	if(pTab->IsTextEditor()) {
		pCtrl = static_cast<CAlphaEditController*>(pTab);
		pDoc = pCtrl->GetDocument();
	} else
		return;

	if(iDocType == -1)	// gqhLg^Cv
		iDocType = GetDocumentTypeFromFileName(pDoc->GetTitle());
	else if(iDocType >= m_vecDocumentTypes.size())
		throw out_of_range("invalid index for document type.");

	if(!m_vecDocumentTypes.empty()) {
		pDocType = &m_vecDocumentTypes[iDocType];
		pDoc->m_iDocType = iDocType;
		if(!m_vecDocStyleTypes.empty())
			pDocStyleType = (pDocType->iStyle < m_vecDocStyleTypes.size()) ? &m_vecDocStyleTypes[pDocType->iStyle] : 0;
	}

	// ͌P̐ݒ (XML gȂb)
	list<TCandidateWord>	listCandidateWords;
	if(pDocType != 0 && !pDocType->strCandidateWordsFile.empty()) {
		wifstream	oFile;
		char		szPath[MAX_PATH];
		wstring		strWord;

		::GetModuleFileNameA(0, szPath, MAX_PATH);
		setlocale(LC_CTYPE, 0);
		wcstombs(strrchr(szPath, '\\') + 1, pDocType->strCandidateWordsFile.c_str(), MAX_PATH);
		oFile.open(szPath, ios_base::in);
		if(!oFile.bad() && !oFile.fail()) {
			while(oFile >> strWord)
				listCandidateWords.push_back(TCandidateWord(strWord, WP_PROPERTY, L""));
			oFile.close();
		}
	}

	CAlphaView*		pView = pCtrl->GetPrimaryView();
	TEditViewOption	evo;

	// ftHg擾
	pView->GetOption(evo);

	// ʐݒ (݊Y)
	evo.evoMiscellaneous = EVO_SHOW_BREAKARROWS | EVO_SHOW_EOFMARK
							| EVO_SHOW_WHITESPACE | EVO_SHOW_CURRENTUNDERLINE
							| EVO_USE_OLEDRAGDROP | EVO_PAINTBREAKCONTINUINGSEL;

	// ^Cvʐݒ
	if(pDocType != 0) {
		evo.aitAutoIndentType = pDocType->ait;
//		evo.chTabAlternative = 
//		evo.chWhitespaceAlternative = 
//		evo.cRecognizingLines = 
		evo.strCharsTreatedAsAlpha = pDocType->strSpecialKeywordChars;
//		evo.strEndOfFile = 
		evo.evoMiscellaneous |= pDocType->bIgnoreCase ? EVO_IGNORECASE : 0;
	}

	pView->SetOption(evo);
	if(pDocType != 0) {
		pView->LockParsing();
		pView->SetCharSpaces(pDocType->nLineSpan, pDocType->nCharSpan);
		pView->SetTabWidth(pDocType->nTabWidth);
		pView->SetKeywordLists(pDocType->listKeywords1, pDocType->listKeywords2);
		pView->SetOperators(pDocType->listOperators);
		pView->SetMultilineCommentDelimiters(
			pDocType->strMCommentBegin1, pDocType->strMCommentEnd1,
			pDocType->strMCommentBegin2, pDocType->strMCommentEnd2);
		pView->SetSinglelineCommentHeaders(pDocType->strSCommentHeader1, pDocType->strSCommentHeader2);
		pView->SetLeftTabType(pDocType->ltt);
		pView->SetMargins(GetProfileInt(L"View", L"nLeftMargin", 5), GetProfileInt(L"View", L"nTopMargin", 0));
		for(int iType = 0; iType < TEXTTYPE_NUMBER; ++iType)
			pView->SetTextFoundation(static_cast<TextType>(iType), pDocStyleType->arrTfs[iType]);
		pView->SetCandidateWords(listCandidateWords);
		pView->UnlockParsing();
	}

	UpdateStatusBar();


/*	if(m_pXMLDoc != 0 && !pDocType->strCandidateWordsFile.empty()) {
		VARIANT_BOOL	bSuccess;
		_variant_t		vt(pDocType->strCandidateWordsFile.c_str());
		m_pXMLDoc->load(vt, &bSuccess);

		if(bSuccess) {	// XML t@C͌⃊Xg쐬
			IXMLDOMElement*			pElement = 0;
			IXMLDOMNodeList*		pNodeList = 0;
			IXMLDOMNode*			pNode = 0;
			long					nNodeLength;
			wchar_t					wsz[512];
			TCandidateWord			cw;
			list<TCandidateWord>	li;

			m_pXMLDoc->get_documentElement(&pElement);
			pElement->get_childNodes(&pNodeList);
			pNodeList->get_length(&nNodeLength);
			pElement->Release();

			for(long iNode = 0; iNode < nNodeLength; ++iNode) {
				pNodeList->get_item(iNode, &pNode);
				pNode->QueryInterface(__uuidof(IXMLDOMElement), reinterpret_cast<void**>(&pElement));
				pElement->getAttribute(L"name", &vt);
				cw.strName = vt.bstrVal;
				li.push_back(cw);
				pElement->Release();
			}

			pNodeList->Release();
			pView->SetCandidateWords(li);
		} else {	// ͎s
			IXMLDOMParseError*	pErr = 0;
			wchar_t				wszMessage[512];
			wchar_t				wszPrompt[100];
			long				iLine, iColumn;
			BSTR				bstrReason;

			m_pXMLDoc->get_parseError(&pErr);
			LoadString(115, wszPrompt, 100);
			pErr->get_line(&iLine);
			pErr->get_linepos(&iColumn);
			pErr->get_reason(&bstrReason);
			swprintf(wszMessage, L"\"%s\" : %s\n\nline:\t%d\ncolumn:\t%d\nreason:\t%s",
				pDocType->strCandidateWordsFile.c_str(), wszPrompt, iLine, iColumn, bstrReason);
			m_pMainWindow->MessageBox(wszMessage, IDS_APPNAME, MB_ICONEXCLAMATION);
			::SysFreeString(bstrReason);
			pErr->Release();
		}
	}*/
}

LRESULT CALLBACK CAlphaApp::AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	if(CAlphaApp::m_pInstance)
		return CAlphaApp::m_pInstance->DispatchEvent(hWnd, message, wParam, lParam);
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 *	L[oCh1o^B̂̂͏㏑
 *	@param sVKey		zL[
 *	@param km			CL[
 *	@param nCommandID	蓖ĂR}h ID
 */
void CAlphaApp::BindOneKey(short sVKey, KeyModifier km, int nCommandID) {
	AssertValid();
}

LRESULT	CAlphaApp::DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	POINT	pt;

	switch(message) {
	case WM_ACTIVATE:
		if(!m_vecDocuments.empty() && m_iActiveTab != -1)
			return ::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
		return 0L;
	case WM_ACTIVATEAPP:
		if(toBoolean(wParam) && m_pMainWindow != 0)
			m_pMainWindow->SetFocus();
		return 0L;
	case WM_COMMAND:
		return OnCommand(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
	case WM_CLOSE:
		if(!OnClose())
			return 0;
		break;
	case WM_COPYDATA:
		OnCopyData(reinterpret_cast<HWND>(wParam), reinterpret_cast<PCOPYDATASTRUCT>(lParam));
		break;
	case WM_CREATE:
		break;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_DRAWITEM:
		OnDrawItem(wParam, reinterpret_cast<LPDRAWITEMSTRUCT>(lParam));
		break;
	case WM_DROPFILES:
		OnDropFiles(reinterpret_cast<HDROP>(wParam));
		break;
	case WM_ENTERMENULOOP:
		OnEnterMenuLoop(toBoolean(wParam));
		break;
	case WM_EXITMENULOOP:
		OnExitMenuLoop(toBoolean(wParam));
		break;
//	case WM_KILLFOCUS:
//		// r[ɓ]
//		if(!m_vecDocuments.empty())
//			return ::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
//		return 0L;
	case WM_MEASUREITEM:
		OnMeasureItem(wParam, reinterpret_cast<LPMEASUREITEMSTRUCT>(lParam));
		break;
	case WM_MENUCHAR:
		return m_pMenu->ExecuteMenuChar(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
	case WM_MENUSELECT:
		OnMenuSelect(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
		break;
	case WM_MOUSEMOVE:
		pt.x = LOWORD(lParam);
		pt.y = HIWORD(lParam);
		OnMouseMove(wParam, pt);
		return 0L;
	case WM_NOTIFY:
		OnNotify(wParam, reinterpret_cast<LPNMHDR>(lParam));
		break;
	case WM_SETCURSOR:
		if(OnSetCursor(reinterpret_cast<HWND>(wParam),
				static_cast<UINT>(LOWORD(lParam)), static_cast<UINT>(HIWORD(lParam))))
			return false;
		break;
	case WM_SETFOCUS:
		// m_iActiveView 悤ƂĂr[w\
		if(!m_vecDocuments.empty() && m_iActiveTab != -1
				&& reinterpret_cast<HWND>(wParam) != GetActiveTab()->GetWindow())
			::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
		return 0L;
	case WM_SIZE:
		OnSize(wParam, LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	}
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 *	G[bZ[W\
 *	@param nErrorId	G[ʒlBXgOe[uQ
 *	@param nType	Win32 API MessageBoxW Ɠ
 *	@return			Win32 API MessageBoxW Ɠ
 */
int CAlphaApp::ErrorMessageBox(unsigned int nErrorId, unsigned int nType) {
	AssertValid();

	int	nAnswer;
	wostringstream	ssMessage;

	ssMessage << LoadErrorString(nErrorId).c_str() << L"\n\n(G[ԍ: " << nErrorId << L")";
	if(m_pMainWindow != 0 && m_pMainWindow->IsWindowVisible())
		nAnswer = m_pMainWindow->MessageBox(ssMessage.str().c_str(), IDS_APPNAME, nType);
	else
		nAnswer = ::MessageBoxW(0, ssMessage.str().c_str(), IDS_APPNAME, nType);
	ssMessage.clear();
	ssMessage << L"[Error: " << nErrorId << L"] " << LoadErrorString(nErrorId).c_str();
	m_wndOutput.WriteLine(OTT_GENERAL, ssMessage.str().c_str());

	return nAnswer;
}

/**
 *	݃ANeBuȃhLgւ̃|C^ԂB
 *	hLgeLXgGfB^łȂꍇ null Ԃ
 *	@see	GetActiveTab, GetActiveTabIndex
 */
CAlphaDoc* CAlphaApp::GetActiveDocument() const {
	AssertValid();
	return m_vecDocuments[m_iActiveTab]->IsTextEditor() ?
		static_cast<CAlphaEditController*>(m_vecDocuments[m_iActiveTab])->GetDocument() : 0;
}

/**
 *	݃ANeBuȃ^uւ̃|C^Ԃ
 *	@see	GetActiveDocument, GetActiveTabIndex
 */
IAlphaTab* CAlphaApp::GetActiveTab() const {
	AssertValid();
	return m_vecDocuments[m_iActiveTab];
}

///	݃ANeBuȃr[̃CfbNXԂ
unsigned int CAlphaApp::GetActiveTabIndex() const {
	AssertValid();
	return m_iActiveTab;
}

///	ANeBuȃeLXgGfB^Rg[ԂBANeBuȃ^ueLXgGfB^łȂꍇ null Ԃ
CAlphaEditController* CAlphaApp::GetActiveTextEditor() const {
	AssertValid();
	IAlphaTab*	pActiveTab = GetActiveTab();
	return pActiveTab->IsTextEditor() ? static_cast<CAlphaEditController*>(pActiveTab) : 0;
}

///	I[g[VpC^[tFCXIuWFNgԂ
void CAlphaApp::GetAutomation(IApplication** ppApplication) {
	AssertValid();
	assert(ppApplication != 0);

	if(m_pApplication == 0) {
		m_pApplication = new Alpha::Ambient::CApplication(this);
		m_pApplication->AddRef();
	}
	*ppApplication = m_pApplication;
	(*ppApplication)->AddRef();
}

///	I[g[VpC^[tFCXIuWFNgԂ
void CAlphaApp::GetAutomationDocuments(IDocuments** ppDocuments) {
	AssertValid();
	assert(ppDocuments != 0);

	if(m_pDocuments == 0) {
		m_pDocuments = new Alpha::Ambient::CDocuments(this);
		m_pDocuments->AddRef();
	}
	*ppDocuments = m_pDocuments;
	(*ppDocuments)->AddRef();
}

/**
 *	t@C (̊gq) hLg^Cv擾
 *	@param strFileName	Ώۃt@C
 *	@return				hLg^CṽCfbNX
 */
unsigned int CAlphaApp::GetDocumentTypeFromFileName(const wstring& strFileName) const {
	AssertValid();

	wchar_t*	pwszExt = 0;
	size_t		iExt = strFileName.rfind(L'.');

	if(iExt == wstring::npos)	// gq
		return 0;

	pwszExt = new wchar_t[strFileName.length() - iExt];
	wcscpy(pwszExt, strFileName.c_str() + iExt + 1);
	wcslwr(pwszExt);

	for(unsigned int i = 1; i < m_vecDocumentTypes.size(); ++i) {	// T
		if(m_vecDocumentTypes[i].listExtensions.end() != std::find(
				m_vecDocumentTypes[i].listExtensions.begin(),
				m_vecDocumentTypes[i].listExtensions.end(), pwszExt)) {
			delete[] pwszExt;
			return i;
		}
	}

	delete[] pwszExt;
	return 0;
}

///	@see	CWinApp::GetModelessDialogList
void CAlphaApp::GetModelessDialogList(list<HWND>& listDlgs) const {
	listDlgs.clear();

	// [hX_CAO炱ɒǉ
	listDlgs.push_back(m_dlgFind.m_hWnd);
	listDlgs.push_back(m_pdlgBookmark->m_hWnd);
	listDlgs.push_back(m_pdlgGotoLine->m_hWnd);
	listDlgs.push_back(m_pdlgDebugCallStack->m_hWnd);
	listDlgs.push_back(m_pdlgDebugImmediate->m_hWnd);
	listDlgs.push_back(m_pdlgDebugRunningDocuments->m_hWnd);
	listDlgs.push_back(m_pdlgDebugThreads->m_hWnd);
	listDlgs.push_back(m_pdlgDebugVariables->m_hWnd);
}

/**
 *	^u擾
 *	@param iTab	^uԍ
 *	@return		^u
 *	@throw		<var>iTab</var> ȂƂX[
 */
IAlphaTab* CAlphaApp::GetTab(unsigned int iTab) const throw(out_of_range) {
	AssertValid();

	try {
		return m_vecDocuments.at(iTab);
	} catch(out_of_range& /* e */) {
		throw out_of_range("First argument is invalid as tab index.");
	}
}

///	JĂhLg̐Ԃ
unsigned int CAlphaApp::GetTabCount() const {
	AssertValid();
	return m_vecDocuments.size();
}

/**
 *	eLXgGfB^Rg[擾BeLXgGfB^łȂꍇ null Ԃ
 *	@param iTab	^uԍ
 *	@return		Rg[
 *	@throw		<var>iTab</var> ȂƂX[
 */
CAlphaEditController* CAlphaApp::GetTextEditor(unsigned int iTab) const throw(out_of_range) {
	AssertValid();

	try {
		IAlphaTab*	pTab = m_vecDocuments.at(iTab);
		return pTab->IsTextEditor() ? static_cast<CAlphaEditController*>(pTab) : 0;
	} catch(out_of_range& /* e */) {
		throw out_of_range("First argument is invalid as tab index.");
	}
}

/**
 *	t@CĴɎsƂ̏
 *	@param ss	G[e
 *	@return		ʓIɃG[łꍇ (CAlphaApp::OpenFile ̖߂lƓ)
 */
bool CAlphaApp::HandleFileOpenError(Ascension::StreamStatus ss) {
	AssertValid();

	CAlphaDoc*	pActiveDoc = GetActiveDocument();
	assert(pActiveDoc != 0);

	if(ss == SS_OK) {
		ModifyTabIcons();
		m_pMRUManager->Add(pActiveDoc->GetPathName());
		return true;
	} else if(ss == SS_READ_READONLY) {
		wstring	strPathName = pActiveDoc->GetPathName();
		wstring	strErrorMessage = strPathName + LoadErrorString(109);
		m_pMainWindow->MessageBox(strErrorMessage.c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
		ModifyTabIcons();
		m_pMRUManager->Add(strPathName);
		return true;
	} else if(ss == SS_READ_UNKNOWNCHARCODE) {
		wstring	strErrorMessage = pActiveDoc->GetPathName() + LoadErrorString(110);
		m_pMainWindow->MessageBox(strErrorMessage.c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
		ModifyTabIcons();
		return true;
	} else if(ss == SS_READ_ILLEGALCHAR) {
		wstring	strErrorMessage = pActiveDoc->GetPathName() + LoadErrorString(111);
		m_pMainWindow->MessageBox(strErrorMessage.c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
		ModifyTabIcons();
		return true;
	} else {
		wstring	strErrorMessage;
		switch(ss) {
		strErrorMessage = pActiveDoc->GetPathName();
		case SS_ACCESSDENIED:
			strErrorMessage += LoadErrorString(106);	break;
		case SS_ILLEGALCODEPAGE:
			strErrorMessage += LoadErrorString(107);	break;
		case SS_UNKNOWNERROR:
			strErrorMessage += LoadErrorString(108);	break;
		case SS_READ_HUGEFILE:
			strErrorMessage += LoadErrorString(112);	break;
		case SS_READ_NOEXISTS:
			strErrorMessage += LoadErrorString(113);	break;
		case SS_READ_CANNOTRESOLVELINK:
			strErrorMessage += LoadErrorString(119);	break;
		}
		m_pMainWindow->MessageBox(strErrorMessage.c_str(), IDS_APPNAME, MB_ICONHAND);
		OnFileClose(false);
		return false;
	}
}

///	@see	CWinApp::InitApplication
bool CAlphaApp::InitApplication(HINSTANCE hInstance) {
	AssertValid();

	WNDCLASSEX wcProg;

	wcProg.cbSize			= sizeof(WNDCLASSEX);
	wcProg.style			= CS_HREDRAW | CS_VREDRAW;
	wcProg.lpfnWndProc		= reinterpret_cast<WNDPROC>(CAlphaApp::AppWndProc);
	wcProg.cbClsExtra		= 0;
	wcProg.cbWndExtra		= 0;
	wcProg.hInstance		= hInstance;
	wcProg.hIcon			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	wcProg.hIconSm			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	wcProg.hCursor			= ::LoadCursor(0, IDC_ARROW);
	wcProg.hbrBackground	= ::GetSysColorBrush(COLOR_BTNFACE);
	wcProg.lpszClassName	= L"Alpha";
	wcProg.lpszMenuName		= MAKEINTRESOURCE(IDR_MENU);

	return toBoolean(::RegisterClassEx(&wcProg));
}

/**
 *	CX^X̏
 *	@see	CWinApp::InitInstance
 */
bool CAlphaApp::InitInstance() {
	AssertValid();

	static CWindow	wndApp;
	RECT			rect;

	wndApp.Create(false, L"Alpha", L"", /*WS_VISIBLE |*/ WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		reinterpret_cast<HWND>(::GetModuleHandle(0)), 0, 0);

	if(!wndApp.IsWindow())
		return false;
	m_pMainWindow = &wndApp;

	// m_hCommandImageList  m_hDisabledCommandImageList ̊ (̃rbg}bvɂĊi[)
	HDC		hBaseBmpDC = ::CreateCompatibleDC(0);
	HBITMAP	hBaseBMP = LoadBitmap(IDB_BMP_COMMANDS);
	HBITMAP	hOldBaseBMP = reinterpret_cast<HBITMAP>(::SelectObject(hBaseBmpDC, hBaseBMP));
	HDC		hCompletedBmpDC = ::CreateCompatibleDC(hBaseBmpDC);
	HBITMAP	hCompletedBMP = ::CreateCompatibleBitmap(hBaseBmpDC, 16 * IDN_TOOLIMAGECOUNT, 16);
	HBITMAP	hOldCompletedBMP = reinterpret_cast<HBITMAP>(::SelectObject(hCompletedBmpDC, hCompletedBMP));
	for(int i = 0; i < IDN_TOOLIMAGECOUNT / 32; i++)
		::BitBlt(hCompletedBmpDC, 16 * 32 * i, 0, 16 * 32, 16, hBaseBmpDC, 0, 16 * i, SRCCOPY);
	::SelectObject(hBaseBmpDC, hOldBaseBMP);
	::SelectObject(hCompletedBmpDC, hOldCompletedBMP);
	m_hCommandImageList = ::ImageList_Create(16, 16, ILC_COLOR24 | ILC_MASK, IDN_TOOLIMAGECOUNT, 0);
	::ImageList_AddMasked(m_hCommandImageList, hCompletedBMP, 0x00C0C0C0);

	::DeleteObject(hBaseBMP);
	hBaseBMP = LoadBitmap(IDB_BMP_DCOMMANDS);
	::SelectObject(hBaseBmpDC, hBaseBMP);
	::SelectObject(hCompletedBmpDC, hCompletedBMP);
	for(int i = 0; i < IDN_TOOLIMAGECOUNT / 32; i++)
		::BitBlt(hCompletedBmpDC, 16 * 32 * i, 0, 16 * 32, 16, hBaseBmpDC, 0, 16 * i, SRCCOPY);
	::SelectObject(hBaseBmpDC, hOldBaseBMP);
	::SelectObject(hCompletedBmpDC, hOldCompletedBMP);
	m_hDisabledCommandImageList = ::ImageList_Create(16, 16, ILC_COLOR24 | ILC_MASK, IDN_TOOLIMAGECOUNT, 0);
	::ImageList_AddMasked(m_hDisabledCommandImageList, hCompletedBMP, 0x00C0C0C0);

	// ʐݒ̓ǂݍ
	LoadINISettings();

	::DeleteObject(hBaseBMP);
	::DeleteObject(hCompletedBMP);
	::DeleteDC(hBaseBmpDC);
	::DeleteDC(hCompletedBmpDC);

	// MRU Xg̍쐬
	m_pMRUManager = new CMRUManager(GetProfileInt(L"File", L"nMRULimit", 8), IDCM_FILE_MRULISTSTART, true);
	unsigned int	iMRU = 0;
	wchar_t			szKeyName[12];
	wstring			strFilePath;
	stack<wstring>	stkNames;
	while(true) {
		swprintf(szKeyName, L"strPath(%u)", iMRU);
		strFilePath = GetProfileString(L"MRU", szKeyName, L"");
		if(strFilePath.empty())
			break;
		stkNames.push(strFilePath);
		++iMRU;
	}
	while(!stkNames.empty()) {
		m_pMRUManager->Add(stkNames.top());
		stkNames.pop();
	}

	// vOC̃[h
	OnEditReloadPlugin();

	// R}hn̏
	SetupKeyBinds(GetProfileString(L"KeyboardMap", L"strSchemeName", L"default"));
	SetupMenus();
	SetupTextFoundations();

	// Zp[^̍쐬
	m_hwndSeparator = ::CreateWindow(L"STATIC", L"",
		WS_CHILD | WS_VISIBLE | SS_SUNKEN, 0, 0, 0, 0, wndApp, 0, m_hInstance, 0L);

	// o[̍쐬
	REBARINFO				rbi = {sizeof(REBARINFO), 0, 0};
	INITCOMMONCONTROLSEX	icex = {sizeof(INITCOMMONCONTROLSEX), ICC_COOL_CLASSES};
	::InitCommonControlsEx(&icex);
	m_hRebar = ::CreateWindowEx(WS_EX_TOOLWINDOW, REBARCLASSNAME, 0,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN
		| RBS_BANDBORDERS | RBS_VARHEIGHT | CCS_NODIVIDER,
		0, 0, 0, 0, wndApp, 0, m_hInstance, 0L);
	::SendMessage(m_hRebar, RB_SETBARINFO, 0, reinterpret_cast<LPARAM>(&rbi));

	// c[o[̍쐬
	SetupToolbar();

	// Xe[^Xo[̍쐬
	m_hStatusBar = ::CreateStatusWindow(
		WS_CHILD | WS_VISIBLE | CCS_BOTTOM | CCS_NODIVIDER | SBARS_SIZEGRIP | SBT_TOOLTIPS,
		L"", m_pMainWindow->m_hWnd, IDC_STATUSBAR);
//	::SendMessage(m_hStatusBar, SB_SETMINHEIGHT, 10, 0L);

	// ^u̍쐬
	SIZE	sizePad = {3, 3};
	m_hTabFont = ::CreateFont(11, 0, 0, 0, FW_NORMAL, false, false, false,
		SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		VARIABLE_PITCH | FF_SWISS, L"MS UI Gothic");
	::SetRect(&rect, 0, 2, 600, 400);
	m_wndTab.Create(m_pMainWindow->m_hWnd, rect, IDC_TAB_VIEWS);
	m_wndTab.SetFont(m_hTabFont, false);
	::SendMessage(m_hStatusBar, WM_SETFONT, reinterpret_cast<WPARAM>(m_hTabFont), 0L);

	// AEgvbgEBhE̍쐬
	m_wndOutput.Create(m_pMainWindow);
	m_wndOutput.WriteLine(OTT_GENERAL, IDS_APPFULLVERSION);

	// XML t@C͂̏
/*	HRESULT hr = ::CoCreateInstance(__uuidof(DOMDocument), 0,
		CLSCTX_ALL, __uuidof(IXMLDOMDocument), reinterpret_cast<void**>(&m_pXMLDoc));
	if(SUCCEEDED(hr)) {
		m_pXMLDoc->put_async(VARIANT_FALSE);
		m_pXMLDoc->put_validateOnParse(VARIANT_TRUE);
	}
*/
	// c[_CAO̍쐬
	m_pdlgGotoLine->Create(m_hInstance, IDD_DLG_GOTOLINE, m_pMainWindow->m_hWnd);
	m_pdlgBookmark->Create(m_hInstance, IDD_DLG_BOOKMARKS, m_pMainWindow->m_hWnd);
	m_pdlgDebugBreakPoints->Create(m_hInstance, IDD_DLG_DEBUGBREAKPOINTS, m_pMainWindow->m_hWnd);
	m_pdlgDebugCallStack->Create(m_hInstance, IDD_DLG_DEBUGCALLSTACK, m_pMainWindow->m_hWnd);
	m_pdlgDebugImmediate->Create(m_hInstance, IDD_DLG_DEBUGIMMEDIATE, m_pMainWindow->m_hWnd);
	m_pdlgDebugRunningDocuments->Create(m_hInstance, IDD_DLG_DEBUGACTIVEDOCUMENTS, m_pMainWindow->m_hWnd);
	m_pdlgDebugThreads->Create(m_hInstance, IDD_DLG_DEBUGTHREADS, m_pMainWindow->m_hWnd);
	m_pdlgDebugVariables->Create(m_hInstance, IDD_DLG_DEBUGVARIABLES, m_pMainWindow->m_hWnd);

	// ]EBhE̍쐬
	m_oToolTip.Create(m_pMainWindow->m_hWnd, m_hInstance, WS_POPUP | TTS_NOPREFIX);
//	m_oToolTip.SetDelayTime(TTDT_AUTOPOP, 0xFFFFFFFF);
	m_oToolTip.Activate(true);

	// ̑̏
	wndApp.DragAcceptFiles(true);
	wndApp.SetTimer(ID_TIMER_QUERYCOMMAND, 200, 0);

	// ̃r[̍쐬
	OnFileNew(::GetACP());

	wndApp.SetWindowPos(0, 0, 0, 760, 560, SWP_NOMOVE | SWP_NOZORDER);
	wndApp.CenterWindow();
	wndApp.ShowWindow(SW_SHOW);

	// R}hC^ꂽt@CJ
	vector<wstring>	vecArguments;
	GetCommandLineArguments(vecArguments);
	ParseCommandLine(vecArguments);

	return true;
}

/**
 *	G[bZ[WԂ
 *	@param nErrorId	G[ʒlBXgOe[uQ
 *	@return			G[bZ[WBȂƂ͋󕶎
 */
wstring CAlphaApp::LoadErrorString(unsigned int nErrorId) const {
	AssertValid();

	wchar_t	wszString[1024];

	if(LoadString(nErrorId, wszString, 1024) == 0)
		return L"";
	return wstring(wszString);
}

///	INI t@Cݒǂݍ
void CAlphaApp::LoadINISettings() {
	AssertValid();

	// INI t@C΍
	if(!toBoolean(::PathFileExistsW(m_szINIPath))) {
		char	szINIPath[MAX_PATH];
		::WideCharToMultiByte(CP_ACP, 0, m_szINIPath, -1, szINIPath, MAX_PATH, 0, 0);
		ofstream	oFile(szINIPath);
		oFile << "[DocumentTypes(0)]\r\n"
				<< "strName=ݒ薳\r\nnLeftTabType=2\r\n\r\n"
				<< "[FoundationStyle(0)]\r\nstrName=W\r\n"
				<< "oTextFoundation(3).fgColor=10070188\r\n"
				<< "oTextFoundation(3).bgColor=14215660\r\n"
				<< "oTextFoundation(4).fgColor=10027008\r\n"
				<< "oTextFoundation(4).bgColor=15790320\r\n"
				<< "oTextFoundation(5).fgColor=10027008\r\n"
				<< "oTextFoundation(5).bgColor=15790320\r\n"
				<< "oTextFoundation(6).fgColor=10027008\r\n"
				<< "oTextFoundation(6).bgColor=14737632\r\n"
				<< "oTextFoundation(6).bold=1\r\n"
				<< "oTextFoundation(7).fgColor=13421721\r\n"
				<< "oTextFoundation(8).fgColor=13408665\r\n"
				<< "oTextFoundation(9).fgColor=153\r\n"
				<< "oTextFoundation(10).fgColor=6684672\r\n"
				<< "oTextFoundation(11).fgColor=6684672\r\n"
				<< "oTextFoundation(12).fgColor=16711680\r\n"
				<< "oTextFoundation(13).fgColor=153\r\n"
				<< "oTextFoundation(14).fgColor=34816\r\n"
				<< "oTextFoundation(17).fgColor=10053120\r\n"
				<< "oTextFoundation(17).bgColor=16764057\r\n\r\n";
		oFile.close();
	}

	m_bCancelSelAfterCopy = toBoolean(GetProfileInt(L"Edit", L"nCancelSelectionAfterCopy", 0));
	if(!GetProfileStruct(L"View", L"oFont.pLogfont", &m_lfCommonFont, sizeof(LOGFONTW))) {
		ZeroMemory(&m_lfCommonFont, sizeof(LOGFONTW));
		m_lfCommonFont.lfCharSet = ANSI_CHARSET;
		m_lfCommonFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
		m_lfCommonFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		m_lfCommonFont.lfQuality = DEFAULT_QUALITY;
		m_lfCommonFont.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
		wcscpy(m_lfCommonFont.lfFaceName, L"FixedSys");
	}
	m_nLeftMargin = GetProfileInt(L"View", L"nLeftMargin", 5);
	m_nTopMargin = GetProfileInt(L"View", L"nTopMargin", 1);
	m_nOutputWndHeight = 0;//GetProfileInt(L"View", L"nOutputWindowHeight", 98);

	wchar_t			wszKeyName[30];
	wstring			strLanguageName;
	wchar_t*		pwszExtensions = 0;
	set<wstring>	setExtensions;
	for(unsigned short i = 0; ; ++i) {
		swprintf(wszKeyName, L"strLanguageName(%u)", i);
		strLanguageName = wstring(GetProfileString(L"Script", wszKeyName, L""));
		if(strLanguageName.empty())
			break;
		swprintf(wszKeyName, L"strExtensions(%u)", i);
		CAlphaApp::GetProfileSet(L"Script", wszKeyName, setExtensions, L"");
		m_oScriptLanguages.Add(strLanguageName, setExtensions);
	}

	// ̗
	wstring	strValue;
	list<wstring>	listFindWhats, listReplacesWiths;
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listFindWhats.push_back(strValue);
	}
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listReplacesWiths.push_back(strValue);
	}
	m_dlgFind.ClearHistory(false);
	m_dlgFind.ClearHistory(true);
	m_dlgFind.SetHistory(listFindWhats, listReplacesWiths);

	m_bShowMessageBoxOnFind = toBoolean(GetProfileInt(L"Find", L"bShowMessageBox", 1));
	m_bInitializeFindTextFromEditor = toBoolean(GetProfileInt(L"Find", L"bInitializeFromEditor", 1));
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param dwID		bZ[Wʎq
 *	@param nType	_CAÕ^Cv (::MessageBox Ɠ)
 *	@return			[U̕ԓ (::MessageBox Ɠ)
 */
int CAlphaApp::MessageBox(DWORD dwID, UINT nType) {
	AssertValid();
	assert(m_pMainWindow != 0);
	return m_pMainWindow->MessageBox(LoadMessage(dwID).c_str(), IDS_APPNAME, nType);
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param dwID		bZ[Wʎq
 *	@param nType	_CAÕ^Cv (::MessageBox Ɠ)
 *	@param args		bZ[Ẅ
 *	@return			[U̕ԓ (::MessageBox Ɠ)
 */
int CAlphaApp::MessageBox(DWORD dwID, UINT nType, const CMessageArguments& args) {
	AssertValid();
	assert(m_pMainWindow != 0);
	return m_pMainWindow->MessageBox(LoadMessage(dwID, args).c_str(), IDS_APPNAME, nType);
}

///	^ũACRXV
void CAlphaApp::ModifyTabIcons() {
	SHFILEINFO	sfi;
	TCITEMW		item;

	m_oTabIconsImageList.DeleteImageList();
	m_oTabIconsImageList.Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, m_vecDocuments.size());
	item.mask = TCIF_IMAGE;

	wstring	strPath;
	for(item.iImage = 0; item.iImage < static_cast<int>(m_vecDocuments.size()); ++item.iImage) {
		strPath = GetTab(item.iImage)->IsTextEditor() ?
			GetTextEditor(item.iImage)->GetDocument()->GetPathName() : L"";
		::SHGetFileInfo(strPath.c_str(), 0, &sfi, sizeof(SHFILEINFO), SHGFI_ICON | SHGFI_SMALLICON);
		m_oTabIconsImageList.Add(sfi.hIcon);
		m_wndTab.SetItem(item.iImage, &item);
	}
	m_wndTab.SetImageList(&m_oTabIconsImageList);
}

///	[t@CJ] _CAÕtbNvVW
UINT CALLBACK CAlphaApp::OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	static HWND					hCharCodeCombo, hCharCodeStatic;
	static HWND					hBreakCodeCombo, hBreakCodeStatic;
	unsigned int				iCharCode;
	int							iBreakCode;
	UINT						cCharCode;
	list<UINT>					listCodePages;
	list<UINT>::const_iterator	it;
	const wchar_t*				pwszCPName;
	LPNMHDR						lpNMHDR = 0;
	LPOFNOTIFYW					lpOFNOIFY = 0;
	LPOPENFILENAMEW				lpOFN = 0;

	switch(message) {
	case WM_INITDIALOG:
		lpOFN = reinterpret_cast<LPOPENFILENAMEW>(lParam);
		hCharCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_CHARCODE);
		hCharCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_1);
		hBreakCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE);
		hBreakCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_2);
		CCodePageManager::EnumAvailableCodePages(listCodePages);
		::SendMessage(hCharCodeCombo, CB_ADDSTRING,
			0, reinterpret_cast<LPARAM>(::IsWindow(hBreakCodeCombo) ? L"<ϊ>" : L"<>"));
		::SendMessage(hCharCodeCombo, CB_SETITEMDATA, 0, static_cast<LPARAM>(EXTCP_AUTO));
		for(it = listCodePages.begin(); it != listCodePages.end(); ++it) {
			pwszCPName = CCodePageManager::GetCodePageName(*it);
			if(wcslen(pwszCPName) == 0)
				continue;
			iCharCode = ::SendMessage(hCharCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszCPName));
			::SendMessage(hCharCodeCombo, CB_SETITEMDATA, iCharCode, *it);
		}
		cCharCode = ::SendMessage(hCharCodeCombo, CB_GETCOUNT, 0, 0L);
		::SendMessage(hCharCodeCombo, CB_SETCURSEL, 0, 0L);
		for(iCharCode = 0; iCharCode < cCharCode; ++iCharCode) {
			if(LOWORD(lpOFN->lCustData) == ::SendMessage(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L)) {
				::SendMessage(hCharCodeCombo, CB_SETCURSEL, iCharCode, 0L);
				break;
			}
		}
		if(::IsWindow(hBreakCodeCombo)) {
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ꂵȂ"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CR+LF (Windows)"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"LF (Unix)"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"CR (Macintosh)"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"NEL (U+0085)"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"LS (U+2028)"));
			::SendMessage(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"PS (U+2029)"));
			switch(HIWORD(lpOFN->lCustData)) {
			case BT_AUTO:	::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 0, 0L);	break;
			case BT_CRLF:	::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 1, 0L);	break;
			case BT_LF:		::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 2, 0L);	break;
			case BT_CR:		::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 3, 0L);	break;
			case BT_NEL:	::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 4, 0L);	break;
			case BT_LS:		::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 5, 0L);	break;
			case BT_PS:		::SendMessage(hBreakCodeCombo, CB_SETCURSEL, 6, 0L);	break;
			}
		}
		break;
	case WM_NOTIFY:
		lpNMHDR = reinterpret_cast<LPNMHDR>(lParam);
		if(lpNMHDR->code == CDN_FILEOK) {
			lpOFNOIFY = reinterpret_cast<LPOFNOTIFYW>(lParam);
			iCharCode = ::SendMessage(hCharCodeCombo, CB_GETCURSEL, 0, 0L);
			lpOFNOIFY->lpOFN->lCustData = ::SendMessage(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L);
			if(::IsWindow(hBreakCodeCombo)) {
				iBreakCode = ::SendMessage(hBreakCodeCombo, CB_GETCURSEL, 0, 0L);
				switch(iBreakCode) {
				case 0:	lpOFNOIFY->lpOFN->lCustData |= BT_AUTO << 16;	break;
				case 1:	lpOFNOIFY->lpOFN->lCustData |= BT_CRLF << 16;	break;
				case 2:	lpOFNOIFY->lpOFN->lCustData |= BT_LF << 16;		break;
				case 3:	lpOFNOIFY->lpOFN->lCustData |= BT_CR << 16;		break;
				case 4:	lpOFNOIFY->lpOFN->lCustData |= BT_NEL << 16;	break;
				case 5:	lpOFNOIFY->lpOFN->lCustData |= BT_LS << 16;		break;
				case 6:	lpOFNOIFY->lpOFN->lCustData |= BT_PS << 16;		break;
				}
			}
		}
		break;
	case WM_SIZE:
		// Rg[̈ʒuTCYς...
		break;
	}

	return 0L;
}

/**
 *	t@CeLXgGfB^ŐVr[ɊJÃr[ANeBuɂB
 *	܂AgqɉăhLg^CvKpB̃\bh̓t@CI[v
 *	ʂ_CAO\
 *	@param strPathName	t@C̃pX
 *	@param nCodePage	t@C̃R[hy[WBȗƎ
 *	@param iDocType		KphLg^Cv̔ԍBȗ葶݂Ȃl̏ꍇ͊gq画ʁB
 *	@return				t@CJƂł true
 */
bool CAlphaApp::OpenFile(const wstring& strPathName,
		UINT nCodePage /* = EXTCP_AUTO */, unsigned int iDocType /* = -1 */) {
	AssertValid();

	CAlphaDoc*				pActiveDoc = 0;
	StreamStatus			ss;
	wstring					strErrorMessage;
	Ascension::FileOpenMode	fom;

	// (eLXgGfB^) łɊJĂ邩ׂ
	for(unsigned long iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
		IAlphaTab*	pTab = GetTab(iTab);
		if(pTab->IsTextEditor()
				&& static_cast<CAlphaEditController*>(pTab)->GetDocument()->GetPathName() == strPathName) {
			SetActiveTab(iTab);
			return true;
		}
	}

	// bN
	switch(GetProfileInt(L"File", L"nShareMode", 0)) {
	case 0:	fom = Ascension::FOM_DENYNONE;	break;
	case 1:	fom = Ascension::FOM_DENYWRITE;	break;
	case 2:	fom = Ascension::FOM_DENYREAD;	break;
	}

	pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return false;
	if(pActiveDoc->IsModified()
			|| !pActiveDoc->GetPathName().empty())	// V^uŊJ
		OnFileNew(nCodePage);
	else if(pActiveDoc->GetController()->IsSplit())	// ̃^ugꍇ͑I
		pActiveDoc->GetController()->SplitView(0);

	pActiveDoc = GetActiveDocument();
	assert(pActiveDoc != 0);
	if(nCodePage != EXTCP_AUTO) {
		try {
			pActiveDoc->SetCodePage(nCodePage);
		} catch(invalid_argument& /* e */) {
			if(IDNO == ErrorMessageBox(118, MB_YESNO | MB_ICONEXCLAMATION))
				return false;
			nCodePage = ::GetACP();
			pActiveDoc->SetCodePage(nCodePage);
		}
	}
	m_pMainWindow->LockWindowUpdate();

	// hLg^Cv̓Kp
	ApplyDocumentType(m_iActiveTab,
		(iDocType < m_vecDocumentTypes.size()) ? iDocType : GetDocumentTypeFromFileName(strPathName));

	// ł̂Ńt@CJ
	ss = pActiveDoc->LoadDocument(strPathName, fom, nCodePage);
	m_pMainWindow->UnlockWindowUpdate();
	m_pMainWindow->ShowWindow(m_pMainWindow->IsWindowVisible() ? SW_SHOW : SW_RESTORE);
	return HandleFileOpenError(ss);
}

/**
 *	R}hC͂ĎsBȈ͖
 *	@param vecArgs	eR}hCIvVBCWinApp::GetCommandLineArguments ̏o͂g
 *	@see			CWinApp::GetCommandLineArguments
 */
void CAlphaApp::ParseCommandLine(const vector<wstring>& vecArgs) {
	AssertValid();

	list<wstring>	listPaths;	// t@CpX̃Xg
	UINT			nCodePage = EXTCP_AUTO;
	UINT			iDocType = -1;
	unsigned long	iLine = 0;
	unsigned long	iChar = 0;
	bool			bReadOnly = false;

	for(vector<wstring>::size_type i = 0; i < vecArgs.size(); ++i) {
		const wstring& strArgument = vecArgs[i];
		if(strArgument.empty())
			continue;
		if(strArgument[0] == L'-') {	// IvV
			if(strArgument == L"-r")
				bReadOnly = true;
			else if(strArgument.substr(1, 2) == L"c:")
				nCodePage = wcstoul(strArgument.substr(3).c_str(), 0, 0);
			else if(strArgument.substr(1, 5) == L"type:")
				iDocType = wcstoul(strArgument.substr(6).c_str(), 0, 0);
			else if(strArgument.substr(1, 5) == L"line:")
				iLine = wcstoul(strArgument.substr(6).c_str(), 0, 0);
			else if(strArgument.substr(1, 5) == L"char:")
				iChar = wcstoul(strArgument.substr(6).c_str(), 0, 0);
		} else	// t@CpX
			listPaths.push_back(strArgument);
	}

	// ԂɃt@CJ
	for(list<wstring>::const_iterator it = listPaths.begin(); it != listPaths.end(); ++it) {
		if(OpenFile(*it, nCodePage, iDocType))
			if(iLine != 0 || iChar != 0)
				GetActiveTextEditor()->GetActiveView()->SetSelWithoutSelection(iLine, iChar);
	}
}

/**
 *	w肵r[\AtH[JX킹BɃANeBułΉȂ
 *	@param iView	ANeBuɂr[̃CfbNX
 */
void CAlphaApp::SetActiveTab(unsigned int iView) throw(out_of_range) {
	AssertValid();
	if(iView >= m_vecDocuments.size())
		throw out_of_range("Specified tab is not found!");
	if(iView == m_iActiveTab)
		return;

	RECT	rect;

	if(m_vecDocuments.size() > 1 && m_vecDocuments.size() > m_iActiveTab)	// ANeBur[\ɂ
		m_vecDocuments[m_iActiveTab]->OnActivate(false);
	m_vecDocuments[iView]->OnActivate(true);
	m_iLastActiveTab = m_iActiveTab;
	m_iActiveTab = iView;
	m_wndTab.SetCurSel(m_iActiveTab);
	UpdateTitleBar();
	m_pMainWindow->GetClientRect(&rect);
	OnSize(SIZE_RESTORED, rect.right - rect.left, rect.bottom - rect.top);
	::SetFocus(GetActiveTab()->GetWindow());
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();
}

/**
 *	L[ () 蓖
 *	@param strSchemeName	gpL[{[h}bvXL[̖O
 */
void CAlphaApp::SetupKeyBinds(const wstring& strSchemeName) {
	AssertValid();

/*	wchar_t							wszVKey[4];

	// INI t@Cݒǂݍ
	for(short i = 0; i < 0x0100; ++i) {
		swprintf(wszVKey, L"%d", i);
		wistringstream	is(GetProfileString(L"KeyBind", wszVKey, L"0 0 0 0 0 0 0 0"));
		for(short j = 0; j < 8; ++j) {
			unsigned int	nCommandID;
			is >> nCommandID;
			if(nCommandID != 0)
				m_oKeyboardMap.SetOneCommand(i, static_cast<KeyModifier>(j), nCommandID);
		}
	}
*/
	wchar_t	wszPathName[MAX_PATH];
	::GetModuleFileNameW(0, wszPathName, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPathName), L"keyboardMap\\");
	wcscat(wszPathName, strSchemeName.c_str());
	wcscat(wszPathName, L".akm");
	m_oKeyboardMap.Load(wszPathName);
//	m_oKeyboardMap.Save(wszPathName);

/*	if(!m_oKeyboardMap.Load(wszPathName)) {
		// t@C̏ɎsA̐ݒg
	}*/

	// ANZ[^e[u̍č\z
	::DestroyAcceleratorTable(m_hAcceleratorTable);
	m_hAcceleratorTable = m_oKeyboardMap.CreateAcceleratorTable();
}

///	j[̏
void CAlphaApp::SetupMenus() {
	AssertValid();

	if(m_pMenu != 0)
		delete m_pMenu;

	m_pNewDocTypeMenu = new CPopupMenu();
	m_pMenu = new CMenuOperator(m_pMainWindow->m_hWnd);

	// [t@C]
	CPopupMenu* pFileMenu = m_pMenu->AppendMenuItem(0, MF_POPUP, LoadMessage(MSG_MENU_FILETOP).c_str());
	pFileMenu->AppendMenuItem(IDCM_FILE_NEW, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_NEW));
	pFileMenu->AppendMenuItem(IDCM_FILE_NEWWITHFORMAT, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_NEWWITHFORMAT));
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_OPEN, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_OPEN));
	pFileMenu->AppendMenuItem(IDCM_FILE_REOPEN, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_REOPEN));
	pFileMenu->AppendMenuItem(IDCM_FILE_REOPENWITHCODEPAGE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_REOPENWITHCODEPAGE));
	pFileMenu->AppendMenuItem(0, MF_OWNERDRAW, LoadMessage(MSG_MENU_FILEMRU).c_str());
	pFileMenu->AppendChildPopup(m_pMRUManager->GetPopupMenu(), 6);
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_CLOSE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_CLOSE));
	pFileMenu->AppendMenuItem(IDCM_FILE_CLOSEALL, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_CLOSEALL));
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_SAVE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_SAVE));
	pFileMenu->AppendMenuItem(IDCM_FILE_SAVEAS, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_SAVEAS));
	pFileMenu->AppendMenuItem(IDCM_FILE_SAVEALL, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_SAVEALL));
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_PROPERTY, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_PROPERTY));
	m_pFileOpeMenu = pFileMenu->AppendMenuItem(16, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_FILEOPE).c_str());
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_SENDMAIL, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_SENDMAIL));
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFileMenu->AppendMenuItem(IDCM_FILE_EXIT, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_EXIT));

	// [t@C]-[t@C]
	m_pFileOpeMenu->AppendMenuItem(IDCM_FILE_RENAME, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_RENAME));
	m_pFileOpeMenu->AppendMenuItem(IDCM_FILE_COPY, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_COPY));
	m_pFileOpeMenu->AppendMenuItem(IDCM_FILE_MOVE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_MOVE));
	m_pFileOpeMenu->AppendMenuItem(IDCM_FILE_DELETE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_DELETE));

	// [ҏW]
	CPopupMenu* pEditMenu = m_pMenu->AppendMenuItem(1, MF_POPUP, LoadMessage(MSG_MENU_EDITTOP).c_str());
	pEditMenu->AppendMenuItem(IDCM_EDIT_UNDO, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_UNDO));
	pEditMenu->AppendMenuItem(IDCM_EDIT_REDO, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_REDO));
	pEditMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pEditMenu->AppendMenuItem(IDCM_EDIT_CUT, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_CUT));
	pEditMenu->AppendMenuItem(IDCM_EDIT_COPY, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_COPY));
	pEditMenu->AppendMenuItem(IDCM_EDIT_PASTE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_PASTE));
	pEditMenu->AppendMenuItem(IDCM_EDIT_CLEAR, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_CLEAR));
	pEditMenu->AppendMenuItem(IDCM_EDIT_SELECTALL, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_SELECTALL));
	pEditMenu->AppendMenuItem(0, MF_SEPARATOR, 0);

	// [ҏW]-[xȑ]
	CPopupMenu* pAdvEditMenu = pEditMenu->AppendMenuItem(9, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_EDITADVANCED).c_str());
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_TOGGLECHARCODEPOINT, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_TOGGLECHARCODEPOINT));
	pAdvEditMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTGRAVE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTGRAVE));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTACUTE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTACUTE));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTCIRCUMFLEX, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTCIRCUMFLEX));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTTILDE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTTILDE));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTDIAERESIS, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTDIAERESIS));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTRINGABOVE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTRINGABOVE));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTCEDILLA, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTCEDILLA));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTSTROKE, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTSTROKE));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTSHARP, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTSHARP));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTETH, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTETH));
	pAdvEditMenu->AppendMenuItem(IDCM_EDIT_MAKENEXTCOMBINED, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_MAKENEXTCOMBINED));
	pAdvEditMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pEditMenu->AppendMenuItem(IDCM_EDIT_CANDIDATELIST, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_CANDIDATELIST));

	// [ҏW]-[xȑ]-[Unicode 䕶̑}]
	CPopupMenu* pInsertUCMenu = pAdvEditMenu->AppendMenuItem(14, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_EDITINSUNICTRL).c_str());
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200E, MFT_STRING, L"LRM\tLeft-to-right mark");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200F, MFT_STRING, L"RLM\tRight-to-left mark");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200D, MFT_STRING, L"ZWJ\tZero width joiner");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200C, MFT_STRING, L"ZWNJ\tZero width non-joiner");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200B, MFT_STRING, L"LRE\tStart of left-to-right embedding");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200A, MFT_STRING, L"RLE\tStart of right-to-left embedding");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x202D, MFT_STRING, L"LRO\tStart of left-to-right override");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x202E, MFT_STRING, L"RLO\tStart of right-to-left override");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x202C, MFT_STRING, L"PDF\tPop directional formatting");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206E, MFT_STRING, L"NADS\tNational digit shapes substitution");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206F, MFT_STRING, L"NODS\tNominal (European) digit shapes");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206B, MFT_STRING, L"ASS\tActivate symmetric swapping");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206A, MFT_STRING, L"ISS\tInhibit symmetric swapping");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206D, MFT_STRING, L"AAFS\tActivate Arabic form shapes");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x206C, MFT_STRING, L"IAFS\tInhibit Arabic form shapes");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x201E, MFT_STRING, L"RS\tRecord separator (Block separator)");
	pInsertUCMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x201F, MFT_STRING, L"US\tUnit separator (Segment separator)");

	// [ҏW]-[xȑ]-[Unicode 󔒕̑}]
	CPopupMenu* pInsertUSMenu = pAdvEditMenu->AppendMenuItem(15, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_EDITINSUNIWS).c_str());
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x00A0, MFT_STRING, L"NBSP\tNo-Break Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x1680, MFT_STRING, L"U+1680\tOgham Space Mark");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2000, MFT_STRING, L"U+2000\tEn Quad");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2001, MFT_STRING, L"U+2001\tEm Quad");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2002, MFT_STRING, L"U+2002\tEn Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2003, MFT_STRING, L"U+2003\tEm Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2004, MFT_STRING, L"U+2004\tThree-Per-Em Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2005, MFT_STRING, L"U+2005\tFour-Per-Em Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2006, MFT_STRING, L"U+2006\tSix-Per-Em Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2007, MFT_STRING, L"U+2007\tFigure Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2008, MFT_STRING, L"U+2008\tPunctuation Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2009, MFT_STRING, L"U+2009\tThin Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200A, MFT_STRING, L"U+200A\tHair Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x200B, MFT_STRING, L"U+200B\tZero Width Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x202F, MFT_STRING, L"NNBSP\tNarrow No-Break Space");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x3000, MFT_STRING, L"U+3000\tIdeographic Space");
	pInsertUSMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x0085, MFT_STRING, L"NEL\tNext Line");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2028, MFT_STRING, L"LS\tLine Separator");
	pInsertUSMenu->AppendMenuItem(IDCM_EDIT_INSERTUNICODECHARSTART + 0x2029, MFT_STRING, L"PS\tParagraph Separator");

	// [ҏW]-[vOC]
	CPopupMenu*	pPluginMenu = pEditMenu->AppendMenuItem(11, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_EDITPLUGINS).c_str());
//	pPluginMenu->AppendMenuItem(IDCM_EDIT_RELOADPLUGIN, MF_OWNERDRAW, GetMenuLabel(IDCM_EDIT_RELOADPLUGIN));
//	pPluginMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
	unsigned int	cPlugins = m_oPluginManager.GetCount();
	if(cPlugins != 0) {
		for(unsigned int iPlugin = 0; iPlugin < cPlugins; ++iPlugin)
			pPluginMenu->AppendMenuItem(IDCM_EDIT_PLUGINLISTSTART + iPlugin,
				MFT_STRING | MFT_OWNERDRAW, m_oPluginManager.GetPluginName(iPlugin).c_str());
	} else
		pPluginMenu->AppendMenuItem(IDCM_EDIT_PLUGINLISTSTART,
			MFT_STRING | MF_GRAYED | MF_DISABLED | MFT_OWNERDRAW, LoadMessage(MSG_MENU_EDITFAILEDTOLOAD).c_str());

	// []
	CPopupMenu* pFindMenu = m_pMenu->AppendMenuItem(2, MF_POPUP, LoadMessage(MSG_MENU_SEARCHTOP).c_str());
	pFindMenu->AppendMenuItem(IDCM_FIND_FIND, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_FIND));
	pFindMenu->AppendMenuItem(IDCM_FIND_FINDNEXT, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_FINDNEXT));
	pFindMenu->AppendMenuItem(IDCM_FIND_FINDPREV, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_FINDPREV));
	pFindMenu->AppendMenuItem(IDCM_FIND_REPLACE, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_REPLACE));
	pFindMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFindMenu->AppendMenuItem(IDCM_FIND_GOTOLINE, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_GOTOLINE));
	pFindMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFindMenu->AppendMenuItem(IDCM_FIND_TOGGLEBOOKMARK, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_TOGGLEBOOKMARK));
	pFindMenu->AppendMenuItem(IDCM_FIND_NEXTBOOKMARK, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_NEXTBOOKMARK));
	pFindMenu->AppendMenuItem(IDCM_FIND_PREVBOOKMARK, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_PREVBOOKMARK));
	pFindMenu->AppendMenuItem(IDCM_FIND_CLEARBOOKMARKS, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_CLEARBOOKMARKS));
	pFindMenu->AppendMenuItem(IDCM_FIND_BOOKMARKS, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_BOOKMARKS));
	pFindMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pFindMenu->AppendMenuItem(IDCM_FIND_GOTOMATCHBRACKET, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_GOTOMATCHBRACKET));
	pFindMenu->AppendMenuItem(IDCM_FIND_EXTENDTOMATCHBRACKET, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_EXTENDTOMATCHBRACKET));
	pFindMenu->AppendMenuItem(IDCM_FIND_PARSEOUTLINE, MF_OWNERDRAW, GetMenuLabel(IDCM_FIND_PARSEOUTLINE));
	pFindMenu->EnableMenuItem(IDCM_FIND_PARSEOUTLINE, false);

	// [\]
	CPopupMenu*	pViewMenu = m_pMenu->AppendMenuItem(3, MF_POPUP, LoadMessage(MSG_MENU_VIEWTOP).c_str());
	pViewMenu->AppendMenuItem(IDCM_VIEW_TOOLBAR, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_TOOLBAR));
	pViewMenu->AppendMenuItem(IDCM_VIEW_STATUSBAR, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_STATUSBAR));
	pViewMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pViewMenu->AppendMenuItem(IDCM_VIEW_NEXTTAB, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_NEXTTAB));
	pViewMenu->AppendMenuItem(IDCM_VIEW_PREVTAB, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_PREVTAB));
	pViewMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pViewMenu->AppendMenuItem(IDCM_VIEW_SPLITVIEW, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_SPLITVIEW));
	pViewMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pViewMenu->AppendMenuItem(IDCM_VIEW_NOWRAP, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_NOWRAP));
	pViewMenu->AppendMenuItem(IDCM_VIEW_WRAPBYSPECIFIEDWIDTH, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(IDCM_VIEW_WRAPBYSPECIFIEDWIDTH));
	pViewMenu->AppendMenuItem(IDCM_VIEW_WRAPBYWINDOWWIDTH, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(IDCM_VIEW_WRAPBYWINDOWWIDTH));
	pViewMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pViewMenu->AppendMenuItem(IDCM_VIEW_REPAINT, MF_OWNERDRAW, GetMenuLabel(IDCM_VIEW_REPAINT));

	// [fobO]
	CPopupMenu*	pDebugMenu = m_pMenu->AppendMenuItem(4, MF_POPUP, LoadMessage(MSG_MENU_DEBUGTOP).c_str());
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_INSERTBREAKPOINT, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_INSERTBREAKPOINT));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_BREAKPOINTS, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_BREAKPOINTS));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_ACTIVEDOCUMENTS, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(IDCM_DEBUG_ACTIVEDOCUMENTS));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_START, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_START));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_RESTART, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_RESTART));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_STOP, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_STOP));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_STEPINTO, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_STEPINTO));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_STEPOVER, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_STEPOVER));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_STEPOUT, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_STEPOUT));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_CALLSTACK, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_CALLSTACK));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_VARIABLES, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_VARIABLES));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_IMMEDIATE, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_IMMEDIATE));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_THREADS, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_THREADS));
	pDebugMenu->AppendMenuItem(IDCM_DEBUG_EXCEPTION, MF_OWNERDRAW, GetMenuLabel(IDCM_DEBUG_EXCEPTION));

	// [c[]
	CPopupMenu* pToolMenu = m_pMenu->AppendMenuItem(5, MF_POPUP, LoadMessage(MSG_MENU_TOOLTOP).c_str());
	pToolMenu->AppendMenuItem(IDCM_TOOL_EXECUTE, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_EXECUTE));
	pToolMenu->AppendMenuItem(IDCM_TOOL_EXECUTECOMMAND, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_EXECUTECOMMAND));
	pToolMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	m_pAppDocTypeMenu = pToolMenu->AppendMenuItem(3, MF_POPUP | MF_OWNERDRAW, LoadMessage(MSG_MENU_TOOLAPPLYDOCTYPE).c_str());
	pToolMenu->AppendMenuItem(IDCM_TOOL_DOCUMENTTYPEOPTION, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_DOCUMENTTYPEOPTION));
	pToolMenu->AppendMenuItem(IDCM_TOOL_COMMONOPTION, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_COMMONOPTION));
	pToolMenu->AppendMenuItem(IDCM_TOOL_FONT, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_FONT));
	pToolMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pToolMenu->AppendMenuItem(IDCM_TOOL_KEYMACRORECORD, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACRORECORD));
	pToolMenu->AppendMenuItem(IDCM_TOOL_KEYMACROPLAY, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROPLAY));
	pToolMenu->AppendMenuItem(IDCM_TOOL_KEYMACROSAVE, MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROSAVE));

	// [wv]
	CPopupMenu* pHelpMenu = m_pMenu->AppendMenuItem(6, MF_POPUP, LoadMessage(MSG_MENU_HELPTOP).c_str());
	pHelpMenu->AppendMenuItem(IDCM_HELP_ABOUT, MF_OWNERDRAW, GetMenuLabel(IDCM_HELP_ABOUT));

	// ^u
	CPopupMenu*	pTabMenu = m_wndTab.GetContextMenu();
	pTabMenu->AppendMenuItem(IDCM_FILE_CLOSE, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_CLOSE));
	pTabMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pTabMenu->AppendMenuItem(IDCM_FILE_PROPERTY, MF_OWNERDRAW, GetMenuLabel(IDCM_FILE_PROPERTY));
	pTabMenu->AppendMenuItem(0, MF_OWNERDRAW, LoadMessage(MSG_MENU_FILEOPE).c_str());
	pTabMenu->AppendChildPopup(m_pFileOpeMenu, 3);

	m_pMainWindow->DrawMenuBar();
}

///	\ݒƓKphLg^CvXg̏
void CAlphaApp::SetupTextFoundations() {
	AssertValid();

	unsigned int		i;
	wchar_t				wszSectionName[30];
	wchar_t				wszKeyName[30];
	wstring				strKeyName;
	const wchar_t*		psz = 0;
	TDocumentType		oDocType;
	TDocumentStyleType	oDocStyleType;

	// O̐ݒ폜
	m_vecDocumentTypes.clear();
	m_vecDocStyleTypes.clear();
	m_pNewDocTypeMenu->ResetContent();
//	m_pNewDocTypeMenu->AppendMenuItem(IDCM_TOOL_DOCTYPELISTSTART, MFT_STRING, L"ݒȂ");
	m_pAppDocTypeMenu->ResetContent();
//	m_pAppDocTypeMenu->AppendMenuItem(IDCM_TOOL_DOCTYPELISTSTART, MFT_STRING, L"ݒȂ");

	// ݒ肪ǉ
	for(i = 0; ; ++i) {
		swprintf(wszSectionName, L"DocumentTypes(%u)", i);
		psz = GetProfileString(wszSectionName, L"strName", L"");
		if(*psz == 0)
			break;
		m_pNewDocTypeMenu->AppendMenuItem(IDCM_FILE_DOCTYPELISTSTART + i, MFT_STRING | MFT_OWNERDRAW, psz);
		m_pAppDocTypeMenu->AppendMenuItem(IDCM_TOOL_DOCTYPELISTSTART + i, MFT_STRING | MFT_OWNERDRAW, psz);
		oDocType.strName = psz;
		oDocType.iStyle = GetProfileInt(wszSectionName, L"iStyle", 0);
		oDocType.ait = static_cast<AutoIndentType>(GetProfileInt(wszSectionName, L"nAutoIndentType", AIT_BLOCK));
		oDocType.strMCommentBegin1 = GetProfileString(wszSectionName, L"strMultilineCommentBegin1", L"");
		oDocType.strMCommentEnd1 = GetProfileString(wszSectionName, L"strMultilineCommentEnd1", L"");
		oDocType.strMCommentBegin2 = GetProfileString(wszSectionName, L"strMultilineCommentBegin2", L"");
		oDocType.strMCommentEnd2 = GetProfileString(wszSectionName, L"strMultilineCommentEnd2", L"");
		oDocType.strSCommentHeader1 = GetProfileString(wszSectionName, L"strSinglelineCommentHeader1", L"");
		oDocType.strSCommentHeader2 = GetProfileString(wszSectionName, L"strSinglelineCommentHeader2", L"");
		oDocType.bIgnoreCase = toBoolean(GetProfileInt(wszSectionName, L"bIgnoreCase", 0));
		oDocType.strSpecialKeywordChars = GetProfileString(wszSectionName, L"strCharsTreatedAsAlpha", L"");
		oDocType.nLineSpan = GetProfileInt(wszSectionName, L"nLineSpan", 0);
		oDocType.nCharSpan = GetProfileInt(wszSectionName, L"nCharSpan", 0);
		oDocType.nTabWidth = GetProfileInt(wszSectionName, L"nTabWidth", 4);
		oDocType.nSmartIndentRule = GetProfileInt(wszSectionName, L"nSmartIndentRule", 0);
		oDocType.ltt = static_cast<LeftTabType>(GetProfileInt(wszSectionName, L"nLeftTabType", 2));
		GetProfileList(wszSectionName, L"strExtensions", oDocType.listExtensions);
		GetProfileList(wszSectionName, L"strKeywords1", oDocType.listKeywords1);
		GetProfileList(wszSectionName, L"strKeywords2", oDocType.listKeywords2);
		GetProfileList(wszSectionName, L"strOperators", oDocType.listOperators);
		oDocType.strCandidateWordsFile = GetProfileString(wszSectionName, L"strCandidateWordsFilePath");
		oDocType.strLanguageForOutlineParsing = GetProfileString(wszSectionName, L"strLanguageForOutlineParsing");
		m_vecDocumentTypes.push_back(oDocType);
	}

	// ݒ肪ǉ
	for(i = 0; ; ++i) {
		swprintf(wszSectionName, L"FoundationStyle(%u)", i);
		psz = GetProfileString(wszSectionName, L"strName", L"");
		if(*psz == 0)
			break;
		oDocStyleType.strName = psz;
		for(unsigned int j = 0; j < TEXTTYPE_NUMBER; ++j) {
			swprintf(wszKeyName, L"oTextFoundation(%u).", j);
			strKeyName = wszKeyName;
			oDocStyleType.arrTfs[j].enabled = toBoolean(GetProfileInt(wszSectionName, (strKeyName + L"enabled").c_str(), 1));
			oDocStyleType.arrTfs[j].fgColor = GetProfileInt(wszSectionName, (strKeyName + L"fgColor").c_str(), -1);
			oDocStyleType.arrTfs[j].bgColor = GetProfileInt(wszSectionName, (strKeyName + L"bgColor").c_str(), -1);
			oDocStyleType.arrTfs[j].bold = toBoolean(GetProfileInt(wszSectionName, (strKeyName + L"bold").c_str(), 0));
			oDocStyleType.arrTfs[j].italic = toBoolean(GetProfileInt(wszSectionName, (strKeyName + L"italic").c_str(), 0));
			oDocStyleType.arrTfs[j].underline = static_cast<UnderlineType>(GetProfileInt(wszSectionName, (strKeyName + L"underline").c_str(), 0));
		}
		m_vecDocStyleTypes.push_back(oDocStyleType);
	}
}

///	c[o[̏
void CAlphaApp::SetupToolbar() {
	AssertValid();

	REBARBANDINFOW	rbbi;
	TBBUTTON*		pTButton = 0;
	int				cItem = GetProfileInt(L"ToolbarButtons", L"cItems", 0);
	wchar_t			wsz[20];
	TBBUTTON		tbDefault[] = {
		{IDCM_FILE_NEW - IDCM_COMMANDSTART,				IDCM_FILE_NEW,			TBSTATE_ENABLED,	TBSTYLE_DROPDOWN},
		{0,												0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_FILE_OPEN - IDCM_COMMANDSTART,			IDCM_FILE_OPEN,			TBSTATE_ENABLED,	TBSTYLE_DROPDOWN},
		{IDCM_FILE_SAVE - IDCM_COMMANDSTART,			IDCM_FILE_SAVE,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_FILE_SAVEAS - IDCM_COMMANDSTART,			IDCM_FILE_SAVEAS,		TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_FILE_SAVEALL - IDCM_COMMANDSTART,			IDCM_FILE_SAVEALL,		TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{0,												0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_EDIT_CUT - IDCM_COMMANDSTART,				IDCM_EDIT_CUT,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_EDIT_COPY - IDCM_COMMANDSTART,			IDCM_EDIT_COPY,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_EDIT_PASTE - IDCM_COMMANDSTART,			IDCM_EDIT_PASTE,		TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{0,												0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_EDIT_UNDO - IDCM_COMMANDSTART,			IDCM_EDIT_UNDO,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_EDIT_REDO - IDCM_COMMANDSTART,			IDCM_EDIT_REDO,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{0,												0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_FIND_FIND - IDCM_COMMANDSTART,			IDCM_FIND_FIND,			TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_FIND_FINDNEXT - IDCM_COMMANDSTART,		IDCM_FIND_FINDNEXT,		TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_FIND_FINDPREV - IDCM_COMMANDSTART,		IDCM_FIND_FINDPREV,		TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{0,												0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_TOOL_KEYMACROPLAY - IDCM_COMMANDSTART,	IDCM_TOOL_KEYMACROPLAY,	TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_TOOL_KEYMACRORECORD - IDCM_COMMANDSTART,	IDCM_TOOL_KEYMACRORECORD,	TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_TOOL_KEYMACROCANCEL - IDCM_COMMANDSTART,	IDCM_TOOL_KEYMACROCANCEL,	0,	TBSTYLE_BUTTON},
	};
	TBBUTTON	tbDebugBar[] = {
		{IDCM_DEBUG_START - IDCM_COMMANDSTART,	IDCM_DEBUG_START,	TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_DEBUG_STOP - IDCM_COMMANDSTART,	IDCM_DEBUG_STOP,	TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{0,											0,						TBSTATE_ENABLED,	TBSTYLE_SEP},
		{IDCM_DEBUG_STEPINTO - IDCM_COMMANDSTART,	IDCM_DEBUG_STEPINTO,TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_DEBUG_STEPOVER - IDCM_COMMANDSTART,	IDCM_DEBUG_STEPOVER,TBSTATE_ENABLED,	TBSTYLE_BUTTON},
		{IDCM_DEBUG_STEPOUT - IDCM_COMMANDSTART,	IDCM_DEBUG_STEPOUT,TBSTATE_ENABLED,	TBSTYLE_BUTTON},
	};

	if(::IsWindow(m_hToolbar)) {
		::SendMessage(m_hRebar, RB_DELETEBAND, 0, 0L);
		::DestroyWindow(m_hToolbar);
	}
	if(::IsWindow(m_hDebugBar)) {
		::SendMessage(m_hRebar, RB_DELETEBAND, 0, 0L);
		::DestroyWindow(m_hDebugBar);
	}

	if(cItem == 0)	// INI ɏ񂪖 -> ftHĝ̂g
		m_hToolbar = ::CreateToolbarEx(m_hRebar,
			WS_CHILD | WS_VISIBLE | CCS_NODIVIDER | CCS_NORESIZE | CCS_TOP | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS,
			IDC_TOOLBAR, 21, m_hInstance, 0/*IDB_BMP_COMMANDS*/, tbDefault, 21, 0, 0, 16, 16, sizeof(TBBUTTON));
	else {
		pTButton = new TBBUTTON[cItem];
		for(int i = 0; i < cItem; ++i) {
			swprintf(wsz, L"nCommand(%d)", i);
			int nItemID = GetProfileInt(L"ToolbarButtons", wsz, -1);
			if(nItemID == -1)
				break;
			(pTButton + i)->idCommand = nItemID;
			(pTButton + i)->fsState = TBSTATE_ENABLED;
			(pTButton + i)->iBitmap = nItemID - IDCM_FILE_NEW;
			switch(nItemID) {
			case 0:	// Zp[^
				(pTButton + i)->fsStyle = TBSTYLE_SEP;
				break;
			case IDCM_FILE_OPEN:	// hbv_E
				(pTButton + i)->fsStyle = TBSTYLE_DROPDOWN;
				break;
			default:
				(pTButton + i)->fsStyle = TBSTYLE_BUTTON;
				break;
			}
		}
		m_hToolbar = ::CreateToolbarEx(m_hRebar,
			WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS
			| CCS_NODIVIDER | CCS_TOP | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT,
			IDC_TOOLBAR, 1, m_hInstance, IDB_BMP_COMMANDS, pTButton, cItem, 0, 0, 16, 16, sizeof(TBBUTTON));
		delete[] pTButton;
	}
	m_hDebugBar = ::CreateToolbarEx(m_hRebar,
		WS_CHILD | WS_VISIBLE | CCS_NODIVIDER | CCS_NORESIZE | CCS_TOP | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS,
		IDC_DEBUGBAR, 6, m_hInstance, 0/*IDC_BMP_COMMANDS*/, tbDebugBar, 6, 0, 0, 16, 16, sizeof(TBBUTTON));
	::SendMessage(m_hToolbar, TB_SETIMAGELIST, 0, reinterpret_cast<LPARAM>(m_hCommandImageList));
	::SendMessage(m_hToolbar, TB_SETDISABLEDIMAGELIST, 0, reinterpret_cast<LPARAM>(m_hDisabledCommandImageList));
	::SendMessage(m_hToolbar, TB_SETEXTENDEDSTYLE, 0, TBSTYLE_EX_DRAWDDARROWS);
	::SendMessage(m_hDebugBar, TB_SETIMAGELIST, 0, reinterpret_cast<LPARAM>(m_hCommandImageList));
	::SendMessage(m_hDebugBar, TB_SETDISABLEDIMAGELIST, 0, reinterpret_cast<LPARAM>(m_hDisabledCommandImageList));

	// o[ɏ悹
	rbbi.cbSize = sizeof(REBARBANDINFO);
	rbbi.fMask = RBBIM_STYLE | RBBIM_CHILD | RBBIM_CHILDSIZE;
	rbbi.fStyle = RBBS_CHILDEDGE;
	rbbi.hwndChild = m_hToolbar;
	rbbi.cxMinChild = 510;
	rbbi.cyMinChild = 22;//rectToolbar.bottom - rectToolbar.top;
	::SendMessage(m_hRebar, RB_INSERTBAND, 0, reinterpret_cast<LPARAM>(&rbbi));
	::ShowWindow(m_hDebugBar, SW_HIDE);
//	rbbi.hwndChild = m_hDebugBar;
//	rbbi.cxMinChild = 206;
//	::SendMessage(m_hRebar, RB_INSERTBAND, 1, reinterpret_cast<LPARAM>(&rbbi));
}

///	Xe[^Xo[̍XV
void CAlphaApp::UpdateStatusBar() {
	AssertValid();

	IAlphaTab*				pActiveTab = GetActiveTab();
	CAlphaEditController*	pActiveCtrl = 0;
	CAlphaDoc*	pActiveDoc = 0;

	if(!::IsWindow(m_hStatusBar))
		return;
	if(!pActiveTab->IsTextEditor()) {
		::SendMessage(m_hStatusBar, SB_SIMPLE, true, 0L);
		return;
	} else {
		::SendMessage(m_hStatusBar, SB_SIMPLE, false, 0L);
		pActiveCtrl = static_cast<CAlphaEditController*>(pActiveTab);
		pActiveDoc = pActiveCtrl->GetDocument();
	}

	// Xe[^Xo[̃yC͍
	// ėpA݈ʒuAhLg^Cv̖OAR[hAfobOԁAL[}NԁAҏW[hA_~[
	// UpdateStatusBar Q
	int				arrParts[8];
	RECT			rect;
	HDC				hDC = ::GetDC(m_hStatusBar);
	HFONT			hOldFont = reinterpret_cast<HFONT>(::SelectObject(hDC, m_hTabFont));
	CAlphaView*		pView = pActiveCtrl->GetActiveView();
	CCharPos		pos1, pos2;
	const wchar_t*	pwszPosition = pView->GetCurrentPositionString();
	const wchar_t*	pwszDocType = (m_vecDocumentTypes.empty() || pActiveDoc->m_iDocType == 0) ?
						L"ݒ薳" : m_vecDocumentTypes[pActiveDoc->m_iDocType].strName.c_str();
	const wchar_t*	pwszCharCode = CCodePageManager::GetCodePageName(pView->GetDocument()->GetCodePage());
	const wchar_t*	pwszKeymacroRec = (CEditView::GetViewKeyMacroRecording() == pView) ? L"REC" : L"";
	const wchar_t*	pwszDebugging = (m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging()) ? L"fobO" : L"";
	const wchar_t*	pwszOverwrite = pView->IsOverwriteMode() ? L"㏑" : L"}";

	// eyC̕߂
	::GetWindowRect(m_hStatusBar, &rect);
	arrParts[7] = rect.right - rect.left;
	arrParts[6] = arrParts[7] - (m_pMainWindow->IsZoomed() ? 0 : (rect.bottom - rect.top - 4));
	::DrawTextW(hDC, pwszOverwrite, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[5] = arrParts[6] - rect.right + rect.left - 8;
	::DrawTextW(hDC, pwszDebugging, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[4] = arrParts[5] - rect.right + rect.left - 8;
	::DrawTextW(hDC, pwszKeymacroRec, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[3] = arrParts[4] - rect.right + rect.left - 8;
	::DrawTextW(hDC, pwszCharCode, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[2] = arrParts[3] - rect.right + rect.left - 12;
	::DrawTextW(hDC, pwszDocType, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[1] = arrParts[2] - rect.right + rect.left - 10;
	::DrawTextW(hDC, pwszPosition, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[0] = arrParts[1] - rect.right + rect.left - 6;
	::SendMessage(m_hStatusBar, SB_SETPARTS, 7, reinterpret_cast<LPARAM>(arrParts));

	::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(L""));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 1, reinterpret_cast<LPARAM>(pwszPosition));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 2, reinterpret_cast<LPARAM>(pwszDocType));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 3, reinterpret_cast<LPARAM>(pwszCharCode));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 4, reinterpret_cast<LPARAM>(pwszKeymacroRec));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 5, reinterpret_cast<LPARAM>(pwszDebugging));
	::SendMessage(m_hStatusBar, SB_SETTEXT, 6, reinterpret_cast<LPARAM>(pwszOverwrite));

	::SelectObject(hDC, hOldFont);
	::ReleaseDC(m_hStatusBar, hDC);
}

///	^Cgo[ƃ^uLvV̍XV
void CAlphaApp::UpdateTitleBar() {
	AssertValid();

	static wstring	strTitleCache;

	if(!m_pMainWindow->IsWindow()
			|| !m_wndTab.IsWindow())
		return;

	IAlphaTab*	pActiveTab = GetActiveTab();
	TCITEMW		item;
	wstring		strTitle = pActiveTab->GetTabTitle();

	if(strTitle == strTitleCache)
		return;
	strTitleCache = strTitle;

	// ^u
	item.mask = TCIF_TEXT;
	item.pszText = const_cast<wchar_t*>(strTitle.c_str());
	m_wndTab.SetItem(m_iActiveTab, &item);

	// ^Cgo[
	strTitle += L" - " IDS_APPFULLVERSION;
	if(pActiveTab->IsTextEditor()
			&& static_cast<CAlphaEditController*>(pActiveTab)->GetDocument()->IsReadOnly())
		strTitle += L" [ǂݎp]";
	m_pMainWindow->SetWindowText(strTitle.c_str());
}

///	vOC () [h
void CAlphaApp::OnEditReloadPlugin() {
	wchar_t	wszPluginPath[MAX_PATH];

	wcscpy(wszPluginPath, m_szModulePath);
	wcscpy(::PathFindFileNameW(wszPluginPath), L"plugins.xml");
	m_oPluginManager.LimitCount(16);
	if(!m_oPluginManager.LoadPlugins(wszPluginPath))
		m_pMainWindow->MessageBox((LoadErrorString(117)
			+ m_oPluginManager.GetLastErrorMessage()).c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
}

/**
 *	ANeBuȃ^u폜
 *	@return	{Ƀ^u폜Ƃ true
 */
bool CAlphaApp::OnFileClose(bool bConfirm /* = true */) {
	IAlphaTab*				pActiveTab = GetActiveTab();
	CAlphaEditController*	pActiveCtrl = GetActiveTextEditor();
	CAlphaDoc*				pActiveDoc = GetActiveDocument();

	if(bConfirm && pActiveDoc != 0) {
		wstring		strPrompt;
		int			nAnswer;

		// fobO~̊mF
		if(m_pDebuggingEditor != 0 && pActiveCtrl == m_pDebuggingEditor) {
			nAnswer = MessageBox(MSG_DEBUG_DOCUMENTISDEBUGGING, MB_YESNO | MB_ICONQUESTION);
			if(nAnswer == IDNO)
				return false;
			m_pActiveDebugger->Abort();
		}

		// ۑ̊mF
		if(pActiveDoc->IsModified()) {
			nAnswer = MessageBox(MSG_FILE_FILEISDIRTY,
						MB_YESNOCANCEL | MB_ICONQUESTION,
						CMessageArguments() % pActiveDoc->GetTitle().c_str());
			if(nAnswer == IDCANCEL)
				return false;
			else if(nAnswer == IDYES) {
				if(!OnFileSave())
					return false;
			}
		}

		if(!pActiveCtrl->OnClosing())
			return false;	// hLg̂ۂ
	}

	// mFȂƂ̂
	if(m_pDebuggingEditor != 0 && pActiveCtrl == m_pDebuggingEditor) {
		if(m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging())
			m_pActiveDebugger->Abort();
	}

	pActiveTab->DeleteInstance();
	m_vecDocuments.erase(m_vecDocuments.begin() + m_iActiveTab);
	m_wndTab.DeleteItem(m_iActiveTab);

	// ʂ̃r[ANeBuɂ
	m_iActiveTab = -1;	// SetActiveTab ɋ₳Ȃ
	if(m_vecDocuments.empty())
		OnFileNew(::GetACP());
	else if(m_iActiveTab == 0)
		SetActiveTab(0);
	else
		SetActiveTab(std::min(m_iLastActiveTab, m_vecDocuments.size() - 1));

	return true;
}

/**
 *	SẴ^u폜
 *	@return	SẴ^u폜łƂ true
 */
bool CAlphaApp::OnFileCloseAll() {
	// TODO: eLXgGfB^ȊO^uɊ܂܂悤ɂȂC
	CConfirmUnsavedDocumentDlg	oDlg;

	// ۑ̕Kv̖hLgS
	for(unsigned int iDoc = m_vecDocuments.size(); iDoc != 0; --iDoc) {
		if(GetTab(iDoc - 1)->IsTextEditor()) {
			CAlphaDoc*	pDocument = GetTextEditor(iDoc - 1)->GetDocument();
			if(!pDocument->IsModified()) {
				SetActiveTab(iDoc - 1);
				OnFileClose(false);
				if(iDoc == 1 && m_vecDocuments.size() == 1)
					return true;	// ۑ̃t@CΏI
			}
		}
	}

	// ۑ̃t@C1Ȃʏ̊mF_CAOo
	if(m_vecDocuments.size() == 1
			&& GetTab(0)->IsTextEditor()
			&& GetActiveDocument()->IsModified())
		return OnFileClose();

	// ̃t@Cۑ邩ǂmF_CAOo
	for(unsigned int iDoc = 0; iDoc < m_vecDocuments.size(); ++iDoc) {
		if(GetTab(iDoc)->IsTextEditor()) {
			TDirtyFile	tf;
			tf.iTab = iDoc;
			tf.strFileName = GetTextEditor(iDoc)->GetDocument()->GetTitle();
			tf.bSave = true;
			oDlg.m_vecFiles.push_back(tf);
		}
	}
	oDlg.Create(m_hInstance, IDD_DLG_CONFIRMUNSAVEDDOCUMENTS, m_pMainWindow->m_hWnd);
	if(IDOK != oDlg.DoModal())
		return false;

	// ۑ
	for(vector<TDirtyFile>::reverse_iterator it = oDlg.m_vecFiles.rbegin(); it != oDlg.m_vecFiles.rend(); ++it) {
		SetActiveTab(it->iTab);
		if(it->bSave) {
			if(!OnFileSave())
				return false;
		}
		if(!OnFileClose(false))
			return false;
	}

	return true;
}

/**
 *	V^u쐬
 *	@param nCodePage	R[hy[W
 */
void CAlphaApp::OnFileNew(UINT nCodePage) {
	RECT					rect = {0, 0, 0, 0};
	CAlphaEditController*	pEditor = new CAlphaEditController();
	bool					bSucceededToCreate;
	static bool				bLoadedKeyMacro = false;

	pEditor->SetSplitterWidth(3);
	bSucceededToCreate = pEditor->Create(m_pMainWindow->m_hWnd,
		&rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, 0,
		WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	if(!bLoadedKeyMacro) {
		pEditor->GetPrimaryView()->CmdKeymacroLoad(IDS_KEYMACROFILENAME);
		bLoadedKeyMacro = true;
	}

	if(nCodePage != EXTCP_AUTO)
		pEditor->GetDocument()->SetCodePage(nCodePage);

	m_wndTab.InsertItem(m_vecDocuments.size(), IDS_UNTITLED);
	pEditor->GetPrimaryView()->SetEventListener(static_cast<IEditViewEventListener*>(this));
	pEditor->GetDocument()->SetEventListener(static_cast<IEditDocEventListener*>(this));
	pEditor->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);
	m_vecDocuments.push_back(pEditor);
	SetActiveTab(m_vecDocuments.size() - 1);
	ApplyDocumentType(m_iActiveTab, 0);
	m_oToolTip.AddTool(m_pMainWindow->m_hWnd, L"", pEditor->GetPrimaryView()->m_hWnd);
	ModifyTabIcons();
}

///	[w肵ĐVK] _CAOJ
void CAlphaApp::OnFileNewWithFormat() {
	RECT					rect = {0, 0, 0, 0};
	CAlphaEditController*	pEditor = 0;
	CNewFileFormatDlg		dlg;
	bool					bSucceededToCreate;

	dlg.Create(m_hInstance, IDD_DLG_FILENEWWITHFORMAT, m_pMainWindow->m_hWnd);
	dlg.m_nCodePage = ::GetACP();	// INI ɊYڂ邪
	dlg.m_breakType = BT_CRLF;		// ͖
	dlg.m_iDocumentType = 0;
	dlg.m_listDocumentTypes.clear();
	for(vector<TDocumentType>::const_iterator it
			= m_vecDocumentTypes.begin(); it != m_vecDocumentTypes.end(); ++it)
		dlg.m_listDocumentTypes.push_back(it->strName);

	if(dlg.DoModal() != IDOK)
		return;

	pEditor = new CAlphaEditController();
	bSucceededToCreate = pEditor->Create(m_pMainWindow->m_hWnd,
		&rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, WS_EX_STATICEDGE,
		WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	pEditor->GetDocument()->SetCodePage(dlg.m_nCodePage);
	pEditor->GetDocument()->SetBreakType(dlg.m_breakType);

	// ^CvȊO͌ OnFileNew Ɠ...
	m_wndTab.InsertItem(m_vecDocuments.size(), IDS_UNTITLED);
	pEditor->GetPrimaryView()->SetEventListener(static_cast<IEditViewEventListener*>(this));
	pEditor->GetDocument()->SetEventListener(static_cast<IEditDocEventListener*>(this));
	pEditor->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);
	m_vecDocuments.push_back(pEditor);
	SetActiveTab(m_vecDocuments.size() - 1);
	ApplyDocumentType(m_iActiveTab, dlg.m_iDocumentType);
	m_oToolTip.AddTool(m_pMainWindow->m_hWnd, L"", pEditor->GetPrimaryView()->m_hWnd);
	ModifyTabIcons();
}

///	t@CJ
bool CAlphaApp::OnFileOpen() {
	OPENFILENAMEW	ofn;
	wchar_t			wszFilter[300];
	wstring			strFilter = GetProfileString(L"File", L"strFilter", L"ׂẴt@C:*.*");
	wchar_t			wszFileName[MAX_PATH + 1] = L"";
	wstring			strErrorMessage;

	// tB^𐮌`
	wstring::size_type	iFound = 0;
	while(true) {
		iFound = strFilter.find(L':', iFound + 1);
		if(iFound == wstring::npos)
			break;
		strFilter[iFound] = L'\0';
	}
	strFilter.copy(wszFilter, strFilter.length());
	wszFilter[strFilter.length()] = L'\0';
	wszFilter[strFilter.length() + 1] = L'\0';

	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_pMainWindow->m_hWnd;
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = wszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST/* | OFN_SHOWHELP*/;
	ofn.lCustData = MAKELONG(EXTCP_AUTO, 0);
	ofn.lpfnHook = CAlphaApp::OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_OPENFILE);

	if(!::GetOpenFileNameW(&ofn))
		return false;
	return OpenFile(ofn.lpstrFile, LOWORD(ofn.lCustData));
}

/**
 *	[t@C]_CAO̕\
 *	@param id	R}h ID
 */
void CAlphaApp::OnFileOperation(UINT id) {
	assert(id >= IDCM_FILE_RENAME && id <= IDCM_FILE_DELETE);

	CAlphaDoc*		pActiveDoc = GetActiveDocument();
	OperationStatus	ops = OPS_OK;
	wchar_t			wszError[200];

	if(pActiveDoc == 0)
		return;
	if(id != IDCM_FILE_DELETE) {
		CFileOperationDlg	dlg(id, pActiveDoc->GetPathName());
		dlg.Create(m_hInstance, IDD_DLG_FILEOPERATION, m_pMainWindow->m_hWnd);
		if(dlg.DoModal() == IDOK) {
			switch(id) {
			case IDCM_FILE_COPY:	ops = pActiveDoc->CopyCurrentFile(dlg.m_strFilePath.c_str());	break;
			case IDCM_FILE_MOVE:
			case IDCM_FILE_RENAME:	ops = pActiveDoc->MoveCurrentFile(dlg.m_strFilePath.c_str());	break;
			}
		}
	} else {
		ops = pActiveDoc->DeleteCurrentFile();
		if(ops == OPS_OK)
			OnFileClose();
	}

	// ^Cgo[ƃ^uXV
	UpdateTitleBar();

	// G[bZ[W̐
	switch(ops) {
	case OPS_OK:
	case OPS_ABORTED:
		return;
	case OPS_ALREADYEXISTS:
		LoadString(100, wszError, 200);
		break;
	case OPS_OPENEDASREADONLY:
		LoadString(101, wszError, 200);
		break;
	case OPS_CANNOTOPEN:
		LoadString(102, wszError, 200);
		break;
	case OPS_UNKNOWNERROR:
		LoadString(103, wszError, 200);
		::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, 0, ::GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), wszError + wcslen(wszError), 200, 0);
		break;
	}
	m_pMainWindow->MessageBox(wszError, IDS_APPNAME, MB_ICONEXCLAMATION);
}

///	[vpeB] _CAO̕\
void CAlphaApp::OnFileProperty() {
	CAlphaDoc*			pActiveDoc = GetActiveDocument();
	CFilePropertyDlg	dlg;

	if(pActiveDoc == 0) {
		::MessageBeep(MB_OK);
		return;
	}

	dlg.m_pDocument = pActiveDoc;
	dlg.m_strDocTypeName = m_vecDocumentTypes[pActiveDoc->m_iDocType].strName;
	dlg.Create(m_hInstance, IDD_DLG_FILEPROPERTY, m_pMainWindow->m_hWnd);
	dlg.DoModal();
}

///	݊JĂt@CۑɕAJ
void CAlphaApp::OnFileReopen() {
	CAlphaDoc*	pActiveDoc = GetActiveDocument();

	if(pActiveDoc == 0)
		return;
	wstring	strPathName = pActiveDoc->GetPathName();
	if(strPathName.empty())
		return;

	if(!pActiveDoc->IsModified()
			|| IDYES == MessageBox(MSG_FILE_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION)) {
		pActiveDoc->GetController()->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			strPathName, pActiveDoc->GetShareMode(), pActiveDoc->GetCodePage());
		HandleFileOpenError(ss);
	}
}

///	݊JĂt@CۑɕAR[hy[Ww肵ĊJ
void CAlphaApp::OnFileReopenWithCodepage() {
	CCodePagesDlg	dlg;
	CAlphaDoc*		pActiveDoc = GetActiveDocument();

	if(pActiveDoc == 0)
		return;
	if(pActiveDoc->GetPathName().empty())
		return;
	if(pActiveDoc->IsModified() &&
			IDNO == MessageBox(MSG_FILE_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION))
		return;

	dlg.Create(m_hInstance, IDD_DLG_CODEPAGES, m_pMainWindow->m_hWnd);
	dlg.m_nCodePage = GetActiveDocument()->GetCodePage();
	if(dlg.DoModal() == IDOK) {
		pActiveDoc->GetController()->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			pActiveDoc->GetPathName(), pActiveDoc->GetShareMode(), dlg.m_nCodePage);
		HandleFileOpenError(ss);
	}
}

/**
 *	t@C㏑ۑBt@C݂ȂƂ CAlphaApp::OnFileSaveAs Ăяo
 *	@param iTab			^uԍB-1ƃANeBuȃ^u
 *	@return				 (ۑKvꍇ true)
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSave(unsigned int iTab /* = -1 */) throw(out_of_range) {
	IAlphaTab*		pTab = 0;
	CAlphaDoc*		pDocument = 0;
	StreamStatus	ss;
	UINT			nCurrentCP;
	bool			bWriteBOM = false;

	if(iTab == -1)
		iTab = GetActiveTabIndex();
	try {
		pTab = GetTab(iTab);
	} catch(out_of_range&) {
		throw;
	}
	if(!pTab->IsTextEditor())
		return false;
	pDocument = static_cast<CAlphaEditController*>(pTab)->GetDocument();
	if(!pDocument->GetPathName().empty() && !pDocument->IsModified())
		return true;

	// t@C݂邩
	if(!::PathFileExistsW(pDocument->GetPathName().c_str()))
		return OnFileSaveAs(iTab);

	nCurrentCP = pDocument->GetCodePage();
	switch(nCurrentCP) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF8", 0));
		break;
	case EXTCP_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16LE", 1));
		break;
	case EXTCP_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16bE", 1));
		break;
	case EXTCP_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32LE", 1));
		break;
	case EXTCP_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	do {
		ss = pDocument->SaveDocument(pDocument->GetPathName(), sdo, BT_AUTO, nCurrentCP);
		if(ss == SS_OK)
			m_pMRUManager->Add(pDocument->GetPathName());
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			wstring	strPrompt = LoadString(IDS_FILECONTAINSILLEGALCHARACTER);
			wchar_t	wszPrompt[1024];
			swprintf(wszPrompt, strPrompt.c_str(), pDocument->GetPathName().c_str());
			if(IDYES == m_pMainWindow->MessageBox(
					wszPrompt, IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	if(iTab != GetActiveTabIndex()) {	// ANeBułȂ^uۑ
		wstring	strTitle = pTab->GetTabTitle();
		TCITEMW	item;
		item.mask = TCIF_TEXT;
		item.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_wndTab.SetItem(iTab, &item);
	}

	return true;
}

/**
 *	t@CSĕۑ
 *	@return	rŒfȂ true
 */
bool CAlphaApp::OnFileSaveAll() {
	for(unsigned int iDoc = 0; iDoc < m_vecDocuments.size(); ++iDoc) {	// SẴhLgۑ
		if(!OnFileSave(iDoc))
			return false;
	}
	return true;
}

/**
 *	t@Cw肵Oŕۑ
 *	@param iTab			^uԍB-1ƃANeBuȃ^u
 *	@return				
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSaveAs(unsigned int iTab /* = -1 */) throw(out_of_range) {
	IAlphaTab*		pTab = 0;
	CAlphaDoc*		pDocument = 0;
	StreamStatus	ss;
	OPENFILENAMEW	ofn;
	wchar_t			wszFilter[] = IDS_FILEFILTERW;
	wchar_t			wszFileName[MAX_PATH + 1] = L"";
	BreakType		bc = BT_AUTO;						// sR[h
	bool			bWriteBOM = false;

	if(iTab == -1)
		iTab = GetActiveTabIndex();
	try {
		pTab = GetTab(iTab);
	} catch(out_of_range&) {
		throw;
	}
	if(!pTab->IsTextEditor())
		return false;
	pDocument = static_cast<CAlphaEditController*>(pTab)->GetDocument();

	if(!pDocument->GetPathName().empty())
		wcscpy(wszFileName, pDocument->GetPathName().c_str());

	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_pMainWindow->m_hWnd;
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = wszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT /* | OFN_SHOWHELP*/;
	ofn.lCustData = MAKELPARAM(pDocument->GetCodePage(), bc);
	ofn.lpfnHook = CAlphaApp::OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_SAVEFILE);

	if(!::GetSaveFileNameW(&ofn))
		return false;

	switch(LOWORD(ofn.lCustData)) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF8", 0));
		break;
	case EXTCP_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16LE", 1));
		break;
	case EXTCP_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16BE", 1));
		break;
	case EXTCP_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32LE", 1));
		break;
	case EXTCP_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	do {
		ss = pDocument->SaveDocument(ofn.lpstrFile, sdo,
				static_cast<BreakType>(HIWORD(ofn.lCustData)), LOWORD(ofn.lCustData));
		if(ss == SS_OK)
			m_pMRUManager->Add(ofn.lpstrFile);
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			wstring	strPrompt = LoadString(IDS_FILECONTAINSILLEGALCHARACTER);
			wchar_t	wszPrompt[1024];
			swprintf(wszPrompt, strPrompt.c_str(), ofn.lpstrFile);
			if(IDYES == m_pMainWindow->MessageBox(
					wszPrompt, IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	if(iTab != GetActiveTabIndex()) {	// ANeBułȂ^uۑ
		wstring	strTitle = pTab->GetTabTitle();
		TCITEMW	item;
		item.mask = TCIF_TEXT;
		item.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_wndTab.SetItem(iTab, &item);
	}
	ModifyTabIcons();
	UpdateStatusBar();
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();

	return true;
}

///	[ׂă}[N]
void CAlphaApp::OnFindBookmarkAll() {
	CAlphaEditController*	pActiveCtrl = GetActiveTextEditor();
	EditViewFindFlag		evfFlags = 0;

	if(pActiveCtrl == 0)
		return;

	// ̍쐬
	if(m_dlgFind.m_bWholeWord)		evfFlags |= EVF_WHOLEWORD;
	if(m_dlgFind.m_bIgnoreCase)		evfFlags |= EVF_IGNORECASE;
	if(m_dlgFind.m_bIgnoreKanaType)	evfFlags |= EVF_IGNOREKANATYPE;

	unsigned long	cFound = pActiveCtrl->GetPrimaryView()->BookmarkAll(m_dlgFind.m_strFindWhat, evfFlags);
	if(cFound != 0)
		m_dlgFind.AddToHistory(m_dlgFind.m_strFindWhat, false);
}

///	[] _CAO̕\/\
void CAlphaApp::OnFindFind() {
	if(!GetActiveTab()->IsTextEditor())
		return;

	CAlphaView*	pActiveView = GetActiveTextEditor()->GetActiveView();
	bool		bOpen = false;

	if(m_dlgFind.IsWindow()) {
		if(!m_dlgFind.m_bType) {	// [u] _CAOɕ\Ă
			m_dlgFind.EndDialog(IDCANCEL);
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_FIND, true);
			m_dlgFind.m_bType = true;
			bOpen = true;
		} else {
			m_dlgFind.EndDialog(IDCANCEL);
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_FIND, false);
		}
	} else {
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_FIND, true);
		m_dlgFind.m_bType = true;
		bOpen = true;
	}

	if(bOpen) {
		m_dlgFind.m_strFindWhat = pActiveView->HasSelection() ?
			pActiveView->GetSelection() : pActiveView->GetNearestWordFromCaret();
		m_dlgFind.Create(m_hInstance, IDD_DLG_FIND, m_pMainWindow->m_hWnd);
		m_dlgFind.DoModeless();
	}
}

/**
 *	݂̌ɏ]ĎA͑O̕B
 *	̃\bh̓qbgIԂɂB
 *	܂A_CAO\ł@\
 *	@param bPrevious	true ɂƑO
 *	@param bNotice		true ɂƌsƂɃvvg\
 */
void CAlphaApp::OnFindFindNext(bool bPrevious /* = false */, bool bNotice /* = true */) {
	CAlphaEditController*	pActiveCtrl = GetActiveTextEditor();
	EditViewFindFlag		evfFlags = bPrevious ? EVF_BACKWARD : EVF_FORWARD;

	if(pActiveCtrl == 0)
		return;

	// ̍쐬
	if(m_dlgFind.m_bWholeWord)		evfFlags |= EVF_WHOLEWORD;
	if(m_dlgFind.m_bIgnoreCase)		evfFlags |= EVF_IGNORECASE;
	if(m_dlgFind.m_bIgnoreKanaType)	evfFlags |= EVF_IGNOREKANATYPE;

	if(pActiveCtrl->GetActiveView()->FindNext(m_dlgFind.m_strFindWhat, evfFlags))
		m_dlgFind.AddToHistory(m_dlgFind.m_strFindWhat, false);
	else if(bNotice && m_bShowMessageBoxOnFind)
		MessageBox(MSG_SEARCH_TEXTNOTFOUND, MB_ICONINFORMATION);
	if(m_dlgFind.IsWindow()) {
		if(m_dlgFind.m_bAutoClose)	// [_CAO]
			m_pMainWindow->SendMessage(WM_COMMAND, m_dlgFind.m_bType ? IDCM_FIND_FIND : IDCM_FIND_REPLACE);
		else
			::SetFocus(m_dlgFind.GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	AEgC͂s_CAO\B
 *	݂̃hLg^CvɌꂪݒ肳ĂȂꍇ̓G[bZ[Wo
 */
void CAlphaApp::OnFindParseOutline() {
	CAlphaDoc*		pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	const wstring&	strLanguage = m_vecDocumentTypes[pActiveDoc->m_iDocType].strLanguageForOutlineParsing;

	if(m_dlgOutline.IsWindow()) {	// _CAOJĂΕ邾
		m_dlgOutline.EndDialog(IDCANCEL);
		return;
	}

	if(strLanguage == L"JScript")
		m_dlgOutline.m_oplLanguage = OPL_JSCRIPT;
	else if(strLanguage == L"VBScript")
		m_dlgOutline.m_oplLanguage = OPL_VBSCRIPT;
	else {
		wchar_t	wszMessage[256];
		LoadString(116, wszMessage, 256);
		m_pMainWindow->MessageBox(wszMessage, IDS_APPNAME, MB_ICONEXCLAMATION);
		return;
	}

	m_dlgOutline.Create(m_hInstance, IDD_DLG_OUTLINE, m_pMainWindow->m_hWnd);
	m_dlgOutline.Parse(pActiveDoc);
}

///	[u] _CAO̕\/\
void CAlphaApp::OnFindReplace() {
	if(!GetActiveTab()->IsTextEditor())
		return;

	CAlphaView*	pActiveView = GetActiveTextEditor()->GetActiveView();
	bool		bOpen = false;

	if(m_dlgFind.IsWindow()) {
		if(m_dlgFind.m_bType) {	// [] _CAOɕ\Ă
			m_dlgFind.EndDialog(IDCANCEL);
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_FIND, false);
			m_dlgFind.m_bType = false;
			m_dlgFind.m_bHasSelection = pActiveView->HasSelection();
			bOpen = true;
		} else
			m_dlgFind.EndDialog(IDCANCEL);
	} else {
		m_dlgFind.m_bType = false;
		m_dlgFind.m_bHasSelection = pActiveView->HasSelection();
		bOpen = true;
	}

	if(bOpen) {
		m_dlgFind.m_strFindWhat = pActiveView->HasSelection() ?
			pActiveView->GetSelection() : pActiveView->GetNearestWordFromCaret();
		m_dlgFind.Create(m_hInstance, IDD_DLG_REPLACE, m_pMainWindow->m_hWnd);
		m_dlgFind.DoModeless();
	}
}

/**
 *	݈ʒuȍ~̌SĒuB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAll() {
	unsigned int		cReplaced;
	CAlphaDoc*			pActiveDoc = GetActiveDocument();
	CAlphaView*			pActiveView = 0;
	EditViewFindFlag	evfFlags = 0;

	if(!GetActiveTab()->IsTextEditor())
		return;

	// ̍쐬
	if(m_dlgFind.m_bWholeWord)		evfFlags |= EVF_WHOLEWORD;
	if(m_dlgFind.m_bIgnoreCase)		evfFlags |= EVF_IGNORECASE;
	if(m_dlgFind.m_bIgnoreKanaType)	evfFlags |= EVF_IGNOREKANATYPE;

	pActiveView = GetActiveTextEditor()->GetActiveView();
	cReplaced = pActiveView->ReplaceAll(m_dlgFind.m_strFindWhat, m_dlgFind.m_strReplaceWith, evfFlags);

	// ʂ̏o
	if(m_bShowMessageBoxOnFind) {
		if(cReplaced != 0)
			MessageBox(MSG_SEARCH_REPLACESUCCEEDED, MB_ICONINFORMATION, CMessageArguments() % cReplaced);
		else
			MessageBox(MSG_SEARCH_TEXTNOTFOUND, MB_ICONINFORMATION);
	}

	if(cReplaced != 0) {	// ɒǉ
		m_dlgFind.AddToHistory(m_dlgFind.m_strFindWhat, false);
		m_dlgFind.AddToHistory(m_dlgFind.m_strReplaceWith, true);
	}
	if(m_dlgFind.IsWindow()) {
		if(m_dlgFind.m_bAutoClose)	// [ׂĒu_CAO]
			m_pMainWindow->SendMessage(WM_COMMAND, m_dlgFind.m_bType ? IDCM_FIND_FIND : IDCM_FIND_REPLACE);
		else
			::SetFocus(m_dlgFind.GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	݂̑I͈͂łΒusB
 *	uA͑I͈͂Ŗꍇ͎̌IԂɂB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAndNext() {
	if(!GetActiveTab()->IsTextEditor())
		return;

	CAlphaEditController*	pActiveCtrl = GetActiveTextEditor();
	CAlphaView*				pActiveView = pActiveCtrl->GetActiveView();
	EditViewFindFlag		evf = 0;

	if(m_dlgFind.m_bReplaceBackward)	evf |= EVF_BACKWARD;
	if(m_dlgFind.m_bWholeWord)			evf |= EVF_WHOLEWORD;
	if(m_dlgFind.m_bIgnoreCase)			evf |= EVF_IGNORECASE;
	if(m_dlgFind.m_bIgnoreKanaType)		evf |= EVF_IGNOREKANATYPE;

	if(pActiveView->ReplaceAndFindNext(m_dlgFind.m_strFindWhat, m_dlgFind.m_strReplaceWith, evf))	// u
		m_dlgFind.AddToHistory(m_dlgFind.m_strReplaceWith, true);
	else if(m_bShowMessageBoxOnFind)
		MessageBox(MSG_SEARCH_TEXTNOTFOUND, MB_ICONINFORMATION);

	if(m_dlgFind.IsWindow()) {
//		if(m_dlgFind.m_bAutoClose && m_dlgFind.IsWindow())	// [_CAO]
//			m_pMainWindow->SendMessage(WM_COMMAND, m_dlgFind.m_bType ? IDCM_FIND_FIND : IDCM_FIND_REPLACE);
//		else
			::SetFocus(m_dlgFind.GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

///	[ubN}[N̐ݒ/]
void CAlphaApp::OnFindToggleBookmark() {
	CCharPos	posBegin, posEnd;
	CAlphaView*	pActiveView = GetActiveTextEditor()->GetPrimaryView();

	pActiveView->GetSel(posBegin, posEnd);
	pActiveView->ToggleBookmark(posEnd.m_iLine);
}

///	[o[W] _CAO̕\
void CAlphaApp::OnHelpAbout() {
	CAboutDlg	oDlg;
	oDlg.Create(m_hInstance, IDD_DLG_ABOUT, m_pMainWindow->m_hWnd);
	oDlg.DoModal();
}

///	[ʐݒ] _CAO̕\
void CAlphaApp::OnToolCommonOption() {
	CCommonOptionSheet	oSheet(L"ʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CFileOptionDlg		oFileOptionPG;
	CEditOptionDlg		oEditOptionPG;
	CFindOptionDlg		oFindOptionPG;
	CViewOptionDlg		oViewOptionPG;
	CStyleOptionDlg		oStyleOptionPG;
	CKeyBindsOptionDlg	oKeyBindsOptionPG(this, &m_oKeyboardMap);
	CCodePageOptionDlg	oCodePagesOptionPG;
	CScriptOptionDlg	oScriptOptionPG(&m_oScriptLanguages);

	// [t@C] ^u
	oFileOptionPG.m_nShareMode = GetProfileInt(L"File", L"nShareMode", 1);
	oFileOptionPG.m_bWriteBOMAsUTF8 = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF8", 0));
	oFileOptionPG.m_bWriteBOMAsUTF16LE = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF16BE = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF16BE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32LE = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32BE = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsUTF32BE", 1));
	oFileOptionPG.m_bWriteBOMAsISO2022CN = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022CN", 0));
	oFileOptionPG.m_bWriteBOMAsISO2022KR = toBoolean(GetProfileInt(L"File", L"bWriteBOMAsISO2022KR", 0));
	oFileOptionPG.m_bUseSystemACP = toBoolean(GetProfileInt(L"File", L"bUseSystemCP", 1));
	oFileOptionPG.m_nCustomCP = GetProfileInt(L"File", L"nCustomCP", 65001);
	oFileOptionPG.m_breakType = static_cast<BreakType>(GetProfileInt(L"File", L"nBreakType", BT_CRLF));
	oFileOptionPG.m_bAutoSave = toBoolean(GetProfileInt(L"File", L"bUseAutoSave", 0));
	oFileOptionPG.m_nInterval = GetProfileInt(L"File", L"nAutoSaveInterval", 300);
	oFileOptionPG.m_nMRULimit = GetProfileInt(L"File", L"nMRULimit", 8);
	oFileOptionPG.m_bSendAsAttachment = toBoolean(GetProfileInt(L"File", L"bSendMailAsAttachment", 1));
	oFileOptionPG.Construct(IDD_DLGPAGE_OPTION_FILE, L"t@C");
	oSheet.AddPage(&oFileOptionPG);

	// [ҏW] ^u
	oEditOptionPG.m_bCancelAfterCopy = m_bCancelSelAfterCopy;
	oEditOptionPG.m_bUseCurrentBreak = toBoolean(GetProfileInt(L"Edit", L"bUseCurrentBreakAsCopy", 0));
	oEditOptionPG.m_bLimitUndoHistory = toBoolean(GetProfileInt(L"Edit", L"bLimitUndoHistoryLength", 0));
	oEditOptionPG.m_bConcatSuccessiveChars = toBoolean(GetProfileInt(L"Edit", L"bConcatSuccessiveChars", 1));
	oEditOptionPG.m_nUndoLimit = GetProfileInt(L"Edit", L"nUndoLimit", 100);
	oEditOptionPG.Construct(IDD_DLGPAGE_OPTION_EDIT, L"ҏW");
	oSheet.AddPage(&oEditOptionPG);

	// [] ^u
	oFindOptionPG.m_bShowMessageBox = m_bShowMessageBoxOnFind;
	oFindOptionPG.m_bInitializeFromEditor = m_bInitializeFindTextFromEditor;
	oFindOptionPG.Construct(IDD_DLGPAGE_OPTION_FIND, L"");
	oSheet.AddPage(&oFindOptionPG);

	// [\] ^u
	oViewOptionPG.m_bVisibleToolbar = toBoolean(::IsWindowVisible(m_hRebar));
	oViewOptionPG.m_bVisibleStatusBar = toBoolean(::IsWindowVisible(m_hStatusBar));
	oViewOptionPG.m_nLeftMargin = m_nLeftMargin;
	oViewOptionPG.m_nTopMargin = m_nTopMargin;
	oViewOptionPG.m_nStartupWindowPos = GetProfileInt(L"View", L"nStartupWindowPos", 0);
	if(!GetProfileStruct(L"View", L"rectSpecified", &oViewOptionPG.m_rectSpecifiedWindow, sizeof(RECT)))
		::SetRect(&oViewOptionPG.m_rectSpecifiedWindow, 0, 0, 760, 480);
	oViewOptionPG.Construct(IDD_DLGPAGE_OPTION_VIEW, L"\");
	oSheet.AddPage(&oViewOptionPG);

	// [X^C] ^u
	oStyleOptionPG.m_vecDocStyles = m_vecDocStyleTypes;
	oStyleOptionPG.Construct(IDD_DLGPAGE_OPTION_STYLE, L"X^C");
	oSheet.AddPage(&oStyleOptionPG);

	// [L[蓖] ^u
	oKeyBindsOptionPG.Construct(IDD_DLGPAGE_OPTION_KEYBINDS, L"L[蓖");
	oSheet.AddPage(&oKeyBindsOptionPG);

	// [R[hy[W]
	oCodePagesOptionPG.Construct(IDD_DLGPAGE_OPTION_CODEPAGE, L"R[hy[W");
	oSheet.AddPage(&oCodePagesOptionPG);

	// [XNvg] ^u
	oScriptOptionPG.Construct(IDD_DLGPAGE_OPTION_SCRIPT, L"XNvg");
	oSheet.AddPage(&oScriptOptionPG);

	if(oSheet.DoModal() == IDOK) {	// ݒ INI t@Cɕۑ
		WriteProfileInt(L"File", L"nShareMode", oFileOptionPG.m_nShareMode);
		WriteProfileInt(L"File", L"bUseAutoSave", oFileOptionPG.m_bAutoSave);
		WriteProfileInt(L"File", L"nAutoSaveInterval", oFileOptionPG.m_nInterval);
		WriteProfileInt(L"File", L"bWriteBOMAsUTF8", oFileOptionPG.m_bWriteBOMAsUTF8 ? 1 : 0);
		WriteProfileInt(L"File", L"bWriteBOMAsUTF16LE", oFileOptionPG.m_bWriteBOMAsUTF16LE ? 1 : 0);
		WriteProfileInt(L"File", L"bWriteBOMAsUTF16BE", oFileOptionPG.m_bWriteBOMAsUTF16BE ? 1 : 0);
		WriteProfileInt(L"File", L"bWriteBOMAsUTF32LE", oFileOptionPG.m_bWriteBOMAsUTF32LE ? 1 : 0);
		WriteProfileInt(L"File", L"bWriteBOMAsUTF32BE", oFileOptionPG.m_bWriteBOMAsUTF32BE ? 1 : 0);
		WriteProfileInt(L"File", L"nMRULimit", oFileOptionPG.m_nMRULimit);
		WriteProfileInt(L"File", L"bSendMailAsAttachment", oFileOptionPG.m_bSendAsAttachment ? 1 : 0);

		WriteProfileInt(L"Edit", L"bCancelSelectionAfterCopy", oEditOptionPG.m_bCancelAfterCopy);

		WriteProfileInt(L"View", L"nLeftMargin", oViewOptionPG.m_nLeftMargin);
		WriteProfileInt(L"View", L"nTopMargin", oViewOptionPG.m_nTopMargin);
		WriteProfileInt(L"View", L"bVisibleToolbar", oViewOptionPG.m_bVisibleToolbar);
		WriteProfileInt(L"View", L"bVisibleStatusBar", oViewOptionPG.m_bVisibleStatusBar);

		WriteProfileInt(L"Find", L"bShowMessageBox", oFindOptionPG.m_bShowMessageBox ? 1 : 0);
		WriteProfileInt(L"Find", L"bInitializeFromEditor", oFindOptionPG.m_bInitializeFromEditor ? 1 : 0);

		if(oFileOptionPG.m_bClearedMRU)
			m_pMRUManager->Clear();

		LoadINISettings();	// INI t@C̐ݒAvP[Vɔf
	}
}

///	[c[]-[fobO]-[u[N|Cg̊Ǘ]
void CAlphaApp::OnToolDebugBreakPoints() {
	BreakPointList							listBreakPoints;
	list<TAppDefinedLine>					listLineAttrs;
	list<TAppDefinedLine>::const_iterator	it;

	if(GetActiveTab()->IsTextEditor()) {
		// AvP[Vsu[N|Cgɕϊ
		CAlphaView*		pActiveView = GetActiveTextEditor()->GetPrimaryView();
		TBreakPointInfo	bpi;

		pActiveView->GetAllLineParams(listLineAttrs);
		for(it = listLineAttrs.begin(); it != listLineAttrs.end(); ++it) {
			if(it->dwParam & LA_BREAKPOINT_ENABLED)
				bpi.bEnabled = true;
			else if(it->dwParam & LA_BREAKPOINT_DISABLED)
				bpi.bEnabled = false;
			else
				continue;
			bpi.iLine = it->iLine;
			listBreakPoints.push_back(bpi);
		}

		m_pdlgDebugBreakPoints->m_listBreakPoints = listBreakPoints;
		if(IDOK == m_pdlgDebugBreakPoints->DoModal()) {
			// u[N|Cgݒ肵
			unsigned long	cLines = pActiveView->GetDocument()->GetLineCount();

			for(unsigned long iLine = 0; iLine < cLines; ++iLine)	// xSĉ
				pActiveView->SetLineParam(iLine, LA_NONE, LA_BREAKPOINT_MASK);
			for(BreakPointList::const_iterator it
					= m_pdlgDebugBreakPoints->m_listBreakPoints.begin();
					it != m_pdlgDebugBreakPoints->m_listBreakPoints.end(); ++it)	// ݒ肷
				pActiveView->SetLineParam(it->iLine, it->bEnabled ?
					LA_BREAKPOINT_ENABLED : LA_BREAKPOINT_DISABLED, LA_BREAKPOINT_MASK);
		}
	}
}


///	[c[]-[fobO]-[R[X^bN]
void CAlphaApp::OnToolDebugCallStack() {
	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugCallStack->IsWindow()) {
			m_pdlgDebugCallStack->DoModeless();
			m_pdlgDebugCallStack->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
	}
}

///	[c[]-[fobO]-[C~fBGCg]
void CAlphaApp::OnToolDebugImmediate() {
	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugImmediate->IsWindow()) {
			m_pdlgDebugImmediate->DoModeless();
			m_pdlgDebugImmediate->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
	}
}

///	[c[]-[fobO]-[u[N|Cg̑}//폜]
void CAlphaApp::OnToolDebugInsertBreakPoint() {
	if(GetActiveTab()->IsTextEditor()) {
		CCharPos				posBegin, posEnd;
		CAlphaEditController*	pController = GetActiveTextEditor();
		CAlphaView*				pView = pController->GetPrimaryView();
		DWORD					dwLineAttr;

		pView->GetSel(posBegin, posEnd);
		dwLineAttr= pView->GetLineParam(posEnd.m_iLine);
		if(dwLineAttr & LA_BREAKPOINT_ENABLED) {	// L -> 
			dwLineAttr &= ~LA_BREAKPOINT_ENABLED;
			dwLineAttr |= LA_BREAKPOINT_DISABLED;
		} else if(dwLineAttr & LA_BREAKPOINT_DISABLED)	//  -> 폜
			dwLineAttr &= ~LA_BREAKPOINT_DISABLED;
		else	//  -> L
			dwLineAttr |= LA_BREAKPOINT_ENABLED;
		pView->SetLineParam(posEnd.m_iLine, dwLineAttr);
	}
}

///	[c[]-[fobO]-[Jn]
void CAlphaApp::OnToolDebugStart() {
	if(!GetActiveTab()->IsTextEditor())
		return;
	if(m_pActiveDebugger != 0) {	// fobOłΑs
		m_pActiveDebugger->Continue();
		return;
	}

	Alpha::BreakPointList	listBreakPoints;
	list<TAppDefinedLine>	listLines;
	CAlphaDoc*				pActiveDoc = GetActiveDocument();
	Alpha::TBreakPointInfo	bpi;
	wstring					strLanguageName = m_oScriptLanguages.LanguageNameFromExtension(pActiveDoc->GetExtensionName());

	// GWŶꍇ̓_CAOŐu
	if(strLanguageName.empty()) {
		CSelectLanguageDlg	oDlg;

		oDlg.m_setLanguages = m_oScriptLanguages.GetLanguages();
		oDlg.Create(m_hInstance, IDD_DLG_SELECTLANGUAGE, m_pMainWindow->m_hWnd);
		if(IDOK != oDlg.DoModal())
			return;
		strLanguageName = oDlg.m_strSelection;
	}

	// fobOT|[gĂȂꍇɑs邩q˂
	if(!CScriptLanguageManager::QueryDebuggable(strLanguageName)
			&& IDNO == MessageBox(MSG_DEBUG_ENGINENOTSUPPORTDEBUGGING, MB_YESNO | MB_ICONQUESTION))
		return;

	m_pDebuggingEditor = GetActiveTextEditor();
	m_pDebuggingEditor->GetPrimaryView()->GetAllLineParams(listLines);
	for(list<TAppDefinedLine>::const_iterator it = listLines.begin(); it != listLines.end(); ++it) {
		if(it->dwParam & LA_BREAKPOINT_ENABLED)
			bpi.bEnabled = true;
		else if(it->dwParam & LA_BREAKPOINT_DISABLED)
			bpi.bEnabled = false;
		else
			continue;
		bpi.iLine = it->iLine;
		listBreakPoints.push_back(bpi);
	}

	m_pActiveDebugger = new CAlphaApplicationDebugger(m_pMainWindow->m_hWnd, listBreakPoints);
	m_pActiveDebugger->AddRef();
	m_pActiveDebugger->SetEventListener(static_cast<IAlphaApplicationDebuggerEventListener*>(this));
	m_pActiveDebugger->StartDebugging(pActiveDoc, strLanguageName);
}

///	[c[]-[fobO]-[Xbh]
void CAlphaApp::OnToolDebugThreads() {
	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugThreads->IsWindow()) {
			CComPtr<IRemoteDebugApplication>	pApplication;
			m_pActiveDebugger->GetDebuggingApplication(&pApplication);
			m_pdlgDebugThreads->DoModeless();
			m_pdlgDebugThreads->Update(pApplication);
		} else
			m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}
}

///	[c[]-[fobO]-[ϐ]
void CAlphaApp::OnToolDebugVariables() {
	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugVariables->IsWindow()) {
			m_pdlgDebugVariables->DoModeless();
			m_pdlgDebugVariables->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugVariables->SendMessage(WM_CLOSE);
	}
}

///	[^Cvʐݒ] _CAO̕\
void CAlphaApp::OnToolDocTypeOption() {
	CAlphaDoc*					pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	CPropertySheet		oSheet(L"^Cvʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CDocTypeOptionDlg	oDocTypeOptionPG;

	oDocTypeOptionPG.m_vecDocTypes = m_vecDocumentTypes;
	oDocTypeOptionPG.m_iActiveType = 0;
	oDocTypeOptionPG.Construct(IDD_DLGPAGE_DOCTYPEOPTION, L"C\ƃCAEg");
	oSheet.AddPage(&oDocTypeOptionPG);

	if(oSheet.DoModal()) {
	}
}

///	[s]
void CAlphaApp::OnToolExecute() {
	wchar_t			wsz[256];
	const wchar_t*	pwszExecutePath = 0;

	swprintf(wsz, L"DocumentTypes(%d)", GetActiveDocument()->m_iDocType);
	pwszExecutePath = GetProfileString(wsz, L"strExecutePath");

	if(wcslen(pwszExecutePath) == 0)	// pXݒ肳ĂȂ
		MessageBox(MSG_TOOL_EXENOTREGISTERED, MB_ICONEXCLAMATION,
			CMessageArguments() % m_vecDocumentTypes[GetActiveDocument()->m_iDocType].strName);
	else {
		wchar_t*	pwszParameter = new wchar_t[GetActiveDocument()->GetPathName().length() + 3];

		swprintf(pwszParameter, L"\"%s\"", GetActiveDocument()->GetPathName().c_str());
		if(32 >= reinterpret_cast<int>(::ShellExecute(
				::GetDesktopWindow(), L"open", pwszExecutePath, pwszParameter, 0, SW_SHOWDEFAULT)))
			MessageBox(MSG_TOOL_FAILEDTORUNEXE, MB_ICONEXCLAMATION);
		delete[] pwszParameter;
	}
}

///	[R}h̎s]
void CAlphaApp::OnToolExecuteCommand() {
	CExecuteCommandDlg	dlg(this);

	dlg.m_bHijackConsole = toBoolean(GetProfileInt(L"CommandExecuting", L"bHijackConsole", 1));
	dlg.m_bUseUnicode = toBoolean(GetProfileInt(L"CommandExecuting", L"bUseUnicode", 0));
	dlg.Create(m_hInstance, IDD_DLG_EXECUTECOMMAND, m_pMainWindow->m_hWnd);
	dlg.DoModal();
}

///	[tHg] _CAO̕\
void CAlphaApp::OnToolFont() {
	CHOOSEFONT	cf;
	CAlphaDoc*	pActiveDoc = GetActiveDocument();

	if(pActiveDoc == 0)
		return;

	ZeroMemory(&cf, sizeof(CHOOSEFONT));
	cf.lStructSize = sizeof(CHOOSEFONT);
	cf.hwndOwner = m_pMainWindow->m_hWnd;
	cf.lpLogFont = &m_lfCommonFont;
	cf.Flags = /*CF_ENABLETEMPLATE | */ CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS;
	cf.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_FONTFOOTER);
	cf.hInstance = m_hInstance;

	if(!::ChooseFont(&cf))
		return;

	// SẴr[̃tHgXV
	CAlphaView*	pView = 0;
	for(unsigned int i = 0; i < m_vecDocuments.size(); ++i) {
		if(!m_vecDocuments[i]->IsTextEditor())
			continue;
		static_cast<CAlphaEditController*>(m_vecDocuments[i])->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, true);
	}

	// INI t@Cɕۑ
	WriteProfileStruct(L"View", L"oFont.pLogfont", &m_lfCommonFont, sizeof(LOGFONT));

	//  <-> ϕŕ\LςKv
	UpdateStatusBar();
}

///	@see	IClipboardRingEventListener::OnClipboardRingChanged
void CAlphaApp::OnClipboardRingChanged() {
}

///	@see	IClipboardRingEventListener::OnClipboardRingDeniedAdding
void CAlphaApp::OnClipboardRingDeniedAdding() {
}

///	@see	WM_CLOSE
bool CAlphaApp::OnClose() {
	if(OnFileCloseAll())
		return m_wndTab.DestroyWindow(), true;
	return false;
}

///	@see	IEditViewEventListener::OnChangeLines
void CAlphaApp::OnChangeLines(unsigned long iLine, unsigned long cLines) {
}

///	@see	CWindow::OnCommand
bool CAlphaApp::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	IAlphaTab*		pActiveTab = GetActiveTab();
	CAlphaDoc*		pActiveDoc = GetActiveDocument();
	CAlphaView*		pActiveView = 0;
	ofstream*		pOutputFile = 0;
//	VIEW_POSITION	pos;
	unsigned long	iTab;

	if(!GetActiveTab()->IsTextEditor())	// _ł͉Ȃ
		return true;
	pActiveView = GetActiveTextEditor()->GetActiveView();

	switch(wID) {
	case IDCM_FILE_NEW:	// [VK]
		OnFileNew(::GetACP());
		break;
	case IDCM_FILE_NEWWITHFORMAT:	// [w肵ĐVK]
		OnFileNewWithFormat();
		break;
	case IDCM_FILE_OPEN:	// [J]
		OnFileOpen();
		break;
	case IDCM_FILE_REOPEN:	// [J]
		OnFileReopen();
		break;
	case IDCM_FILE_REOPENWITHCODEPAGE:	// [R[hy[WύXĊJ]
		OnFileReopenWithCodepage();
		break;
	case IDCM_FILE_CLOSE:	// []
		OnFileClose(true);
		break;
	case IDCM_FILE_CLOSEALL:	// [ׂĕ]
		OnFileCloseAll();
		break;
	case IDCM_FILE_SAVE:	// [㏑ۑ]
		OnFileSave();
		break;
	case IDCM_FILE_SAVEAS:	// [Otĕۑ]
		if(OnFileSaveAs())
			ApplyDocumentType(m_iActiveTab);
		break;
	case IDCM_FILE_SAVEALL:	// [ׂĕۑ]
		OnFileSaveAll();
		break;
	case IDCM_FILE_PROPERTY:	// [vpeB]
		OnFileProperty();
		break;
	case IDCM_FILE_RENAME:	// [O̕ύX]
	case IDCM_FILE_COPY:	// [Rs[]
	case IDCM_FILE_MOVE:	// [ړ]
	case IDCM_FILE_DELETE:	// [폜]
		OnFileOperation(wID);
		break;
	case IDCM_FILE_SENDMAIL:	// [M]
		pActiveDoc->SendCurrentFile(toBoolean(GetProfileInt(L"File", L"bSendMailAsAttachment", 1)));
		break;
	case IDCM_FILE_EXIT:	// [Alpha ̏I]
		m_pMainWindow->SendMessage(WM_CLOSE);
		break;
	case IDCM_EDIT_UNDO:	// [ɖ߂]
		pActiveView->ExecCommand(CMDID_EDIT_UNDO);
		break;
	case IDCM_EDIT_REDO:	// [蒼]
		pActiveView->ExecCommand(CMDID_EDIT_REDO);
		break;
	case IDCM_EDIT_CUT:	// [؂]
		pActiveView->ExecCommand(CMDID_EDIT_CUT);
		break;
	case IDCM_EDIT_COPY:	// [Rs[]
		pActiveView->ExecCommand(CMDID_EDIT_COPY);
		break;
	case IDCM_EDIT_PASTE:	// [\t]
		pActiveView->ExecCommand(CMDID_EDIT_PASTE);
		break;
	case IDCM_EDIT_CLEAR:	// [폜]
		pActiveView->ExecCommand(CMDID_EDIT_DELETE);
		break;
	case IDCM_EDIT_SELECTALL:	// [ׂđI]
		pActiveView->ExecCommand(CMDID_MOVE_SELECTALL);
		break;
	case IDCM_EDIT_CANDIDATELIST:	// [P͌]
		pActiveView->ExecCommand(CMDID_EDIT_OPENCANDIDATEWINDOW);
		break;
	case IDCM_EDIT_TOGGLECHARCODEPOINT:	// [ƃR[h|Cg̕ϊ]
		pActiveView->ExecCommand(CMDID_EDIT_TOGGLECHARCODEPOINT);
		break;
	case IDCM_EDIT_MAKENEXTGRAVE:
	case IDCM_EDIT_MAKENEXTACUTE:
	case IDCM_EDIT_MAKENEXTCIRCUMFLEX:
	case IDCM_EDIT_MAKENEXTTILDE:
	case IDCM_EDIT_MAKENEXTDIAERESIS:
	case IDCM_EDIT_MAKENEXTRINGABOVE:
	case IDCM_EDIT_MAKENEXTCEDILLA:
	case IDCM_EDIT_MAKENEXTSTROKE:
	case IDCM_EDIT_MAKENEXTSHARP:
	case IDCM_EDIT_MAKENEXTETH:
	case IDCM_EDIT_MAKENEXTCOMBINED:
		pActiveView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, wID - IDCM_EDIT_MAKENEXTGRAVE + 1);
		break;
	case IDCM_EDIT_RELOADPLUGIN:	// [vOC] - [vOCt@C̍ēǂݍ]
		OnEditReloadPlugin();
		break;
	case IDCM_FIND_FIND:	// []
		OnFindFind();
		break;
	case IDCM_FIND_FINDNEXT:	// []
		OnFindFindNext(false, m_bShowMessageBoxOnFind);
		break;
	case IDCM_FIND_FINDPREV:	// [O]
		OnFindFindNext(true, m_bShowMessageBoxOnFind);
		break;
	case IDCM_FIND_BOOKMARKALL:	// [ׂă}[N]
		OnFindBookmarkAll();
		break;
	case IDCM_FIND_REPLACE:	// [u]
		OnFindReplace();
		break;
	case IDCM_FIND_REPLACEANDNEXT:	// [u]
		OnFindReplaceAndNext();
		break;
	case IDCM_FIND_REPLACEALL:	// [ׂĒu]
		OnFindReplaceAll();
		break;
	case IDCM_FIND_GOTOLINE:	// [wsɈړ]
		if(!m_pdlgGotoLine->IsWindow())
			m_pdlgGotoLine->DoModeless();
		else
			m_pdlgGotoLine->EndDialog(IDCANCEL);
		break;
	case IDCM_FIND_TOGGLEBOOKMARK:	// [ubN}[N̐ݒ/]
		OnFindToggleBookmark();
		break;
	case IDCM_FIND_NEXTBOOKMARK:	// [̃ubN}[N]
		pActiveView->ExecCommand(CMDID_MOVE_BOOKMARKNEXT);
		break;
	case IDCM_FIND_PREVBOOKMARK:	// [ÕubN}[N]
		pActiveView->ExecCommand(CMDID_MOVE_BOOKMARKPREV);
		break;
	case IDCM_FIND_CLEARBOOKMARKS:	// [ubN}[ÑNA]
		pActiveView->ClearBookmarks();
		break;
	case IDCM_FIND_BOOKMARKS:	// [ubN}[N̊Ǘ]
		if(!m_pdlgBookmark->IsWindow())
			m_pdlgBookmark->DoModeless();
		else
			m_pdlgBookmark->EndDialog(IDCANCEL);
		break;
	case IDCM_FIND_GOTOMATCHBRACKET:	// [ΊʂɈړ]
		pActiveView->ExecCommand(CMDID_MOVE_MATCHBRACKET);
		break;
	case IDCM_FIND_EXTENDTOMATCHBRACKET:	// [Ίʂ܂őIg]
		pActiveView->ExecCommand(CMDID_MOVE_MATCHBRACKETEXTEND);
		break;
	case IDCM_FIND_PARSEOUTLINE:	// [AEgC]
		OnFindParseOutline();
		break;
	case IDCM_TOOL_COMMONOPTION:	// [ʐݒ]
		OnToolCommonOption();
		break;
	case IDCM_TOOL_DOCUMENTTYPEOPTION:	// [hLg^Cvʐݒ]
		OnToolDocTypeOption();
		break;
	case IDCM_TOOL_FONT:	// [tHgݒ]
		OnToolFont();
		break;
	case IDCM_TOOL_KEYMACROPLAY:	// [L[}N̎s]
		pActiveView->CmdKeymacroPlay();
		break;
	case IDCM_TOOL_KEYMACRORECORD:	// [L[}N̋L^]
		pActiveView->CmdKeymacroRecord();
		break;
	case IDCM_TOOL_KEYMACROSTOP:	// [L[}N̋L^~]
		pActiveView->CmdKeymacroStop();
		break;
	case IDCM_TOOL_KEYMACROPAUSE:	// [L[}N̋L^ꎞ~]
		pActiveView->CmdKeymacroPause();
		break;
	case IDCM_TOOL_KEYMACROSAVE:	// [L[}N̕ۑ]
		pActiveView->CmdKeymacroSave(IDS_KEYMACROFILENAME);
		break;
	case IDCM_TOOL_KEYMACROCANCEL:	// [L[}NL^̒~]
		pActiveView->CmdKeymacroCancel();
		break;
	case IDCM_VIEW_TOOLBAR:	// [c[o[...]
		::ShowWindow(m_hRebar, ::IsWindowVisible(m_hRebar) ? SW_HIDE : SW_SHOW);
		OnSize(SIZE_RESTORED, -1, -1);
		break;
	case IDCM_VIEW_STATUSBAR:	// [Xe[^Xo[...]
		::ShowWindow(m_hStatusBar, ::IsWindowVisible(m_hStatusBar) ? SW_HIDE : SW_SHOW);
		OnSize(SIZE_RESTORED, -1, -1);
		break;
	case IDCM_VIEW_NEXTTAB:	// [̃^u]
		if(GetTabCount() > 1) {
			iTab = GetActiveTabIndex();
			iTab = (iTab + 1 != GetTabCount()) ? iTab + 1 : 0;
			SetActiveTab(iTab);
		}
		break;
	case IDCM_VIEW_PREVTAB:	// [Õ^u]
		if(GetTabCount() > 1) {
			iTab = GetActiveTabIndex();
			iTab = (iTab != 0) ? iTab - 1 : GetTabCount() - 1;
			SetActiveTab(iTab);
		}
		break;
	case IDCM_VIEW_SPLITVIEW:	// [EBhE]
		pActiveDoc->GetController()->SplitView(
			pActiveDoc->GetController()->IsSplit() ? 0 : -1);
		break;
/*	case IDCM_VIEW_NOWRAP:	// [܂ԂȂ]
		pActiveView->SetWrapMode(WPM_NONE);
		break;
	case IDCM_VIEW_WRAPBYSPECIFIEDWIDTH:	// [w蕝Ő܂Ԃ]
		pActiveView->SetWrapMode(WPM_SPECIFIED);
		break;
	case IDCM_VIEW_WRAPBYWINDOWWIDTH:	// [E[Ő܂Ԃ]
		pActiveView->SetWrapMode(WPM_WINDOW);
		break;
*/	case IDCM_VIEW_REPAINT:	// [ĕ`]
		pActiveTab->RefreshWindow();
		break;
	case IDCM_TOOL_EXECUTE:	// [s]
		OnToolExecute();
		break;
	case IDCM_TOOL_EXECUTECOMMAND:	// [R}hs]
		OnToolExecuteCommand();
		break;
	case IDCM_DEBUG_START:	// [fobO]-[Jn/s]
		OnToolDebugStart();
		break;
	case IDCM_DEBUG_STOP:	// [fobO]-[~]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->Abort();
		break;
	case IDCM_DEBUG_STEPOVER:	// [fobO]-[XebvI[o[]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOver();
		break;
	case IDCM_DEBUG_STEPINTO:	// [fobO]-[XebvC]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepInto();
		break;
	case IDCM_DEBUG_STEPOUT:	// [fobO]-[XebvAEg]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOut();
		break;
	case IDCM_DEBUG_INSERTBREAKPOINT:	// [fobO]-[u[N|Cg̑}/폜]
		OnToolDebugInsertBreakPoint();
		break;
	case IDCM_DEBUG_BREAKPOINTS:		// [fobO]-[u[N|Cg̊Ǘ]
		OnToolDebugBreakPoints();
		break;
	case IDCM_DEBUG_ACTIVEDOCUMENTS:	// [fobO]-[s̃hLg]
		if(m_pdlgDebugRunningDocuments->IsWindowVisible())
			m_pdlgDebugRunningDocuments->SendMessage(WM_CLOSE);
		else
			m_pdlgDebugRunningDocuments->DoModeless();
		break;
	case IDCM_DEBUG_CALLSTACK:	// [fobO]-[Ăяo]
		OnToolDebugCallStack();
		break;
	case IDCM_DEBUG_IMMEDIATE:	// [fobO]-[C~fBGCg]
		OnToolDebugImmediate();
		break;
	case IDCM_DEBUG_THREADS:	// [fobO]-[Xbh]
		OnToolDebugThreads();
		break;
	case IDCM_DEBUG_VARIABLES:	// [fobO]-[ϐ]
		OnToolDebugVariables();
		break;
	case IDCM_HELP_ABOUT:	// [o[W]
		OnHelpAbout();
		break;
	default:
		if(wID >= IDCM_FILE_MRULISTSTART && wID < IDCM_TOOL_DOCTYPELISTSTART) {	// [ŋߎgt@C]ȉ
			if(!OpenFile(m_pMRUManager->GetFilePathAt(wID - IDCM_FILE_MRULISTSTART), EXTCP_AUTO))
				m_pMRUManager->Remove(wID - IDCM_FILE_MRULISTSTART);
			break;
		} else if(wID >= IDCM_TOOL_DOCTYPELISTSTART && wID < IDCM_FILE_DOCTYPELISTSTART) {	// [KphLg]ȉ
			ApplyDocumentType(m_iActiveTab, wID - IDCM_TOOL_DOCTYPELISTSTART);
			break;
		} else if(wID >= IDCM_FILE_DOCTYPELISTSTART && wID < IDCM_EDIT_PLUGINLISTSTART) {	// [VK]hbv_E
			OnFileNew(::GetACP());
			ApplyDocumentType(m_iActiveTab, wID - IDCM_FILE_DOCTYPELISTSTART);
			break;
		} else if(wID >= IDCM_EDIT_PLUGINLISTSTART && wID < IDCM_EDIT_INSERTUNICODECHARSTART)
			if(!m_oPluginManager.ExecutePlugin(this, wID - IDCM_EDIT_PLUGINLISTSTART))
				m_pMainWindow->MessageBox(m_oPluginManager.GetLastErrorMessage().c_str(), IDS_APPNAME, MB_ICONEXCLAMATION);
		else if(wID >= IDCM_EDIT_INSERTUNICODECHARSTART)	// [Unicode 䕶̑}]A[Unicode 󔒕̑}]ȉ
			pActiveView->SendMessage(WM_CHAR, wID - IDCM_EDIT_INSERTUNICODECHARSTART);
		return false;
	}

	return true;
}

///	@see	WM_COPYDATA
void CAlphaApp::OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds) {
	vector<wstring>	vecArguments;
	GetCommandLineArguments(static_cast<wchar_t*>(pcds->lpData), vecArguments);
	vecArguments.erase(vecArguments.begin());
	ParseCommandLine(vecArguments);
}

///	@see	IEditViewEventListener::OnCreateLines
void CAlphaApp::OnCreateLines(unsigned long iLine, unsigned long cLines) {
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugEnd
void CAlphaApp::OnDebugEnd() {
	if(m_pActiveDebugger != 0) {
		m_pActiveDebugger->Release();
		m_pActiveDebugger = 0;
		m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(-1);
		m_pDebuggingEditor->GetDocument()->SetReadOnly(false);
		m_pDebuggingEditor = 0;
		m_wndOutput.WriteLine(OTT_DEBUG, L"fobOI܂ ----------------\r\n");

		// fobO_CAOЕt
		if(m_pdlgDebugCallStack->IsWindow())	m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
		if(m_pdlgDebugImmediate->IsWindow())	m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
		if(m_pdlgDebugVariables->IsWindow())	m_pdlgDebugVariables->SendMessage(WM_CLOSE);
		if(m_pdlgDebugThreads->IsWindow())		m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugIllegalStatus
void CAlphaApp::OnDebugIllegalStatus(DebugStatus ds) {
	wstring	strPrompt;

	switch(ds) {
	case DS_OK:
		return;
	case DS_FAILEDTOGETPDM:
		MessageBox(MSG_DEBUG_FAILEDTOGETPDM, MB_ICONEXCLAMATION);
		break;
	case DS_UNKNOWNSCRIPTLANGUAGE:
		MessageBox(MSG_DEBUG_INVALIDLANGUAGENAME, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTPARSER:
		MessageBox(MSG_DEBUG_ENGINENOTSUPPORTPARSING, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTDEBUGGING:
		return;
//		strPrompt = IDS_SENOTSUPPORTDEBUG;
//		break;
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStart
void CAlphaApp::OnDebugStart() {
	m_pDebuggingEditor->GetDocument()->SetReadOnly(true);
	m_wndOutput.Clear(OTT_DEBUG);
	m_wndOutput.WriteLine(OTT_DEBUG, L"fobOJn܂ ----------------");
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStepTo
void CAlphaApp::OnDebugStepTo(unsigned long iLine) {
	m_pDebuggingEditor->GetActiveView()->SetSelWithoutSelection(iLine, 0);
	m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(iLine);

	// fobO_CAO̍XV
	if(m_pdlgDebugCallStack->IsWindow())
		m_pdlgDebugCallStack->Update(m_pActiveDebugger);
	if(m_pdlgDebugVariables->IsWindow())
		m_pdlgDebugVariables->Update(m_pActiveDebugger);
	if(m_pdlgDebugThreads->IsWindow()) {
		CComPtr<IRemoteDebugApplication>	pApplication;
		m_pActiveDebugger->GetDebuggingApplication(&pApplication);
		m_pdlgDebugThreads->Update(pApplication);
	}

	// fobÕhLgANeBuɂ
	if(!GetActiveTab()->IsTextEditor() || m_pDebuggingEditor != GetActiveTextEditor()) {
		for(unsigned int iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
			if(m_vecDocuments[iTab]->IsTextEditor() && GetTextEditor(iTab) == m_pDebuggingEditor) {
				SetActiveTab(iTab);
				break;
			}
		}
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopAtBreakPoint
void CAlphaApp::OnDebugStopAtBreakPoint(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"u[N|CgŒ~܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopByError
void CAlphaApp::OnDebugStopByError(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"^CG[܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}

///	@see	IEditViewEventListener::OnDeleteLines
void CAlphaApp::OnDeleteLines(unsigned long iLine, unsigned long cLines) {
}

///	@see	CWindow::OnDestroy
void CAlphaApp::OnDestroy() {
	// nȂ (CAlphaApp::OnClose Q)
	m_pMainWindow->KillTimer(ID_TIMER_QUERYCOMMAND);

	wchar_t			wszKeyName[30];
	unsigned short	iItem;

	// EBhËʒuƃTCY̕ۑ
	RECT	rect;
	m_pMainWindow->GetWindowRect(&rect);
	WriteProfileStruct(L"View", L"rectLastWindowPos", &rect, sizeof(RECT));

	// MRU Xg̕ۑ
	for(iItem = 0; ; ++iItem) {
		swprintf(wszKeyName, L"strPath(%d)", iItem);
		if(iItem == m_pMRUManager->GetCount()) {
			WriteProfileString(L"MRU", wszKeyName, L"");
			break;
		} else
			WriteProfileString(L"MRU", wszKeyName, m_pMRUManager->GetFilePathAt(iItem).c_str());
	}

	// 񗚗̕ۑ
	list<wstring>					listFindWhat, listReplaceWith;
	list<wstring>::const_iterator	it;
	m_dlgFind.GetHistory(listFindWhat, listReplaceWith);
	for(iItem = 0, it = listFindWhat.begin(); it != listFindWhat.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
	for(iItem = 0, it = listReplaceWith.begin(); it != listReplaceWith.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");

	delete m_pMenu;
	delete m_pMRUManager;
	::DestroyWindow(m_hwndSeparator);
	::DestroyWindow(m_hToolbar);
	::DestroyWindow(m_hStatusBar);
	::DeleteObject(m_hTabFont);

	if(m_pXMLDoc != 0)
		m_pXMLDoc->Release();

	// r[SĔj
	for(unsigned int i = m_vecDocuments.size(); i != 0; --i) {
		m_vecDocuments[i - 1]->DeleteInstance();
	}

//	m_wndTab.SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(m_wndprocTab));

	m_oToolTip.DestroyWindow();

	::PostQuitMessage(0);
}

///	@see	IEditDocEventListener::OnDocumentModified
void CAlphaApp::OnDocumentModified() {
	UpdateTitleBar();
}

///	@see	IEditDocEventListener::OnDocumentOverwrittenByOtherProcess
void CAlphaApp::OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument) {
	if(IDYES == MessageBox(MSG_FILE_FILEHASBEENMODIFIEDBYOTHER,
			MB_YESNO | MB_ICONQUESTION, CMessageArguments() % pDocument->GetPathName())) {
		size_t	i = 0;
		while(true) {
			if(i == m_vecDocuments.size())
				return;	// ...
			if(m_vecDocuments[i] == reinterpret_cast<CAlphaEditController*>(pDocument->GetController()))
				break;
			++i;
		}
		SetActiveTab(i);
		OnFileReopen();
	}
}

///	@see	IEditViewEventListener::OnDrawIndicatorMargin
void CAlphaApp::OnDrawIndicatorMargin(unsigned long iLine,
		CMinimalDC& oDC, const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) {
	CPen	oPen;
	CBrush	oBrush;
	HPEN	hOldPen;
	HBRUSH	hOldBrush;
	int		nMinWidth = min(rectMargin.right - rectMargin.left, rectMargin.bottom - rectMargin.top);

	nMinWidth -= (nMinWidth + 1) % 2;	// ~ȂȂ悤ɓK...

	if(toBoolean(dwParam & LA_BREAKPOINT_ENABLED)) {	// Lȃu[N|Cg
		RECT	rectCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		oPen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		oBrush.CreateSolidBrush(RGB(0x80, 0x00, 0x00));
		hOldPen = oDC.SelectObject(oPen);
		hOldBrush = oDC.SelectObject(oBrush);
		::OffsetRect(&rectCircle,
			rectMargin.left + (rectMargin.right - rectMargin.left) / 2 - nMinWidth / 2,
			rectMargin.top + (rectMargin.bottom - rectMargin.top) / 2 - nMinWidth / 2);
		oDC.Ellipse(&rectCircle);
		oDC.SelectObject(hOldPen);
		oDC.SelectObject(hOldBrush);
	} else if(toBoolean(dwParam & LA_BREAKPOINT_DISABLED)) {	// ȃu[N|Cg
		RECT	rectCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		oPen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		oBrush.CreateSolidBrush(RGB(0xFF, 0xF9, 0xF9));
		hOldPen = oDC.SelectObject(oPen);
		hOldBrush = oDC.SelectObject(oBrush);
		::OffsetRect(&rectCircle,
			rectMargin.left + (rectMargin.right - rectMargin.left) / 2 - nMinWidth / 2,
			rectMargin.top + (rectMargin.bottom - rectMargin.top) / 2 - nMinWidth / 2);
		oDC.Ellipse(&rectCircle);
		oDC.SelectObject(hOldPen);
		oDC.SelectObject(hOldBrush);
	}
	if(bSingleEmphasis) {	// fobOg[Xs
		// TODO: fobOg[Xs̖`
	}
}

///	@see	WM_DRAWITEM
void CAlphaApp::OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem) {
	CMinimalDC	oDC;
	const RECT&	rectItem = lpDrawItem->rcItem;
	RECT		rectCaption;
	HPEN		hOldPen, hPen;
	HBRUSH		hOldBrush, hBrush;
	wchar_t*	pszCaption = 0;
	wchar_t*	pszAccel = 0;	// ANZ[^At@C

	oDC.Attach(lpDrawItem->hDC);

	if(lpDrawItem->CtlType == ODT_MENU) {	// j[̕`
		COLORREF	clrHighlight = ::GetSysColor(COLOR_HIGHLIGHT);
		COLORREF	clrHighlightBack = RGB(GetRValue(clrHighlight) / 3 + 170,
										GetGValue(clrHighlight) / 3 + 170, GetBValue(clrHighlight) / 3 + 170);
		COLORREF	clrHighlightIconBack = RGB((GetRValue(clrHighlightBack) + 0xFF) / 2,
										(GetGValue(clrHighlightBack) + 0xFF) / 2, (GetBValue(clrHighlightBack) + 0xFF) / 2);
		// wi̕`
		if(toBoolean(lpDrawItem->itemState & ODS_SELECTED)) {
			hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
			hBrush = ::CreateSolidBrush(clrHighlightBack);
			hOldPen = oDC.SelectObject(hPen);
			hOldBrush = oDC.SelectObject(hBrush);
			oDC.Rectangle(&rectItem);
			oDC.SelectObject(hOldPen);
			oDC.SelectObject(hOldBrush);
			::DeleteObject(hPen);
			::DeleteObject(hBrush);
		} else {
			oDC.FillSolidRect(&rectItem, ::GetSysColor(COLOR_MENU));
//			oDC.FillSolidRect(rectItem.left, rectItem.top,
//				rectItem.bottom - rectItem.top, rectItem.bottom - rectItem.top,
//				::GetSysColor(COLOR_3DFACE));
		}

		if(lpDrawItem->itemID >= IDCM_FILE_MRULISTSTART
				&& lpDrawItem->itemID < IDCM_TOOL_DOCTYPELISTSTART) {	// MRU Xg
			pszCaption = reinterpret_cast<wchar_t*>(lpDrawItem->itemData);
			pszAccel = ::PathFindFileNameW(pszCaption);
			rectCaption = rectItem;
			rectCaption.left += 14;
			rectCaption.right -= 14;
			oDC.SetBkMode(TRANSPARENT);

			// pX̕`
			if(pszCaption != pszAccel) {
				oDC.SetTextColor(toBoolean(lpDrawItem->itemState & ODS_SELECTED) ?
					::GetSysColor(COLOR_MENUTEXT) : RGB(0x66, 0x66, 0x99));
				oDC.DrawText(pszCaption, pszAccel - pszCaption, &rectCaption, DT_SINGLELINE | DT_VCENTER);
				oDC.DrawText(pszCaption,
					pszAccel - pszCaption, &rectCaption, DT_CALCRECT | DT_SINGLELINE | DT_VCENTER);
				rectCaption.left = rectCaption.right;
				rectCaption.right = rectItem.right;
				rectCaption.top = rectItem.top;
				rectCaption.bottom = rectItem.bottom;
			}

			// t@C̕`
			oDC.SetTextColor(toBoolean(lpDrawItem->itemState & ODS_SELECTED) ?
				::GetSysColor(COLOR_MENUTEXT) : RGB(0x33, 0x33, 0xFF));
			oDC.DrawText(pszAccel, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
		} else {
			// ACR̕`
			RECT	rectIcon;
			rectIcon.left = rectItem.left + (rectItem.bottom - rectItem.top - 16) / 2 - 1;
			rectIcon.top = rectItem.top + (rectItem.bottom - rectItem.top - 16) / 2 - 1;
			rectIcon.right = rectIcon.left + 18;
			rectIcon.bottom = rectIcon.top + 18;
			if(lpDrawItem->itemID >= IDCM_COMMANDSTART
					&& lpDrawItem->itemID < IDCM_COMMANDEND
					&& arrAvailableIcon[lpDrawItem->itemID - IDCM_COMMANDSTART]) {	// ACRpłꍇ
				if(toBoolean(lpDrawItem->itemState & ODS_CHECKED)) {
					hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
					hBrush = ::CreateSolidBrush(clrHighlightIconBack);
					hOldPen = oDC.SelectObject(hPen);
					hOldBrush = oDC.SelectObject(hBrush);
					oDC.Rectangle(&rectIcon);
					oDC.SelectObject(hOldPen);
					oDC.SelectObject(hOldBrush);
					::DeleteObject(hPen);
					::DeleteObject(hBrush);
				}
				::InflateRect(&rectIcon, -1, -1);
				if(toBoolean(lpDrawItem->itemState & ODS_DISABLED))
					::ImageList_Draw(m_hDisabledCommandImageList, lpDrawItem->itemID - IDCM_COMMANDSTART,
						oDC.GetSafeHdc(), rectIcon.left, rectIcon.top, 0);
				else
					::ImageList_Draw(m_hCommandImageList, lpDrawItem->itemID - IDCM_COMMANDSTART,
						oDC.GetSafeHdc(), rectIcon.left, rectIcon.top, 0);
			} else if(toBoolean(lpDrawItem->itemState & ODS_CHECKED)) {
				int	nCheckBoxWidth = rectItem.bottom - rectItem.top;
				hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
				hBrush = ::CreateSolidBrush(clrHighlightIconBack);
				hOldPen = oDC.SelectObject(hPen);
				hOldBrush = oDC.SelectObject(hBrush);
				oDC.Rectangle(rectItem.left + 1, rectItem.top + 1,
					rectItem.left + rectItem.bottom - rectItem.top - 1, rectItem.bottom - 1);
				oDC.SelectObject(hOldPen);
				oDC.SelectObject(hOldBrush);
				::DeleteObject(hPen);
				::DeleteObject(hBrush);
				hPen = ::CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));	// v񂩂?
				hOldPen = oDC.SelectObject(hPen);
				oDC.MoveTo(rectItem.left + nCheckBoxWidth / 2 - 3, rectItem.top + nCheckBoxWidth / 2 - 1);	// `FbN}[N
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 - 1, rectItem.top + nCheckBoxWidth / 2 + 1);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 + 4, rectItem.top + nCheckBoxWidth / 2 - 4);
				oDC.MoveTo(rectItem.left + nCheckBoxWidth / 2 - 3, rectItem.top + nCheckBoxWidth / 2 + 0);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 - 1, rectItem.top + nCheckBoxWidth / 2 + 2);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 + 4, rectItem.top + nCheckBoxWidth / 2 - 3);
				oDC.SelectObject(hOldPen);
				::DeleteObject(hPen);
			}

			// LvV̕`
			oDC.SetBkMode(TRANSPARENT);
			rectCaption = lpDrawItem->rcItem;
	//		if(reinterpret_cast<HMENU>(lpDrawItem->hwndItem) != m_pMenu->GetSafeHmenu()) {
				if(toBoolean(lpDrawItem->itemState & ODS_DISABLED))
					oDC.SetTextColor(::GetSysColor(COLOR_3DSHADOW));	// COLOR_GRAYTEXT ƌȂȂ XP XL
				else
					oDC.SetTextColor(::GetSysColor(COLOR_MENUTEXT));
				rectCaption.left = rectIcon.right + 6;
				rectCaption.right -= 6;
				pszCaption = new wchar_t[wcslen(reinterpret_cast<wchar_t*>(lpDrawItem->itemData)) + 1];
				wcscpy(pszCaption, reinterpret_cast<wchar_t*>(lpDrawItem->itemData));
				pszAccel = wcschr(pszCaption, L'\t');
				if(pszAccel != 0) {
					*pszAccel = 0;
					oDC.DrawText(pszCaption, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
					oDC.DrawText(pszAccel + 1, -1, &rectCaption, DT_RIGHT | DT_SINGLELINE | DT_VCENTER);
				} else
					oDC.DrawText(pszCaption, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
				delete[] pszCaption;
	//		} else {	// j[o[̏ꍇ
	//			if(lpDrawItem->itemState & ODS_SELECTED || lpDrawItem->itemState & ODS_HOTLIGHT) {
	//				oDC.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_HIGHLIGHT));
	//				oDC.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
	//			} else {
	//				oDC.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_BTNFACE));
	//				oDC.SetTextColor(::GetSysColor(COLOR_MENUTEXT));
	//			}
	//			oDC.DrawText(reinterpret_cast<const wchar_t*>(lpDrawItem->itemData),
	//				-1, &rectCaption, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
	//		}
		}
	}
	oDC.Detach();
}

///	@see	WM_DROPFILES
void CAlphaApp::OnDropFiles(HDROP hDrop) {
	unsigned int	cFiles = ::DragQueryFile(hDrop, 0xFFFFFFFF, 0, 0);
	wchar_t			wszFilePath[MAX_PATH];

	for(unsigned int iFile = 0; iFile < cFiles; ++iFile) {
		::DragQueryFile(hDrop, iFile, wszFilePath, MAX_PATH);
		OpenFile(wszFilePath);
	}
	::DragFinish(hDrop);
}

///	@see	WM_ENTERMENULOOP
void CAlphaApp::OnEnterMenuLoop(bool bIsTrackPopup) {
	CPopupMenu*	pMenu = 0;
	CAlphaDoc*	pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	CAlphaView*	pActiveView = GetActiveTextEditor()->GetActiveView();
	bool		bReadOnly = pActiveDoc->IsReadOnly();
	bool		bHasSelection = pActiveView->HasSelection();
	bool		bIsDebugging = m_pActiveDebugger != 0;

//	::SendMessage(m_hStatusBar, SB_SIMPLE, true, 0L);

	// j[ACe̗L/

	// [t@C]
	pMenu = m_pMenu->GetSubMenu(0);
	pMenu->EnableMenuItem(IDCM_FILE_REOPEN, !pActiveDoc->GetPathName().empty());
	pMenu->EnableMenuItem(IDCM_FILE_REOPENWITHCODEPAGE, !pActiveDoc->GetPathName().empty());
	pMenu->EnableMenuItem(IDCM_FILE_SAVE, !bReadOnly && pActiveDoc->IsModified());
	bool	bModifiedAtLeast = false;
	for(unsigned int i = 0; i < m_vecDocuments.size(); ++i) {
		if(m_vecDocuments[i]->IsTextEditor()
				&& static_cast<CAlphaEditController*>(m_vecDocuments[i])->GetDocument()->IsModified())
			bModifiedAtLeast = true;
	}
	pMenu->EnableMenuItem(IDCM_FILE_SAVEALL, bModifiedAtLeast);
	pMenu->EnableMenuItem(IDCM_FILE_SENDMAIL,
		!toBoolean(GetProfileInt(L"File", L"bSendMailAsAttachment", 1)) || !pActiveDoc->GetPathName().empty());

	// [t@C]-[t@C]
	m_pFileOpeMenu->EnableMenuItem(IDCM_FILE_RENAME, !bReadOnly && !pActiveDoc->GetPathName().empty());
	m_pFileOpeMenu->EnableMenuItem(IDCM_FILE_COPY, !pActiveDoc->GetPathName().empty());
	m_pFileOpeMenu->EnableMenuItem(IDCM_FILE_MOVE, !bReadOnly && !pActiveDoc->GetPathName().empty());
	m_pFileOpeMenu->EnableMenuItem(IDCM_FILE_DELETE, !bReadOnly && !pActiveDoc->GetPathName().empty());

	// [ҏW]
	pMenu = m_pMenu->GetSubMenu(1);
	pMenu->EnableMenuItem(IDCM_EDIT_UNDO, !bReadOnly && pActiveDoc->GetUndoHistoryLength() != 0);
	pMenu->EnableMenuItem(IDCM_EDIT_REDO, !bReadOnly && pActiveDoc->GetUndoHistoryLength(true) != 0);
	pMenu->EnableMenuItem(IDCM_EDIT_CUT, !bReadOnly && bHasSelection);
	pMenu->EnableMenuItem(IDCM_EDIT_COPY, bHasSelection);
	pMenu->EnableMenuItem(IDCM_EDIT_PASTE, !bReadOnly && pActiveView->CanPaste());
	pMenu->EnableMenuItem(IDCM_EDIT_CLEAR, !bReadOnly && bHasSelection);

	// []
	pMenu = m_pMenu->GetSubMenu(2);
	pMenu->CheckMenuItem(IDCM_FIND_FIND, m_dlgFind.IsWindow() && m_dlgFind.m_bType);
	pMenu->EnableMenuItem(IDCM_FIND_FINDNEXT, !m_dlgFind.m_strFindWhat.empty());
	pMenu->EnableMenuItem(IDCM_FIND_FINDPREV, !m_dlgFind.m_strFindWhat.empty());
	pMenu->CheckMenuItem(IDCM_FIND_REPLACE, m_dlgFind.IsWindow() && !m_dlgFind.m_bType);
	pMenu->CheckMenuItem(IDCM_FIND_GOTOLINE, m_pdlgGotoLine->IsWindow());
	pMenu->CheckMenuItem(IDCM_FIND_BOOKMARKS, m_pdlgBookmark->IsWindow());

	// [\]
	pMenu = m_pMenu->GetSubMenu(3);
	pMenu->CheckMenuItem(IDCM_VIEW_TOOLBAR, toBoolean(::IsWindowVisible(m_hRebar)));
	pMenu->CheckMenuItem(IDCM_VIEW_STATUSBAR, toBoolean(::IsWindowVisible(m_hStatusBar)));
	pMenu->CheckMenuItem(IDCM_VIEW_SPLITVIEW, pActiveDoc->GetController()->IsSplit());
	pMenu->CheckMenuItem(IDCM_VIEW_NOWRAP, pActiveView->GetWrapMode() == WPM_NONE);
	pMenu->CheckMenuItem(IDCM_VIEW_WRAPBYSPECIFIEDWIDTH, pActiveView->GetWrapMode() == WPM_SPECIFIED);
	pMenu->CheckMenuItem(IDCM_VIEW_WRAPBYWINDOWWIDTH, pActiveView->GetWrapMode() == WPM_WINDOW);

	// [fobO]
	pMenu = m_pMenu->GetSubMenu(4);
	pMenu->EnableMenuItem(IDCM_DEBUG_RESTART, false/*bIsDebugging*/);
	pMenu->EnableMenuItem(IDCM_DEBUG_STOP, bIsDebugging);
	pMenu->EnableMenuItem(IDCM_DEBUG_STEPINTO, bIsDebugging);
	pMenu->EnableMenuItem(IDCM_DEBUG_STEPOVER, bIsDebugging);
	pMenu->EnableMenuItem(IDCM_DEBUG_STEPOUT, bIsDebugging);
	pMenu->EnableMenuItem(IDCM_DEBUG_VARIABLES, bIsDebugging);
	pMenu->CheckMenuItem(IDCM_DEBUG_VARIABLES, m_pdlgDebugVariables->IsWindow());
	pMenu->EnableMenuItem(IDCM_DEBUG_CALLSTACK, bIsDebugging);
	pMenu->CheckMenuItem(IDCM_DEBUG_CALLSTACK, m_pdlgDebugCallStack->IsWindow());
	pMenu->EnableMenuItem(IDCM_DEBUG_IMMEDIATE, bIsDebugging);
	pMenu->CheckMenuItem(IDCM_DEBUG_IMMEDIATE, m_pdlgDebugImmediate->IsWindow());
	pMenu->EnableMenuItem(IDCM_DEBUG_THREADS, bIsDebugging);
	pMenu->CheckMenuItem(IDCM_DEBUG_THREADS, m_pdlgDebugThreads->IsWindow());
	pMenu->EnableMenuItem(IDCM_DEBUG_EXCEPTION, bIsDebugging);

	// [c[]
	pMenu = m_pMenu->GetSubMenu(5);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACROPLAY);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACRORECORD);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACROSTOP);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACROPAUSE);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACROSAVE);
	pMenu->DeleteMenuItem(IDCM_TOOL_KEYMACROCANCEL);
	switch(pActiveView->GetKeyMacroState()) {
	case KMS_NONE:
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACROPLAY, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROPLAY));
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACRORECORD, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACRORECORD));
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACROSAVE, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROSAVE));
		if(CEditView::GetViewKeyMacroRecording() != 0) {
			pMenu->EnableMenuItem(IDCM_TOOL_KEYMACROPLAY, false);
			pMenu->EnableMenuItem(IDCM_TOOL_KEYMACRORECORD, false);
			pMenu->EnableMenuItem(IDCM_TOOL_KEYMACROSAVE, false);
		}
		break;
	case KMS_RECORDING:
	case KMS_PAUSING:
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACROSTOP, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROSTOP));
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACROPAUSE, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROPAUSE));
		pMenu->AppendMenuItem(IDCM_TOOL_KEYMACROCANCEL, MF_STRING | MF_OWNERDRAW, GetMenuLabel(IDCM_TOOL_KEYMACROCANCEL));
		pMenu->CheckMenuItem(IDCM_TOOL_KEYMACROPAUSE,
			pActiveView->GetKeyMacroState() == KMS_PAUSING);
		break;
	}

	// [c[]-[KphLg^Cv]
	pMenu = pMenu->GetSubMenu(3);
	pMenu->CheckMenuRadioItem(IDCM_TOOL_DOCTYPELISTSTART,
		IDCM_TOOL_DOCTYPELISTSTART + m_vecDocumentTypes.size(),
		IDCM_TOOL_DOCTYPELISTSTART + pActiveDoc->m_iDocType);
}

///	@see	WM_EXITMENULOOP
void CAlphaApp::OnExitMenuLoop(bool bIsTrackPopup) {
//	::SendMessage(m_hStatusBar, SB_SIMPLE, false, 0L);
}

///	@see	WM_MEASUREITEM
void CAlphaApp::OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI) {
	HDC					hDC;
	NONCLIENTMETRICS	ncm;
	RECT				rect;
	HFONT				hMenuFont, hOldFont;

	if(lpMI->CtlType == ODT_MENU){
		// j[̃tHg擾
		ncm.cbSize = sizeof(NONCLIENTMETRICS);
		::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, reinterpret_cast<void*>(&ncm), 0);
		hMenuFont = ::CreateFontIndirect(&ncm.lfMenuFont);

		hDC = m_pMainWindow->GetDC();
		hOldFont = reinterpret_cast<HFONT>(::SelectObject(hDC, hMenuFont));
		::DrawText(hDC, reinterpret_cast<TCHAR*>(lpMI->itemData),
			-1, &rect, DT_CALCRECT | /*DT_EXPANDTABS |*/ DT_SINGLELINE);
		::SelectObject(hDC, hOldFont);
		m_pMainWindow->ReleaseDC(hDC);
		::DeleteObject(hMenuFont);

		if(lpMI->itemID >= IDCM_FILE_MRULISTSTART) {
			lpMI->itemHeight = rect.bottom - rect.top + 4;
			lpMI->itemWidth = rect.right - rect.left + 28;
		} else {
			lpMI->itemHeight = (rect.bottom - rect.top < 20) ? 20 : rect.bottom - rect.top;
			lpMI->itemWidth = rect.right - rect.left + ((lpMI->itemID >= IDCM_COMMANDSTART) ? 24 : 0);
		}
	}
}

///	@see	WM_MENUSELECT
void CAlphaApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu) {
	wchar_t	wszPrompt[200] = L"";

	// IڂɑΉXe[^Xo[ɕ\
	if(nItemID >= IDCM_EDIT_PLUGINLISTSTART && nItemID < IDCM_EDIT_PLUGINLISTSTART + 16) {
		::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS, (m_oPluginManager.GetCount() != 0) ?
			reinterpret_cast<LPARAM>(m_oPluginManager.GetPluginDescription(nItemID - IDCM_EDIT_PLUGINLISTSTART).c_str())
			: reinterpret_cast<LPARAM>(L""));
	} else {
		if(!(nFlags & MF_POPUP) && !(nFlags & MF_SEPARATOR))
			LoadString(nItemID, wszPrompt, 200);
		::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS,
			reinterpret_cast<LPARAM>((*wszPrompt != 0) ? wcschr(wszPrompt, L'\n') + 1 : L""));
	}
}

///	@see	WM_MOUSEMOVE
void CAlphaApp::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_bSizingOutputWnd) {	// o̓EBhE̍ύX
	} 
}

///	@see	IEditViewEventListener::OnMoveCaret
void CAlphaApp::OnMoveCaret(const CCharPos& pos) {
	UpdateStatusBar();
}

///	@see	IEditViewEventListener::OnMoveCursor
void CAlphaApp::OnMoveCursor(const POINT& pt) {
	m_pMainWindow->SetTimer(ID_TIMER_MOUSEMOVE, 1200, 0);
}

///	@see	CWindow::OnNotify
bool CAlphaApp::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	int					iTab;
	LPNMTBHOTITEM		lpNMTHI = 0;
	CMenuItem*			pMenuItem = 0;
	wchar_t				wszCommandCaption[200];
	wchar_t*			psz = 0;
	wstring				strKey;
	RECT				rect;
	POINT				pt;
	LPNMOBJECTNOTIFY	lpNMObject = 0;
	LPNMTTDISPINFOW		lpNMTTDI = 0;

	switch(lpNMHDR->code) {
	case RBN_HEIGHTCHANGE:	// o[̍ς
		OnSize(0, -1, -1);
		return true;
	case TBN_DROPDOWN:	// c[o[̃hbv_E
		::SendMessage(m_hToolbar, TB_GETRECT,
			reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem, reinterpret_cast<LPARAM>(&rect));
		pt.x = rect.left;
		pt.y = rect.bottom;
		m_pMainWindow->ClientToScreen(&pt);
		switch(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem) {
		case IDCM_FILE_NEW:
			m_pNewDocTypeMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->m_hWnd);
			return true;
		case IDCM_FILE_OPEN:
			m_pMRUManager->GetPopupMenu()->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->m_hWnd);
			return true;
		}
		break;
	case TCN_GETOBJECT:	// Ӗ
		if(idCtrl == IDC_TAB_VIEWS) {
			lpNMObject = reinterpret_cast<LPNMOBJECTNOTIFY>(lpNMHDR);
			if(*lpNMObject->piid == IID_IDropTarget) {
				lpNMObject->hResult = m_wndTab.QueryInterface(*lpNMObject->piid, &lpNMObject->pObject);
				return true;
			}
		}
		break;
	case TCN_SELCHANGE:	// ANeBuȃ^uύXꂽ
		if(idCtrl == IDC_TAB_VIEWS) {
			iTab = m_wndTab.GetCurSel();
			SetActiveTab(iTab);
			return true;
		}
		break;
	case TTN_GETDISPINFO:	// ^ũc[`bv
		lpNMTTDI = reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR);
		if(idCtrl == IDC_TAB_VIEWS) {
			lpNMTTDI->lpszText = const_cast<wchar_t*>(GetActiveTab()->GetDescription().c_str());
			return true;
		} else {
			lpNMTTDI->hinst = m_hInstance;
			LoadString(lpNMTTDI->hdr.idFrom, wszCommandCaption, 200);
			psz = wcschr(wszCommandCaption, L'(');
			if(psz != 0)
				*psz = 0;
			strKey = m_oKeyboardMap.GetKeyString(lpNMTTDI->hdr.idFrom);
			if(!strKey.empty()) {
				wcscat(wszCommandCaption, L" (");
				wcscat(wszCommandCaption, strKey.c_str());
				wcscat(wszCommandCaption, L")");
			}
			lpNMTTDI->lpszText = wszCommandCaption;
			return true;
		}
		break;
//	case TBN_HOTITEMCHANGE:
//		lpNMTHI = reinterpret_cast<LPNMTBHOTITEM>(lpNMHDR);
//		if(0 != LoadString(lpNMTHI->idNew, wszCommandCaption, 200)) {
//			psz = wcschr(wszCommandCaption, L'\n');
//			if(psz != 0)
//				::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(psz + 1));
//		} else
//			::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(L""));
//		break;
	}
	return false;
}

///	@see	IEditView::OnQueryLineColor
void CAlphaApp::OnQueryLineColor(unsigned long iLine, bool bBookmarked,
		DWORD dwParam, bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) {
	if(bSingleEmphasis)
		clrBack = RGB(0xFF, 0xFF, 0xCC);
	else if(dwParam & LA_BREAKPOINT_ENABLED)
		clrBack = RGB(0xFF, 0xEE, 0xEE);
	else if(bBookmarked)
		clrBack = RGB(0xF0, 0xF0, 0xFF);
}

///	@see	CWindow::OnSetCursor
bool CAlphaApp::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;		// J[\ʒu
	RECT	rectClient, rectStatusBar;

	m_pMainWindow->GetClientRect(&rectClient);
	if(::IsWindowVisible(m_hStatusBar))	::GetWindowRect(m_hStatusBar, &rectStatusBar);
	else								::SetRect(&rectStatusBar, 0, 0, 0, 0);
	::GetCursorPos(&pt);
	m_pMainWindow->ScreenToClient(&pt);

	if(pt.y >= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top) - 3
			&& pt.y <= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top)) {
		::SetCursor(::LoadCursor(0, IDC_SIZENS));
		return true;
	}

	return false;
}

/**
 *	@see			CWindow::OnSize
 *	@param nType	CWindow::OnSize Q
 *	@param cx, cy	-1ɂƂ̃\bh݂͌̃EBhETCYgB
 *					̃\bhs̏PɎgpꍇɂĂяoƂł
 */
void CAlphaApp::OnSize(UINT nType, int cx, int cy) {
	RECT	rectTab, rectRebar, rectStatusBar, rectEditor;

	if(cx == -1 && cy == -1) {
		RECT	rect;
		m_pMainWindow->GetClientRect(&rect);
		cx = rect.right - rect.left;
		cy = rect.bottom - rect.top;
	}

	if(::IsWindowVisible(m_hStatusBar)) {
		::SendMessage(m_hStatusBar, WM_SIZE, cx, cy/*10*/);
		::GetWindowRect(m_hStatusBar, &rectStatusBar);
		UpdateStatusBar();
	} else
		::SetRect(&rectStatusBar, 0, 0, 0, 0);

	if(::IsWindowVisible(m_hRebar)) {
		::SendMessage(m_hRebar, WM_SIZE, cx, cy);
		::GetWindowRect(m_hRebar, &rectRebar);
		::SendMessage(m_hToolbar, WM_SIZE, cx, rectRebar.bottom - rectRebar.top - 2);
	} else
		::SetRect(&rectRebar, 0, 0, 0, 0);

	if(m_wndTab.IsWindow()) {
		cy -= (rectStatusBar.bottom - rectStatusBar.top) + (rectRebar.bottom - rectRebar.top);
		::MoveWindow(m_hwndSeparator, 0, 0, cx + 1, 2, true);
		m_wndTab.MoveWindow(0, rectRebar.bottom - rectRebar.top, cx + 3, cy, true);
		m_wndTab.GetItemRect(0, &rectTab);
		m_wndTab.MoveWindow(0, rectRebar.bottom - rectRebar.top + 1,
			cx + 2, rectTab.bottom - rectTab.top + 5, true);
		rectEditor.left =  0;
		rectEditor.top = rectRebar.bottom - rectRebar.top + rectTab.bottom - rectTab.top + 5;
		rectEditor.right = cx;
		rectEditor.bottom = rectEditor.top + cy - rectTab.bottom - 5 + 2;
		if(m_wndOutput.IsWindow() && m_wndOutput.IsWindowVisible())
			rectEditor.bottom -= m_nOutputWndHeight;
		m_vecDocuments[m_iActiveTab]->OnSize(&rectEditor);
	}

	if(m_wndOutput.IsWindow()) {
		m_wndOutput.MoveWindow(0, rectEditor.bottom + 2, cx, m_nOutputWndHeight);
		m_wndOutput.ShowWindow(SW_SHOW);
	}
}

///	@see	WM_TIMER
void CAlphaApp::OnTimer(UINT nIDTimer) {
	if(nIDTimer == ID_TIMER_QUERYCOMMAND && !m_vecDocuments.empty()) {	// c[o[ACe̗L/
		CAlphaDoc*	pActiveDoc = GetActiveDocument();
		CAlphaView*	pActiveView = 0;

		if(pActiveDoc == 0) {
			for(unsigned int iCmd = IDCM_COMMANDSTART; iCmd < IDCM_COMMANDSTART + 32 * 5; ++iCmd)
				::SendMessage(m_hToolbar, TB_ENABLEBUTTON, iCmd, false);
			return;
		}
		pActiveView = GetActiveTextEditor()->GetActiveView();

		if(pActiveView == 0 || !pActiveView->IsWindow())
			return;

		bool			bReadOnly = pActiveDoc->IsReadOnly();
		bool			bHasSelection = pActiveView->HasSelection();
		bool			bIsDebugging = (m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging());
		KeyMacroState	kms = pActiveView->GetKeyMacroState();
		TBBUTTONINFOW	tbbi;

		// [t@C]
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_FILE_SAVE, pActiveDoc->IsModified() && !bReadOnly);

		// [ҏW]
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_UNDO, !bReadOnly && pActiveDoc->GetUndoHistoryLength() != 0);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_REDO, !bReadOnly && pActiveDoc->GetUndoHistoryLength(true) != 0);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_CUT, !bReadOnly && bHasSelection);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_COPY, bHasSelection);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_PASTE, !bReadOnly && pActiveView->CanPaste());
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_EDIT_CLEAR, !bReadOnly && bHasSelection);

		// []
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_FIND_FINDNEXT, !m_dlgFind.m_strFindWhat.empty());
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_FIND_FINDPREV, !m_dlgFind.m_strFindWhat.empty());
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_GOTOLINE, m_pdlgGotoLine->IsWindow());
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_BOOKMARKS, m_pdlgBookmark->IsWindow());
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_FIND_PARSEOUTLINE, m_dlgOutline.IsWindow());

		// [\]
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_VIEW_NOWRAP, pActiveView->GetWrapMode() == WPM_NONE);
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_VIEW_WRAPBYSPECIFIEDWIDTH, pActiveView->GetWrapMode() == WPM_SPECIFIED);
		::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_VIEW_WRAPBYWINDOWWIDTH, pActiveView->GetWrapMode() == WPM_WINDOW);

		// [fobO]
		::SendMessage(m_hDebugBar, TB_ENABLEBUTTON, IDCM_DEBUG_START, !bIsDebugging);
		::SendMessage(m_hDebugBar, TB_ENABLEBUTTON, IDCM_DEBUG_STOP, bIsDebugging);
		::SendMessage(m_hDebugBar, TB_ENABLEBUTTON, IDCM_DEBUG_STEPINTO, bIsDebugging);
		::SendMessage(m_hDebugBar, TB_ENABLEBUTTON, IDCM_DEBUG_STEPOVER, bIsDebugging);
		::SendMessage(m_hDebugBar, TB_ENABLEBUTTON, IDCM_DEBUG_STEPOUT, bIsDebugging);

		// [c[]
		tbbi.cbSize = sizeof(TBBUTTONINFOW);
		tbbi.dwMask = TBIF_COMMAND | TBIF_IMAGE | TBIF_STATE;
		switch(kms) {
		case KMS_NONE:
			if(-1 != ::SendMessage(m_hToolbar, TB_GETBUTTONINFO,
					IDCM_TOOL_KEYMACROPAUSE, reinterpret_cast<LPARAM>(&tbbi))) {
				tbbi.idCommand = IDCM_TOOL_KEYMACROPLAY;
				tbbi.iImage = IDCM_TOOL_KEYMACROPLAY - IDCM_COMMANDSTART;
				::SendMessage(m_hToolbar,
					TB_SETBUTTONINFO, IDCM_TOOL_KEYMACROPAUSE, reinterpret_cast<LPARAM>(&tbbi));
			}
			if(-1 != ::SendMessage(m_hToolbar, TB_GETBUTTONINFO,
					IDCM_TOOL_KEYMACROSTOP, reinterpret_cast<LPARAM>(&tbbi))) {
				tbbi.idCommand = IDCM_TOOL_KEYMACRORECORD;
				tbbi.iImage = IDCM_TOOL_KEYMACRORECORD - IDCM_COMMANDSTART;
				::SendMessage(m_hToolbar,
					TB_SETBUTTONINFO, IDCM_TOOL_KEYMACROSTOP, reinterpret_cast<LPARAM>(&tbbi));
			}
			if(CEditView::GetViewKeyMacroRecording() != 0) {
				::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROPLAY, false);
				::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACRORECORD, false);
			}
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_TOOL_KEYMACROPLAY, false);
			::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROCANCEL, false);
			break;
		case KMS_RECORDING:
		case KMS_PAUSING:
			if(-1 != ::SendMessage(m_hToolbar, TB_GETBUTTONINFO,
					IDCM_TOOL_KEYMACROPLAY, reinterpret_cast<LPARAM>(&tbbi))) {
				tbbi.idCommand = IDCM_TOOL_KEYMACROPAUSE;
				tbbi.iImage = IDCM_TOOL_KEYMACROPAUSE - IDCM_COMMANDSTART;
				tbbi.fsState = TBSTATE_ENABLED | ((kms == KMS_PAUSING) ? TBSTATE_CHECKED : 0);
				::SendMessage(m_hToolbar,
					TB_SETBUTTONINFO, IDCM_TOOL_KEYMACROPLAY, reinterpret_cast<LPARAM>(&tbbi));
			}
			if(-1 != ::SendMessage(m_hToolbar, TB_GETBUTTONINFO,
					IDCM_TOOL_KEYMACRORECORD, reinterpret_cast<LPARAM>(&tbbi))) {
				tbbi.idCommand = IDCM_TOOL_KEYMACROSTOP;
				tbbi.iImage = IDCM_TOOL_KEYMACROSTOP - IDCM_COMMANDSTART;
				::SendMessage(m_hToolbar,
					TB_SETBUTTONINFO, IDCM_TOOL_KEYMACRORECORD, reinterpret_cast<LPARAM>(&tbbi));
			}
			::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROSTOP, true);
			::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROPAUSE, true);
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, IDCM_TOOL_KEYMACROPAUSE, kms == KMS_PAUSING);
			::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROCANCEL, true);
			break;
		}
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROPLAY, !bReadOnly);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACRORECORD, !bReadOnly);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROSTOP, !bReadOnly);
		::SendMessage(m_hToolbar, TB_ENABLEBUTTON, IDCM_TOOL_KEYMACROPAUSE, !bReadOnly);
	} else if(nIDTimer == ID_TIMER_MOUSEMOVE) {	// qg\
		if(GetActiveTab()->IsTextEditor() && m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging()) {
			CAlphaView*			pActiveView = GetActiveTextEditor()->GetActiveView();
			DebugPropertyInfo	dpi;
			POINT				pt, ptView;
			wstring				strExpression;
			wostringstream		ssResult;

			::GetCursorPos(&pt);
			ptView = pt;
			pActiveView->ScreenToClient(&ptView);
			strExpression = (pActiveView->HasSelection() && pActiveView->IsOverSelection(ptView)) ?
				pActiveView->GetSelection() : pActiveView->GetNearestWordFromCursor();
			dpi.m_dwValidFields = DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
			if(!strExpression.empty()
						&& SUCCEEDED(m_pActiveDebugger->EvaluateExpression(strExpression, 10, true, &dpi))) {
				if(dpi.m_bstrType != 0
						&& wcscmp(dpi.m_bstrType, L"Error") != 0	// VC6
						&& wcscmp(dpi.m_bstrType, L"G[") != 0)	// VC7
					ssResult << dpi.m_bstrName << L" = " << dpi.m_bstrValue;
				if(dpi.m_dwValidFields & DBGPROP_INFO_NAME)		::SysFreeString(dpi.m_bstrName);
				if(dpi.m_dwValidFields & DBGPROP_INFO_TYPE)		::SysFreeString(dpi.m_bstrType);
				if(dpi.m_dwValidFields & DBGPROP_INFO_VALUE)	::SysFreeString(dpi.m_bstrValue);
			}
			m_oToolTip.UpdateTipText(ssResult.str().c_str(), m_pMainWindow->m_hWnd, pActiveView->m_hWnd);
		}
		m_pMainWindow->KillTimer(ID_TIMER_MOUSEMOVE);
	}
}

/* [EOF] */