/*
 * Created on 2005/06/15
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;

import org.jpn.xucker.rcp.RCPUtils;
import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;

import java.io.File;

/**
 * 
 *
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer{


    /* (non-Javadoc)
     * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
     */
    public void initializeDefaultPreferences() {
        IPreferenceStore store=SubplayerPlugin.getDefault().getPreferenceStore();
        store.setDefault(SubViewPage.LAYER1_TRANSPARENT,200);
    	
       FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(store,SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(store,SubViewPage.LAYER1_BGCOLOR,ColorConstants.gray.getRGB());
		PreferenceConverter.setDefault(store,SubViewPage.LAYER1_FGCOLOR,ColorConstants.black.getRGB());
		
		PreferenceConverter.setDefault(store,LabelPage.LABEL1_COLOR,ColorConstants.white.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL2_COLOR,ColorConstants.red.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL3_COLOR,ColorConstants.yellow.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL4_COLOR,ColorConstants.green.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL5_COLOR,ColorConstants.blue.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL6_COLOR,ColorConstants.darkGray.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL7_COLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL8_COLOR,ColorConstants.cyan.getRGB());
		PreferenceConverter.setDefault(store,LabelPage.LABEL9_COLOR,ColorConstants.orange.getRGB());
		
		store.setDefault(SubPlayPage.SUBPLAY_EXTEND,250);
		store.setDefault(SubPlayPage.SUBPLAY_WAIT,500);
		
    }
}
