package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.ui.SliderFieldEditor;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class SubPlayPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String SUBPLAY_EXTEND = "subplay.extend";

	public static final String SUBPLAY_WAIT = "subplay.wait";
	public SubPlayPage() {
		super(GRID);
		setPreferenceStore(SubplayerPlugin.getDefault().getPreferenceStore());
		setDescription("SubView Setting");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		/*
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
        addField(new IntegerFieldEditor(SUBPLAY_EXTEND,"extend time",getFieldEditorParent()));
        addField(new IntegerFieldEditor(SUBPLAY_WAIT,"wait time",getFieldEditorParent()));
        
        
    }
	
	public void init(IWorkbench workbench) {
	}
}