/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.WizardFileSystemResourceExportPage1;
import org.eclipse.ui.wizards.datatransfer.ZipFileExportOperation;

class WizardZipFileResourceExportPage1
extends WizardFileSystemResourceExportPage1 {
    protected Button compressContentsCheckbox;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardZipFileResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardZipFileResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_COMPRESS_CONTENTS_ID = "WizardZipFileResourceExportPage1.STORE_COMPRESS_CONTENTS_ID";

    protected WizardZipFileResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardZipFileResourceExportPage1(IStructuredSelection selection) {
        this("zipFileExportPage1", selection);
        this.setTitle(DataTransferMessages.getString("ZipExport.exportTitle"));
        this.setDescription(DataTransferMessages.getString("ZipExport.description"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.zip_file_export_wizard_page");
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.compressContentsCheckbox = new Button((Composite)optionsGroup, 16416);
        this.compressContentsCheckbox.setText(DataTransferMessages.getString("ZipExport.compressContents"));
        this.compressContentsCheckbox.setFont(font);
        this.createDirectoryStructureOptions(optionsGroup, font);
        this.createDirectoryStructureButton.setSelection(true);
        this.createSelectionOnlyButton.setSelection(false);
        this.compressContentsCheckbox.setSelection(true);
    }

    protected boolean ensureTargetDirectoryIsValid(String fullPathname) {
        int separatorIndex = fullPathname.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(fullPathname.substring(0, separatorIndex)));
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipExport.mustBeFile"));
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists()) {
            if (targetFile.canWrite()) {
                if (!this.queryYesNoQuestion(DataTransferMessages.getString("ZipExport.alreadyExists"))) {
                    return false;
                }
            } else {
                this.displayErrorDialog(DataTransferMessages.getString("ZipExport.alreadyExistsError"));
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(targetPath)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(targetPath));
    }

    protected boolean executeExportOperation(ZipFileExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        op.setUseCompression(this.compressContentsCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.exportProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        List resourcesToExport = this.getWhiteCheckedResources();
        this.saveDirtyEditors();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            return this.executeExportOperation(new ZipFileExportOperation(null, resourcesToExport, this.getDestinationValue()));
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileExport.noneSelected"));
        return false;
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.getString("ZipExport.destinationLabel");
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getOutputSuffix() {
        return ".zip";
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.zip", "*.*"});
        dialog.setText(DataTransferMessages.getString("ZipExport.selectDestinationTitle"));
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
            settings.put(STORE_COMPRESS_CONTENTS_ID, this.compressContentsCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            boolean setStructure = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(setStructure);
            this.createSelectionOnlyButton.setSelection(!setStructure);
            this.compressContentsCheckbox.setSelection(settings.getBoolean(STORE_COMPRESS_CONTENTS_ID));
        }
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.getString("ZipExport.destinationEmpty");
    }
}

