/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.subplayer;

import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageCanvas
extends Canvas
implements PaintListener {
    private Image image;
    private String text;
    private Font font = new Font((Device)this.getDisplay(), "MS \u660e\u671d", 24, 0);

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ImageCanvas(Composite composite) {
        super(composite, 262144);
        this.addPaintListener(this);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = image;
    }

    public void paintControl(PaintEvent e) {
        GC gc = new GC((Drawable)this);
        Image bgImage = new Image((Device)this.getShell().getDisplay(), this.getClientArea());
        GC imageGc = new GC((Drawable)bgImage);
        imageGc.setBackground(new Color((Device)this.getDisplay(), 0, 0, 0));
        imageGc.setForeground(new Color((Device)this.getDisplay(), 255, 0, 0));
        imageGc.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        if (this.image != null) {
            if (this.image.getBounds().height > this.getClientArea().height) {
                imageGc.drawImage(this.image, 0, this.getClientArea().height - this.image.getBounds().height);
            } else {
                imageGc.drawImage(this.image, 0, 0);
            }
        } else if (this.text != null) {
            int dx = 10;
            imageGc.setFont(this.font);
            imageGc.setForeground(new Color((Device)this.getDisplay(), 255, 255, 255));
            String newText = this.wrapString(imageGc, this.getClientArea().width - dx * 2, this.text);
            imageGc.drawText(newText, dx, 10, 2);
        }
        gc.drawImage(bgImage, 0, 0);
        bgImage.dispose();
        imageGc.dispose();
        gc.dispose();
    }

    public String wrapString(GC gc, int maxwidth, String str) {
        String result = "";
        if (gc.stringExtent((String)str).x < maxwidth) {
            result = str;
        } else {
            String value = StringUtils.replace((String)str, (String)"\r\n", (String)"\n");
            value = StringUtils.replace((String)str, (String)"\r", (String)"\n");
            String[] lines = value.split("\n");
            String newLine = "";
            Vector<String> linesList = new Vector<String>();
            int i = 0;
            while (i < lines.length) {
                String[] words = lines[i].split(" ");
                String tmpLine = "";
                int k = 0;
                while (k < words.length) {
                    tmpLine = String.valueOf(tmpLine) + words[k];
                    if (gc.stringExtent((String)tmpLine).x > maxwidth) {
                        if (newLine.length() > 0) {
                            linesList.add(newLine);
                            newLine = "";
                            tmpLine = words[k];
                        } else {
                            int j = 0;
                            while (j < words[k].length()) {
                                tmpLine = String.valueOf(tmpLine) + words[k].charAt(j);
                                if (gc.stringExtent((String)newLine).x > maxwidth) {
                                    linesList.add(tmpLine);
                                    tmpLine = "";
                                    newLine = "";
                                } else {
                                    newLine = tmpLine;
                                }
                                ++j;
                            }
                        }
                    } else {
                        newLine = tmpLine = String.valueOf(tmpLine) + " ";
                    }
                    ++k;
                }
                if (tmpLine.length() > 0) {
                    linesList.add(tmpLine);
                }
                newLine = "";
                ++i;
            }
            String[] values = linesList.toArray(new String[linesList.size()]);
            int i2 = 0;
            while (i2 < values.length) {
                result = String.valueOf(result) + values[i2];
                if (i2 != values.length - 1) {
                    result = String.valueOf(result) + SystemUtils.LINE_SEPARATOR;
                }
                ++i2;
            }
        }
        return result;
    }
}

