/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer.views;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.io.PathnameUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.draw2d.AlphaLayerFigure;
import org.jpn.xucker.rcp.draw2d.AlphaUtils;
import org.jpn.xucker.rcp.draw2d.DoubleScalableFigure;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.WaveFormFigureCanvas;
import org.jpn.xucker.rcp.draw2d.WaveFormListener;
import org.jpn.xucker.rcp.draw2d.WrapTextPainter;
import org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener;
import org.jpn.xucker.rcp.subplayer.MultiTimeAudioPlayer;
import org.jpn.xucker.rcp.subplayer.PlayPatternComposite;
import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.subplayer.TextAndImageFigure;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileUpdater;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileWindow;
import org.jpn.xucker.rcp.subplayer.label.LabelControler;
import org.jpn.xucker.rcp.subplayer.label.LabelMoveComposite;
import org.jpn.xucker.rcp.subplayer.preferences.LabelPage;
import org.jpn.xucker.rcp.subplayer.views.TranslateView;
import org.jpn.xucker.rcp.subplayer.views.WebDictionaryView;
import org.jpn.xucker.rcp.ui.FileDialogBuilder;
import org.jpn.xucker.rcp.ui.RCPFileApplication;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.SubUtils;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;
import org.xml.sax.SAXException;

public class SubView
extends ViewPart {
    public static final String ID;
    public static Log log;
    private SubApplication subApplication;
    private Shell editShell;
    private StandardSubObject currentStandardSubObject;
    MultiTimeAudioPlayer multiTimeAudioPlayer;
    private TimeBaseFileObject timeBaseFileObject;
    private FileImageCache imageCache = new FileImageCache();
    private CenterImageFigure ci;
    long lastset;
    private boolean shiftPressed;
    private WaveFormFigureCanvas waveFormFigureCanvas;
    private Shell shell;
    private File audioFile;
    private long lastSelectionEvent;
    boolean stopped = true;
    private JavaSoundAudioPlayer player;
    private Button playButton;
    private Point selection;
    private long duration;
    private boolean playMoveSelection;
    SRTListFigure[] srtListFigures = new SRTListFigure[4];
    private TextAndImageFigure subtitleShowText1;
    private TextAndImageFigure subtitleShowText2;
    private LabelMoveComposite labelMove;
    private SubViewLabelControler labelControler;
    private PlayPatternComposite playPattern;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.views.SubView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.views.SubView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz2);
    }

    public SubView() {
        FileDialogBuilder builder = new FileDialogBuilder();
        builder.setCreateAny(true);
        String xmlName = "Subplayer-XML Files";
        builder.add(xmlName, new String[]{"xml"});
        builder.add("Audio Files", "MP3 Files", new String[]{"mp3"});
        builder.add("Audio Files", "Wave Files", new String[]{"wav"});
        this.subApplication = new SubApplication();
        this.subApplication.setOpenFilterExtensions(builder.getFilterExtentions(xmlName));
        this.subApplication.setOpenFilterNames(builder.getFilterNames(xmlName));
        FileDialogBuilder saveBuilder = new FileDialogBuilder();
        saveBuilder.setCreateAll(false);
        saveBuilder.add(xmlName, new String[]{"xml"});
        this.subApplication.setSaveFilterExtensions(saveBuilder.getFilterExtentions(null));
        this.subApplication.setSaveFilterNames(saveBuilder.getFilterNames(null));
    }

    private void alertFileNotFound(String message) {
        MessageBox messageBox = new MessageBox(this.shell, 32);
        messageBox.setText("File Not Found");
        messageBox.setMessage("File Not Found\n" + message);
        messageBox.open();
    }

    private void cancelLoadWaveForm() {
        if (this.waveFormFigureCanvas.getCanceller() != null) {
            this.waveFormFigureCanvas.getCanceller().setCanceld(true);
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setData(File baseFile, TimeBaseFileObject data) throws UnsupportedAudioFileException, IOException {
        this.timeBaseFileObject = data;
        File audio = this.parseFirstAudioFile(baseFile, data);
        if (audio != null) {
            if (!audio.exists()) {
                this.alertFileNotFound(audio.getAbsolutePath());
                this.audioFile = null;
            } else {
                this.cancelLoadWaveForm();
                this.audioFile = audio;
                log.info((Object)("load-audio:" + this.audioFile));
                if (TimeBaseFileObjectReadUtils.isWavFile(this.audioFile.getName())) {
                    this.waveFormFigureCanvas.loadEmpty(WaveUtils.countAudioMillisecond((File)this.audioFile));
                    new LoadWave(AudioSystem.getAudioInputStream(this.audioFile), this.audioFile).start();
                    this.player = new JavaSoundAudioPlayer();
                } else if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                    this.cancelLoadWaveForm();
                    try {
                        log.trace((Object)("load-mp3:" + this.audioFile));
                        this.waveFormFigureCanvas.loadEmpty(MP3Utils.getAudioDurationTimeQuickly((File)this.audioFile));
                        new LoadWave(MP3Utils.toPCMAudioInputStream((InputStream)new FileInputStream(this.audioFile)), this.audioFile).start();
                        this.player = new JavaLayerMP3Player();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedAudioFileException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.cancelLoadWaveForm();
            this.waveFormFigureCanvas.loadEmpty(0L);
        }
        this.setSubtitleData(baseFile, data);
        this.waveFormFigureCanvas.getInFigure().setVisible(true);
        this.lastset = System.currentTimeMillis();
    }

    public void setSubtitleData(File baseFile, TimeBaseFileObject data) {
        int i = 0;
        while (i < this.srtListFigures.length) {
            this.srtListFigures[i].setStandardSubObjectList(null);
            this.srtListFigures[i].rerect();
            ++i;
        }
        ParameterObject[] params = SubView.getSubtitleParameters(data);
        HashMap<String, String> alreadyMap = new HashMap<String, String>();
        int i2 = 0;
        while (i2 < params.length) {
            try {
                String subfilePath = params[i2].getValue();
                File subFile = this.toRelationPath(baseFile, subfilePath);
                if (!subFile.exists()) {
                    this.alertFileNotFound(subFile.getAbsolutePath());
                } else if (alreadyMap.get(subFile.getAbsolutePath()) == null) {
                    List subDataList = SubUtils.loadSub((File)subFile);
                    this.loadLabel(subfilePath, subDataList, data.getTimeParameters());
                    this.addSubs(subfilePath, i2, subDataList);
                    alreadyMap.put(subFile.getAbsolutePath(), "");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    private void loadLabel(String subfilePath, List subDataList, TimeParameterObject[] timeParameters) {
        int i = 0;
        while (i < timeParameters.length) {
            log.info((Object)(timeParameters[i] + "," + subfilePath));
            if (timeParameters[i].getName().equals(subfilePath)) {
                int j = 0;
                while (j < subDataList.size()) {
                    if (timeParameters[i].equalTime((StandardSubObject)subDataList.get(j))) {
                        log.info((Object)("mutch:" + timeParameters[i]));
                        ((StandardSubObject)subDataList.get(j)).setOption(timeParameters[i].getValue());
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static ParameterObject[] getAudioParameters(TimeBaseFileObject data) {
        ArrayList<ParameterObject> subs = new ArrayList<ParameterObject>();
        ParameterObject[] params = data.getParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().equals("file")) {
                log.trace((Object)("file:" + params[i].getValue()));
                if (TimeBaseFileObjectReadUtils.isAudioFile(params[i].getValue())) {
                    subs.add(params[i]);
                }
            }
            ++i;
        }
        return subs.toArray(new ParameterObject[subs.size()]);
    }

    public static ParameterObject[] getSubtitleParameters(TimeBaseFileObject data) {
        ArrayList<ParameterObject> subs = new ArrayList<ParameterObject>();
        ParameterObject[] params = data.getParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().equals("file")) {
                log.trace((Object)("file:" + params[i].getValue()));
                if (TimeBaseFileObjectReadUtils.isSRTFile(params[i].getValue())) {
                    subs.add(params[i]);
                }
            }
            ++i;
        }
        return subs.toArray(new ParameterObject[subs.size()]);
    }

    public void addSubs(String path, int index, List sublist) {
        this.srtListFigures[index].setStandardSubObjectList(sublist);
        this.srtListFigures[index].setSubObjectPath(path);
        this.srtListFigures[index].rerect();
        log.trace((Object)("sub-added:" + this.srtListFigures[index].getClientArea()));
    }

    private void initData() {
        log.trace((Object)"initData");
        this.stopped = true;
        this.waveFormFigureCanvas.removeWaveForm();
        this.waveFormFigureCanvas.setSelectRealValue(0, 0);
        this.waveFormFigureCanvas.setCurrentRealValue(0);
        int i = 0;
        while (i < this.srtListFigures.length) {
            if (this.srtListFigures[i] != null) {
                this.srtListFigures[i].removeAll();
            }
            ++i;
        }
        log.trace((Object)"removed-subtitle");
        this.waveFormFigureCanvas.scrollToX(0);
        this.waveFormFigureCanvas.getInFigure().setVisible(false);
        this.audioFile = null;
        this.subtitleShowText1.setText("");
        this.subtitleShowText1.repaint();
    }

    public File parseFirstAudioFile(File baseFile, TimeBaseFileObject object) {
        ParameterObject[] params = object.getParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().equals("file") && TimeBaseFileObjectReadUtils.isWavFile(params[i].getValue()) || TimeBaseFileObjectReadUtils.isMP3File(params[i].getValue())) {
                return this.toRelationPath(baseFile, params[i].getValue());
            }
            ++i;
        }
        return null;
    }

    public File toRelationPath(File file, String value) {
        if (file == null) {
            return new File(value);
        }
        return new File(PathnameUtils.createPath((String)file.getAbsolutePath(), (String)value));
    }

    private void setLayerData(File baseFile, TextAndImageFigure target, StandardSubObject sub) {
        log.trace((Object)"set layer data");
        if (sub.getText() != null && !target.getText().equals(sub.getText())) {
            target.setText(sub.getText());
            target.repaint();
        } else {
            Image image;
            String imagePath = sub.getImagePath();
            if (log.isTraceEnabled()) {
                log.trace((Object)("sub-image:" + imagePath));
            }
            if (imagePath != null && (image = this.imageCache.loadImage(new File(baseFile, imagePath).getAbsolutePath())) != null && !image.equals((Object)target.getImage())) {
                log.trace((Object)("sub-setImage:" + imagePath));
                target.setImage(image);
                target.repaint();
            }
        }
    }

    public File getSubtitleBaseFile(int index) {
        return new File(this.srtListFigures[index].getSubObjectPath()).getParentFile();
    }

    public TextAndImageFigure createTextAndImageFigure(int width, int height) {
        TextAndImageFigure subtitleShowText = new TextAndImageFigure(this.shell);
        RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_bg_color");
        subtitleShowText.setBackgroundColor(new Color((Device)this.shell.getDisplay(), c));
        RGB c2 = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_fg_color");
        subtitleShowText.setForegroundColor(new Color((Device)this.shell.getDisplay(), c2));
        int transparent = SubplayerPlugin.getDefault().getPreferenceStore().getInt("subview.layer1_transparent");
        subtitleShowText.setAlpha(transparent);
        subtitleShowText.setFont(new Font((Device)this.shell.getDisplay(), PreferenceConverter.getFontData((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_font")));
        subtitleShowText.setSize(width, height);
        return subtitleShowText;
    }

    public Figure createMixFigure(Figure main, int width, int height) {
        int shadow = 5;
        AlphaLayerFigure alpha = new AlphaLayerFigure(ColorConstants.black, 32);
        alpha.setSize(width, height);
        alpha.setLocation(new Point(shadow, shadow));
        alpha.setVisible(false);
        MixWindowFigure mix = new MixWindowFigure();
        mix.setShadowFigure((Figure)alpha);
        mix.setMainFigure(main);
        mix.setLayoutManager(null);
        mix.add((IFigure)alpha);
        mix.add((IFigure)main);
        mix.setSize(width + shadow, height + shadow);
        ResizeBox box = new ResizeBox(mix);
        mix.add((IFigure)box);
        FigureMove move = new FigureMove();
        mix.addMouseListener(move);
        mix.addMouseMotionListener(move);
        return mix;
    }

    public void createPartControl(Composite parent) {
        this.imageCache.setMaxSize(4);
        Composite component = new Composite(parent, 0);
        this.shell = parent.getShell();
        component.setLayout((Layout)new GridLayout());
        Composite panel = new Composite(component, 0);
        panel.setLayout((Layout)new RowLayout());
        panel.addKeyListener((KeyListener)new EmptyKeyListener());
        this.playButton = new Button(panel, 0);
        this.playButton.setText("play");
        Image play = ImageDescriptor.createFromURL((URL)SubplayerPlugin.getDefault().find((IPath)new Path("icons/play.png"))).createImage();
        this.playButton.setImage(play);
        this.playButton.addSelectionListener((SelectionListener)new Play());
        Button bt3 = new Button(panel, 0);
        bt3.setText("stop");
        bt3.setImage(ImageDescriptor.createFromURL((URL)SubplayerPlugin.getDefault().find((IPath)new Path("icons/stop.png"))).createImage());
        bt3.addSelectionListener((SelectionListener)new Stop());
        Button bt4 = new Button(panel, 0);
        bt4.setText("Zoom In");
        bt4.addSelectionListener((SelectionListener)new Zoomup());
        Button bt5 = new Button(panel, 0);
        bt5.setText("Zoom Out");
        bt5.addSelectionListener((SelectionListener)new Zoomdown());
        Button bt6 = new Button(panel, 0);
        bt6.setText("subplay");
        bt6.setImage(ImageDescriptor.createFromURL((URL)SubplayerPlugin.getDefault().find((IPath)new Path("icons/subplay.png"))).createImage());
        bt6.addSelectionListener((SelectionListener)new PlayRepeat());
        this.labelMove = new LabelMoveComposite(panel, 0);
        this.labelControler = new SubViewLabelControler();
        this.labelMove.setLabelControler(this.labelControler);
        this.initLabelMove();
        this.playPattern = new PlayPatternComposite(panel, 0);
        Composite base = new Composite(component, 0);
        base.setLayoutData((Object)new GridData(1808));
        FillLayout fillLayout = new FillLayout();
        base.setLayout((Layout)fillLayout);
        this.waveFormFigureCanvas = new WaveFormFigureCanvas(base);
        this.waveFormFigureCanvas.getInFigure().setVisible(false);
        this.waveFormFigureCanvas.setWaveFormListener((WaveFormListener)new ChangeSubInfo());
        this.ci = new CenterImageFigure();
        this.ci.setParentCanvas((Canvas)this.waveFormFigureCanvas);
        try {
            Image img;
            String imgPath = SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage");
            if (new File(imgPath).exists() && (img = new Image(null, imgPath)) != null) {
                this.ci.setImage(img);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.waveFormFigureCanvas.getBackgroundFigure().setLayoutManager(null);
        this.waveFormFigureCanvas.getBackgroundFigure().add((IFigure)this.ci);
        this.waveFormFigureCanvas.addKeyListener((KeyListener)new CanvasKeyListener());
        int w = 700;
        int h = 240;
        this.subtitleShowText1 = this.createTextAndImageFigure(w, h);
        Figure mix1 = this.createMixFigure(this.subtitleShowText1, w, h);
        mix1.setLocation(new Point(1, 150));
        this.subtitleShowText2 = this.createTextAndImageFigure(w, h);
        Figure mix2 = this.createMixFigure(this.subtitleShowText2, w, h);
        mix2.setLocation(new Point(1, 300));
        this.waveFormFigureCanvas.getForegroundFigure().setLayoutManager(null);
        this.waveFormFigureCanvas.setSplitFrame(0.1);
        this.waveFormFigureCanvas.getForegroundFigure().add((IFigure)mix2);
        this.waveFormFigureCanvas.getForegroundFigure().add((IFigure)mix1);
        int i = 0;
        while (i < this.srtListFigures.length) {
            this.srtListFigures[i] = new SRTListFigure(1, 1);
            this.srtListFigures[i].setScale(this.waveFormFigureCanvas.getZoom(), 1.0);
            this.srtListFigures[i].setRectangleY(this.toSubtitleY(i));
            this.srtListFigures[i].setLocation(new Point(0, 0));
            this.waveFormFigureCanvas.getInFigure().add((IFigure)this.srtListFigures[i]);
            ++i;
        }
        this.waveFormFigureCanvas.getForegroundFigure().addMouseListener((MouseListener)new SRTClick());
        this.player = new JavaSoundAudioPlayer();
        GC gc = new GC((Drawable)component.getDisplay());
        String text = "text\n\nalo";
        org.eclipse.swt.graphics.Point dm = gc.stringExtent(text);
        log.trace((Object)("dm:" + dm));
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        StatusLineContributionItem item = new StatusLineContributionItem("fileinfo", 32);
        StatusLineContributionItem item2 = new StatusLineContributionItem("subinfo", 32);
        lineManager.add((IContributionItem)item2);
        lineManager.add((IContributionItem)item);
        long time = System.currentTimeMillis();
        log.trace((Object)("loadTime:" + (System.currentTimeMillis() - time)));
        SubplayerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new PropertyCheck());
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.waveFormFigureCanvas, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
    }

    private void initLabelMove() {
        log.info((Object)"initlabelmove");
        this.labelMove.initComposite();
        this.labelMove.addTarget("subtitle1");
        this.labelMove.addTarget("subtitle2");
        this.labelMove.addTarget("subtitle3");
        this.labelMove.addTarget("subtitle4");
        this.labelMove.addLabel("ALL             ", null);
        int i = 0;
        while (i < 8) {
            this.labelMove.addLabel("[" + (i + 1) + "]" + SubplayerPlugin.getDefault().getPluginPreferences().getString("subview.label" + (i + 1)), new Color(null, PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)("subview.color_label" + (i + 1)))));
            ++i;
        }
        this.labelMove.selectLabel(this.labelMove.getLastSelection());
        log.info((Object)"selected");
    }

    public int toSubtitleY(int index) {
        return 20 + 36 * index;
    }

    public int toSubtitleHeight(int index) {
        return 32;
    }

    private StatusLineContributionItem getFileInfoStatusLine() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return (StatusLineContributionItem)lineManager.find("fileinfo");
    }

    public void execTranslate(String text) {
        String[] lines = text.split("\\.");
        String newText = "";
        int i = 0;
        while (i < lines.length) {
            int index = 0;
            if (lines[i].startsWith("\n")) {
                index = 1;
            }
            newText = String.valueOf(newText) + lines[i].substring(index) + ".\n";
            ++i;
        }
        TranslateView view = (TranslateView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(TranslateView.ID);
        if (view != null) {
            view.setText(newText);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
        }
    }

    public void execWebDictionary(String text) {
        WebDictionaryView view = (WebDictionaryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(WebDictionaryView.ID);
        if (view != null) {
            view.setText(text);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
        }
    }

    public void play() {
        if (this.isPlayingAudio() || this.audioFile == null) {
            this.stop();
            return;
        }
        try {
            if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                MP3Utils.getAudioFormat((InputStream)new FileInputStream(this.audioFile));
            } else {
                WaveUtils.getAudioFormat((File)this.audioFile);
            }
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.selection = this.waveFormFigureCanvas.getSelection();
        if (this.selection == null || this.selection.x == 0 && this.selection.y == 0) {
            this.selection = new Point(this.waveFormFigureCanvas.getCurrentRealValue(), this.waveFormFigureCanvas.getLastPosition());
        }
        long starttime = this.selection.x * 1000 / this.waveFormFigureCanvas.getBaseMemoryPixel();
        long endtime = this.selection.y * 1000 / this.waveFormFigureCanvas.getBaseMemoryPixel();
        this.duration = endtime - starttime;
        log.trace((Object)("duration:" + starttime + "," + endtime));
        this.player.setStopper((AudioStopper)new PlayStop());
        this.player.setAudioListener((AudioListener)new AudioMove());
        this.playButton.setEnabled(false);
        Thread t = new Thread(new Playing(this.audioFile, starttime, endtime));
        t.start();
    }

    public void play(long start, long end) {
    }

    public void stop() {
        log.trace((Object)"call stop");
        this.stopped = true;
        this.shell.getDisplay().asyncExec((Runnable)new EnablePlay());
        this.playMoveSelection = false;
        if (this.multiTimeAudioPlayer != null) {
            this.multiTimeAudioPlayer.stop();
        }
    }

    public boolean isPlayingAudio() {
        return !this.stopped;
    }

    public int timeToRealValue(long time) {
        return (int)(time * (long)this.waveFormFigureCanvas.getBaseMemoryPixel() / 1000L);
    }

    public void setFocus() {
        this.waveFormFigureCanvas.setFocus();
    }

    public void editFile() {
        File file = this.subApplication.getFile();
        log.info((Object)("file:" + file));
        if (this.editShell == null || this.editShell.isDisposed()) {
            this.editShell = new Shell(this.shell);
            this.editShell.setSize(640, 400);
            new TimeBaseFileWindow(file, this.timeBaseFileObject, new EditExecuter(), this.editShell);
            this.editShell.open();
        } else {
            log.info((Object)"edit-active:");
            this.editShell.setActive();
        }
    }

    public void openFile() {
        if (this.isPlayingAudio()) {
            this.stop();
        }
        this.subApplication.openFile();
        log.info((Object)this.labelMove);
        this.currentStandardSubObject = null;
        this.waveFormFigureCanvas.setRectangleRealValue(null);
        this.labelMove.updateButtons();
    }

    public void saveFile() {
        this.subApplication.saveFile();
    }

    public void saveAsFile() {
        this.subApplication.saveAsFile();
    }

    public void execLabel(int index) {
        log.info((Object)("label:" + index));
        if (this.currentStandardSubObject != null) {
            if (index == 1) {
                this.currentStandardSubObject.setOption(null);
                boolean changed = this.updateTimeBaseData(this.currentStandardSubObject);
                if (changed) {
                    this.subApplication.setNeedSave(true);
                }
            } else if (index == 0) {
                log.warn((Object)"0 never called");
            } else {
                this.currentStandardSubObject.setOption("" + index);
                boolean changed = this.updateTimeBaseData(this.currentStandardSubObject);
                if (changed) {
                    this.subApplication.setNeedSave(true);
                }
            }
            this.waveFormFigureCanvas.getInFigure().repaint();
        }
        this.labelMove.updateButtons();
    }

    private boolean updateTimeBaseData(StandardSubObject subObject) {
        TimeParameterObject timeObject;
        int subtitleIndex = this.checkSubtitleIndex(subObject);
        if (subtitleIndex == -1) {
            log.warn((Object)"subtitle value wrong");
        }
        if ((timeObject = this.findTimeObject(subObject, subtitleIndex)) == null) {
            String subObjectValue = subObject.getOption();
            if (subObjectValue != null) {
                TimeParameterObject newTime = new TimeParameterObject();
                newTime.setStartTime(subObject.getStartTime());
                newTime.setEndTime(subObject.getEndTime());
                newTime.setName(this.getSubtitlePathName(subtitleIndex));
                newTime.setValue(subObjectValue);
                this.timeBaseFileObject.addTimeParameter(newTime);
                log.info((Object)("add-time:" + newTime));
                return true;
            }
        } else {
            String subObjectValue = subObject.getOption();
            if (subObjectValue == null) {
                subObjectValue = "1";
            }
            if (!timeObject.getValue().equals(subObjectValue)) {
                if (subObjectValue.equals("1")) {
                    this.timeBaseFileObject.removeTimeParameter(timeObject);
                    log.info((Object)"remove-time:");
                } else {
                    timeObject.setValue(subObjectValue);
                    log.info((Object)("edit-time:" + timeObject));
                }
                return true;
            }
        }
        return false;
    }

    private TimeParameterObject findTimeObject(StandardSubObject subObject, int subtitleIndex) {
        TimeParameterObject[] timeObjects = this.timeBaseFileObject.getTimeParameters();
        String timeObjectName = this.getSubtitlePathName(subtitleIndex);
        int i = 0;
        while (i < timeObjects.length) {
            if (timeObjects[i].getName().equals(timeObjectName) && timeObjects[i].getStartTime() == subObject.getStartTime() && timeObjects[i].getEndTime() == subObject.getEndTime()) {
                return timeObjects[i];
            }
            ++i;
        }
        return null;
    }

    private String getSubtitlePathName(int subtitleIndex) {
        ParameterObject[] subs = SubView.getSubtitleParameters(this.timeBaseFileObject);
        if (subs.length < subtitleIndex) {
            log.warn((Object)"invalid index");
            return null;
        }
        return subs[subtitleIndex].getValue();
    }

    private int checkSubtitleIndex(StandardSubObject subObject) {
        int i = 0;
        while (i < this.srtListFigures.length) {
            int j = 0;
            while (j < this.srtListFigures[i].getStandardSubObjectList().size()) {
                if (this.srtListFigures[i].getStandardSubObjectList().get(j) == subObject) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private StandardSubObject findFirstSub(int index) {
        if (this.srtListFigures.length > index) {
            if (this.srtListFigures[index].getStandardSubObjectList() == null) {
                return null;
            }
            if (this.srtListFigures[index].getStandardSubObjectList().size() > 0) {
                return (StandardSubObject)this.srtListFigures[0].getStandardSubObjectList().get(0);
            }
        }
        return null;
    }

    private StandardSubObject findFirstSub(int index, String value) {
        if (this.srtListFigures.length > index) {
            if (this.srtListFigures[index].getStandardSubObjectList() == null) {
                return null;
            }
            int i = 0;
            while (i < this.srtListFigures[index].getStandardSubObjectList().size()) {
                StandardSubObject sub = (StandardSubObject)this.srtListFigures[index].getStandardSubObjectList().get(i);
                if (ObjectUtils.equals((Object)sub.getOption(), (Object)value)) {
                    return sub;
                }
                ++i;
            }
        }
        return null;
    }

    private StandardSubObject findPrevSubtitle(StandardSubObject subtitle, boolean isSame) {
        int i = 0;
        while (i < this.srtListFigures.length) {
            int j = 0;
            while (j < this.srtListFigures[i].getStandardSubObjectList().size()) {
                if (this.srtListFigures[i].getStandardSubObjectList().get(j) == subtitle) {
                    int k = j - 1;
                    while (k >= 0) {
                        StandardSubObject nextSubtitle = (StandardSubObject)this.srtListFigures[i].getStandardSubObjectList().get(k);
                        if (isSame) {
                            if (ObjectUtils.equals((Object)subtitle.getOption(), (Object)nextSubtitle.getOption())) {
                                return nextSubtitle;
                            }
                        } else {
                            return nextSubtitle;
                        }
                        --k;
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private StandardSubObject findNextSubtitle(StandardSubObject subtitle, boolean isSame) {
        int i = 0;
        while (i < this.srtListFigures.length) {
            int j = 0;
            while (j < this.srtListFigures[i].getStandardSubObjectList().size()) {
                if (this.srtListFigures[i].getStandardSubObjectList().get(j) == subtitle) {
                    int k = j + 1;
                    while (k < this.srtListFigures[i].getStandardSubObjectList().size()) {
                        StandardSubObject nextSubtitle = (StandardSubObject)this.srtListFigures[i].getStandardSubObjectList().get(k);
                        if (isSame) {
                            if (ObjectUtils.equals((Object)subtitle.getOption(), (Object)nextSubtitle.getOption())) {
                                return nextSubtitle;
                            }
                        } else {
                            return nextSubtitle;
                        }
                        ++k;
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private int getSubtitleIndex(StandardSubObject subtitle) {
        int i = 0;
        while (i < this.srtListFigures.length) {
            int j = 0;
            while (j < this.srtListFigures[i].getStandardSubObjectList().size()) {
                if (this.srtListFigures[i].getStandardSubObjectList().get(j) == subtitle) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void moveSubtitleNext() {
        StandardSubObject sub = null;
        int index = 0;
        if (this.currentStandardSubObject == null) {
            sub = this.findFirstSub(0);
            index = 0;
        } else {
            sub = this.findNextSubtitle(this.currentStandardSubObject, false);
            index = this.getSubtitleIndex(this.currentStandardSubObject);
        }
        if (sub != null) {
            this.selectSubtitle(index, sub);
        }
    }

    public void moveSubtitlePrev() {
        StandardSubObject sub = null;
        int index = 0;
        if (this.currentStandardSubObject == null) {
            sub = this.findFirstSub(0);
            index = 0;
        } else {
            sub = this.findPrevSubtitle(this.currentStandardSubObject, false);
            index = this.getSubtitleIndex(this.currentStandardSubObject);
        }
        if (sub != null) {
            this.selectSubtitle(index, sub);
        }
    }

    public void moveSubtitleLabelNext() {
        StandardSubObject sub = null;
        int index = 0;
        if (this.currentStandardSubObject == null) {
            sub = this.findFirstSub(0);
            index = 0;
        } else {
            sub = this.findNextSubtitle(this.currentStandardSubObject, true);
            index = this.getSubtitleIndex(this.currentStandardSubObject);
        }
        if (sub != null) {
            this.selectSubtitle(index, sub);
        }
    }

    public void moveSubtitleLabelPrev() {
        StandardSubObject sub = null;
        int index = 0;
        if (this.currentStandardSubObject == null) {
            sub = this.findFirstSub(0);
            index = 0;
        } else {
            sub = this.findPrevSubtitle(this.currentStandardSubObject, true);
            index = this.getSubtitleIndex(this.currentStandardSubObject);
        }
        if (sub != null) {
            this.selectSubtitle(index, sub);
        }
    }

    public void selectSubtitle(int index, StandardSubObject subtitle) {
        int lastX;
        log.info((Object)("index:" + index + " sub:" + subtitle));
        int dx1 = this.timeToRealValue(subtitle.getStartTime());
        int dx2 = this.timeToRealValue(subtitle.getEndTime());
        this.currentStandardSubObject = subtitle;
        this.waveFormFigureCanvas.setSelectRealValue(dx1, dx2);
        this.waveFormFigureCanvas.setRectangleRealValue(new Rectangle(dx1, this.toSubtitleY(index), dx2 - dx1, this.toSubtitleHeight(index)));
        int firstX = this.waveFormFigureCanvas.realToCanvasValue(dx1);
        if (firstX < 8) {
            this.waveFormFigureCanvas.scrollToX(this.waveFormFigureCanvas.getHorizontalBar().getSelection() + Math.min(-200, firstX + 8 - 100));
        }
        if ((lastX = this.waveFormFigureCanvas.realToCanvasValue(dx2)) > this.waveFormFigureCanvas.getClientArea().width) {
            int scrollValue = Math.max(200, lastX - this.waveFormFigureCanvas.getClientArea().width + 100);
            log.info((Object)("client=" + this.waveFormFigureCanvas.getClientArea().width + ",lastX=" + lastX + ",scroll:" + scrollValue));
            this.waveFormFigureCanvas.scrollToX(this.waveFormFigureCanvas.getHorizontalBar().getSelection() + scrollValue);
        }
        this.labelMove.updateButtons();
        if (index == 0) {
            this.setLayerData(this.getSubtitleBaseFile(index), this.subtitleShowText1, subtitle);
        } else if (index == 1) {
            this.setLayerData(this.getSubtitleBaseFile(index), this.subtitleShowText2, subtitle);
        } else {
            log.warn((Object)"currently don't support");
        }
    }

    public void singleRepeat() {
        if (this.isPlayingAudio() || this.currentStandardSubObject == null) {
            log.trace((Object)"do nothing:now playing or current null");
            return;
        }
        this.stopped = false;
        this.playButton.setEnabled(false);
        this.multiTimeAudioPlayer = new MultiTimeAudioPlayer();
        this.multiTimeAudioPlayer.setWaitTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt("subplay.wait"));
        this.multiTimeAudioPlayer.setMultiTimeAudioListener(new SubViewMultiTimeAudioListener());
        int cIndex = this.getSubtitleIndex(this.currentStandardSubObject);
        this.multiTimeAudioPlayer.addData(this.currentStandardSubObject);
        this.multiTimeAudioPlayer.setIndex(cIndex);
        this.multiTimeAudioPlayer.setPlayPattern(new int[]{2});
        this.multiTimeAudioPlayer.setAudioFile(this.audioFile);
        MultiTimeAudioPlayerPlay thread = new MultiTimeAudioPlayerPlay(this.multiTimeAudioPlayer);
        thread.start();
    }

    public void playRepeat() {
        if (this.isPlayingAudio()) {
            log.trace((Object)"do nothing:now playing");
            return;
        }
        this.stopped = false;
        this.playButton.setEnabled(false);
        this.multiTimeAudioPlayer = new MultiTimeAudioPlayer();
        this.multiTimeAudioPlayer.setRepeat(this.playPattern.isLoop());
        this.multiTimeAudioPlayer.setWaitTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt("subplay.wait"));
        this.multiTimeAudioPlayer.setExtendTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt("subplay.extend"));
        this.multiTimeAudioPlayer.setPlayPattern(this.playPattern.getPlayPattern());
        this.multiTimeAudioPlayer.setMultiTimeAudioListener(new SubViewMultiTimeAudioListener());
        int target = this.labelMove.getTarget();
        int label = this.labelMove.getLabel();
        log.info((Object)("play:target=" + target + ",label=" + label));
        if (this.srtListFigures[target].getStandardSubObjectList().size() > 0) {
            String option = null;
            if (label > 1) {
                option = "" + label;
            }
            int cIndex = 0;
            boolean isCheck = false;
            if (this.currentStandardSubObject != null && this.getSubtitleIndex(this.currentStandardSubObject) == target && (label == 0 || ObjectUtils.equals((Object)this.currentStandardSubObject.getOption(), (Object)option))) {
                isCheck = true;
            }
            int index = 0;
            int i = 0;
            while (i < this.srtListFigures[target].getStandardSubObjectList().size()) {
                StandardSubObject sub = (StandardSubObject)this.srtListFigures[target].getStandardSubObjectList().get(i);
                if (label == 0 || ObjectUtils.equals((Object)sub.getOption(), (Object)option)) {
                    if (isCheck && sub == this.currentStandardSubObject) {
                        cIndex = index;
                        log.info((Object)("cindex:" + index));
                    }
                    this.multiTimeAudioPlayer.addData(sub);
                    log.trace((Object)("addsub:" + sub));
                    ++index;
                }
                ++i;
            }
            this.multiTimeAudioPlayer.setIndex(cIndex);
            this.multiTimeAudioPlayer.setAudioFile(this.audioFile);
            MultiTimeAudioPlayerPlay thread = new MultiTimeAudioPlayerPlay(this.multiTimeAudioPlayer);
            thread.start();
        }
    }

    public class SubApplication
    extends RCPFileApplication {
        protected void execOpen() {
            SubView.this.initData();
            TimeBaseFileObject data = null;
            log.trace((Object)("read-data:" + this.getFile()));
            data = TimeBaseFileObjectReadUtils.read(this.getFile());
            if (data == null) {
                log.info((Object)("invalid data:" + this.getFile()));
                SubView.this.audioFile = null;
            } else {
                try {
                    SubView.this.setData(this.getFile(), data);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (TimeBaseFileObjectReadUtils.checkType(this.getFile()) == 1) {
                this.setFile(null);
            }
            this.saveStatusChanged();
        }

        public void toLoadRelativePath(File base, TimeBaseFileObject timeBaseFileObject) {
            String baseDir = base.getParent();
            ParameterObject[] params = timeBaseFileObject.getParameters();
            int i = 0;
            while (i < params.length) {
                String newValue;
                String old;
                if (params[i].getName().equals("file") && !(old = params[i].getValue()).equals(newValue = PathnameUtils.getRemainPath((String)baseDir, (String)params[i].getValue()))) {
                    log.info((Object)("oldValue=" + old + ",newValue=" + newValue));
                    this.changeTimeParam(timeBaseFileObject, old, newValue);
                    params[i].setValue(newValue);
                }
                ++i;
            }
        }

        private void changeTimeParam(TimeBaseFileObject timeBaseFileObject, String old, String newValue) {
            TimeParameterObject[] times = timeBaseFileObject.getTimeParameters();
            int i = 0;
            while (i < times.length) {
                if (times[i].getName().equals(old)) {
                    times[i].setName(newValue);
                }
                ++i;
            }
        }

        protected void execSave() {
            log.info((Object)"dosave");
            this.toLoadRelativePath(this.getFile(), SubView.this.timeBaseFileObject);
            try {
                BeanWriter writer = new BeanWriter((Writer)new FileWriter(this.getFile()));
                writer.writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
                writer.write((Object)SubView.this.timeBaseFileObject);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }

        protected void saveStatusChanged() {
            String title = this.getFile() == null ? "Untitled" : this.getFile().getName();
            if (this.isNeedSave()) {
                title = "*" + title;
            }
            log.info((Object)("saveStatusChanged:" + title));
            SubView.this.getFileInfoStatusLine().setText(title);
        }

        protected void execNew() {
        }

        protected void execOpenSubFile(File file) {
            File srtFile;
            SubView.this.initData();
            TimeBaseFileObject data = null;
            if (TimeBaseFileObjectReadUtils.isWavFile(file.getName())) {
                data = new TimeBaseFileObject();
                data.addParameter(new ParameterObject("file", file.getAbsolutePath()));
                srtFile = new File(file.getParentFile(), TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(), "srt"));
                if (srtFile.exists()) {
                    data.addParameter(new ParameterObject("file", srtFile.getAbsolutePath()));
                }
            } else if (TimeBaseFileObjectReadUtils.isMP3File(file.getName())) {
                data = new TimeBaseFileObject();
                data.addParameter(new ParameterObject("file", file.getAbsolutePath()));
                srtFile = new File(file.getParentFile(), TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(), "srt"));
                if (srtFile.exists()) {
                    data.addParameter(new ParameterObject("file", srtFile.getAbsolutePath()));
                }
            }
            if (data != null) {
                try {
                    SubView.this.setData(null, data);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.setFile(null);
            this.saveStatusChanged();
        }

        protected boolean isStandardFile(File file) {
            return TimeBaseFileObjectReadUtils.isXMLFile(file.getName());
        }
    }

    public class LoadWave
    extends Thread {
        private AudioInputStream audioInputStream;
        private File targetAudioFile;

        public LoadWave(AudioInputStream audioInputStream, File targetAudioFile) {
            this.audioInputStream = audioInputStream;
            this.targetAudioFile = targetAudioFile;
        }

        public void run() {
            List byteList = SubView.this.waveFormFigureCanvas.loadByteList(this.audioInputStream);
            if (SubView.this.audioFile != null && SubView.this.audioFile.getAbsolutePath().equals(SubView.this.audioFile.getAbsolutePath())) {
                log.trace((Object)("setWaveFirugre:audio=" + SubView.this.audioFile + ",target=" + this.targetAudioFile.getAbsolutePath()));
                SubView.this.shell.getDisplay().asyncExec((Runnable)new SetWaveFormFigure(byteList));
            }
        }
    }

    public class SetWaveFormFigure
    extends Thread {
        List byteList;

        public SetWaveFormFigure(List byteList) {
            this.byteList = byteList;
        }

        public void run() {
            SubView.this.waveFormFigureCanvas.setByteData(this.byteList);
        }
    }

    public class ChangeSubInfo
    implements WaveFormListener {
        public void changeCurrent(long arg0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("changed:" + arg0));
            }
            int j = 0;
            while (j < SubView.this.srtListFigures.length) {
                if (SubView.this.srtListFigures[j] != null && SubView.this.srtListFigures[j].getStandardSubObjectList() != null && SubView.this.srtListFigures[j].getStandardSubObjectList().size() > 0) {
                    StandardSubObject[] subs = SubView.this.srtListFigures[j].getStandardSubObjectList().toArray(new StandardSubObject[SubView.this.srtListFigures[j].getStandardSubObjectList().size()]);
                    File baseFile = SubView.this.getSubtitleBaseFile(j);
                    int i = 0;
                    while (i < subs.length) {
                        if (subs[i].getStartTime() <= arg0 && subs[i].getEndTime() >= arg0) {
                            log.trace((Object)("sub-selected:" + subs[i].getText()));
                            if (subs[i].getText() != null && !SubView.this.subtitleShowText1.getText().equals(subs[i].getText())) {
                                if (j == 0) {
                                    SubView.this.subtitleShowText1.setText(subs[i].getText());
                                    SubView.this.subtitleShowText1.repaint();
                                } else {
                                    SubView.this.subtitleShowText2.setText(subs[i].getText());
                                    SubView.this.subtitleShowText2.repaint();
                                }
                            } else {
                                String imagePath = subs[i].getImagePath();
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("sub-image:" + imagePath));
                                }
                                if (imagePath != null) {
                                    Image image = SubView.this.imageCache.loadImage(new File(baseFile, imagePath).getAbsolutePath());
                                    if (j == 0) {
                                        if (image != null && !image.equals((Object)SubView.this.subtitleShowText1.getImage())) {
                                            log.trace((Object)("sub-setImage:" + imagePath));
                                            SubView.this.subtitleShowText1.setImage(image);
                                            SubView.this.subtitleShowText1.repaint();
                                        } else if (image != null) {
                                            log.trace((Object)("sub-sameimage:" + imagePath));
                                        }
                                    } else if (image != null && !image.equals((Object)SubView.this.subtitleShowText2.getImage())) {
                                        log.trace((Object)("sub-setImage:" + imagePath));
                                        SubView.this.subtitleShowText2.setImage(image);
                                        SubView.this.subtitleShowText2.repaint();
                                    } else if (image != null) {
                                        log.trace((Object)("sub-sameimage:" + imagePath));
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            if (SubView.this.isPlayingAudio()) {
                SubView.this.stop();
            }
            SubView.this.subApplication.openFile(new File(files[0]));
        }
    }

    public class CanvasKeyListener
    implements KeyListener,
    Runnable {
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (SubView.this.shiftPressed) {
                System.out.println("shift-press");
                while (SubView.this.shiftPressed) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("shift-off");
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 131072) {
                if (!SubView.this.shiftPressed) {
                    SubView.this.shiftPressed = true;
                    Thread t = new Thread(this);
                    t.start();
                }
            } else {
                SubView.this.shiftPressed = false;
            }
        }

        public void keyReleased(KeyEvent e) {
            SubView.this.shiftPressed = false;
        }
    }

    public class EmptyKeyListener
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            log.trace((Object)("pressed:" + e));
        }

        public void keyReleased(KeyEvent e) {
            log.trace((Object)("released:" + e));
        }
    }

    public class PropertyCheck
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            log.trace((Object)("propertychange:" + event.getProperty() + "," + event.getNewValue() + "," + event.getOldValue()));
            if (event.getProperty().equals("subview.layer1_bg_color")) {
                RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_bg_color");
                SubView.this.subtitleShowText1.setBackgroundColor(new Color(null, c));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setBackgroundColor(new Color(null, c));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_fg_color")) {
                RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_fg_color");
                SubView.this.subtitleShowText1.setForegroundColor(new Color(null, c));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setForegroundColor(new Color(null, c));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_transparent")) {
                int transparent = Integer.parseInt((String)event.getNewValue());
                log.trace((Object)("new-trans:" + transparent));
                SubView.this.subtitleShowText1.setAlpha(transparent);
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setAlpha(transparent);
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_font")) {
                log.trace((Object)("font:" + SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.layer1_font")));
                FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_font");
                SubView.this.subtitleShowText1.setFont(new Font(null, fontData));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setFont(new Font(null, fontData));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.bgimage")) {
                log.info((Object)("bgimage:" + SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage")));
                Image img = new Image(null, SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage"));
                if (img != null) {
                    if (SubView.this.ci.getImage() != null) {
                        SubView.this.ci.getImage().dispose();
                    }
                    SubView.this.ci.setImage(img);
                    SubView.this.ci.repaint(SubView.this.ci.getClientArea());
                }
            } else if (event.getProperty().startsWith("subview.color_label")) {
                log.info((Object)"change color");
                int index = LabelPage.toIndex(event.getProperty());
                int i = 0;
                while (i < SubView.this.srtListFigures.length) {
                    SubView.this.srtListFigures[i].initColor(index - 1);
                    ++i;
                }
                SubView.this.waveFormFigureCanvas.getInFigure().repaint();
                SubView.this.initLabelMove();
            } else if (event.getProperty().startsWith("subview.label")) {
                SubView.this.initLabelMove();
            }
        }
    }

    public class ResizeBox
    extends Figure
    implements MouseListener,
    MouseMotionListener {
        int minWidth = 100;
        int minHeight = 100;
        int clickx;
        int clicky;
        Figure target;
        int sizeX = 20;
        int sizeY = 20;
        int marginX = 7;
        int marginY = 7;

        public ResizeBox(Figure target) {
            this.target = target;
            this.setForegroundColor(ColorConstants.gray);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setSize(this.sizeX, this.sizeY);
            this.setLocation(this.newPoint());
        }

        public void mousePressed(MouseEvent arg0) {
            this.clickx = arg0.x;
            this.clicky = arg0.y;
            log.trace((Object)("click:" + this.clickx + "," + this.clicky));
            arg0.consume();
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseDoubleClicked(MouseEvent arg0) {
        }

        public void mouseDragged(MouseEvent arg0) {
            int moveX = this.clickx - arg0.x;
            int moveY = this.clicky - arg0.y;
            this.clickx = arg0.x;
            this.clicky = arg0.y;
            boolean movex = false;
            boolean movey = false;
            int newSizeX = 0;
            int newSizeY = 0;
            if (this.target.getSize().width > this.minWidth) {
                newSizeX = Math.max(this.minWidth, this.target.getSize().width - moveX);
            } else if (this.target.getSize().width <= this.minWidth) {
                newSizeX = Math.max(this.minWidth, this.target.getSize().width - moveX);
            }
            if (this.target.getSize().height > this.minHeight) {
                newSizeY = Math.max(this.minHeight, this.target.getSize().height - moveY);
            } else if (this.target.getSize().height <= this.minHeight) {
                newSizeY = Math.max(this.minHeight, this.target.getSize().height - moveY);
            }
            if (newSizeX > 0 && newSizeY > 0) {
                log.trace((Object)("newsize:" + newSizeX + "," + newSizeY));
                SubView.this.shell.getDisplay().syncExec((Runnable)new Resize(this.target, newSizeX, newSizeY));
            }
            if (newSizeX > this.minWidth) {
                movex = true;
            }
            if (newSizeY > this.minHeight) {
                movey = true;
            }
            if (movex || movey) {
                Point current = this.newPoint();
                log.trace((Object)("newPoint:" + current));
                this.setLocation(current);
            }
            arg0.consume();
        }

        public Point newPoint() {
            return new Point(this.target.getLocation().x + this.target.getSize().width - this.sizeX - this.marginX, this.target.getLocation().y + this.target.getSize().height - this.sizeY - this.marginY);
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mouseHover(MouseEvent arg0) {
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void paintFigure(Graphics g) {
            g.drawRectangle(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width - 1, this.getClientArea().height - 1);
        }

        public class Resize
        implements Runnable {
            Figure target;
            int w;
            int h;

            public Resize(Figure target, int w, int h) {
                this.target = target;
                this.w = w;
                this.h = h;
            }

            public void run() {
                this.target.setSize(this.w, this.h);
            }
        }
    }

    public class MixWindowFigure
    extends Figure {
        private Figure shadowFigure;
        private Figure mainFigure;
        int shadowSizeX = 5;
        int shadowSizeY = 5;

        public Figure getMainFigure() {
            return this.mainFigure;
        }

        public void setMainFigure(Figure mainFigure) {
            this.mainFigure = mainFigure;
        }

        public Figure getShadowFigure() {
            return this.shadowFigure;
        }

        public void setShadowFigure(Figure shadowFigure) {
            this.shadowFigure = shadowFigure;
        }

        public void setSize(int w, int h) {
            super.setSize(w, h);
            this.shadowFigure.setSize(this.getSize().width - this.shadowSizeX, this.getSize().height - this.shadowSizeY);
            this.mainFigure.setSize(this.getSize().width - this.shadowSizeX, this.getSize().height - this.shadowSizeY);
        }
    }

    public class FigureMove
    implements MouseMotionListener,
    MouseListener {
        int downx = 0;
        int downy = 0;
        boolean pressed = false;

        public void mouseDragged(MouseEvent me) {
            if (this.pressed) {
                log.trace((Object)("dragged:" + me));
                Figure figure = (Figure)me.getSource();
                int moveX = this.downx - me.x;
                int moveY = this.downy - me.y;
                log.trace((Object)("moveX=" + moveX + ",moveY=" + moveY));
                Point loc = figure.getLocation();
                loc.x -= moveX;
                loc.y -= moveY;
                log.trace((Object)("locx=" + loc.x + ",loc.y=" + loc.y));
                figure.setLocation(loc);
                this.downx = me.x;
                this.downy = me.y;
                me.consume();
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            Figure figure = (Figure)me.getSource();
            IFigure parent = figure.getParent();
            List list = parent.getChildren();
            int index = 0;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) == figure) {
                    index = i;
                    break;
                }
                ++i;
            }
            log.trace((Object)("index:" + index));
            if (index != list.size() - 1) {
                parent.remove((IFigure)figure);
                parent.add((IFigure)figure);
            }
            this.downx = me.x;
            this.downy = me.y;
            this.pressed = true;
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            this.pressed = false;
        }

        public void mouseDoubleClicked(MouseEvent me) {
            Figure main;
            log.info((Object)("doubleclick:" + me.x + "," + me.y));
            Figure figure = (Figure)me.getSource();
            if (figure instanceof MixWindowFigure && (main = ((MixWindowFigure)figure).getMainFigure()) instanceof TextAndImageFigure) {
                TextAndImageFigure textAndImage = (TextAndImageFigure)main;
                WrapTextPainter painter = ((TextAndImageFigure)main).getWrapTextPainter();
                int index = painter.getClickIndex(me.x - main.getClientArea().x - textAndImage.getMarginX(), me.y - main.getClientArea().y - textAndImage.getMarginY());
                if (index != -1) {
                    String word = painter.getWord(index);
                    log.info((Object)("word:" + word));
                    if (word.equals("")) {
                        SubView.this.execTranslate(textAndImage.getText());
                    } else {
                        SubView.this.execWebDictionary(word);
                    }
                } else {
                    SubView.this.execTranslate(textAndImage.getText());
                }
            }
        }
    }

    public class SRTClick
    implements MouseListener {
        public void mousePressed(MouseEvent me) {
            int i = 0;
            while (i < SubView.this.srtListFigures.length) {
                StandardSubObject[] subs = SubView.this.srtListFigures[i].containSubtitles(me.x, me.y);
                if (subs.length > 0) {
                    SubView.this.selectSubtitle(i, subs[0]);
                    me.consume();
                    return;
                }
                ++i;
            }
            SubView.this.currentStandardSubObject = null;
            SubView.this.waveFormFigureCanvas.setRectangleRealValue(null);
        }

        public void mouseReleased(MouseEvent me) {
            if (SubView.this.lastset + 500L > System.currentTimeMillis()) {
                log.trace((Object)"opend so soon");
                return;
            }
            int i = 0;
            while (i < SubView.this.srtListFigures.length) {
                StandardSubObject[] subs = SubView.this.srtListFigures[i].containSubtitles(me.x, me.y);
                if (subs.length > 0) {
                    SubView.this.selectSubtitle(i, subs[0]);
                    me.consume();
                    return;
                }
                ++i;
            }
            SubView.this.currentStandardSubObject = null;
        }

        public void mouseDoubleClicked(MouseEvent me) {
            if (!SubView.this.isPlayingAudio()) {
                if ((me.getState() & 0x20000) > 0) {
                    SubView.this.singleRepeat();
                } else {
                    SubView.this.play();
                }
            }
        }
    }

    public class Zoomup
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.zoomUp();
            SubView.this.waveFormFigureCanvas.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class Zoomdown
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.zoomDown();
            SubView.this.waveFormFigureCanvas.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class PlayRepeat
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.playRepeat();
            SubView.this.waveFormFigureCanvas.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class SRTFigure
    extends DoubleScalableFigure {
        long start = 1000L;
        long end = 2000L;
        private int index;
        private String text;
        int height = 32;
        AlphaLayerFigure alpha;

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setImage(Image img) {
        }

        public SRTFigure(Shell shell, int index) {
            super(1, 1);
            this.index = index;
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setScale(1.0, 1.0);
        }

        public void setScale(double w, double h) {
            this.wzoom = w;
            this.hzoom = h;
            this.setBounds(this.getRectangle());
        }

        public Rectangle getRectangle() {
            int dx = (int)((double)this.start * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
            int dx2 = (int)((double)this.end * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
            Rectangle rectangle = new Rectangle(dx, this.getClientArea().y, dx2 - dx, this.height);
            if (this.getParent() != null) {
                rectangle.x += this.getParent().getClientArea().x;
            }
            log.trace((Object)("srt-rectangle:" + rectangle));
            return rectangle;
        }

        public void paintFigure(Graphics g) {
            log.trace((Object)("srt-paint:" + this.getClientArea()));
            if (this.text != null) {
                g.setFont(new Font((Device)SubView.this.shell.getDisplay(), "MS \u660e\u671d", 12, 0));
                g.drawString(this.text, this.getClientArea().x, this.getClientArea().y);
            }
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public class Stop
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.setFocus();
            SubView.this.stop();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class PlayStop
    implements AudioStopper {
        public boolean isStopped() {
            return SubView.this.stopped;
        }

        public void setStopped(boolean arg0) {
        }
    }

    public class SRTListFigure
    extends DoubleScalableFigure {
        List standardSubObjectList = new ArrayList(0);
        private Rectangle[] inRectangle;
        private int rectangleY = 32;
        private int rectangleHeight = 32;
        private Image[] labelImages = new Image[8];
        private String subObjectPath;

        public SRTListFigure(int arg0, int arg1) {
            super(arg0, arg1);
            int i = 0;
            while (i < 8) {
                this.initColor(i);
                ++i;
            }
        }

        public void initColor(int index) {
            RGB color = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)("subview.color_label" + (index + 1)));
            this.labelImages[index] = AlphaUtils.createColorAlphaImageData((Color)new Color((Device)SubView.this.shell.getDisplay(), color), (int)128);
        }

        public void setStandardSubObjectList(List list) {
            this.standardSubObjectList = list;
        }

        public StandardSubObject[] containSubtitles(int x, int y) {
            if (this.standardSubObjectList != null) {
                ArrayList tmp = new ArrayList();
                int i = 0;
                while (i < this.inRectangle.length) {
                    if (this.inRectangle[i].contains(-this.getParent().getBounds().x + x, y)) {
                        tmp.add(this.standardSubObjectList.get(i));
                    }
                    ++i;
                }
                return tmp.toArray(new StandardSubObject[tmp.size()]);
            }
            return new StandardSubObject[0];
        }

        public void setScale(double w, double h) {
            super.setScale(w, h);
            this.rerect();
        }

        public void rerect() {
            log.trace((Object)"rerect");
            if (this.standardSubObjectList != null) {
                StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
                Rectangle[] tmpRect = new Rectangle[subs.length];
                int i = 0;
                while (i < subs.length) {
                    int dx = (int)((double)subs[i].getStartTime() * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
                    int dx2 = (int)((double)subs[i].getEndTime() * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
                    tmpRect[i] = new Rectangle(dx, this.rectangleY, dx2 - dx, this.rectangleHeight);
                    log.trace((Object)("subrect:" + tmpRect[i]));
                    ++i;
                }
                this.inRectangle = tmpRect;
            } else {
                this.inRectangle = new Rectangle[0];
            }
        }

        public void paintFigure(Graphics g) {
            if (this.inRectangle == null) {
                this.rerect();
            }
            log.trace((Object)("srtlist-paint:" + this.getClientArea() + ",inRectangle=" + this.inRectangle.length));
            int i = 0;
            while (i < this.inRectangle.length) {
                Rectangle drawRec = new Rectangle(this.inRectangle[i].x + this.getParent().getBounds().x, this.inRectangle[i].y, this.inRectangle[i].width, this.inRectangle[i].height);
                int labelIndex = 0;
                String option = ((StandardSubObject)this.standardSubObjectList.get(i)).getOption();
                if (option != null) {
                    labelIndex = Integer.parseInt(option) - 1;
                }
                g.drawImage(this.labelImages[labelIndex], new Rectangle(this.labelImages[0].getBounds()), drawRec);
                ++i;
            }
        }

        public int getRectangleHeight() {
            return this.rectangleHeight;
        }

        public void setRectangleHeight(int rectangleHeight) {
            this.rectangleHeight = rectangleHeight;
        }

        public int getRectangleY() {
            return this.rectangleY;
        }

        public void setRectangleY(int rectangleY) {
            this.rectangleY = rectangleY;
        }

        public List getStandardSubObjectList() {
            return this.standardSubObjectList;
        }

        public String getSubObjectPath() {
            return this.subObjectPath;
        }

        public void setSubObjectPath(String subObjectPath) {
            this.subObjectPath = subObjectPath;
        }
    }

    public class EnablePlay
    implements Runnable {
        public void run() {
            SubView.this.playButton.setEnabled(true);
        }
    }

    public class Playing
    implements Runnable {
        private File file;
        private long start;
        private long end;

        public Playing(File file, long start, long end) {
            this.file = file;
            this.start = start;
            this.end = end;
        }

        public void run() {
            if (SubView.this.stopped) {
                log.trace((Object)("play-duration:" + (this.end - this.start)));
                SubView.this.stopped = false;
                try {
                    SubView.this.player.play(this.file, this.start, this.end);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
            SubView.this.stop();
        }
    }

    public class MovePosition
    implements Runnable {
        private int selection;

        public MovePosition(int selection) {
            this.selection = selection;
        }

        public void run() {
            log.trace((Object)("move-position:" + this.selection));
            SubView.this.waveFormFigureCanvas.moveCurrentPosition(this.selection);
        }
    }

    public class AudioMove
    implements AudioListener {
        public void startPlaying() {
            SubView.this.playMoveSelection = true;
            SubView.this.shell.getDisplay().syncExec((Runnable)new MovePosition(((SubView)SubView.this).selection.x));
            log.info((Object)"start-playing2");
            if (((SubView)SubView.this).selection.x == -1) {
                ((SubView)SubView.this).selection.x = 0;
            }
            PlayMove move = new PlayMove(((SubView)SubView.this).selection.x);
            Thread t = new Thread(move);
            t.start();
        }

        public void stopPlaying() {
            log.trace((Object)"stopplaying");
            SubView.this.stopped = true;
            SubView.this.playMoveSelection = false;
        }

        public void finishPlaying() {
            log.trace((Object)"finishplaying");
            SubView.this.stopped = true;
            SubView.this.playMoveSelection = false;
        }
    }

    public class PlayMove
    implements Runnable {
        int sleeptime = 30;
        int startPosition;
        private boolean canceld = false;

        public PlayMove(int start) {
            this.startPosition = start;
        }

        public void cancel() {
            this.canceld = true;
        }

        public void run() {
            long start = System.currentTimeMillis();
            log.trace((Object)("playMoveSelection=" + SubView.this.playMoveSelection + "," + this.canceld));
            while (SubView.this.playMoveSelection && !this.canceld) {
                try {
                    Thread.sleep(this.sleeptime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long played = System.currentTimeMillis() - start;
                log.trace((Object)("played:" + played + ",duration=" + SubView.this.duration));
                if (played > SubView.this.duration) break;
                SubView.this.shell.getDisplay().syncExec((Runnable)new MovePosition(this.toPosition(played)));
            }
        }

        public int toPosition(long time) {
            return SubView.this.timeToRealValue(time) + this.startPosition;
        }
    }

    public class CenterImageFigure
    extends Figure {
        private Image image;
        private Canvas parentCanvas;

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Canvas getParentCanvas() {
            return this.parentCanvas;
        }

        public void setParentCanvas(Canvas parentCanvas) {
            this.parentCanvas = parentCanvas;
            parentCanvas.addControlListener((ControlListener)new ResizeCheck());
            parentCanvas.getHorizontalBar().addSelectionListener((SelectionListener)new Selection());
        }

        public void paintFigure(Graphics g) {
            Rectangle client = new Rectangle(this.parentCanvas.getClientArea());
            Rectangle rec = g.getClip(client);
            log.trace((Object)("repaint:" + rec));
            if (this.image != null) {
                int centerX = (this.parentCanvas.getClientArea().width - this.image.getBounds().width) / 2;
                int centerY = (this.parentCanvas.getClientArea().height - this.image.getBounds().height) / 2;
                Rectangle rectangle = new Rectangle(this.getLocation().x + centerX, this.getLocation().y + centerY, this.image.getBounds().width, this.image.getBounds().height);
                log.trace((Object)("g:" + rectangle));
                g.drawImage(this.image, new Rectangle(this.image.getBounds()), rectangle);
            }
        }

        public void moveImage() {
            log.trace((Object)"move");
            this.setLocation(new Point(this.parentCanvas.getHorizontalBar().getSelection(), this.parentCanvas.getVerticalBar().getSelection()));
        }

        public class Selection
        implements SelectionListener {
            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }

        public class ResizeCheck
        implements ControlListener {
            public void controlMoved(ControlEvent e) {
                log.trace((Object)"moved");
            }

            public void controlResized(ControlEvent e) {
                log.trace((Object)"resized");
                CenterImageFigure.this.setSize(((CenterImageFigure)CenterImageFigure.this).parentCanvas.getClientArea().width, ((CenterImageFigure)CenterImageFigure.this).parentCanvas.getClientArea().height);
            }
        }
    }

    public class Play
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.setFocus();
            SubView.this.play();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DrawTextFigure
    extends Figure {
    }

    public class Select
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            log.warn((Object)"select?");
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class EditExecuter
    implements TimeBaseFileUpdater {
        public void update(TimeBaseFileObject oldObject, TimeBaseFileObject newObject) {
            log.trace((Object)"update");
            File newAudio = SubView.this.parseFirstAudioFile(SubView.this.subApplication.getFile(), newObject);
            boolean different = false;
            if (SubView.this.audioFile == null) {
                if (newAudio != null) {
                    different = true;
                }
            } else if (newAudio == null) {
                different = true;
            } else if (!SubView.this.audioFile.getAbsolutePath().equals(newAudio.getAbsolutePath())) {
                different = true;
            }
            if (different) {
                log.info((Object)("different:" + newAudio));
                SubView.this.subApplication.setNeedSave(true);
                try {
                    SubView.this.setData(SubView.this.subApplication.getFile(), newObject);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                ParameterObject[] news;
                ParameterObject[] olds;
                SubView.this.audioFile = newAudio;
                ParameterObject[] oldsaudio = SubView.getAudioParameters(oldObject);
                ParameterObject[] newsaudio = SubView.getAudioParameters(newObject);
                if (!ArrayUtils.isEquals((Object)oldsaudio, (Object)newsaudio)) {
                    SubView.this.subApplication.setNeedSave(true);
                }
                if (!ArrayUtils.isEquals((Object)(olds = SubView.getSubtitleParameters(oldObject)), (Object)(news = SubView.getSubtitleParameters(newObject)))) {
                    SubView.this.subApplication.setNeedSave(true);
                    log.info((Object)"different");
                    SubView.this.setSubtitleData(SubView.this.subApplication.getFile(), newObject);
                    SubView.this.waveFormFigureCanvas.getInFigure().setVisible(true);
                }
            }
            SubView.this.timeBaseFileObject = newObject;
        }
    }

    public class SubViewLabelControler
    implements LabelControler {
        public StandardSubObject prev(int index1, int index2) {
            if (SubView.this.srtListFigures == null || SubView.this.srtListFigures[index1] == null) {
                return null;
            }
            log.info((Object)"prev");
            if (index1 < SubView.this.srtListFigures.length && SubView.this.srtListFigures[index1].getStandardSubObjectList().size() > 0) {
                if (SubView.this.currentStandardSubObject != null) {
                    int currentIndex = SubView.this.getSubtitleIndex(SubView.this.currentStandardSubObject);
                    if (currentIndex == index1) {
                        if (index2 == 0) {
                            return SubView.this.findPrevSubtitle(SubView.this.currentStandardSubObject, false);
                        }
                        String indexValue = null;
                        if (index2 > 1) {
                            indexValue = "" + index2;
                        }
                        if (ObjectUtils.equals((Object)SubView.this.currentStandardSubObject.getOption(), indexValue)) {
                            return SubView.this.findPrevSubtitle(SubView.this.currentStandardSubObject, true);
                        }
                        return SubView.this.findFirstSub(index1, indexValue);
                    }
                    return SubView.this.findFirstSub(index1);
                }
                return SubView.this.findFirstSub(index1);
            }
            return null;
        }

        public StandardSubObject next(int index1, int index2) {
            log.trace((Object)"next");
            if (SubView.this.srtListFigures == null || SubView.this.srtListFigures[index1] == null) {
                return null;
            }
            if (index1 < SubView.this.srtListFigures.length && SubView.this.srtListFigures[index1].getStandardSubObjectList().size() > 0) {
                if (SubView.this.currentStandardSubObject != null) {
                    int currentIndex = SubView.this.getSubtitleIndex(SubView.this.currentStandardSubObject);
                    if (currentIndex == index1) {
                        if (index2 == 0) {
                            return SubView.this.findNextSubtitle(SubView.this.currentStandardSubObject, false);
                        }
                        String indexValue = null;
                        if (index2 > 1) {
                            indexValue = "" + index2;
                        }
                        if (ObjectUtils.equals((Object)SubView.this.currentStandardSubObject.getOption(), indexValue)) {
                            return SubView.this.findNextSubtitle(SubView.this.currentStandardSubObject, true);
                        }
                        return SubView.this.findFirstSub(index1, indexValue);
                    }
                    return SubView.this.findFirstSub(index1);
                }
                return SubView.this.findFirstSub(index1);
            }
            return null;
        }

        public boolean canMoveNext(int index1, int index2) {
            return this.next(index1, index2) != null;
        }

        public boolean canMovePrev(int index1, int index2) {
            return this.prev(index1, index2) != null;
        }

        public void moveNext(int index, int index2) {
            StandardSubObject sub = this.next(index, index2);
            if (sub != null) {
                SubView.this.selectSubtitle(index, sub);
            }
        }

        public void movePrev(int index, int index2) {
            StandardSubObject sub = this.prev(index, index2);
            if (sub != null) {
                SubView.this.selectSubtitle(index, sub);
            }
        }

        public void changed(int index, int index2) {
        }
    }

    public class MultiTimeAudioPlayerPlay
    extends Thread {
        MultiTimeAudioPlayer player;

        public MultiTimeAudioPlayerPlay(MultiTimeAudioPlayer player) {
            this.player = player;
        }

        public void run() {
            this.player.play();
        }
    }

    public class SubViewMultiTimeAudioListener
    implements MultiTimeAudioListener {
        private PlayMove move;

        public void play(StandardSubObject subtitle, long start, long end) {
            log.info((Object)("set:" + subtitle));
            SubView.this.shell.getDisplay().asyncExec((Runnable)new SelectSubtitle(SubView.this.getSubtitleIndex(subtitle), subtitle));
            log.info((Object)("set-end:" + subtitle));
            if (this.move != null) {
                this.move.cancel();
            }
            SubView.this.duration = subtitle.getEndTime() - subtitle.getStartTime();
            SubView.this.shell.getDisplay().syncExec((Runnable)new StartPlayMove(start));
        }

        public void finishPlaying() {
            log.trace((Object)"finish");
            SubView.this.stop();
        }

        public void startPlaying() {
            SubView.this.playMoveSelection = true;
        }

        public class StartPlayMove
        extends Thread {
            private long startTime;

            public StartPlayMove(long startTime) {
                this.startTime = startTime;
            }

            public void run() {
                int value = SubView.this.timeToRealValue(this.startTime);
                log.trace((Object)("value=" + value));
                SubViewMultiTimeAudioListener.this.move = new PlayMove(value);
                Thread t = new Thread(SubViewMultiTimeAudioListener.this.move);
                t.start();
            }
        }
    }

    public class SelectSubtitle
    extends Thread {
        private int index;
        private StandardSubObject subtitle;

        public SelectSubtitle(int index, StandardSubObject subtitle) {
            this.index = index;
            this.subtitle = subtitle;
        }

        public void run() {
            SubView.this.selectSubtitle(SubView.this.getSubtitleIndex(this.subtitle), this.subtitle);
        }
    }
}

