/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileUpdater;
import org.jpn.xucker.rcp.ui.PathListTable;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;

public class TimeBaseFileWindow
implements SelectionListener {
    public static Log log;
    TimeBaseFileUpdater updater;
    Shell shell;
    private Button okButton;
    private Button cancelButton;
    TimeBaseFileObject oldValue;
    private List oldUnknownParams = new ArrayList();
    private PathListTable audioList;
    private PathListTable subList;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.TimeBaseFileWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public TimeBaseFileWindow(File file, TimeBaseFileObject oldValue, TimeBaseFileUpdater updater, Shell shell) {
        log.info((Object)"timebasefilewindows");
        this.updater = updater;
        this.shell = shell;
        this.oldValue = oldValue;
        if (file != null) {
            shell.setText("File " + file.getName());
        } else {
            shell.setText("File UNKNOWN");
        }
        shell.setLayout((Layout)new GridLayout());
        Label fileLabel = new Label((Composite)shell, 0);
        fileLabel.setText("FileName");
        Text text = new Text((Composite)shell, 12);
        if (file != null) {
            text.setText(file.getAbsolutePath());
        }
        Label audioLabel = new Label((Composite)shell, 0);
        audioLabel.setText("Audios");
        this.audioList = new PathListTable((Composite)shell, 0);
        this.audioList.setLayoutData((Object)new GridData(1808));
        this.audioList.setFileExtension(new String[]{"mp3", "wav"});
        Label subLabel = new Label((Composite)shell, 0);
        subLabel.setText("Subtitles");
        this.subList = new PathListTable((Composite)shell, 0);
        this.subList.setLayoutData((Object)new GridData(1808));
        this.subList.setFileExtension(new String[]{"srt"});
        Composite cp = new Composite((Composite)shell, 0);
        cp.setLayout((Layout)new RowLayout());
        this.okButton = new Button(cp, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener((SelectionListener)this);
        RowData okButton_data = new RowData();
        this.okButton.setLayoutData((Object)okButton_data);
        this.cancelButton = new Button(cp, 0);
        this.cancelButton.setText("cancel");
        this.cancelButton.addSelectionListener((SelectionListener)this);
        RowData cancelButton_data = new RowData();
        this.cancelButton.setLayoutData((Object)cancelButton_data);
        ParameterObject[] params = oldValue.getParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().equals("file")) {
                if (TimeBaseFileObjectReadUtils.isSRTFile(params[i].getValue())) {
                    this.subList.addFileItem(params[i].getValue());
                } else if (TimeBaseFileObjectReadUtils.isAudioFile(params[i].getValue())) {
                    this.audioList.addFileItem(params[i].getValue());
                } else {
                    this.oldUnknownParams.add(params[i]);
                }
            }
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            System.out.println("target==null");
        } else if (target == this.okButton) {
            this.do_okButton();
        } else if (target == this.cancelButton) {
            this.do_cancelButton();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void do_okButton() {
        this.shell.close();
        TimeBaseFileObject newTime = new TimeBaseFileObject();
        TimeParameterObject[] times = this.oldValue.getTimeParameters();
        String[] audios = this.audioList.getFiles();
        int i = 0;
        while (i < audios.length) {
            newTime.addParameter(new ParameterObject("file", audios[i]));
            ++i;
        }
        String[] subs = this.subList.getFiles();
        int i2 = 0;
        while (i2 < subs.length) {
            newTime.addParameter(new ParameterObject("file", subs[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < times.length) {
            newTime.addTimeParameter(times[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.oldUnknownParams.size()) {
            newTime.addParameter((ParameterObject)this.oldUnknownParams.get(i2));
            ++i2;
        }
        this.updater.update(this.oldValue, newTime);
    }

    public void do_cancelButton() {
        this.shell.close();
    }
}

