/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ToggleEditorsVisibilityAction
extends Action
implements IPerspectiveListener,
ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.isEditorAreaVisible()) {
            this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
        } else {
            this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId == "reset" || changeId == "editorAreaHide" || changeId == "editorAreaShow") {
            if (page.isEditorAreaVisible()) {
                this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
            } else {
                this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
            }
        }
    }

    public ToggleEditorsVisibilityAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.window.hideShowEditors");
        this.setToolTipText(WorkbenchMessages.getString("ToggleEditor.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.target_editors_visibility_action_context");
        this.setEnabled(false);
        this.workbenchWindow.addPerspectiveListener(this);
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page == null) {
            return;
        }
        boolean visible = page.isEditorAreaVisible();
        if (visible) {
            page.setEditorAreaVisible(false);
            this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
        } else {
            page.setEditorAreaVisible(true);
            this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.removePerspectiveListener(this);
        this.workbenchWindow = null;
    }
}

