/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.jpn.xucker.commons.util.Messages;
import org.jpn.xucker.rcp.ui.FileStatusChanger;

public class FileListTable
extends FileStatusChanger
implements KeyListener,
MouseListener,
SelectionListener {
    private Menu menu1;
    private MenuItem addfile;
    private MenuItem addfolder;
    private MenuItem separatemenu3;
    private MenuItem deletefile;
    private MenuItem deleteAll;
    private Table table;
    private Image fileIcon;
    private Image folderIcon;
    private String[] fileExtension;
    static /* synthetic */ Class class$0;

    public void setLayoutData(Object object) {
        this.table.setLayoutData(object);
    }

    public FileListTable(Composite parent, int layout) {
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.ui.FileListTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fileIcon = new Image((Device)display, clazz.getClassLoader().getResourceAsStream("org/jpn/xucker/commons/resource/file.png"));
        Display display2 = Display.getCurrent();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.ui.FileListTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.folderIcon = new Image((Device)display2, clazz2.getClassLoader().getResourceAsStream("org/jpn/xucker/commons/resource/folder.png"));
        this.table = new Table(parent, layout);
        this.table.addMouseListener((MouseListener)this);
        this.table.addKeyListener((KeyListener)this);
        this.menu1 = new Menu((Control)this.table);
        this.table.setMenu(this.menu1);
        this.addfile = new MenuItem(this.menu1, 8);
        this.addfile.setText(Messages.getString("FileListTable.addfile"));
        this.addfile.addSelectionListener((SelectionListener)this);
        this.addfolder = new MenuItem(this.menu1, 8);
        this.addfolder.setText(Messages.getString("FileListTable.adddir"));
        this.addfolder.addSelectionListener((SelectionListener)this);
        this.separatemenu3 = new MenuItem(this.menu1, 2);
        this.deletefile = new MenuItem(this.menu1, 8);
        this.deletefile.setText(Messages.getString("FileListTable.delete_selection"));
        this.deletefile.addSelectionListener((SelectionListener)this);
        MenuItem item = new MenuItem(this.menu1, 2);
        item.setText("");
        this.deleteAll = new MenuItem(this.menu1, 8);
        this.deleteAll.setText(Messages.getString("FileListTable.deleteall"));
        this.deleteAll.addSelectionListener((SelectionListener)this);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.table, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new FileStatusChanger.DropMonitor(this));
    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == this.menu1) {
            this.do_menu1();
        } else if (target == this.addfile) {
            this.execAddFile();
        } else if (target == this.addfolder) {
            this.execAddFolder();
        } else if (target == this.deletefile) {
            this.execDeleteFile();
        } else if (target == this.deleteAll) {
            this.execDeleteAll();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void do_menu1() {
        System.out.println("menu1");
    }

    public void execAddFile() {
        String file;
        FileDialog dialog = new FileDialog(this.table.getShell(), 4096);
        if (this.fileExtension != null) {
            String[] extensions = new String[this.fileExtension.length];
            int i = 0;
            while (i < extensions.length) {
                extensions[i] = "*." + this.fileExtension[i];
                ++i;
            }
            dialog.setFilterExtensions(extensions);
        }
        if ((file = dialog.open()) != null) {
            this.addFilePath(file);
        }
    }

    public void execAddFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.table.getShell(), 4096);
        String file = dialog.open();
        if (file != null) {
            this.addDirectoryPath(file);
        }
    }

    public void execDeleteFile() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            this.table.remove(selection);
            this.fireRemoveFile((Widget)this.table, path);
        }
    }

    public void execDeleteAll() {
        int size = this.table.getItemCount();
        int i = size - 1;
        while (i >= 0) {
            String path = this.table.getItem(i).getText();
            this.table.remove(i);
            this.fireRemoveFile((Widget)this.table, path);
            --i;
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setFileListText(String text) {
        if (text != null && text.length() > 0) {
            String[] path = text.split(";");
            int i = 0;
            while (i < path.length) {
                this.addDragAndDropFile(path[i]);
                ++i;
            }
        }
    }

    public String[] getFiles() {
        String[] result = new String[this.table.getItemCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.table.getItem(i).getText();
            ++i;
        }
        return result;
    }

    public int getFileCount() {
        return this.table.getItemCount();
    }

    public String getFileListText() {
        String[] fileList = this.getFiles();
        String result = "";
        int i = 0;
        while (i < fileList.length) {
            result = String.valueOf(result) + fileList[i];
            if (i != fileList.length - 1) {
                result = String.valueOf(result) + ";";
            }
            ++i;
        }
        return result;
    }

    protected void addFilePath(String path) {
        if (this.fileExtension != null) {
            int i = 0;
            while (i < this.fileExtension.length) {
                if (path.toLowerCase().endsWith(this.fileExtension[i])) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(path);
                    item.setImage(this.fileIcon);
                    break;
                }
                ++i;
            }
        } else {
            TableItem item = new TableItem(this.table, 0);
            item.setText(path);
            item.setImage(this.fileIcon);
        }
        this.fireAddFile((Widget)this.table, path);
    }

    protected void addDirectoryPath(String path) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(path);
        item.setImage(this.folderIcon);
        this.fireAddFile((Widget)this.table, path);
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent event) {
        TableItem item;
        if (event.button == 1 && (item = this.table.getItem(new Point(event.x, event.y))) == null) {
            this.table.setSelection(-1);
        }
        if (event.button == 3) {
            if (this.table.getSelectionIndex() == -1) {
                this.deletefile.setEnabled(false);
            } else {
                this.deletefile.setEnabled(true);
            }
        }
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.keyCode == 127) {
            this.execDeleteFile();
        }
    }

    public String[] getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String[] fileExtension) {
        this.fileExtension = fileExtension;
    }
}

