/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ExceptionHandler;
import org.eclipse.compare.internal.ListContentProvider;
import org.eclipse.compare.internal.ListDialog;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class CompareWithPatchAction
extends BaseCompareAction {
    protected boolean isEnabled(ISelection selection) {
        return Utilities.getResources(selection).length == 1;
    }

    protected void run(ISelection selection) {
        PatchWizard wizard = new PatchWizard(selection);
        if (this.areAllEditorsSaved()) {
            PatchWizardDialog dialog = new PatchWizardDialog(CompareUIPlugin.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areAllEditorsSaved() {
        if (CompareUIPlugin.getDirtyEditors().length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors()) {
            return false;
        }
        Shell shell = CompareUIPlugin.getShell();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                new ProgressMonitorDialog(shell).run(false, false, this.createRunnable());
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, shell, PatchMessages.getString("PatchAction.ExceptionTitle"), PatchMessages.getString("Exception"));
            return false;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, PatchMessages.getString("PatchAction.ExceptionTitle"), PatchMessages.getString("Exception"));
            return false;
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
            return false;
        }
    }

    private IRunnableWithProgress createRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                IEditorPart[] editorsToSave = CompareUIPlugin.getDirtyEditors();
                pm.beginTask(PatchMessages.getString("PatchAction.SavingDirtyEditorsTask"), editorsToSave.length);
                int i = 0;
                while (i < editorsToSave.length) {
                    editorsToSave[i].doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    pm.worked(1);
                    ++i;
                }
                pm.done();
            }
        };
    }

    private boolean saveAllDirtyEditors() {
        if (ComparePreferencePage.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(CompareUIPlugin.getShell()){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Button check = new Button(result, 32);
                check.setText(PatchMessages.getString("PatchAction.AlwaysSaveQuestion"));
                check.setSelection(ComparePreferencePage.getSaveAllEditors());
                check.addSelectionListener((SelectionListener)new SelectionAdapter(this, check){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Button val$check;
                    {
                        this.this$1 = var1_1;
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        ComparePreferencePage.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                Dialog.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(PatchMessages.getString("PatchAction.SaveAllQuestion"));
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(PatchMessages.getString("PatchAction.SaveAllDescription"));
        dialog.setContentProvider(new ListContentProvider());
        dialog.setInput(Arrays.asList(CompareUIPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    static class PatchWizardDialog
    extends WizardDialog {
        PatchWizardDialog(Shell parent, IWizard wizard) {
            super(parent, wizard);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setMinimumPageSize(700, 500);
        }
    }
}

