/*
 * Created on 2003/05/24
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.jpn.xucker.subplayer;



import java.util.List;
import java.util.Vector;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/**
 * @author ak
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ImageCanvas extends Canvas implements PaintListener{

	private Image image;

	private String text;
    
	private Font font=new Font(this.getDisplay(),"MS ",24,SWT.NONE);
    public String getText() {
        return text;
    }
    public void setText(String text) {
        this.text = text;
    }
	public ImageCanvas(Composite composite){
		super(composite,SWT.NO_BACKGROUND);
		this.addPaintListener(this);
	}
	
    public Image getImage() {
        return image;
    }
   
    public void setImage(Image image) {
        if(this.image!=null){
            this.image.dispose();
        }
        this.image = image;
    }
   
    
	public void paintControl(PaintEvent e) {
	   
	    GC gc=new GC(this);
	    Image bgImage = new Image(this.getShell().getDisplay(), this.getClientArea());
        GC imageGc = new GC(bgImage);
        
        imageGc.setBackground(new Color(this.getDisplay(),0,0,0));
        imageGc.setForeground(new Color(this.getDisplay(),255,0,0));
        imageGc.fillRectangle(0,0,getBounds().width,getBounds().height);
		//System.out.println(this.getBounds());
		
		if(image!=null){
		    if(image.getBounds().height>this.getClientArea().height){
		        imageGc.drawImage(image,0,this.getClientArea().height-image.getBounds().height);
		    }else{
		        imageGc.drawImage(image,0,0);
		    }
		    
		}else{
		
		if(text!=null){
		    int dx=10;
		    imageGc.setFont(font);
		    imageGc.setForeground(new Color(this.getDisplay(),255,255,255));
	        
		    String newText=wrapString(imageGc,this.getClientArea().width-dx*2,text);
		    //System.out.println(newText);
		    imageGc.drawText(newText,dx,10,SWT.DRAW_DELIMITER);
		    //imageGc.drawText(text,10,10);
		}
		
		}
		
		gc.drawImage(bgImage,0,0);
		bgImage.dispose();
		imageGc.dispose();
		gc.dispose();
	}
	
	public String wrapString(GC gc,int maxwidth,String str){
	    String result="";
	    if(gc.stringExtent(str).x<maxwidth){
	        result=str;
	    }else{
	        String value=StringUtils.replace(str,"\r\n","\n");
	        value=StringUtils.replace(str,"\r","\n");
	        String lines[]=value.split("\n");
	        String newLine="";
	        List linesList=new Vector();
	        for(int i=0;i<lines.length;i++){
	            String words[]=lines[i].split(" ");
	            String tmpLine="";
	               for(int k=0;k<words.length;k++){
	                   tmpLine+=words[k];
	                   if(gc.stringExtent(tmpLine).x>maxwidth){
	                   if(newLine.length()>0){
	                       linesList.add(newLine);
		                    newLine="";
		                    tmpLine=words[k];
	                   		}else{
	                   		 for(int j=0;j<words[k].length();j++){
	                   		     tmpLine+=words[k].charAt(j);
	           	               if(gc.stringExtent(newLine).x>maxwidth){
	           	                   linesList.add(tmpLine);
	           	                   tmpLine="";
	           	                   newLine="";
	           	               }else{
	           	                   newLine=tmpLine;
	           	               }
	           	           }
	                   		}
	                   }else{
	                       tmpLine=tmpLine+" ";
	                       newLine=tmpLine;
	                   }
	               }
	               
	           
	           if(tmpLine.length()>0){
	               linesList.add(tmpLine);
	               
	           }
	           newLine="";
	        }
	        String values[]=(String[])linesList.toArray(new String[linesList.size()]);
	        for (int i = 0; i < values.length; i++) {
                result+=values[i];
                if(i!=values.length-1){
                    result+=SystemUtils.LINE_SEPARATOR;
                }
            }
	    }
	    
	    return result;
	}
}
