package org.jpn.xucker.rcp.subplayer.views;


import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.part.ViewPart;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.draw2d.AlphaLayerFigure;
import org.jpn.xucker.rcp.draw2d.AlphaUtils;
import org.jpn.xucker.rcp.draw2d.DoubleScalableFigure;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.WaveFormFigureCanvas;
import org.jpn.xucker.rcp.draw2d.WaveFormListener;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.subplayer.TextAndImageFigure;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.rcp.subplayer.preferences.SubViewPage;
import org.jpn.xucker.rcp.ui.RCPFileApplication;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.SubUtils;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;
import org.xml.sax.SAXException;



import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;


/**
 * [bug]no more handle ---@ACe炷?
 * [todo]ǂݍ݂ɎԂ g`͒xǂݍ?́AIvVŃItɂłB
 * [bug]figureƃnhG[?
 */

public class SubView extends ViewPart {
    public static final String ID=SubView.class.getName();
    public static Log log=LogFactory.getLog(SubView.class);
    
    
    private SubApplication subApplication;
    
	/**
	 * The constructor.
	 */
	public SubView() {
	    subApplication=new SubApplication();
	}
	
	private TimeBaseFileObject timeBaseFileObject;
	
	
	private FileImageCache imageCache=new FileImageCache();
	
	private CenterImageFigure ci;
	public class SubApplication extends RCPFileApplication{

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execOpen()
         */
        protected void execOpen() {
            initData();
    	    TimeBaseFileObject data=null;
            data=TimeBaseFileObjectReadUtils.read(getFile());
    	    if(data==null){
    	        //wrong xml?
    	        log.info("invalid data:"+getFile());
    	        audioFile=null;
    	    }else{
    	        try {
                    setData(data);
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
    	    }
    	    
    	    if(TimeBaseFileObjectReadUtils.checkType(getFile())==TimeBaseFileObjectReadUtils.SUBPLAY_FILE_OBJECT){
    	    //need save file.
    	    setFile(null);
    	    //setNeedSave(true); //for instant play.
    	    }
    	    
    	    saveStatusChanged();
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execSave()
         */
        protected void execSave() {
            log.info("dosave");
           
            
            BeanWriter writer;
            try {
                writer = new BeanWriter(new FileWriter(getFile()));
                writer
                .writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        writer.write(timeBaseFileObject);
        writer.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (SAXException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IntrospectionException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
          
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#saveStatusChanged()
         */
        protected void saveStatusChanged() {
           String title;
           if(getFile()==null){
               title="Untitled";
           }else{
               title=getFile().getName();
           }
           if(isNeedSave()){
               title="*"+title;
           }
           log.info("saveStatusChanged:"+title);
           getFileInfoStatusLine().setText(title);
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execNew()
         */
        protected void execNew() {
           
            //never called.
        }
        
        protected void execOpenSubFile(File file){
            initData();
    	    TimeBaseFileObject data=null;
            if(TimeBaseFileObjectReadUtils.isWavFile(file.getName())){
    	        //add wav & sub
    	        data=new TimeBaseFileObject();
    	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
    	        
    	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
    	        if(srtFile.exists()){
    	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
    	        }
    	        
    	    }else if(TimeBaseFileObjectReadUtils.isMP3File(file.getName())){
    	        data=new TimeBaseFileObject();
    	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
    	        
    	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
    	        if(srtFile.exists()){
    	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
    	        }
    	    }
    	    
            if(data!=null){
    	        try {
                    setData(data);
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
    	    }
            
    	    setFile(null);//need save file.
//    	  setNeedSave(true); //for instant play.
    	    
    	    saveStatusChanged();
        }

        protected boolean isStandardFile(File file){
            return TimeBaseFileObjectReadUtils.isXMLFile(file.getName());
        }
        
	    
	}
	
	/*
	public void load(File file){
	    initData();
	    TimeBaseFileObject data=null;
	    if(TimeBaseFileObjectReadUtils.isXMLFile(file.getName())){
	        data=TimeBaseFileObjectReadUtils.read(file);
	    if(currentTimeBaseFile==null){
	        //wrong xml?
	        
	    }else{
	        
	        //read Wave
	        //read Sub
	    }
	    }else if(TimeBaseFileObjectReadUtils.isWavFile(file.getName())){
	        //add wav & sub
	        data=new TimeBaseFileObject();
	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
	        
	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
	        if(srtFile.exists()){
	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
	        }
	        
	    }else if(TimeBaseFileObjectReadUtils.isMP3File(file.getName())){
	        //add wav & sub
	    }
	    
	    
	}*/
	
	
	public class LoadWave extends Thread{
	    private AudioInputStream audioInputStream;
	    private File targetAudioFile;
	    public LoadWave(AudioInputStream audioInputStream,File targetAudioFile){
	        this.audioInputStream=audioInputStream;
	       this.targetAudioFile=targetAudioFile;
	    }
	    
	    public void run(){
	        List byteList=waveFormFigureCanvas.loadByteList(audioInputStream);
	        if(audioFile!=null && audioFile.getAbsolutePath().equals(audioFile.getAbsolutePath())){
	            log.trace("setWaveFirugre:audio="+audioFile+",target="+targetAudioFile.getAbsolutePath());
		        
	            shell.getDisplay().asyncExec(new SetWaveFormFigure(byteList));
	        }
	    }
	}
	
	public class SetWaveFormFigure extends Thread{
	    List byteList;
	    public SetWaveFormFigure(List byteList){
	        this.byteList=byteList;
	    }
	    public void run(){
	        waveFormFigureCanvas.setByteData(byteList);
	    }
	}
	private void setData(TimeBaseFileObject data) throws UnsupportedAudioFileException, IOException{
	    timeBaseFileObject=data;
	    //set audio.
	    File audio=parseFirstAudioFile(data);
	    if(audio!=null){
	        audioFile=audio;
	       
	        log.info("load-audio:"+audioFile);
	        if(TimeBaseFileObjectReadUtils.isWavFile(audioFile.getName())){
	            waveFormFigureCanvas.loadEmpty(WaveUtils.
	    	            countAudioMillisecond(audioFile));
                  
	            
	        //waveFormFigureCanvas.loadWave(audioFile);
	        new LoadWave(AudioSystem.getAudioInputStream(audioFile),audioFile).start();
	        player=new JavaSoundAudioPlayer();
	        }else if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
	            try {
	                log.trace("load-mp3:"+audioFile);
	                waveFormFigureCanvas.loadEmpty(MP3Utils.getAudioDurationTimeQuickly(audioFile));
	                //waveFormFigureCanvas.loadWave(MP3Utils.toPCMAudioInputStream(new FileInputStream(audioFile)));
	                new LoadWave(MP3Utils.toPCMAudioInputStream(new FileInputStream(audioFile)),audioFile).start();
	                player=new JavaLayerMP3Player();
	                
                } catch (FileNotFoundException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
	        }
	    }
	    
	    //remove sub.
	    for(int i=0;i<srtListFigures.length;i++){
	    srtListFigures[i].setStandardSubObjectList(null);
	    srtListFigures[i].rerect();
	    }
	    //set sub. //check color.
	    ParameterObject params[]=data.getParameters();
	    int index=0;
	    for(int i=0;i<params.length;i++){
	        if(params[i].getName().equals("file")){
	            log.trace("file:"+params[i].getValue());
	            if(TimeBaseFileObjectReadUtils.isSRTFile(params[i].getValue())){
	                log.trace("srt-file:"+params[i].getValue());
	                try {
                        List subDataList=SubUtils.loadSub(new File(params[i].getValue()));
                        addSubs(params[i].getValue(),index,subDataList);
                    } catch (IOException e) {
                       
                        e.printStackTrace();
                    }
	                index++;
	            }
	        }
	    }
	   
	    waveFormFigureCanvas.getInFigure().setVisible(true);
	}
	
	public void addSubs(String path,int index,List sublist){
	    /*
	    StandardSubObject[] subobject=(StandardSubObject[]) sublist.toArray(new StandardSubObject[sublist.size()]);
	    for (int i = 0; i < subobject.length; i++) {
//	      //check label.
	        SRTFigure srt=
	             new SRTFigure(shell,index);
	        srt.setLocation(new Point(0,32*(index+1)));//TODO change this is test.
	        srt.setText(subobject[i].getText());
	        srt.setStart(subobject[i].getStartTime());
	        srt.setEnd(subobject[i].getEndTime());
	        log.trace("srt:"+srt.getStart()+","+srt.getEnd()+","+srt.getText());
	        //TODO support cached thumb image ?.
			srt.setScale(waveFormFigureCanvas.getZoom(),1.0);
			log.trace("srt-size:"+srt.getClientArea());
			srtListFigure.add(srt); //tmp change.
        }
	    srtListFigure.revalidate();
	    */
	    srtListFigures[index].setStandardSubObjectList(sublist);
	    srtListFigures[index].setSubObjectPath(path);
	    srtListFigures[index].rerect();
	    log.trace("sub-added:"+srtListFigures[index].getClientArea());
	}
	
	
	private void initData(){
	    log.trace("initData");
	    stopped=true;
	    //remove figure.
	    waveFormFigureCanvas.removeWaveForm();
	    waveFormFigureCanvas.setSelectRealValue(0,0);
	    waveFormFigureCanvas.setCurrentRealValue(0);
	    //remove srt
	    for(int i=0;i<srtListFigures.length;i++){
	    srtListFigures[i].removeAll();
	    }
	    waveFormFigureCanvas.scrollToX(0);
	    //init subview.
	    waveFormFigureCanvas.getInFigure().setVisible(false);
	    
	    audioFile=null;
	    //clear sub files.
	    subtitleShowText1.setText("");
        subtitleShowText1.repaint();
	}

	public File parseFirstAudioFile(TimeBaseFileObject object){
	    ParameterObject params[]=object.getParameters();
	    for (int i = 0; i < params.length; i++) {
            if(params[i].getName().equals("file") && 
                    //TODO support other audio formats.
                    TimeBaseFileObjectReadUtils.isWavFile(params[i].getValue()) || TimeBaseFileObjectReadUtils.isMP3File(params[i].getValue())
                    ){
                return new File(params[i].getValue());
            }
        }
	    return null;
	}
	
	public class ChangeSubInfo implements WaveFormListener{

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.draw2d.WaveFormListener#changeCurrent(long)
         */
        public void changeCurrent(long arg0) {
            if(log.isTraceEnabled()){
                log.trace("changed:"+arg0);
            }
           
            for(int j=0;j<srtListFigures.length;j++){
            if(srtListFigures[j].getStandardSubObjectList()!=null){
            StandardSubObject[] subs=(StandardSubObject[]) srtListFigures[j].getStandardSubObjectList().toArray(new StandardSubObject[srtListFigures[j].getStandardSubObjectList().size()]);
            
            File baseFile=new File(srtListFigures[j].getSubObjectPath()).getParentFile();
            for(int i=0;i<subs.length;i++){
               // log.info("figures-time:"+figures[i].getStart()+","+figures[i].getEnd());
                if(subs[i].getStartTime()<=arg0 && subs[i].getEndTime()>=arg0){
                    log.trace("sub-selected:"+subs[i].getText());
                    //TODO image Support.
                    if(subs[i].getText()!=null && !subtitleShowText1.getText().equals(subs[i].getText())){//TODO null check.
                    if(j==0){//TODO multi
                    subtitleShowText1.setText(subs[i].getText());
                    subtitleShowText1.repaint();
                    }else{
                        subtitleShowText2.setText(subs[i].getText());
                        subtitleShowText2.repaint();
                    }
                   // waveFormFigureCanvas.getInFigure().repaint(figures[i].getClientArea());
                    }else{
                        String imagePath=subs[i].getImagePath();
                        if(log.isTraceEnabled()){
                        log.trace("sub-image:"+imagePath);
                        }
                        if(imagePath!=null){
                            Image image=imageCache.loadImage(new File(baseFile,imagePath).getAbsolutePath());
                           //TODO support multi sub.
                                if(j==0){
                                    if(image!=null && !image.equals(subtitleShowText1.getImage())){//TODO null check.
                                        log.trace("sub-setImage:"+imagePath);
                                subtitleShowText1.setImage(image);
                                subtitleShowText1.repaint();
                                    }else{
                                        if(image!=null){
                                            log.trace("sub-sameimage:"+imagePath);
                                        }
                                    }
                                }else{
                                    if(image!=null && !image.equals(subtitleShowText2.getImage())){//TODO null check.
                                        log.trace("sub-setImage:"+imagePath);
                                    subtitleShowText2.setImage(image);
                                    subtitleShowText2.repaint();
                                    }else{
                                        if(image!=null){
                                            log.trace("sub-sameimage:"+imagePath);
                                        }
                                    }
                                }
                               // waveFormFigureCanvas.getInFigure().repaint(figures[i].getClientArea());
                              
                        }
                    }
                }
            }
        }
            }
        }
	    
	}
	
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	
	/*
	public class KeyTmp implements KeyListener{

        
        public void keyPressed(KeyEvent e) {
            // TODO Auto-generated method stub
           
            ICommand command=PlatformUI.getWorkbench().getCommandSupport().getCommandManager().getCommand("ccc.com1");
            //ICommand command=PlatformUI.getWorkbench().getCommandSupport().add
           // PlatformUI.getWorkbench().getCommandSupport().
            try {
                System.out.println(command.getName());
            } catch (NotDefinedException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
        }

        
        public void keyReleased(KeyEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}*/
	/*
	public class CommandL implements ICommandManagerListener{

        public void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
            // TODO Auto-generated method stub
            System.out.println(commandManagerEvent);
        }
	    
	}*/
	
	public TextAndImageFigure createTextAndImageFigure(int width,int height){
	    TextAndImageFigure subtitleShowText = new TextAndImageFigure(this.shell);
		
		 RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR);
         subtitleShowText.setBackgroundColor(new Color(shell.getDisplay(), c));
         
         RGB c2=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR);
         subtitleShowText.setForegroundColor(new Color(shell.getDisplay(), c2));
         
		
         int transparent=SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_TRANSPARENT);
        
         subtitleShowText.setAlpha(transparent);
         
         
		
        subtitleShowText.setFont(new Font(shell.getDisplay(),PreferenceConverter.getFontData(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FONT)));
        
        
		subtitleShowText.setSize(width,height);
		
		
		return subtitleShowText;
	}
	
	public Figure createMixFigure(Figure main,int width, int height){
	    int shadow=5;
	    AlphaLayerFigure alpha=new AlphaLayerFigure(ColorConstants.black,32);
		alpha.setSize(width,height);
		alpha.setLocation(new Point(shadow,shadow));
		alpha.setVisible(false);
		
		
		MixWindowFigure mix=new MixWindowFigure();
		//mix.setSize(width,height);
		mix.setShadowFigure(alpha);
		mix.setMainFigure(main);
		//box.addTarget(r2);
		//box.addTarget(alpha);
		//box.addTarget(mix);
		
		//box.setLocation(new Point(300,220));
		
		
		
		mix.setLayoutManager(null);
		mix.add(alpha);
		mix.add(main);
		
		
		mix.setSize(width+shadow,height+shadow);
		
		ResizeBox box=new ResizeBox(mix);
		//box.setSize(20,20);
		
		mix.add(box);
		//mix.setLocation(new Point(100,100));
		
		
		FigureMove move=new FigureMove();
		
		mix.addMouseListener(move);
		mix.addMouseMotionListener(move);
		return mix;
	}
	
	public void createPartControl(Composite parent) {
	    imageCache.setMaxSize(4);
	    // PlatformUI.getWorkbench().getCommandSupport().getCommandManager().addCommandManagerListener(new CommandL());
	    Composite component =new Composite(parent,SWT.NULL);
	    
	    this.shell=parent.getShell();
	    
		component.setLayout(new GridLayout());
		
		Composite panel=new Composite(component,SWT.NULL);
		panel.setLayout(new FillLayout());
		/*
		Button bt=new Button(panel,SWT.NULL);
		
		bt.setText("open");
		bt.addSelectionListener(new Select());
		*/
		playButton = new Button(panel,SWT.NULL);
		
		
		
        playButton.setText("play");
        Image play=ImageDescriptor.createFromURL(SubplayerPlugin.getDefault().find(new Path("icons/play.png"))).createImage(); //$NON-NLS-1$
        
        playButton.setImage(play);
		playButton.addSelectionListener(new Play());
		
		Button bt3=new Button(panel,SWT.NULL);
		bt3.setText("stop");
		bt3.addSelectionListener(new Stop());
		
		Button bt4=new Button(panel,SWT.NULL);
		bt4.setText("zoom up");
		bt4.addSelectionListener(new Zoomup());
		
		
		Button bt5=new Button(panel,SWT.NULL);
		bt5.setText("zoom down");
		bt5.addSelectionListener(new Zoomdown());
		
		Composite base=new Composite(component,SWT.NULL);
		base.setLayoutData(new GridData(GridData.FILL_BOTH));
		base.setLayout(new FillLayout());
		
		//base
		
		waveFormFigureCanvas = new WaveFormFigureCanvas(base);
		waveFormFigureCanvas.getInFigure().setVisible(false);//for initial
		waveFormFigureCanvas.setWaveFormListener(new ChangeSubInfo());
		
		
		ci=new CenterImageFigure();
		ci.setParentCanvas(waveFormFigureCanvas);
		try{
		 log.info("bgimage:"+SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
         Image img=new Image(null,SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
         if(img!=null){
             ci.setImage(img);
         }
		}catch(Exception e){
		    e.printStackTrace();
		}
		//ci.setImage(new Image(this.shell.getDisplay(),"c:\\tmp\\bg.jpg"));
		waveFormFigureCanvas.getBackgroundFigure().setLayoutManager(null);
		waveFormFigureCanvas.getBackgroundFigure().add(ci);
		
		/*
		TextAndImageFigure r1=new TextAndImageFigure(this.shell);
		r1.setBackgroundColor(ColorConstants.black);
		r1.setForegroundColor(ColorConstants.yellow);
		log.trace("textandimage");
		r1.setText("hello this is text.");
		log.trace("textandimage");
		r1.setSize(640,480);
		log.trace("textandimage");
		
		FigureMove move=new FigureMove();
		r1.addMouseListener(move);
		r1.addMouseMotionListener(move);
		r1.setLocation(new Point(200,400));
		//r1.setVisible(false);
		*/
		
		
		
		
		
		
		
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		
		
		int w=700;
		int h=240;
		subtitleShowText1=createTextAndImageFigure(w,h);
		
		Figure mix1=createMixFigure(subtitleShowText1,w,h);
		mix1.setLocation(new Point(1,150));
		
		subtitleShowText2=createTextAndImageFigure(w,h);
		
		Figure mix2=createMixFigure(subtitleShowText2,w,h);
		mix2.setLocation(new Point(1,300));
		
		
		
		waveFormFigureCanvas.getForegroundFigure().setLayoutManager(null);
		waveFormFigureCanvas.setSplitFrame(0.1);
		//waveFormFigureCanvas.getForegroundFigure().add(r1);
		waveFormFigureCanvas.getForegroundFigure().add(mix2);
		
		waveFormFigureCanvas.getForegroundFigure().add(mix1);
		//waveFormFigureCanvas.getForegroundFigure().add(new RectangleFigure());
		//waveFormFigureCanvas.setBackground(ColorConstants.red);
		
		//file=new File("c:\\tmp\\30.wav");
		//for test
		//waveFormFigureCanvas.loadWave(file);
		
		for(int i=0;i<srtListFigures.length;i++){
		srtListFigures[i] = new SRTListFigure(1,1);
		srtListFigures[i].setScale(waveFormFigureCanvas.getZoom(),1);
		srtListFigures[i].setRectangleY(20+36*i);
		//srtListFigure.setLayoutManager(new DelegatingLayout());//auto resize?
		srtListFigures[i].setLocation(new Point(0,0));
		
		waveFormFigureCanvas.getInFigure().add(srtListFigures[i]);
		//srtListFigures[i].setVisible(false);//debug
		}
		
		
		
		waveFormFigureCanvas.getForegroundFigure().addMouseListener(new SRTClick());
		
		//test data
		/*
        srt = new SRTFigure(shell);
        
		srt.setScale(waveFormFigureCanvas.getZoom(),1.0);
		srtListFigure.add(srt);
		*/
		
		
		player = new JavaSoundAudioPlayer();
		
		
		  GC gc=new GC(component.getDisplay());
		    String text="text\n\nalo";
		    org.eclipse.swt.graphics.Point dm=gc.stringExtent(text);
		    log.trace("dm:"+dm);
		    
		    
		    
		    

	        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	        IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
	        
	        
		    StatusLineContributionItem item=new StatusLineContributionItem("fileinfo",32);
	        //item.setText("");
	        
	        StatusLineContributionItem item2=new StatusLineContributionItem("subinfo",32);
	        //item2.setText("duration:03:23:20,1000");
	        
	        lineManager.add(item2);
	        
	        lineManager.add(item);
	        
	    //    .getActiveWorkbenchWindow().getActionBarConfigurer().getStatusLineManager().add(item);
	        
	        //System.out.println("frames:"+MP3Utils.countFrame(new File("c:\\tmp\\matchgirl.mp3")));
	        //
	        long time=System.currentTimeMillis();
	        
	        /*
	         * 
	         subApplication.setFile(new File("C:\\tmp\\testTime.xml"));
	        
	        subApplication.execOpen();
	        */
		       
	       //hellsign1.xml
	        //subApplication.execOpenSubFile(new File("c:\\tmp\\matchgirl.mp3"));
	        //subApplication.execOpenSubFile(new File("C:\\Program Files\\SubRip\\gataka\\gataka.mp3"));
	        
	    //   subApplication.execOpenSubFile(new File("c:\\tmp\\Free_Culture_001_Preface.wav"));
	        log.trace("loadTime:"+(System.currentTimeMillis()-time));
	        
	        SubplayerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new PropertyCheck());
	}
	
	public class PropertyCheck implements IPropertyChangeListener{

        /* (non-Javadoc)
         * @see org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
         */
        public void propertyChange(PropertyChangeEvent event) {
            // TODO Auto-generated method stub
            log.trace("propertychange:"+event.getProperty()+","+event.getNewValue()+","+event.getOldValue());
            if(event.getProperty().equals(SubViewPage.LAYER1_BGCOLOR)){
             //  String rgb=SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_BGCOLOR);
               RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR);
               subtitleShowText1.setBackgroundColor(new Color(null, c));
                //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
               subtitleShowText1.repaint(subtitleShowText1.getClientArea());
               
               subtitleShowText2.setBackgroundColor(new Color(null, c));
               //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
              subtitleShowText2.repaint(subtitleShowText2.getClientArea());
              
            }else if(event.getProperty().equals(SubViewPage.LAYER1_FGCOLOR)){
                //  String rgb=SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_BGCOLOR);
                RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR);
                subtitleShowText1.setForegroundColor(new Color(null, c));
                 //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
                subtitleShowText1.repaint(subtitleShowText1.getClientArea());
                
                subtitleShowText2.setForegroundColor(new Color(null, c));
                //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
               subtitleShowText2.repaint(subtitleShowText2.getClientArea());
               
             }else if(event.getProperty().equals(SubViewPage.LAYER1_TRANSPARENT)){
                int transparent=Integer.parseInt((String)event.getNewValue());
                log.trace("new-trans:"+transparent);
                subtitleShowText1.setAlpha(transparent);
                subtitleShowText1.repaint(subtitleShowText1.getClientArea()); 
                
                subtitleShowText2.setAlpha(transparent);
                subtitleShowText2.repaint(subtitleShowText2.getClientArea()); 
                
            }else if(event.getProperty().equals(SubViewPage.LAYER1_FONT)){
               log.trace("font:"+SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_FONT));
                FontData fontData=PreferenceConverter.getFontData(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FONT);
                subtitleShowText1.setFont(new Font(null,fontData));
                subtitleShowText1.repaint(subtitleShowText1.getClientArea());
                
                //debug
                subtitleShowText2.setFont(new Font(null,fontData));
                subtitleShowText2.repaint(subtitleShowText2.getClientArea());
                
            }else if(event.getProperty().equals(SubViewPage.BGIMAGE)){
                log.info("bgimage:"+SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
                Image img=new Image(null,SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
                if(img!=null){
                    if(ci.getImage()!=null){
                        ci.getImage().dispose();
                    }
                    ci.setImage(img);
                    ci.repaint(ci.getClientArea());
                }
                
            }
            
        }
	    
	}
	
	public class ResizeBox extends Figure implements MouseListener,MouseMotionListener{
	    
	    int minWidth=100;
	    int minHeight=100;
	    int clickx;
	    int clicky;
	    //List targets=new ArrayList();
	    /*
	    public void addTarget(Figure figure){
	        targets.add(figure);
	    }*/
	    Figure target;
	    int sizeX=20;
	    int sizeY=20;
	    public ResizeBox(Figure target){
	    super();
	    this.target=target;
	    this.setForegroundColor(ColorConstants.gray);
	    this.addMouseListener(this);
	    this.addMouseMotionListener(this);
	    this.setSize(sizeX,sizeY);
	    this.setLocation(newPoint());
	    }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent arg0) {
            clickx=arg0.x;
            clicky=arg0.y;
            log.trace("click:"+clickx+","+clicky);
            arg0.consume();
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseDragged(org.eclipse.draw2d.MouseEvent)
         */
        int marginX=5+2;
        int marginY=5+2;
        public void mouseDragged(MouseEvent arg0) {
            int moveX=clickx-arg0.x;
            int moveY=clicky-arg0.y;
            
            clickx=arg0.x;
            clicky=arg0.y;
            
            
            //Figure[] figures=(Figure[]) targets.toArray(new Figure[targets.size()]);
            //log.trace("figures-size:"+figures.length);
            
            boolean movex=false;
            boolean movey=false;
           // for(int i=0;i<figures.length;i++){
                int newSizeX=0;
                int newSizeY=0;
                
            if(target.getSize().width>minWidth){
                newSizeX=Math.max(minWidth,target.getSize().width-moveX);
            }else if(target.getSize().width<=minWidth){
                newSizeX=Math.max(minWidth,target.getSize().width-moveX);
            }
            
            if(target.getSize().height>minHeight){
                newSizeY=Math.max(minHeight,target.getSize().height-moveY);
            }else if(target.getSize().height<=minHeight){
                newSizeY=Math.max(minHeight,target.getSize().height-moveY);
            }
            
            if(newSizeX>0 && newSizeY>0){
                log.trace("newsize:"+newSizeX+","+newSizeY);
                shell.getDisplay().syncExec(new Resize(target,newSizeX,newSizeY));
               // target.setSize(newSizeX,newSizeY);
               
            }
            if(newSizeX>minWidth){
                movex=true;
            }
            
            if(newSizeY>minHeight){
                movey=true;
            }
            
            
        
            if(movex || movey){
                Point current=newPoint();
            log.trace("newPoint:"+current);
            this.setLocation(current);
            }
            
            arg0.consume();
        }
        
        public Point newPoint(){
            return new Point(target.getLocation().x+target.getSize().width-sizeX-marginX,target.getLocation().y+target.getSize().height-sizeY-marginY);
            
        }
        
        public class Resize implements Runnable{
            Figure target;
            int w;
            int h;
            public Resize(Figure target,int w,int h){
                this.target=target;
                this.w=w;
                this.h=h;
            }
            public void run(){
                target.setSize(w,h);
            }
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseEntered(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseEntered(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseExited(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseExited(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseHover(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseHover(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseMoved(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseMoved(MouseEvent arg0) {
           
        }
        
        public void paintFigure(Graphics g){
            
            g.drawRectangle(this.getClientArea().x,this.getClientArea().y,this.getClientArea().width-1,this.getClientArea().height-1);
        }
	}
	

	private StatusLineContributionItem getFileInfoStatusLine(){
	    WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return (StatusLineContributionItem) lineManager.find("fileinfo");
	}
	private WaveFormFigureCanvas waveFormFigureCanvas;

	
    /**
	 * @param shell
	 */
	
	private Shell shell;

	private File audioFile;
	
	public class MixWindowFigure extends Figure{
	    private Figure shadowFigure;
	    private Figure mainFigure;
	    //private Figure resizeFigure;
        public Figure getMainFigure() {
            return mainFigure;
        }
        public void setMainFigure(Figure mainFigure) {
            this.mainFigure = mainFigure;
        }
        public Figure getShadowFigure() {
            return shadowFigure;
        }
        public void setShadowFigure(Figure shadowFigure) {
            this.shadowFigure = shadowFigure;
        }
	    int shadowSizeX=5;
	    int shadowSizeY=5;
	    
	    public void setSize(int w,int h){
	        super.setSize(w,h);
	        shadowFigure.setSize(getSize().width-shadowSizeX,getSize().height-shadowSizeY);
	        mainFigure.setSize(getSize().width-shadowSizeX,getSize().height-shadowSizeY);
	    }
	    /*
        public Figure getResizeFigure() {
            return resizeFigure;
        }
        public void setResizeFigure(Figure resizeFigure) {
            this.resizeFigure = resizeFigure;
        }*/
	}
	
	public class FigureMove implements MouseMotionListener,MouseListener{

	    int downx=0;
	    int downy=0;
	    boolean pressed=false;
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseDragged(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDragged(MouseEvent me) {
            if(pressed){
            log.trace("dragged:"+me);
            Figure figure=(Figure)me.getSource();
            int moveX=downx-me.x;
            int moveY=downy-me.y;
            log.trace("moveX="+moveX+",moveY="+moveY);
            Point loc=figure.getLocation();
            loc.x-=moveX;
            loc.y-=moveY;
            log.trace("locx="+loc.x+",loc.y="+loc.y);
            figure.setLocation(loc);
            downx=me.x;
            downy=me.y;
            me.consume();
            }
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseEntered(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseEntered(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseExited(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseExited(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseHover(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseHover(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseMoved(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseMoved(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent me) {
            Figure figure=(Figure)me.getSource();
            IFigure parent=figure.getParent();
            //figure.requestFocus();
            List list=parent.getChildren();
            int index=0;
            for(int i=0;i<list.size();i++){
                if(list.get(i)==figure){
                    index=i;
                    break;
                }
            }
            log.trace("index:"+index);
            if(index!=list.size()-1){
              parent.remove(figure);
                parent.add(figure);
            }
            
            //figure.
            downx=me.x;
            downy=me.y;
            pressed=true;
            me.consume();
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent me) {
            // TODO Auto-generated method stub
            pressed=false;
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	public class SRTClick implements MouseListener{

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent me) {
            // TODO Auto-generated method stub
            //log.trace(me.getSource().getClass().getName());
           for(int i=0;i<srtListFigures.length;i++){
            StandardSubObject[] subs=srtListFigures[i].containSubtitles(me.x,me.y);
            if(subs.length>0){
                int dx1=timeToRealValue(subs[0].getStartTime());
                int dx2=timeToRealValue(subs[0].getEndTime());
                
                waveFormFigureCanvas.setSelectRealValue(dx1,dx2);
                me.consume();
                break;
            }
           }
           
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent me) {
            for(int i=0;i<srtListFigures.length;i++){
            StandardSubObject[] subs=srtListFigures[i].containSubtitles(me.x,me.y);
            if(subs.length>0){
                int dx1=timeToRealValue(subs[0].getStartTime());
                int dx2=timeToRealValue(subs[0].getEndTime());
                
                waveFormFigureCanvas.setSelectRealValue(dx1,dx2);
                me.consume();
                break;
            }
            }
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	public class Zoomup implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            waveFormFigureCanvas.zoomUp();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	public class Zoomdown implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            
            waveFormFigureCanvas.zoomDown();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	public class SRTFigure extends DoubleScalableFigure{

	    long start=1000;
	    long end=2000;
	    private int index;
	   // TextAndImageFigure textAndImage;
        public long getEnd() {
            return end;
            
            
        }
        public void setEnd(long end) {
            this.end = end;
        }
        public long getStart() {
            return start;
        }
        public void setStart(long start) {
            this.start = start;
        }
      
       private String text;
       
	    public void setImage(Image img){
	     //   textAndImage.setImage(img);
	    }
	   // double perms=0.01;
	    
	    int height=32;
        /**
         * @param arg0
         * @param arg1
         */
	    
	    AlphaLayerFigure alpha;
        public SRTFigure(Shell shell,int index) {
            super(1,1);
            this.index=index;
            //alpha=new AlphaLayerFigure(ColorConstants.white,128);
            //this.add(alpha);
       //     textAndImage=new TextAndImageFigure(shell);
         //   add(textAndImage);
            this.setLayoutManager(new StackLayout());
            // TODO Auto-generated constructor stub
            setScale(1.0,1.0);
        }
        
        public void setScale(double w,double h){
            wzoom=w;
            hzoom=h;
            setBounds(getRectangle());
        }
        
        public Rectangle getRectangle(){
            int dx=(int)(start*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
            int dx2=(int)(end*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
            //log.trace(color+","+getClientArea()+","+getParent().getClientArea());
            //Rectangle rectangle=new Rectangle(dx,0,dx2-dx,height);
            Rectangle rectangle=new Rectangle(dx,this.getClientArea().y,dx2-dx,height);
            if(getParent()!=null){
            rectangle.x=rectangle.x+getParent().getClientArea().x;//???
            //rectangle.y=rectangle.y-getParent().getClientArea().y;//???
            }
            log.trace("srt-rectangle:"+rectangle);
            return rectangle;
        }
        
        public void paintFigure(Graphics g){
            log.trace("srt-paint:"+this.getClientArea());
            if(text!=null){
                g.setFont(new Font(shell.getDisplay(),"MS ",12,SWT.NONE));
                g.drawString(text,this.getClientArea().x,this.getClientArea().y);
            }
            //g.fillRectangle(this.getClientArea());
           // g.drawRectangle(this.getClientArea());
        }
       
    public String getText() {
        return text;
    }
    public void setText(String text) {
        this.text = text;
    }
	}
	
	public class Stop implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            stop();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	boolean stopped=true;
    private JavaSoundAudioPlayer player;
    private Button playButton;

    private Point selection;
    
    //double splitframe=0.01;
	public class PlayStop implements AudioStopper{

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#isStopped()
         */
        public boolean isStopped() {
            // TODO Auto-generated method stub
            return stopped;
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#setStopped(boolean)
         */
        public void setStopped(boolean arg0) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	private long duration;
	private boolean playing;

   // private SRTFigure srt;
	SRTListFigure[] srtListFigures=new SRTListFigure[4];
   // private DoubleScalableFigure srtListFigure;
    private TextAndImageFigure subtitleShowText1;
    private TextAndImageFigure subtitleShowText2;
    public class SRTListFigure extends DoubleScalableFigure{
        List standardSubObjectList;
        private Rectangle[] inRectangle;
        
        private int rectangleY=32;
        private int rectangleHeight=32;
        
        private Image[] labelImages=new Image[8];
        
        private String subObjectPath;
        /**
         * @param arg0
         * @param arg1
         */
        public SRTListFigure(int arg0, int arg1) {
            super(arg0, arg1);
            // TODO Auto-generated constructor stub
            labelImages[0]=AlphaUtils.createColorAlphaImageData(ColorConstants.white,128);
            labelImages[1]=AlphaUtils.createColorAlphaImageData(ColorConstants.red,128);
        }
        
        public void setStandardSubObjectList(List list){
            standardSubObjectList=list;
           // rerect();
        }
        
        public StandardSubObject[] containSubtitles(int x,int y){
            if(standardSubObjectList!=null){
            List tmp=new ArrayList();
            for(int i=0;i<inRectangle.length;i++){
                if(inRectangle[i].contains(-getParent().getBounds().x+x,y)){
                    tmp.add(standardSubObjectList.get(i));
                }
                
            }
            return (StandardSubObject[]) tmp.toArray(new StandardSubObject[tmp.size()]);
            }else{
                return new StandardSubObject[0];
            }
        }
        
        public void setScale(double w,double h){
            super.setScale(w,h);
            rerect();
        }
        public void rerect(){
            log.trace("rerect");
            if(standardSubObjectList!=null){
            StandardSubObject subs[]=(StandardSubObject[]) standardSubObjectList.toArray(new StandardSubObject[standardSubObjectList.size()]);
            Rectangle[] tmpRect=new Rectangle[subs.length];
            for(int i=0;i<subs.length;i++){
                int dx=(int)(subs[i].getStartTime()*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
                int dx2=(int)(subs[i].getEndTime()*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
                tmpRect[i]=new Rectangle(dx,rectangleY,dx2-dx,rectangleHeight);
                log.trace("subrect:"+tmpRect[i]);
            }
            
            inRectangle=tmpRect;
            }else{
                inRectangle=new Rectangle[0];
            }
        }
        
        public void paintFigure(Graphics g){
            if(inRectangle==null){
                rerect();
            }
            log.trace("srtlist-paint:"+this.getClientArea()+",inRectangle="+inRectangle.length);
            
            for(int i=0;i<inRectangle.length;i++){
                //g.drawRectangle(inRectangle[i].x+getParent().getBounds().x,inRectangle[i].y,inRectangle[i].width,inRectangle[i].height);//TODO image & label.
                Rectangle drawRec=new Rectangle(inRectangle[i].x+getParent().getBounds().x,inRectangle[i].y,inRectangle[i].width,inRectangle[i].height);
                if(i%5==0){
//                  mark test.
                    g.drawImage(labelImages[1],new Rectangle(labelImages[1].getBounds()),drawRec);
                    
                }else{
                    
                    g.drawImage(labelImages[0],new Rectangle(labelImages[0].getBounds()),drawRec);
                }
                
            }
        }
        
        public int getRectangleHeight() {
            return rectangleHeight;
        }
        public void setRectangleHeight(int rectangleHeight) {
            this.rectangleHeight = rectangleHeight;
        }
        public int getRectangleY() {
            return rectangleY;
        }
        public void setRectangleY(int rectangleY) {
            this.rectangleY = rectangleY;
        }
        public List getStandardSubObjectList() {
            return standardSubObjectList;
        }
        public String getSubObjectPath() {
            return subObjectPath;
        }
        public void setSubObjectPath(String subObjectPath) {
            this.subObjectPath = subObjectPath;
        }
    }
	 public void play(){
	     
	     AudioFormat format=null;
        try {
            if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
                format = MP3Utils.getAudioFormat(new FileInputStream(audioFile));
            }else{
            format = WaveUtils.getAudioFormat(audioFile);//TODO mp3 support
            }
        } catch (UnsupportedAudioFileException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        } catch (IOException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
            selection = waveFormFigureCanvas.getSelection();
            if(selection==null){
                selection=new Point(waveFormFigureCanvas.getCurrentRealValue(),waveFormFigureCanvas.getLastPosition());
            }
	       long starttime=(long)(selection.x*1000/waveFormFigureCanvas.getBaseMemoryPixel());
	       long endtime=(long)(selection.y*1000/waveFormFigureCanvas.getBaseMemoryPixel());
	       duration=endtime-starttime;
	       log.trace("duration:"+starttime+","+endtime);
	       
	       player.setStopper(new PlayStop());
	       player.setAudioListener(new AudioMove());
	       
	       
	       playButton.setEnabled(false);
	       Thread t=new Thread(new Playing(audioFile,starttime,endtime));
	       
	       t.start();
	    }
	    
	    public void stop(){
	        log.trace("call stop");
	        stopped=true;
	        shell.getDisplay().asyncExec(new EnablePlay());
	    }
	    
	    public class EnablePlay implements Runnable{
	        public void run(){
	            playButton.setEnabled(true);
	        }
	    }
	    
	    public class Playing implements Runnable{
	        private File file;
	        private long start;
	        private long end;
	        public Playing(File file,long start,long end){
	            this.file=file;
	            this.start=start;
	            this.end=end;
	        }
	        public void run(){
	            if(stopped==true){
	               
	                    log.trace("play-duration:"+(end-start));
	        	        stopped=false;
	        	        try {
                            player.play(file,start,end);
                        } catch (UnsupportedAudioFileException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (IOException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (LineUnavailableException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
	                    
	              
	                
	            }
	            stop();
	        }
	    }
	    
	    public class MovePosition implements Runnable{
	        private int selection;
	        public MovePosition(int selection){
	            this.selection=selection;
	        }
	        public void run(){
	            waveFormFigureCanvas.moveCurrentPosition(selection);
	           
	        }
	    }
	    
	    public class AudioMove implements AudioListener{

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#startPlaying()
             */
            public void startPlaying() {
                playing=true;
                //log.info("start-playing");
                shell.getDisplay().syncExec(new MovePosition(selection.x));
                log.info("start-playing2");
                PlayMove move=new PlayMove(selection.x);
                Thread t=new Thread(move);
                t.start();
                
            }

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#stopPlaying()
             */
            public void stopPlaying() {
                log.trace("stopplaying");
                // TODO Auto-generated method stub
                stopped=true;
                playing=false;
            }

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#finishPlaying()
             */
            public void finishPlaying() {
                log.trace("finishplaying");
                stopped=true;
                playing=false;
            }
	        
	    }
	    
	    public class PlayMove implements Runnable{
	        int sleeptime=30;
	        int startPosition;
	        public PlayMove(int start){
	            startPosition=start;
	            //log.info("init:"+start);
	        }
	        public void run(){
	            
	            long start=System.currentTimeMillis();
	            
	            while(playing){
	            try {
                    Thread.sleep(sleeptime);
                } catch (InterruptedException e) {
                    
                    e.printStackTrace();
                }
               
	            long played=System.currentTimeMillis()-start;
	            if(played>duration){
	                break;
	            }
	            shell.getDisplay().syncExec(new MovePosition(toPosition(played)));
	            
	            }
	        }
	        
	        public int toPosition(long time){
	            //log.trace("move"+time);
		        
		        return timeToRealValue(time)+startPosition;
		    }
	    }
	    
	    
	    public int timeToRealValue(long time){
	        return (int)(time*waveFormFigureCanvas.getBaseMemoryPixel()/1000);
	    }
	   
	    
	    
	    
	
	public class CenterImageFigure extends Figure{
	    private Image image;
	    private Canvas parentCanvas;
	    
	    public CenterImageFigure(){
	        //setBackgroundColor(null);
	    }
        public Image getImage() {
            return image;
        }
        public void setImage(Image image) {
            this.image = image;
        }
        public Canvas getParentCanvas() {
            return parentCanvas;
        }
        public void setParentCanvas(Canvas parentCanvas) {
            this.parentCanvas = parentCanvas;
            parentCanvas.addControlListener(new ResizeCheck());
            parentCanvas.getHorizontalBar().addSelectionListener(new Selection());
        }
       
        public void paintFigure(Graphics g) {
            Rectangle client=new Rectangle(parentCanvas.getClientArea());
            Rectangle rec=g.getClip(client);
            log.trace("repaint:"+rec);
            
            /*
            if(client.width!=rec.width || client.height!=rec.height){
                return;
            }*/
            
            if(image!=null){
               
	        int centerX=(parentCanvas.getClientArea().width-image.getBounds().width)/2;
	        int centerY=(parentCanvas.getClientArea().height-image.getBounds().height)/2;
	        
	        Rectangle rectangle=new Rectangle(this.getLocation().x+centerX,this.getLocation().y+centerY,image.getBounds().width,image.getBounds().height);
	        log.trace("g:"+rectangle);
	        //g.clipRect(new Rectangle(parentCanvas.getClientArea()));//change clip
	        g.drawImage(image,new Rectangle(image.getBounds()),rectangle);
            
            }
            
            }
	    
        public void moveImage(){
            log.trace("move");
            this.setLocation(new Point(parentCanvas.getHorizontalBar().getSelection(),parentCanvas.getVerticalBar().getSelection()));
            //repaint();
        }
        
        public class Selection implements SelectionListener{

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e) {
              // moveImage();
            }

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetDefaultSelected(SelectionEvent e) {
               
            }
            
        }
        public class ResizeCheck implements ControlListener{

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.ControlListener#controlMoved(org.eclipse.swt.events.ControlEvent)
             */
            public void controlMoved(ControlEvent e) {
                // TODO Auto-generated method stub
                log.trace("moved");
            }

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.ControlListener#controlResized(org.eclipse.swt.events.ControlEvent)
             */
            public void controlResized(ControlEvent e) {
               log.trace("resized");
               setSize(parentCanvas.getClientArea().width,parentCanvas.getClientArea().height);
            }
            
        }
	}
	public class Play implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            play();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	public class DrawTextFigure extends Figure{
	  
	    
	}
	
	public class Select implements SelectionListener{

	    /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            log.warn("select?");
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		
	}
    
    public void openFile(){
        subApplication.openFile();
    }
    
    public void saveFile(){
        subApplication.saveFile();
    }
    
    public void saveAsFile(){
        subApplication.saveAsFile();
    }
}


 