package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.ui.SliderFieldEditor;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class LabelPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String LABEL1_COLOR = "subview.label1_color";
	public static final String LABEL2_COLOR = "subview.label2_color";
	public static final String LABEL3_COLOR = "subview.label3_color";
	public static final String LABEL4_COLOR = "subview.label4_color";
	public static final String LABEL5_COLOR = "subview.label5_color";
	public static final String LABEL6_COLOR = "subview.label6_color";
	public static final String LABEL7_COLOR = "subview.label7_color";
	public static final String LABEL8_COLOR = "subview.label8_color";
	public static final int defaultJpegQuality=50;
	public LabelPage() {
		super(GRID);
		setPreferenceStore(SubplayerPlugin.getDefault().getPreferenceStore());
		setDescription("Label setting");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		/*
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
           
        addField(new ColorFieldEditor(LABEL1_COLOR,"Label1 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL2_COLOR,"Label2 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL3_COLOR,"Label3 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL4_COLOR,"Label4 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL5_COLOR,"Label5 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL6_COLOR,"Label6 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL7_COLOR,"Label7 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL8_COLOR,"Label8 Color",getFieldEditorParent()));
        
        
        
        
       
        /*addField(new RadioGroupFieldEditor(
		        INITIAL_ZOOM,
				"initial_zoom", //$NON-NLS-1$
				4,
				new String[][] { {"1/16","0.0625"},{"1/8","0.125"},{"1/4","0.25"},{"1/2","0.5"},{"1","1"},{"2","2"},{"4","4"},{"8","8"}
			}, getFieldEditorParent()));
        
        
        FieldEditor editor=new SliderFieldEditor(
                JPEG_QUALITY,
    			"jpeg_quality(if you use high-quality,a file will be bigger than PNG)", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),1,100,defaultJpegQuality);
        
        addField(editor);
        */
        
    }
	
	public void init(IWorkbench workbench) {
	}
}