/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.JavaFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class JavaTextFileBuffer
extends JavaFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("FileBuffer.status.ok"), null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, FileBuffersMessages.getString("FileBuffer.status.error"), null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    private String fExplicitEncoding;
    private boolean fHasBOM;

    public JavaTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IAnnotationModel getAnnotationModel() {
        return null;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public IStatus getStatus() {
        if (!this.isDisposed()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    private InputStream getFileContents(IProgressMonitor monitor) {
        try {
            return new FileInputStream(this.fFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void setFileContents(InputStream stream, boolean overwrite, IProgressMonitor monitor) {
        try {
            FileOutputStream out = new FileOutputStream(this.fFile, false);
            try {
                byte[] buffer = new byte[8192];
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = stream.read(buffer);
                    }
                    catch (IOException iOException) {}
                    if (bytesRead == -1) break;
                    try {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    catch (IOException iOException) {}
                    monitor.worked(1);
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    try {
                        ((OutputStream)out).close();
                        throw throwable2;
                    }
                    catch (IOException iOException) {}
                    throw throwable2;
                }
                try {}
                catch (IOException iOException) {}
                ((OutputStream)out).close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                Object var9_14 = null;
                try {}
                catch (IOException iOException) {}
                ((OutputStream)out).close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            stream.close();
            Object var9_15 = null;
            try {}
            catch (IOException iOException) {
                return;
            }
            ((OutputStream)out).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void revert(IProgressMonitor monitor) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        IDocument original = null;
        IStatus status = null;
        try {
            original = this.fManager.createEmptyDocument(this.getLocation());
            this.setDocumentContent(original, this.getFileContents(monitor), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        this.fStatus = status;
        if (original != null) {
            boolean replaceContents;
            String originalContents = original.get();
            boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            block11: {
                this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
                this.fEncoding = null;
                this.fHasBOM = false;
                stream = this.getFileContents(monitor);
                try {
                    try {
                        options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                        description = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFile.getName(), options);
                        if (description != null) {
                            this.fEncoding = description.getCharset();
                            this.fHasBOM = description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        }
                    }
                    catch (IOException v0) {}
                }
                catch (Throwable var6_6) {
                    var5_7 = null;
                    try {
                        stream.close();
                        throw var6_6;
                    }
                    catch (IOException ex) {
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("JavaTextFileBuffer.error.closeStream"), (Throwable)ex));
                    }
                    throw var6_6;
                }
                {
                    var5_8 = null;
                }
                ** try [egrp 3[TRYBLOCK] [3 : 122->129)] { 
lbl28:
                // 1 sources

                stream.close();
                break block11;
lbl30:
                // 1 sources

                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("JavaTextFileBuffer.error.closeStream"), (Throwable)ex));
                }
            }
            this.setDocumentContent(this.fDocument, this.getFileContents(monitor), this.fEncoding);
            return;
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        String encoding = this.computeEncoding();
        try {
            byte[] bytes = this.fDocument.get().getBytes(encoding);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                int bomLength = IContentDescription.BOM_UTF_8.length;
                byte[] bytesWithBOM = new byte[bytes.length + bomLength];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, bytesWithBOM, 0, bomLength);
                System.arraycopy(bytes, 0, bytesWithBOM, bomLength, bytes.length);
                bytes = bytesWithBOM;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            if (this.fFile.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                this.setFileContents(stream, overwrite, monitor);
                this.fSynchronizationStamp = this.fFile.lastModified();
            }
        }
        catch (UnsupportedEncodingException x) {
            String message = FileBuffersMessages.getFormattedString("ResourceTextFileBuffer.error.unsupported_encoding.message_arg", encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeEncoding() {
        block12: {
            block10: {
                if (this.fExplicitEncoding != null) {
                    return this.fExplicitEncoding;
                }
                reader = new BufferedReader(new StringReader(this.fDocument.get()));
                try {
                    try {
                        options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                        description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFile.getName(), options);
                        if (description == null || (encoding = description.getCharset()) == null) break block10;
                        var7_5 = encoding;
                        var5_6 = null;
                    }
                    catch (IOException v0) {
                        break block10;
                    }
                }
                catch (Throwable var6_12) {
                    var5_7 = null;
                    try {
                        reader.close();
                        throw var6_12;
                    }
                    catch (IOException ex) {
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                    }
                    throw var6_12;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 115->122)] { 
lbl26:
                // 1 sources

                reader.close();
                return var7_5;
lbl28:
                // 1 sources

                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                }
                return var7_5;
            }
            var5_8 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 115->122)] { 
lbl34:
            // 1 sources

            reader.close();
            break block12;
lbl36:
            // 1 sources

            catch (IOException ex) {
                FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
            }
        }
        if (this.fHasBOM == false) return this.fManager.getDefaultEncoding();
        return this.fEncoding;
    }

    /*
     * Exception decompiling
     */
    private void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 209->213)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.isSynchronized()) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, FileBuffersMessages.getString("FileBuffer.error.outOfSync"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            JavaTextFileBuffer.this.fCanBeSaved = true;
            JavaTextFileBuffer.this.removeFileBufferContentListeners();
            JavaTextFileBuffer.this.fManager.fireDirtyStateChanged(JavaTextFileBuffer.this, JavaTextFileBuffer.this.fCanBeSaved);
        }
    }
}

