/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.WebappPreferences;
import org.osgi.framework.Bundle;

public class LiveHelpServlet
extends HttpServlet {
    public void init() throws ServletException {
        if (BaseHelpSystem.getMode() == 1) {
            throw new ServletException();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (BaseHelpSystem.getMode() == 1) {
            return;
        }
        if (!new WebappPreferences().isActiveHelp()) {
            return;
        }
        req.setCharacterEncoding("UTF-8");
        String pluginID = req.getParameter("pluginID");
        if (pluginID == null) {
            return;
        }
        String className = req.getParameter("class");
        if (className == null) {
            return;
        }
        String arg = req.getParameter("arg");
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            return;
        }
        try {
            Class c = bundle.loadClass(className);
            Object o = c.newInstance();
            if (o != null && o instanceof ILiveHelpAction) {
                ILiveHelpAction helpExt = (ILiveHelpAction)o;
                if (arg != null) {
                    helpExt.setInitializationString(arg);
                }
                Thread runnableLiveHelp = new Thread((Runnable)helpExt);
                runnableLiveHelp.setDaemon(true);
                runnableLiveHelp.start();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception exception) {}
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

