/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    public OpenResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.getString("OpenResourceAction.text"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.getString("OpenResourceAction.toolTip"));
        this.setId(ID);
    }

    String getOperationMessage() {
        return "";
    }

    String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("OpenResourceAction.problemMessage");
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("OpenResourceAction.dialogTitle");
    }

    void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).open(monitor);
    }

    boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }
}

