/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.commands.AbstractMutableCommandRegistry;
import org.eclipse.ui.internal.commands.Persistence;

public final class PreferenceCommandRegistry
extends AbstractMutableCommandRegistry {
    private static final String KEY = "org.eclipse.ui.commands";
    private IPreferenceStore preferenceStore;

    public PreferenceCommandRegistry(IPreferenceStore preferenceStore) {
        if (preferenceStore == null) {
            throw new NullPointerException();
        }
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PreferenceCommandRegistry.KEY.equals(propertyChangeEvent.getProperty())) {
                    try {
                        PreferenceCommandRegistry.this.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws IOException {
        String preferenceString = this.preferenceStore.getString(KEY);
        if (preferenceString == null) return;
        if (preferenceString.length() == 0) return;
        StringReader reader = new StringReader(preferenceString);
        try {
            try {
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                List activeKeyConfigurationDefinitions = Collections.unmodifiableList(Persistence.readActiveKeyConfigurationDefinitions(memento, "activeKeyConfiguration", null));
                List categoryDefinitions = Collections.unmodifiableList(Persistence.readCategoryDefinitions(memento, "category", null));
                List commandDefinitions = Collections.unmodifiableList(Persistence.readCommandDefinitions(memento, "command", null));
                List keyConfigurationDefinitions = Collections.unmodifiableList(Persistence.readKeyConfigurationDefinitions(memento, "keyConfiguration", null));
                List keySequenceBindingDefinitions = Collections.unmodifiableList(Persistence.readKeySequenceBindingDefinitions(memento, "keyBinding", null));
                boolean commandRegistryChanged = false;
                if (!activeKeyConfigurationDefinitions.equals(this.activeKeyConfigurationDefinitions)) {
                    this.activeKeyConfigurationDefinitions = activeKeyConfigurationDefinitions;
                    commandRegistryChanged = true;
                }
                if (!categoryDefinitions.equals(this.categoryDefinitions)) {
                    this.categoryDefinitions = categoryDefinitions;
                    commandRegistryChanged = true;
                }
                if (!commandDefinitions.equals(this.commandDefinitions)) {
                    this.commandDefinitions = commandDefinitions;
                    commandRegistryChanged = true;
                }
                if (!keyConfigurationDefinitions.equals(this.keyConfigurationDefinitions)) {
                    this.keyConfigurationDefinitions = keyConfigurationDefinitions;
                    commandRegistryChanged = true;
                }
                if (!keySequenceBindingDefinitions.equals(this.keySequenceBindingDefinitions)) {
                    this.keySequenceBindingDefinitions = keySequenceBindingDefinitions;
                    commandRegistryChanged = true;
                }
                if (commandRegistryChanged) {
                    this.fireCommandRegistryChanged();
                }
            }
            catch (WorkbenchException workbenchException) {
                throw new IOException();
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ((Reader)reader).close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        ((Reader)reader).close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IOException {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot(KEY);
        Persistence.writeActiveKeyConfigurationDefinitions(xmlMemento, "activeKeyConfiguration", this.activeKeyConfigurationDefinitions);
        Persistence.writeCategoryDefinitions(xmlMemento, "category", this.categoryDefinitions);
        Persistence.writeCommandDefinitions(xmlMemento, "command", this.commandDefinitions);
        Persistence.writeKeyConfigurationDefinitions(xmlMemento, "keyConfiguration", this.keyConfigurationDefinitions);
        Persistence.writeKeySequenceBindingDefinitions(xmlMemento, "keyBinding", this.keySequenceBindingDefinitions);
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save(writer);
            this.preferenceStore.setValue(KEY, ((Object)writer).toString());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ((Writer)writer).close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        ((Writer)writer).close();
    }
}

