/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.workingset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.PropertyChange;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSet;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class HelpWorkingSetSynchronizer
implements IPropertyChangeListener,
PropertyChange.IPropertyChangeListener {
    private ArrayList workingSets = new ArrayList();

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("workingSetAdd")) {
            IWorkingSet iws = (IWorkingSet)event.getNewValue();
            this.addWorkingSet(iws);
        } else if (event.getProperty().equals("workingSetRemove")) {
            IWorkingSet iws = (IWorkingSet)event.getOldValue();
            this.removeWorkingSet(iws);
        } else if (event.getProperty().equals("workingSetNameChange")) {
            IWorkingSet iws = (IWorkingSet)event.getNewValue();
            this.renameWorkingSet(iws);
        } else if (event.getProperty().equals("workingSetContentChange")) {
            IWorkingSet iws = (IWorkingSet)event.getNewValue();
            this.changeWorkingSet(iws);
        }
    }

    public void propertyChange(PropertyChange.PropertyChangeEvent event) {
        if (event.getProperty().equals("workingSetAdd")) {
            WorkingSet ws = (WorkingSet)event.getNewValue();
            this.addWorkingSet(ws);
        } else if (event.getProperty().equals("workingSetRemove")) {
            WorkingSet ws = (WorkingSet)event.getOldValue();
            this.removeWorkingSet(ws);
        } else if (event.getProperty().equals("workingSetNameChange")) {
            WorkingSet ws = (WorkingSet)event.getNewValue();
            this.renameWorkingSet(ws);
        } else if (event.getProperty().equals("workingSetContentChange")) {
            WorkingSet ws = (WorkingSet)event.getNewValue();
            this.changeWorkingSet(ws);
        } else if (event.getProperty().equals("workingSetsSynch")) {
            WorkingSet[] baseWorkingSets = this.getHelpWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < baseWorkingSets.length) {
                IWorkingSet iws = this.getEclipseWorkingSetManager().getWorkingSet(baseWorkingSets[i].getName());
                if (iws == null) {
                    this.getHelpWorkingSetManager().removeWorkingSet(baseWorkingSets[i]);
                }
                ++i;
            }
        }
    }

    public void renameWorkingSet(IWorkingSet iws) {
        HelpWorkingSet hws = this.findWorkingSet(iws);
        if (hws != null) {
            hws.getWorkingSet().setName(iws.getName());
        }
    }

    public void changeWorkingSet(IWorkingSet iws) {
        HelpWorkingSet hws = this.findWorkingSet(iws);
        if (hws != null) {
            AdaptableHelpResource[] elements = new AdaptableHelpResource[iws.getElements().length];
            System.arraycopy(iws.getElements(), 0, elements, 0, elements.length);
            hws.getWorkingSet().setElements(elements);
        }
    }

    public void addWorkingSet(IWorkingSet iws) {
        HelpWorkingSet hws;
        WorkingSet ws = this.getHelpWorkingSetManager().getWorkingSet(iws.getName());
        if (ws == null && this.isHelpWorkingSet(iws)) {
            hws = new HelpWorkingSet(iws);
            this.workingSets.add(hws);
            this.getHelpWorkingSetManager().addWorkingSet(hws.getWorkingSet());
        }
        if (ws != null && this.findWorkingSet(iws) == null) {
            hws = new HelpWorkingSet(ws, iws);
            this.workingSets.add(hws);
            iws.setElements((IAdaptable[])ws.getElements());
        }
    }

    public void removeWorkingSet(IWorkingSet iws) {
        WorkingSet ws = this.getHelpWorkingSetManager().getWorkingSet(iws.getName());
        if (ws != null) {
            HelpWorkingSet hws = this.findWorkingSet(iws);
            if (hws != null) {
                this.workingSets.remove(hws);
            }
            this.getHelpWorkingSetManager().removeWorkingSet(ws);
        }
    }

    public void renameWorkingSet(WorkingSet ws) {
        HelpWorkingSet hws = this.findWorkingSet(ws);
        if (hws != null) {
            hws.getIWorkingSet().setName(ws.getName());
        }
    }

    public void changeWorkingSet(WorkingSet ws) {
        HelpWorkingSet hws = this.findWorkingSet(ws);
        if (hws != null) {
            hws.getIWorkingSet().setElements((IAdaptable[])ws.getElements());
        }
    }

    public void removeWorkingSet(WorkingSet ws) {
        IWorkingSet iws = this.getEclipseWorkingSetManager().getWorkingSet(ws.getName());
        if (iws != null) {
            HelpWorkingSet hws = this.findWorkingSet(ws);
            if (hws != null) {
                this.workingSets.remove(hws);
            }
            this.getEclipseWorkingSetManager().removeWorkingSet(iws);
        }
    }

    public void addWorkingSet(WorkingSet ws) {
        IWorkingSet iws = this.getEclipseWorkingSetManager().getWorkingSet(ws.getName());
        if (iws == null) {
            HelpWorkingSet hws = new HelpWorkingSet(ws);
            this.workingSets.add(hws);
            this.getEclipseWorkingSetManager().addWorkingSet(hws.getIWorkingSet());
        } else if (this.findWorkingSet(ws) == null) {
            HelpWorkingSet hws = new HelpWorkingSet(ws, iws);
            this.workingSets.add(hws);
        }
    }

    private boolean isHelpWorkingSet(IWorkingSet ws) {
        IAdaptable[] elements = ws.getElements();
        return elements.length > 0 && elements[0] instanceof AdaptableHelpResource;
    }

    private HelpWorkingSet findWorkingSet(WorkingSet ws) {
        Iterator it = this.workingSets.iterator();
        while (it.hasNext()) {
            HelpWorkingSet hws = (HelpWorkingSet)it.next();
            if (hws.getWorkingSet() != ws) continue;
            return hws;
        }
        return null;
    }

    private HelpWorkingSet findWorkingSet(IWorkingSet iws) {
        Iterator it = this.workingSets.iterator();
        while (it.hasNext()) {
            HelpWorkingSet hws = (HelpWorkingSet)it.next();
            if (hws.getIWorkingSet() != iws) continue;
            return hws;
        }
        return null;
    }

    private IWorkingSetManager getEclipseWorkingSetManager() {
        return PlatformUI.getWorkbench().getWorkingSetManager();
    }

    private WorkingSetManager getHelpWorkingSetManager() {
        return BaseHelpSystem.getWorkingSetManager();
    }
}

