/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.subplayer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.audio.splitter.JavaSoundWaveAudioCutter;
import org.jpn.xucker.commons.audio.splitter.StopperOfAudioCutter;
import org.jpn.xucker.commons.swt.ui.FileDirChoicer;
import org.jpn.xucker.mp3.JavaLayerMP3Cutter;
import org.jpn.xucker.mp3.MP3SearchTime;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.subplayer.SubPlayMain;
import org.jpn.xucker.subtitle.StandardSubObject;

public class SubPlayExportAudioDialog
implements SelectionListener,
StopperOfAudioCutter,
Runnable {
    private Group group1;
    private FileDirChoicer baseDir;
    private FileDirChoicer secondSub;
    private FileDirChoicer firstWav;
    public static Log log;
    private Button okButton;
    private Button cancelButton;
    Shell shell;
    private Button freettsButton;
    SubPlayMain main;
    SubPlayExportAudioDialog dialog = this;
    private boolean executing;
    private Button frameAll;
    private Button frameMark;
    private Button frameUnmark;
    private double spaceTime;
    private int repeatTime;
    boolean stopper;
    private ProgressBar progressBar;
    private Combo repeatCombo;
    private List useSub;
    private File dir;
    private Combo spaceCombo;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.subplayer.SubPlayExportAudioDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getFirstSubFilePath() {
        return this.baseDir.getAbsoluteFilePath();
    }

    public void setFirstSubFilePath(String firstSubFilePath) {
        this.baseDir.setFilePath(firstSubFilePath);
    }

    public String getFirstWavFilePath() {
        return this.firstWav.getAbsoluteFilePath();
    }

    public void setFirstWavFilePath(String firstWavFilePath) {
        this.firstWav.setFilePath(firstWavFilePath);
    }

    public String getSecondSubFilePath() {
        return this.secondSub.getAbsoluteFilePath();
    }

    public void setSecondSubFilePath(String secondSubFilePath) {
        this.secondSub.setFilePath(secondSubFilePath);
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public SubPlayExportAudioDialog(SubPlayMain main, Shell shell) {
        this.main = main;
        this.shell = shell;
        shell.setText("\u97f3\u58f0\u306e\u51fa\u529b");
        shell.setBounds(50, 50, 370, 200);
        RowLayout layout = new RowLayout();
        shell.setLayout((Layout)layout);
        this.group1 = new Group((Composite)shell, 0);
        this.group1.setText("\u51fa\u529b\u5148 \u30d9\u30fc\u30b9\u30d5\u30a9\u30eb\u30c0\u30fc");
        RowData group1_data = new RowData();
        group1_data.width = 350;
        this.group1.setLayoutData((Object)group1_data);
        RowLayout group1_layout = new RowLayout();
        this.group1.setLayout((Layout)group1_layout);
        this.baseDir = new FileDirChoicer((Composite)this.group1, 0, 1, null, true);
        this.baseDir.setFilePath(SystemUtils.USER_DIR);
        Group frameGroup = new Group((Composite)shell, 0);
        frameGroup.setLayout((Layout)new RowLayout());
        frameGroup.setText("\u30d5\u30ec\u30fc\u30e0\u9078\u629e");
        RowData secondSubGroup_data = new RowData();
        secondSubGroup_data.width = 350;
        frameGroup.setLayoutData((Object)secondSubGroup_data);
        this.frameAll = new Button((Composite)frameGroup, 16);
        this.frameAll.setText("\u3059\u3079\u3066");
        this.frameMark = new Button((Composite)frameGroup, 16);
        this.frameMark.setText("\u30de\u30fc\u30af\u6709\u308a\u306e\u307f");
        this.frameUnmark = new Button((Composite)frameGroup, 16);
        this.frameUnmark.setText("\u30de\u30fc\u30af\u7121\u3057\u306e\u307f");
        this.frameAll.setSelection(true);
        Group repeatGroup = new Group((Composite)shell, 0);
        repeatGroup.setLayout((Layout)new RowLayout());
        repeatGroup.setText("\u7e70\u308a\u8fd4\u3057");
        RowData wavegroup_data = new RowData();
        wavegroup_data.width = 350;
        repeatGroup.setLayoutData((Object)wavegroup_data);
        Label r1 = new Label((Composite)repeatGroup, 0);
        r1.setText("\u7e70\u308a\u8fd4\u3057\u56de\u6570");
        this.repeatCombo = new Combo((Composite)repeatGroup, 8);
        RowData tmp = new RowData();
        tmp.width = 30;
        this.repeatCombo.setLayoutData((Object)tmp);
        this.repeatCombo.add("1");
        this.repeatCombo.add("3");
        this.repeatCombo.add("5");
        this.repeatCombo.add("10");
        this.repeatCombo.add("20");
        this.repeatCombo.add("30");
        this.repeatCombo.select(0);
        Label r2 = new Label((Composite)repeatGroup, 0);
        r2.setText("\u56de");
        Label r23 = new Label((Composite)repeatGroup, 0);
        r23.setText("\u7a7a\u767d");
        r23.setToolTipText("MP3\u30d5\u30a1\u30a4\u30eb\u306e\u7a7a\u767d\u306f\u73fe\u5728\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        this.spaceCombo = new Combo((Composite)repeatGroup, 8);
        tmp = new RowData();
        tmp.width = 30;
        this.spaceCombo.setLayoutData((Object)tmp);
        this.spaceCombo.add("0");
        this.spaceCombo.add("0.5");
        this.spaceCombo.add("1");
        this.spaceCombo.add("3");
        this.spaceCombo.add("5");
        this.spaceCombo.add("10");
        this.spaceCombo.select(0);
        Label r3 = new Label((Composite)repeatGroup, 0);
        r3.setText("\u79d2");
        this.progressBar = new ProgressBar((Composite)shell, 0);
        this.okButton = new Button((Composite)shell, 0);
        this.okButton.setText("\u3000\u51fa\u529b\u958b\u59cb\u3000");
        this.okButton.addSelectionListener((SelectionListener)this);
        RowData okButton_data = new RowData();
        this.okButton.setLayoutData((Object)okButton_data);
        this.cancelButton = new Button((Composite)shell, 0);
        this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.cancelButton.addSelectionListener((SelectionListener)this);
        RowData cancelButton_data = new RowData();
        this.cancelButton.setLayoutData((Object)cancelButton_data);
        if (main.getSubPlayFileXmlObject().getFirstWavFilePath().endsWith(".mp3")) {
            this.spaceCombo.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            System.out.println("target==null");
        } else if (target == this.okButton) {
            this.do_okButton();
        } else if (target == this.cancelButton) {
            this.do_cancelButton();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void do_okButton() {
        int i;
        this.okButton.setEnabled(false);
        this.cancelButton.setText("\u4e2d\u6b62");
        this.executing = true;
        this.repeatTime = Integer.parseInt(this.repeatCombo.getItem(this.repeatCombo.getSelectionIndex()));
        this.spaceTime = Double.parseDouble(this.spaceCombo.getItem(this.spaceCombo.getSelectionIndex()));
        List subList = this.main.getSublist();
        this.useSub = new Vector();
        if (this.frameMark.getSelection()) {
            SubPlayMain.log.trace((Object)"frameMark selected");
            i = 0;
            while (i < subList.size()) {
                if (this.main.getMarkControler().isMarked((StandardSubObject)subList.get(i))) {
                    this.useSub.add(subList.get(i));
                    log.trace((Object)("add frame " + i));
                }
                ++i;
            }
        } else if (this.frameUnmark.getSelection()) {
            log.trace((Object)"frameMark unselected");
            i = 0;
            while (i < subList.size()) {
                if (!this.main.getMarkControler().isMarked((StandardSubObject)subList.get(i))) {
                    this.useSub.add(subList.get(i));
                    log.trace((Object)("add frame " + i));
                }
                ++i;
            }
        } else {
            log.trace((Object)"frameMark all");
            i = 0;
            while (i < subList.size()) {
                this.useSub.add(subList.get(i));
                ++i;
            }
        }
        int totalFrameSize = this.useSub.size();
        this.progressBar.setSelection(0);
        this.progressBar.setMaximum(totalFrameSize);
        this.dir = this.baseDir.getFile();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.stopper = false;
        String path = this.main.getSubPlayFileXmlObject().getFirstWavFilePath();
        JavaLayerMP3Cutter cutter = null;
        boolean mp3 = false;
        if (path.endsWith(".mp3")) {
            cutter = new JavaLayerMP3Cutter();
            mp3 = true;
        } else {
            cutter = new JavaSoundWaveAudioCutter();
        }
        cutter.setStopper((StopperOfAudioCutter)this.dialog);
        File inputFile = new File(path);
        MP3SearchTime st = null;
        if (path.endsWith(".mp3")) {
            try {
                st = new MP3SearchTime(inputFile);
                st.setStopper((StopperOfAudioCutter)this);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.useSub.size()) {
            if (this.shell.isDisposed()) {
                this.stopper = true;
            }
            if (this.stopper) break;
            String newName = this.createNewFileName(inputFile.getName(), i + 1);
            StandardSubObject sub = (StandardSubObject)this.useSub.get(i);
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("tmp", newName);
                log.trace((Object)("create tmpFile:" + tmpFile.getAbsolutePath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                log.trace((Object)("subtime:" + sub.getStartTime() + sub.getEndTime()));
                if (mp3) {
                    long[] times = new long[]{st.findByte(sub.getStartTime()), st.findByte(sub.getEndTime())};
                    MP3Utils.copy((File)inputFile, (File)tmpFile, (long)times[0], (long)(times[1] - times[0]));
                    WaveUtils.repeatFile((File)tmpFile, (File)new File(this.dir, newName), (int)this.repeatTime);
                } else {
                    cutter.cut(inputFile, sub.getStartTime(), sub.getEndTime(), tmpFile);
                    WaveUtils.repeatWave((File)tmpFile, (File)new File(this.dir, newName), (int)this.repeatTime, (long)((int)(1000.0 * this.spaceTime)), (boolean)false);
                }
            }
            catch (IOException e1) {
                this.shell.getDisplay().syncExec((Runnable)new ErrorAction(new File(this.dir, newName).getAbsolutePath()));
                log.fatal((Object)"", (Throwable)e1);
                return;
            }
            boolean result = tmpFile.delete();
            if (log.isTraceEnabled() || !result) {
                if (result) {
                    log.trace((Object)("delete tmpFile: " + tmpFile.getAbsoluteFile() + " " + result));
                } else {
                    log.error((Object)("delete faild tmpFile: " + tmpFile.getAbsoluteFile()));
                }
            }
            this.shell.getDisplay().asyncExec((Runnable)new SetProgressbar(i + 1));
            ++i;
        }
        if (!this.stopper) {
            this.shell.getDisplay().syncExec((Runnable)new FinishAction());
        } else {
            this.shell.getDisplay().syncExec((Runnable)new InitAction());
        }
    }

    public String createNewFileName(String name, int index) {
        int last = name.lastIndexOf(".");
        if (last == -1) {
            log.fatal((Object)("wrong file name:" + name));
            return null;
        }
        String indexName = "" + index;
        int numberSize = 4;
        while (indexName.length() < numberSize) {
            indexName = "0" + indexName;
        }
        return String.valueOf(name.substring(0, last)) + indexName + name.substring(last);
    }

    public void do_cancelButton() {
        if (this.executing) {
            this.stopper = true;
            this.executing = false;
        } else {
            this.shell.close();
        }
    }

    public boolean isStopped() {
        return this.stopper;
    }

    public class SetProgressbar
    implements Runnable {
        int value;

        public SetProgressbar(int value) {
            this.value = value;
        }

        public void run() {
            SubPlayExportAudioDialog.this.progressBar.setSelection(this.value);
        }
    }

    public class InitAction
    implements Runnable {
        public void run() {
            SubPlayExportAudioDialog.this.progressBar.setSelection(0);
            SubPlayExportAudioDialog.this.okButton.setEnabled(true);
            SubPlayExportAudioDialog.this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        }
    }

    public class FinishAction
    implements Runnable {
        public void run() {
            log.trace((Object)"finish output");
            MessageBox box = new MessageBox(SubPlayExportAudioDialog.this.shell);
            box.setMessage("\u51fa\u529b\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            box.open();
            SubPlayExportAudioDialog.this.shell.close();
        }
    }

    public class ErrorAction
    implements Runnable {
        private String fileName;

        public ErrorAction(String fileName) {
            this.fileName = fileName;
        }

        public void run() {
            log.trace((Object)"error output");
            MessageBox box = new MessageBox(SubPlayExportAudioDialog.this.shell, 1);
            box.setMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30c7\u30a3\u30b9\u30af\u306e\u5bb9\u91cf\u304c\u8db3\u308a\u306a\u3044\u304b\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u7528\u4e2d\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002\n" + this.fileName);
            box.open();
            new InitAction().run();
        }
    }
}

