/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.intro.impl.IIntroConstants;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;

public class Log
implements IIntroConstants {
    public static final boolean DEBUG = true;
    private static boolean logInfo = false;
    private static final ILog pluginLog = IntroPlugin.getDefault().getLog();

    static {
        if (IntroPlugin.getDefault().isDebugging()) {
            logInfo = Log.getDebugOption("/trace/logInfo");
        }
    }

    private static boolean getDebugOption(String option) {
        return "true".equalsIgnoreCase(Platform.getDebugOption((String)("org.eclipse.ui.intro" + option)));
    }

    public static synchronized void error(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, "org.eclipse.ui.intro", 0, message, ex);
        pluginLog.log((IStatus)errorStatus);
    }

    public static synchronized void info(String message) {
        if (!logInfo) {
            return;
        }
        if (message == null) {
            message = "";
        }
        Status infoStatus = new Status(1, "org.eclipse.ui.intro", 0, message, null);
        pluginLog.log((IStatus)infoStatus);
    }

    public static synchronized void warning(String message) {
        if (!IntroPlugin.getDefault().isDebugging()) {
            return;
        }
        if (message == null) {
            message = "";
        }
        Status warningStatus = new Status(2, "org.eclipse.ui.intro", 0, message, null);
        pluginLog.log((IStatus)warningStatus);
    }

    public static synchronized void debugMessage(String className, String message) {
        MultiStatus debugStatus = new MultiStatus("org.eclipse.ui.intro", 0, className, null);
        Status infoStatus = new Status(0, "org.eclipse.ui.intro", 0, message, null);
        debugStatus.add((IStatus)infoStatus);
        pluginLog.log((IStatus)debugStatus);
    }
}

