/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.subtitle.srt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jpn.xucker.subtitle.srt.SRTList;
import org.jpn.xucker.subtitle.srt.SRTObject;
import org.jpn.xucker.subtitle.srt.TimeData;

public class SRTParser {
    private static int INDEX = 0;
    private static int TIME = 1;
    private static int TEXT = 2;
    private int mode = INDEX;

    public SRTList parse(Reader reader) {
        SRTList data = new SRTList();
        try {
            String line;
            BufferedReader breader = new BufferedReader(reader);
            SRTObject srtObject = new SRTObject();
            SRTObject preObject = null;
            while ((line = breader.readLine()) != null) {
                if (this.mode == INDEX) {
                    if (line.equals("") && srtObject != null) {
                        preObject.setText(String.valueOf(preObject.getText()) + "\r\n");
                        continue;
                    }
                    int index = 0;
                    try {
                        index = Integer.parseInt(line);
                    }
                    catch (Exception e) {
                        index = 0;
                    }
                    srtObject.setIndex(index);
                    this.mode = TIME;
                    continue;
                }
                if (this.mode == TIME) {
                    if (line.length() != 29) continue;
                    TimeData start = this.parseTime(line.substring(0, 12));
                    TimeData end = this.parseTime(line.substring(17));
                    srtObject.setStartTime(start);
                    srtObject.setEndTime(end);
                    this.mode = TEXT;
                    continue;
                }
                if (this.mode != TEXT) continue;
                if (line.equals("")) {
                    if (this.isValid(srtObject)) {
                        data.add(srtObject);
                    }
                    preObject = srtObject;
                    srtObject = new SRTObject();
                    this.mode = INDEX;
                    continue;
                }
                String text = srtObject.getText();
                text = text == null ? line : String.valueOf(text) + "\r\n" + line;
                srtObject.setText(text);
            }
            if (this.isValid(srtObject)) {
                data.add(srtObject);
            }
            reader.close();
            this.mode = INDEX;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private TimeData parseTime(String line) {
        TimeData timeData = new TimeData(line);
        return timeData;
    }

    private boolean isValid(SRTObject srtObject) {
        return srtObject.getIndex() != 0 && srtObject.getStartTime() != null && srtObject.getEndTime() != null;
    }
}

