/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.subtitle.srt;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.srt.SRTObject;
import org.jpn.xucker.subtitle.srt.TimeData;

public class SRTList {
    private int index = 1;
    Vector srtList = new Vector();

    public int size() {
        return this.srtList.size();
    }

    public void add(SRTObject object) {
        this.add(object, false);
    }

    public synchronized void add(SRTObject object, boolean isIndexChange) {
        if (isIndexChange) {
            object.setIndex(this.index);
            this.srtList.addElement(object);
            ++this.index;
        } else {
            this.srtList.addElement(object);
            this.index = object.getIndex() + 1;
        }
    }

    public synchronized void add(TimeData start, TimeData end, String text) {
        SRTObject object = new SRTObject();
        object.setStartTime(start);
        object.setEndTime(end);
        object.setIndex(this.index);
        object.setText(text);
        this.srtList.addElement(object);
        ++this.index;
    }

    public SRTObject getSRTObjectAt(int index) {
        return (SRTObject)this.srtList.elementAt(index);
    }

    public List getSubDataList() {
        Vector<StandardSubObject> list = new Vector<StandardSubObject>();
        int i = 0;
        while (i < this.srtList.size()) {
            SRTObject srt = (SRTObject)this.srtList.get(i);
            StandardSubObject standard = new StandardSubObject();
            standard.setStartTime(srt.getStartTime().getTime());
            standard.setEndTime(srt.getEndTime().getTime());
            if (this.isImageFile(srt.getText())) {
                standard.setImagePath(srt.getText());
            } else {
                standard.setText(srt.getText());
            }
            list.add(standard);
            ++i;
        }
        return list;
    }

    private boolean isImageFile(String text) {
        String[] extensions = new String[]{".png", ".gif", ".bmp", ".jpg"};
        int i = 0;
        while (i < extensions.length) {
            if (text.toLowerCase().endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void sort() {
        Object[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        Arrays.sort(srtObjects);
        this.srtList.removeAll(this.srtList);
        int i = 0;
        while (i < srtObjects.length) {
            this.srtList.add(srtObjects[i]);
            ++i;
        }
    }

    public void reindex() {
        SRTObject[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        int i = 0;
        while (i < srtObjects.length) {
            srtObjects[i].setIndex(i + 1);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        SRTObject[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        int i = 0;
        while (i < srtObjects.length) {
            buffer.append(srtObjects[i].toString());
            buffer.append("\r\n");
            ++i;
        }
        return buffer.toString();
    }
}

