/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.draw2d;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Composite;
import org.jpn.xucker.commons.audio.WaveFormUtils;
import org.jpn.xucker.rcp.draw2d.AlphaLayerFigure;
import org.jpn.xucker.rcp.draw2d.ChainedFlowFigure;
import org.jpn.xucker.rcp.draw2d.WaveFormFigure;

public class _WaveFormFigureCanvas
extends FigureCanvas {
    public static Log log;
    public static final int NORMAL = 0;
    private int mode = 0;
    private double hzoom = 1.0;
    private double vzoom = 0.5;
    private LocationFigure locationFigure;
    private Panel panel = new Panel();
    private WaveFormFigure waveFormFigure;
    private ChainedFlowFigure flowFigure;
    private AlphaLayerFigure selectionFigure;
    private int autoScrollMargin = 20;
    double splitframe = 0.01;
    private boolean drugged;
    boolean pressed;
    int mouseDown;
    int mouseUp;
    private Figure backgroundFigure;
    private Figure foregroundFigure;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.draw2d._WaveFormFigureCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Figure getBackgroundFigure() {
        return this.backgroundFigure;
    }

    public void setBackgroundFigure(Figure backgroundFigure) {
        this.backgroundFigure = backgroundFigure;
    }

    public Figure getForegroundFigure() {
        return this.foregroundFigure;
    }

    public void setForegroundFigure(Figure foregroundFigure) {
        this.foregroundFigure = foregroundFigure;
    }

    public _WaveFormFigureCanvas(Composite parent) {
        super(parent);
        this.setContents((IFigure)this.panel);
        this.backgroundFigure = new EmptyFigure();
        this.panel.add((IFigure)this.backgroundFigure);
        EmptyFigure inPanel = new EmptyFigure();
        this.panel.add((IFigure)inPanel);
        this.selectionFigure = new AlphaLayerFigure(ColorConstants.gray, 128);
        this.selectionFigure.setVisible(false);
        inPanel.add(this.selectionFigure);
        this.panel.setLayoutManager((LayoutManager)new StackLayout());
        this.flowFigure = new ChainedFlowFigure();
        this.panel.add((IFigure)this.flowFigure);
        this.locationFigure = new LocationFigure();
        inPanel.add((IFigure)this.locationFigure);
        this.foregroundFigure = new EmptyFigure();
        this.panel.add((IFigure)this.foregroundFigure);
        this.addMouseListener(new CanvasMouse());
        this.addMouseMoveListener(new CanvasMouseMotion());
    }

    public void moveCurrentPosition(int x) {
        log.info((Object)("moveLocation:" + x));
        this.locationFigure.move(x);
        if (x > this.getClientArea().width + this.getHorizontalBar().getSelection() - this.autoScrollMargin) {
            this.autoScroll(1);
        } else if (x < this.autoScrollMargin) {
            this.autoScroll(-1);
        }
    }

    public void setCurrentPosition(int location) {
        this.locationFigure.move(location);
    }

    public int getCurrentPosition() {
        return this.locationFigure.getCurrent();
    }

    public int getLastPosition() {
        int margin = 5;
        return this.flowFigure.getSize().width + margin;
    }

    public int getXByte(int x) {
        if (x < 0) {
            return 0;
        }
        int figureIndex = x / 256;
        int at = x % 256;
        at = Math.max(0, at);
        if (figureIndex >= this.flowFigure.getChildren().size()) {
            return 0;
        }
        WaveFormFigure figure = (WaveFormFigure)this.flowFigure.getChildren().get(figureIndex);
        if (figure != null && at < figure.getLength()) {
            return figure.getByteAt(at);
        }
        return 0;
    }

    public void loadWave(File file) {
        System.out.println("open:" + file);
        this.flowFigure.removeAll();
        List byteList = WaveFormUtils.toWavValue(this.splitframe, file, 256);
        int byteLength = 0;
        int i = 0;
        while (i < byteList.size()) {
            byte[] bt = (byte[])byteList.get(i);
            WaveFormFigure wf = new WaveFormFigure(bt, 256);
            this.flowFigure.addChainedFigure(wf);
            wf.setForegroundColor(ColorConstants.orange);
            byteLength += bt.length;
            ++i;
        }
        System.out.println(this.flowFigure.getSize());
    }

    public void loadWave(InputStream input) {
    }

    public void autoScroll(int duration) {
        log.info((Object)("autoScroll:" + duration));
        int v = this.getHorizontalBar().getIncrement();
        this.scrollToX(this.getHorizontalBar().getSelection() + v * duration);
    }

    public void updateSelect() {
        int p1 = this.mouseUp;
        int p2 = this.mouseDown;
        if (this.mouseUp > this.mouseDown) {
            p1 = this.mouseDown;
            p2 = this.mouseUp;
        }
        if (p2 > p1 + 1) {
            this.select(p1, p2);
        } else {
            this.unselect();
        }
    }

    private void unselect() {
        this.selectionFigure.setVisible(false);
    }

    private void select(int p1, int p2) {
        this.selectionFigure.setLocation(new Point(p1, 0));
        this.selectionFigure.setSize(p2 - p1, 256);
        this.selectionFigure.setVisible(true);
        log.info((Object)("select:" + this.selectionFigure.getClientArea()));
    }

    public Point getSelection() {
        if (this.selectionFigure.isVisible()) {
            return new Point(this.selectionFigure.getLocation().x, this.selectionFigure.getLocation().x + this.selectionFigure.getSize().width);
        }
        return null;
    }

    static /* synthetic */ boolean access$0(_WaveFormFigureCanvas _WaveFormFigureCanvas2) {
        return _WaveFormFigureCanvas2.drugged;
    }

    static /* synthetic */ void access$1(_WaveFormFigureCanvas _WaveFormFigureCanvas2, boolean bl) {
        _WaveFormFigureCanvas2.drugged = bl;
    }

    static /* synthetic */ int access$2(_WaveFormFigureCanvas _WaveFormFigureCanvas2) {
        return _WaveFormFigureCanvas2.mode;
    }

    static /* synthetic */ int access$3(_WaveFormFigureCanvas _WaveFormFigureCanvas2) {
        return _WaveFormFigureCanvas2.autoScrollMargin;
    }

    public class LocationFigure
    extends Figure {
        int markSize = 2;
        int value = 128;
        int height = 256;

        public LocationFigure() {
            this.setSize(1 + this.markSize * 2, 256);
            this.setForegroundColor(ColorConstants.cyan);
            this.setBackgroundColor(ColorConstants.cyan);
        }

        public int getCurrent() {
            return this.getLocation().x + this.markSize;
        }

        public void move(int location) {
            this.setLocation(new Point(location - this.markSize, 0));
            this.setValue(_WaveFormFigureCanvas.this.getXByte(location));
        }

        public void paintFigure(Graphics g) {
            g.drawLine(this.markSize + this.getClientArea().x, this.getClientArea().y, this.markSize + this.getClientArea().x, this.getClientArea().y + this.height);
            g.fillOval(this.getClientArea().x, this.getClientArea().y + this.value, this.markSize * 2, this.markSize * 2);
        }

        public void setValue(int v) {
            this.value = this.height / 2 + v;
        }
    }

    public class CanvasMouseMotion
    implements MouseMoveListener {
        /*
         * Unable to fully structure code
         */
        public void mouseMove(MouseEvent e) {
            block8: {
                if (e.stateMask != 524288) break block8;
                _WaveFormFigureCanvas.log.info((Object)"mosue-drug");
                if (!_WaveFormFigureCanvas.access$0(_WaveFormFigureCanvas.this)) ** GOTO lbl33
                _WaveFormFigureCanvas.log.warn((Object)"already-pressed-break");
                return;
lbl-1000:
                // 1 sources

                {
                    _WaveFormFigureCanvas.access$1(_WaveFormFigureCanvas.this, true);
                    _WaveFormFigureCanvas.this.mouseUp = e.x + _WaveFormFigureCanvas.this.getHorizontalBar().getSelection();
                    _WaveFormFigureCanvas.log.info((Object)("mosue-up:" + _WaveFormFigureCanvas.this.mouseUp));
                    if (_WaveFormFigureCanvas.access$2(_WaveFormFigureCanvas.this) == 0) {
                        _WaveFormFigureCanvas.this.setCurrentPosition(e.x + _WaveFormFigureCanvas.this.getHorizontalBar().getSelection());
                    }
                    _WaveFormFigureCanvas.this.updateSelect();
                    if (_WaveFormFigureCanvas.this.mouseUp > _WaveFormFigureCanvas.this.mouseDown && e.x > _WaveFormFigureCanvas.this.getClientArea().width - _WaveFormFigureCanvas.access$3(_WaveFormFigureCanvas.this)) {
                        _WaveFormFigureCanvas.this.autoScroll(1);
                        if (_WaveFormFigureCanvas.this.getHorizontalBar().getSelection() >= _WaveFormFigureCanvas.this.getHorizontalBar().getMaximum() - _WaveFormFigureCanvas.this.getHorizontalBar().getThumb()) break;
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        if (_WaveFormFigureCanvas.this.mouseUp >= _WaveFormFigureCanvas.this.mouseDown || e.x >= _WaveFormFigureCanvas.access$3(_WaveFormFigureCanvas.this) || _WaveFormFigureCanvas.this.getHorizontalBar().getSelection() <= 0) break;
                        _WaveFormFigureCanvas.this.autoScroll(-1);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (_WaveFormFigureCanvas.this.getShell().isDisposed()) continue;
                    _WaveFormFigureCanvas.this.getShell().getDisplay().readAndDispatch();
                    _WaveFormFigureCanvas.this.getShell().getDisplay().sleep();
lbl33:
                    // 3 sources

                    ** while (_WaveFormFigureCanvas.this.pressed)
                }
lbl34:
                // 3 sources

                _WaveFormFigureCanvas.access$1(_WaveFormFigureCanvas.this, false);
            }
        }
    }

    public class EmptyFigure
    extends Figure {
    }

    public class CanvasMouse
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            _WaveFormFigureCanvas.this.mouseDown = e.x + _WaveFormFigureCanvas.this.getHorizontalBar().getSelection();
            _WaveFormFigureCanvas.this.pressed = true;
        }

        public void mouseUp(MouseEvent e) {
            _WaveFormFigureCanvas.this.mouseUp = e.x + _WaveFormFigureCanvas.this.getHorizontalBar().getSelection();
            _WaveFormFigureCanvas.this.updateSelect();
            _WaveFormFigureCanvas.this.pressed = false;
        }
    }
}

