/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audio.ogg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audio.AudioConsole;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audio.AudioUtils;
import org.jpn.xucker.rcp.audio.EmptyAudioConsole;

public class VorbisToolsExecuter
implements AudioConverter {
    public static Log log;
    private String oggencPath = "";
    private String oggdecPath = "";
    private AudioConsole audioConsole = new EmptyAudioConsole();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audio.ogg.VorbisToolsExecuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getOggdecPath() {
        return this.oggdecPath;
    }

    public void setOggdecPath(String oggdecPath) {
        this.oggdecPath = oggdecPath;
    }

    public String getOggencPath() {
        return this.oggencPath;
    }

    public void setOggencPath(String oggencPath) {
        this.oggencPath = oggencPath;
    }

    public boolean canConvert(String input, String output) {
        if (input.equals("wav") && output.equals("ogg")) {
            return true;
        }
        return input.equals("ogg") && output.equals("wav");
    }

    public String[] toDecodeArgs(File input, File output, AudioSetting setting, AudioSetting inputSetting) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.getOggdecPath());
        String inputExtension = AudioUtils.getExtension(input.getName());
        String outputExtension = AudioUtils.getExtension(output.getName());
        if (!outputExtension.equals("wav")) {
            throw new RuntimeException("current support wav only");
        }
        if (setting != null) {
            if (setting.getSamplebit() == 16) {
                argList.add("-b");
                argList.add("16");
            } else if (setting.getSamplebit() == 8) {
                argList.add("-b");
                argList.add("8");
                argList.add("-s");
                argList.add("0");
            }
        }
        argList.add(input.getAbsolutePath());
        argList.add("-o");
        argList.add(output.getAbsolutePath());
        return argList.toArray(new String[argList.size()]);
    }

    public String[] toEncodeArgs(File input, File output, AudioSetting setting, AudioSetting inputSetting) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.getOggencPath());
        String inputExtension = AudioUtils.getExtension(input.getName());
        String outputExtension = AudioUtils.getExtension(output.getName());
        if (!inputExtension.equals("wav")) {
            throw new RuntimeException("current support wav only");
        }
        if (setting != null) {
            if (inputSetting == null || inputSetting.getSamplerate() != setting.getSamplerate()) {
                argList.add("--resample");
                argList.add("" + setting.getSamplerate());
            }
            if (setting.getBitrate() > 0) {
                argList.add("-M");
                argList.add("" + setting.getBitrate() / 1000);
            } else if (setting.getQuality() > 0) {
                argList.add("-q");
                argList.add("" + (double)setting.getQuality() / 100.0);
            }
        }
        argList.add(input.getAbsolutePath());
        argList.add("-o");
        argList.add(output.getAbsolutePath());
        return argList.toArray(new String[argList.size()]);
    }

    public void convert(File input, File output, AudioSetting outputSetting, AudioSetting inputSetting) throws IOException {
        String line;
        String errorLine;
        Runtime runtime = Runtime.getRuntime();
        String[] args = null;
        args = AudioUtils.getExtension(input).equals("wav") ? this.toEncodeArgs(input, output, outputSetting, inputSetting) : this.toDecodeArgs(input, output, outputSetting, inputSetting);
        String command = "";
        int i = 0;
        while (i < args.length) {
            command = String.valueOf(command) + this.toArg(args[i]) + " ";
            ++i;
        }
        this.audioConsole.println(command);
        File pathFile = new File(this.getOggencPath());
        Process process = runtime.exec(args, null, pathFile.getParentFile());
        Object in = null;
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((errorLine = errorReader.readLine()) != null) {
            this.audioConsole.errorln(errorLine);
        }
        errorReader.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.audioConsole.println(errorLine);
        }
        reader.close();
    }

    private String toArg(String text) {
        if (text.indexOf(" ") != -1) {
            return "\"" + text + "\"";
        }
        return text;
    }

    public String getName() {
        return "OggTools";
    }
}

