/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.digester.MappedPropertyRule;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementRule
extends MappedPropertyRule {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$ElementRule == null ? (class$org$apache$commons$betwixt$digester$ElementRule = ElementRule.class$("org.apache.commons.betwixt.digester.ElementRule")) : class$org$apache$commons$betwixt$digester$ElementRule));
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$ElementRule;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Map;

    public static final void setLog(Log newLog) {
        log = newLog;
    }

    public void begin(String name, String namespace, Attributes attributes) throws SAXException {
        String nameAttributeValue = attributes.getValue("name");
        if (nameAttributeValue == null || nameAttributeValue.trim().equals("")) {
            throw new SAXException("Name attribute is required.");
        }
        if (!XMLUtils.isWellFormedXMLName(nameAttributeValue)) {
            throw new SAXException("'" + nameAttributeValue + "' would not be a well formed xml element name.");
        }
        ElementDescriptor descriptor = new ElementDescriptor();
        descriptor.setLocalName(nameAttributeValue);
        String uri = attributes.getValue("uri");
        String qName = nameAttributeValue;
        if (uri != null) {
            descriptor.setURI(uri);
            String prefix = this.getXMLIntrospector().getConfiguration().getPrefixMapper().getPrefix(uri);
            qName = prefix + ":" + nameAttributeValue;
        }
        descriptor.setQualifiedName(qName);
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        String propertyType = attributes.getValue("type");
        if (log.isTraceEnabled()) {
            log.trace((Object)("(BEGIN) name=" + nameAttributeValue + " uri=" + uri + " property=" + propertyName + " type=" + propertyType));
        }
        descriptor.setPropertyType(this.getPropertyType(propertyType, this.beanClass, propertyName));
        String implementationClass = attributes.getValue("class");
        if (log.isTraceEnabled()) {
            log.trace((Object)("'class' attribute=" + implementationClass));
        }
        if (implementationClass != null) {
            try {
                Class<?> clazz = Class.forName(implementationClass);
                descriptor.setImplementationClass(clazz);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot load class named: " + implementationClass), (Throwable)e);
                }
                throw new SAXException("Cannot load class named: " + implementationClass);
            }
        }
        if (propertyName != null && propertyName.length() > 0) {
            this.configureDescriptor(descriptor, attributes.getValue("updater"));
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            beanInfo.setElementDescriptor(descriptor);
            this.beanClass = beanInfo.getBeanClass();
            descriptor.setPropertyType(this.beanClass);
        } else if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            parent.addElementDescriptor(descriptor);
        } else {
            throw new SAXException("Invalid use of <element>. It should be nested inside <info> or other <element> nodes");
        }
        this.digester.push((Object)descriptor);
    }

    public void end(String name, String namespace) {
        Object object = this.digester.pop();
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor) {
        this.configureDescriptor(elementDescriptor, null);
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor, String updateMethodName) {
        String name;
        PropertyDescriptor descriptor;
        Class beanClass = this.getBeanClass();
        if (beanClass != null && (descriptor = this.getPropertyDescriptor(beanClass, name = elementDescriptor.getPropertyName())) != null) {
            this.configureProperty(elementDescriptor, descriptor, updateMethodName, beanClass);
            this.getProcessedPropertyNameSet().add(name);
        }
    }

    private void configureProperty(ElementDescriptor elementDescriptor, PropertyDescriptor propertyDescriptor, String updateMethodName, Class beanClass) {
        Class<?> type = propertyDescriptor.getPropertyType();
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        String existingLocalName = elementDescriptor.getLocalName();
        if (existingLocalName == null || "".equals(existingLocalName)) {
            elementDescriptor.setLocalName(propertyDescriptor.getName());
        }
        elementDescriptor.setPropertyType(type);
        if (readMethod == null) {
            log.trace((Object)"No read method");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read method=" + readMethod.getName()));
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = ElementRule.class$("java.lang.Class")) : class$java$lang$Class).equals(type) && "class".equals(propertyDescriptor.getName())) {
            log.trace((Object)"Ignoring class property");
            return;
        }
        if (this.getXMLIntrospector().isPrimitiveType(type)) {
            elementDescriptor.setTextExpression(new MethodExpression(readMethod));
        } else if (this.getXMLIntrospector().isLoopType(type)) {
            log.trace((Object)"Loop type ??");
            elementDescriptor.setContextExpression(new IteratorExpression(new MethodExpression(readMethod)));
            elementDescriptor.setHollow(true);
            writeMethod = null;
            if ((class$java$util$Map == null ? (class$java$util$Map = ElementRule.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
                elementDescriptor.setLocalName("entry");
                ElementDescriptor keyDescriptor = new ElementDescriptor("key");
                keyDescriptor.setHollow(true);
                elementDescriptor.addElementDescriptor(keyDescriptor);
                ElementDescriptor valueDescriptor = new ElementDescriptor("value");
                valueDescriptor.setHollow(true);
                elementDescriptor.addElementDescriptor(valueDescriptor);
            }
        } else {
            log.trace((Object)"Standard property");
            elementDescriptor.setHollow(true);
            elementDescriptor.setContextExpression(new MethodExpression(readMethod));
        }
        if (updateMethodName == null) {
            if (writeMethod != null) {
                elementDescriptor.setUpdater(new MethodUpdater(writeMethod));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Finding custom method: ");
                log.trace((Object)("  on:" + beanClass));
                log.trace((Object)("  name:" + updateMethodName));
            }
            Method updateMethod = null;
            Method[] methods = beanClass.getMethods();
            int i = 0;
            int size = methods.length;
            while (i < size) {
                Method method = methods[i];
                if (updateMethodName.equals(method.getName()) && methods[i].getParameterTypes().length == 1) {
                    updateMethod = methods[i];
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)("Matched method:" + updateMethod));
                    break;
                }
                ++i;
            }
            if (updateMethod == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("No method with name '" + updateMethodName + "' found for update"));
                }
            } else {
                elementDescriptor.setUpdater(new MethodUpdater(updateMethod));
                elementDescriptor.setSingularPropertyType(updateMethod.getParameterTypes()[0]);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Set custom updater on " + elementDescriptor));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

