/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.useradmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.useradmin.UserAdminPermission;

final class UserAdminPermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof UserAdminPermission)) {
            throw new IllegalArgumentException("Invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Attempt to add a Permission to a readonly PermissionCollection");
        }
        UserAdminPermission userAdminPermission = (UserAdminPermission)permission;
        String string = userAdminPermission.getName();
        UserAdminPermission userAdminPermission2 = (UserAdminPermission)this.permissions.get(string);
        if (userAdminPermission2 != null) {
            int n;
            int n2 = userAdminPermission2.getMask();
            if (n2 != (n = userAdminPermission.getMask())) {
                this.permissions.put(string, new UserAdminPermission(string, n2 | n));
            }
        } else {
            this.permissions.put(string, permission);
        }
        if (!this.all_allowed && string.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        UserAdminPermission userAdminPermission;
        if (!(permission instanceof UserAdminPermission)) {
            return false;
        }
        UserAdminPermission userAdminPermission2 = (UserAdminPermission)permission;
        int n2 = userAdminPermission2.getMask();
        int n3 = 0;
        if (this.all_allowed && n2 != 0 && (userAdminPermission = (UserAdminPermission)this.permissions.get("*")) != null && ((n3 |= userAdminPermission.getMask()) & n2) == n2) {
            return true;
        }
        String string = userAdminPermission2.getName();
        userAdminPermission = (UserAdminPermission)this.permissions.get(string);
        if (userAdminPermission != null && ((n3 |= userAdminPermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            userAdminPermission = (UserAdminPermission)this.permissions.get(string = string.substring(0, n + 1) + "*");
            if (userAdminPermission != null && ((n3 |= userAdminPermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

