/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.VirtualNode;
import org.eclipse.draw2d.internal.graph.GraphVisitor;

public class PopulateRanks
extends GraphVisitor {
    private DirectedGraph g;

    public void visit(DirectedGraph g) {
        Node node;
        this.g = g;
        g.ranks = new RankList();
        int i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            g.ranks.getRank(node.rank).add(node);
            ++i;
        }
        i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            int j = 0;
            while (j < node.outgoing.size()) {
                Edge e = node.outgoing.getEdge(j);
                if (e.getLength() > 1) {
                    this.addVirtualNodes(e);
                }
                ++j;
            }
            ++i;
        }
    }

    void addVirtualNodes(Edge e) {
        int start = e.source.rank + 1;
        int end = e.target.rank;
        VirtualNode previous = null;
        VirtualNode current = null;
        e.vNodes = new NodeList();
        int i = start;
        while (i < end) {
            current = this.createVirtualNode(e, i);
            if (previous == null) {
                current.prev = e.source;
            } else {
                previous.next = current;
                current.prev = previous;
            }
            this.g.ranks.getRank(i).add(current);
            e.vNodes.add(current);
            previous = current;
            ++i;
        }
        current.next = e.target;
    }

    VirtualNode createVirtualNode(Edge e, int i) {
        return new VirtualNode(e, i);
    }
}

