/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.IActionItem;
import org.eclipse.ui.internal.cheatsheets.data.IPerformWhenItem;
import org.eclipse.ui.internal.cheatsheets.data.ISubItemItem;
import org.eclipse.ui.internal.cheatsheets.data.Intro;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;

public class Item
extends Intro
implements IActionItem,
IPerformWhenItem,
ISubItemItem {
    private String title;
    private boolean skip;
    private ArrayList itemExtensions;
    private Action action;
    private PerformWhen performWhen;
    private ArrayList subItems;

    public Item() {
    }

    public Item(String title, String description, String href, String contextId, boolean skip) {
        super(description, href, contextId);
        this.title = title;
        this.skip = skip;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDynamic() {
        return this.performWhen != null || this.hasDynamicSubItems();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setItemExtensions(ArrayList exts) {
        this.itemExtensions = exts;
    }

    public ArrayList getItemExtensions() {
        return this.itemExtensions;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public PerformWhen getPerformWhen() {
        return this.performWhen;
    }

    public void setPerformWhen(PerformWhen performWhen) {
        this.performWhen = performWhen;
    }

    public void addSubItem(AbstractSubItem subItem) {
        if (this.subItems == null) {
            this.subItems = new ArrayList();
        }
        this.subItems.add(subItem);
    }

    public ArrayList getSubItems() {
        return this.subItems;
    }

    private boolean hasDynamicSubItems() {
        if (this.subItems != null) {
            Iterator iter = this.subItems.iterator();
            while (iter.hasNext()) {
                AbstractSubItem subItem = (AbstractSubItem)iter.next();
                if (!(subItem instanceof RepeatedSubItem) && !(subItem instanceof ConditionalSubItem) && (!(subItem instanceof SubItem) || ((SubItem)subItem).getPerformWhen() == null)) continue;
                return true;
            }
        }
        return false;
    }
}

