/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.SourceViewerInformationControl;
import org.eclipse.swt.widgets.Shell;

class ProjectionAnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    private IInformationControlCreator fInformationControlCreator;

    ProjectionAnnotationHover() {
    }

    public void setHoverControlCreator(IInformationControlCreator creator) {
        this.fInformationControlCreator = creator;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return null;
    }

    private int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int startLine = document.getLineOfOffset(position.getOffset());
                if (line == startLine) {
                    return 1;
                }
                if (startLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    private String getProjectionTextAtLine(ISourceViewer viewer, int line, int numberOfLines) {
        ISourceViewerExtension2 viewerExtension;
        IAnnotationModel visual;
        IAnnotationModel model = null;
        if (viewer instanceof ISourceViewerExtension2 && (visual = (viewerExtension = (ISourceViewerExtension2)((Object)viewer)).getVisualAnnotationModel()) instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)visual;
            model = modelExtension.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        if (model != null) {
            try {
                IDocument document = viewer.getDocument();
                Iterator e = model.getAnnotationIterator();
                while (e.hasNext()) {
                    Position position;
                    ProjectionAnnotation annotation = (ProjectionAnnotation)e.next();
                    if (!annotation.isCollapsed() || (position = model.getPosition((Annotation)annotation)) == null || 1 != this.compareRulerLine(position, document, line)) continue;
                    return this.getText(document, position.getOffset(), position.getLength(), numberOfLines);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private String getText(IDocument document, int offset, int length, int numberOfLines) throws BadLocationException {
        int endOffset = offset + length;
        try {
            int endLine = document.getLineOfOffset(offset) + Math.max(0, numberOfLines - 1);
            IRegion lineInfo = document.getLineInformation(endLine);
            endOffset = Math.min(endOffset, lineInfo.getOffset() + lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return document.get(offset, endOffset - offset);
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleLines) {
        return this.getProjectionTextAtLine(sourceViewer, lineRange.getStartLine(), visibleLines);
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    public boolean canHandleMouseCursor() {
        return false;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInformationControlCreator != null) {
            return this.fInformationControlCreator;
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, "org.eclipse.jface.textfont");
            }
        };
    }
}

